/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2023-06-07 12:40:22 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `wpxd_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_duplicator_pro_entities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_duplicator_pro_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_fusion_forms` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `views` bigint(20) DEFAULT '0',
  `submissions_count` bigint(20) DEFAULT '0',
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_fusion_form_entries` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `form_id` bigint(20) NOT NULL,
  `field_id` bigint(20) NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  `privacy` tinyint(1) DEFAULT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_fusion_form_fields` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `field_name` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_label` varchar(256) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_fusion_form_submissions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `time` datetime NOT NULL,
  `source_url` varchar(512) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci,
  `ip` varchar(512) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_read` tinyint(1) DEFAULT NULL,
  `privacy_scrub_date` date DEFAULT NULL,
  `on_privacy_scrub` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_itsec_distributed_storage` (
  `storage_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `storage_group` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `storage_key` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `storage_chunk` int(11) NOT NULL DEFAULT '0',
  `storage_data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `storage_updated` datetime NOT NULL,
  PRIMARY KEY (`storage_id`),
  UNIQUE KEY `storage_group__key__chunk` (`storage_group`,`storage_key`,`storage_chunk`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_itsec_fingerprints` (
  `fingerprint_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `fingerprint_user` bigint(20) unsigned NOT NULL,
  `fingerprint_hash` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `fingerprint_created_at` datetime NOT NULL,
  `fingerprint_approved_at` datetime NOT NULL,
  `fingerprint_data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `fingerprint_snapshot` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `fingerprint_last_seen` datetime NOT NULL,
  `fingerprint_uses` int(11) NOT NULL DEFAULT '0',
  `fingerprint_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `fingerprint_uuid` char(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`fingerprint_id`),
  UNIQUE KEY `fingerprint_user__hash` (`fingerprint_user`,`fingerprint_hash`),
  UNIQUE KEY `fingerprint_uuid` (`fingerprint_uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_itsec_geolocation_cache` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_host` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_lat` decimal(10,8) NOT NULL,
  `location_long` decimal(11,8) NOT NULL,
  `location_label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_credit` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_time` datetime NOT NULL,
  PRIMARY KEY (`location_id`),
  UNIQUE KEY `location_host` (`location_host`),
  KEY `location_time` (`location_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_itsec_lockouts` (
  `lockout_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lockout_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `lockout_start` datetime NOT NULL,
  `lockout_start_gmt` datetime NOT NULL,
  `lockout_expire` datetime NOT NULL,
  `lockout_expire_gmt` datetime NOT NULL,
  `lockout_host` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lockout_user` bigint(20) unsigned DEFAULT NULL,
  `lockout_username` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lockout_active` int(1) NOT NULL DEFAULT '1',
  `lockout_context` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`lockout_id`),
  KEY `lockout_expire_gmt` (`lockout_expire_gmt`),
  KEY `lockout_host` (`lockout_host`),
  KEY `lockout_user` (`lockout_user`),
  KEY `lockout_username` (`lockout_username`),
  KEY `lockout_active` (`lockout_active`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_itsec_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `module` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `code` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'notice',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `init_timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `memory_current` bigint(20) unsigned NOT NULL DEFAULT '0',
  `memory_peak` bigint(20) unsigned NOT NULL DEFAULT '0',
  `url` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `blog_id` bigint(20) NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `remote_ip` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `module` (`module`),
  KEY `code` (`code`),
  KEY `type` (`type`),
  KEY `timestamp` (`timestamp`),
  KEY `init_timestamp` (`init_timestamp`),
  KEY `user_id` (`user_id`),
  KEY `blog_id` (`blog_id`)
) ENGINE=InnoDB AUTO_INCREMENT=245 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_itsec_mutexes` (
  `mutex_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `mutex_name` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `mutex_expires` int(11) unsigned NOT NULL,
  PRIMARY KEY (`mutex_id`),
  UNIQUE KEY `mutex_name` (`mutex_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_itsec_opaque_tokens` (
  `token_id` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token_hashed` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token_type` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token_data` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token_created_at` datetime NOT NULL,
  PRIMARY KEY (`token_id`),
  UNIQUE KEY `token_hashed` (`token_hashed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_itsec_temp` (
  `temp_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `temp_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `temp_date` datetime NOT NULL,
  `temp_date_gmt` datetime NOT NULL,
  `temp_host` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `temp_user` bigint(20) unsigned DEFAULT NULL,
  `temp_username` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`temp_id`),
  KEY `temp_date_gmt` (`temp_date_gmt`),
  KEY `temp_host` (`temp_host`),
  KEY `temp_user` (`temp_user`),
  KEY `temp_username` (`temp_username`)
) ENGINE=InnoDB AUTO_INCREMENT=194 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_itsec_user_groups` (
  `group_id` char(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `group_label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `group_roles` text COLLATE utf8mb4_unicode_520_ci,
  `group_canonical` text COLLATE utf8mb4_unicode_520_ci,
  `group_users` text COLLATE utf8mb4_unicode_520_ci,
  `group_min_role` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `group_created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_layerslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `group_id` int(10) DEFAULT NULL,
  `author` int(10) NOT NULL DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `slug` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `data` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(10) NOT NULL,
  `schedule_start` int(10) NOT NULL DEFAULT '0',
  `schedule_end` int(10) NOT NULL DEFAULT '0',
  `flag_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `flag_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `flag_popup` tinyint(1) NOT NULL DEFAULT '0',
  `flag_group` tinyint(1) NOT NULL DEFAULT '0',
  `flag_dirty` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_layerslider_drafts` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `slider_id` int(10) NOT NULL,
  `author` int(10) NOT NULL DEFAULT '0',
  `data` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `slider_id` (`slider_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_layerslider_revisions` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `slider_id` int(10) NOT NULL,
  `author` int(10) NOT NULL DEFAULT '0',
  `data` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_nf3_actions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` longtext,
  `key` longtext,
  `type` longtext,
  `active` tinyint(1) DEFAULT '1',
  `parent_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `label` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `wpxd_nf3_action_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL,
  `key` longtext NOT NULL,
  `value` longtext,
  `meta_key` longtext,
  `meta_value` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=131 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `wpxd_nf3_chunks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `value` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `wpxd_nf3_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` longtext,
  `key` longtext,
  `type` longtext,
  `parent_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `field_label` longtext,
  `field_key` longtext,
  `order` int(11) DEFAULT NULL,
  `required` bit(1) DEFAULT NULL,
  `default_value` longtext,
  `label_pos` varchar(15) DEFAULT NULL,
  `personally_identifiable` bit(1) DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `wpxd_nf3_field_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL,
  `key` longtext NOT NULL,
  `value` longtext,
  `meta_key` longtext,
  `meta_value` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=338 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `wpxd_nf3_forms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` longtext,
  `key` longtext,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `views` int(11) DEFAULT NULL,
  `subs` int(11) DEFAULT NULL,
  `form_title` longtext,
  `default_label_pos` varchar(15) DEFAULT NULL,
  `show_title` bit(1) DEFAULT NULL,
  `clear_complete` bit(1) DEFAULT NULL,
  `hide_complete` bit(1) DEFAULT NULL,
  `logged_in` bit(1) DEFAULT NULL,
  `seq_num` int(11) DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `wpxd_nf3_form_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL,
  `key` longtext NOT NULL,
  `value` longtext,
  `meta_key` longtext,
  `meta_value` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=130 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `wpxd_nf3_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` longtext,
  `title` longtext,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `object_title` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `wpxd_nf3_object_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL,
  `key` longtext NOT NULL,
  `value` longtext,
  `meta_key` longtext,
  `meta_value` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `wpxd_nf3_relationships` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `child_id` int(11) NOT NULL,
  `child_type` longtext NOT NULL,
  `parent_id` int(11) NOT NULL,
  `parent_type` longtext NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `wpxd_nf3_upgrades` (
  `id` int(11) NOT NULL,
  `cache` longtext,
  `stage` int(11) NOT NULL DEFAULT '0',
  `maintenance` bit(1) DEFAULT b'0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `wpxd_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=201546 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=567 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_smush_dir_images` (
  `id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `path` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `path_hash` char(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `resize` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lossy` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `error` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `image_size` int(10) unsigned DEFAULT NULL,
  `orig_size` int(10) unsigned DEFAULT NULL,
  `file_time` int(10) unsigned DEFAULT NULL,
  `last_scan` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `meta` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `path_hash` (`path_hash`),
  KEY `image_size` (`image_size`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT '0',
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wfblocks7` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT '0',
  `blockedHits` int(10) unsigned DEFAULT '0',
  `expiration` bigint(20) unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB AUTO_INCREMENT=34289 DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `real_path` text NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wfhits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT '0',
  `statusCode` int(11) NOT NULL DEFAULT '200',
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wfhoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wfissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wfknownfilelist` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `wordpress_path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wflogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB AUTO_INCREMENT=20040 DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wfls_2fa_secrets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `vtime` int(10) unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wfls_role_counts` (
  `serialized_roles` varbinary(255) NOT NULL,
  `two_factor_inactive` tinyint(1) NOT NULL,
  `user_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`serialized_roles`,`two_factor_inactive`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '1000',
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wfpendingissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wfsnipcache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=28164 DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wfstatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=60310 DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wftrafficrates` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wfwaffailures` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `throwable` text NOT NULL,
  `rule_id` int(10) unsigned DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `wpxd_wpmailsmtp_debug_events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content` text COLLATE utf8mb4_unicode_520_ci,
  `initiator` text COLLATE utf8mb4_unicode_520_ci,
  `event_type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wpxd_wpmailsmtp_tasks_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `wpxd_users` VALUES 
("1","superadmin89","$P$BttquvLVaZB3FVSSJ2ZMQNk1GI9Kpp/","superadmin89","info@deoworkz.net","","2020-09-29 05:37:25","","0","Admin");

INSERT IGNORE INTO `wpxd_usermeta` VALUES 
("1","1","nickname","Admin"),
("2","1","first_name","Admin"),
("3","1","last_name","1"),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","false"),
("11","1","locale",""),
("12","1","wpxd_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","wpxd_user_level","10"),
("14","1","dismissed_wp_pointers",""),
("15","1","show_welcome_panel","0"),
("16","1","session_tokens","a:1:{s:64:\"7977f85e0c7e8f92a8889fa92574c908fe5048ecb7482a2f7a1551aad2461ae8\";a:4:{s:10:\"expiration\";i:1686309903;s:2:\"ip\";s:15:\"113.211.208.188\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36\";s:5:\"login\";i:1686137103;}}"),
("17","1","wpxd_dashboard_quick_press_last_post_id","65"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:13:\"113.211.208.0\";}"),
("19","1","closedpostboxes_dashboard","a:0:{}"),
("20","1","metaboxhidden_dashboard","a:6:{i:0;s:16:\"themefusion-news\";i:1;s:21:\"dashboard_site_health\";i:2;s:19:\"dashboard_right_now\";i:3;s:18:\"dashboard_activity\";i:4;s:21:\"dashboard_quick_press\";i:5;s:17:\"dashboard_primary\";}"),
("36","1","author_email",""),
("37","1","author_facebook",""),
("38","1","author_twitter",""),
("39","1","author_linkedin",""),
("40","1","author_dribble",""),
("41","1","author_whatsapp",""),
("42","1","author_custom",""),
("50","1","itsec_user_activity_last_seen","1601899418"),
("51","1","itsec-settings-view","grid"),
("52","1","wp_mail_smtp_edu_notice_bar_dismissed","1601899947"),
("79","1","wfls-last-login","1686137107"),
("84","1","wpxd_user-settings","libraryContent=browse"),
("85","1","wpxd_user-settings-time","1666338655"),
("86","1","duplicator_pro_created_format","1"),
("87","1","ls-v7-welcome-screen-date","1686141437");

INSERT IGNORE INTO `wpxd_actionscheduler_actions` VALUES 
("3","wp_mail_smtp_admin_notifications_update","complete","0000-00-00 00:00:00","0000-00-00 00:00:00","[1]","O:28:\"ActionScheduler_NullSchedule\":0:{}","2","1","2023-06-07 11:26:24","2023-06-07 19:26:24","0",NULL),
("4","action_scheduler/migration_hook","complete","2023-06-07 12:38:47","2023-06-07 12:38:47","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1686141527;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1686141527;}","1","1","2023-06-07 12:38:48","2023-06-07 20:38:48","0",NULL),
("5","action_scheduler/migration_hook","failed","2023-06-07 12:39:48","2023-06-07 12:39:48","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1686141588;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1686141588;}","1","1","2023-06-07 12:39:57","2023-06-07 20:39:57","0",NULL);

INSERT IGNORE INTO `wpxd_actionscheduler_groups` VALUES 
("1","action-scheduler-migration"),
("2","wp_mail_smtp");

INSERT IGNORE INTO `wpxd_actionscheduler_logs` VALUES 
("7","3","action created","2023-06-07 11:26:18","2023-06-07 11:26:18"),
("8","3","action started via Async Request","2023-06-07 11:26:24","2023-06-07 11:26:24"),
("9","3","action complete via Async Request","2023-06-07 11:26:24","2023-06-07 11:26:24"),
("10","4","action created","2023-06-07 12:37:47","2023-06-07 12:37:47"),
("11","4","action started via Async Request","2023-06-07 12:38:48","2023-06-07 12:38:48"),
("12","4","action complete via Async Request","2023-06-07 12:38:48","2023-06-07 12:38:48"),
("13","5","action created","2023-06-07 12:38:48","2023-06-07 12:38:48"),
("14","5","action started via Async Request","2023-06-07 12:39:57","2023-06-07 12:39:57"),
("15","5","action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2023-06-07 12:39:57","2023-06-07 12:39:57");

INSERT IGNORE INTO `wpxd_duplicator_pro_entities` VALUES 
("1","DUP_PRO_Global_Entity","{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"crypt\": true,\n    \"package_ui_created\": 1,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 1,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"archive_build_mode_schedule\": -1,\n    \"archive_compression_schedule\": true,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"deoworkz@gmail.com\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"json_mode\": 0,\n    \"ajax_protocol\": \"https\",\n    \"custom_ajax_url\": \"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": 2048,\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"dropbox_upload_chunksize_in_kb\": 2000,\n    \"dropbox_transfer_mode\": 1,\n    \"gdrive_upload_chunksize_in_kb\": 1024,\n    \"gdrive_transfer_mode\": 0,\n    \"s3_upload_part_size_in_kb\": 6000,\n    \"onedrive_upload_chunksize_in_kb\": 3200,\n    \"local_upload_chunksize_in_MB\": 16,\n    \"manual_mode_storage_ids\": [\n        \"-2\"\n    ],\n    \"license_status\": 0,\n    \"license_expiration_time\": -1,\n    \"license_no_activations_left\": false,\n    \"license_key_visible\": 1,\n    \"lkp\": \"\",\n    \"license_type\": -1,\n    \"license_limit\": -1,\n    \"last_system_check_timestamp\": 0,\n    \"initial_activation_timestamp\": 1686141163,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"debug_on\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"profile_beta\": false,\n    \"dupHidePackagesGiftFeatures\": true,\n    \"recoveryCustomPath\": \"\",\n    \"id\": 1\n}"),
("2","DUP_PRO_Secure_Global_Entity","{\n    \"basic_auth_password\": \"\",\n    \"lkp\": \"\",\n    \"id\": 2\n}"),
("3","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"Default\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": [],\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"rib16E2uf7iEgKxjYIOBcV8l72gUyOloggqEmXRLprBd8DLDIbnoJcagMhPVoN5ewdDeIcOX6cxosUnkvKmfqg==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"id\": 3\n}"),
("4","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"[Manual Mode]\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"QuOnyOk6hJDYqDBnaT3gVoSZlldcZusTMePSaFVMaIXneB8jNRIgg0ntERt6s\\/lDoB\\/xI39VLcuySPNrYiSspw==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": 0,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"id\": 4\n}"),
("5","DUP_PRO_System_Global_Entity","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1686141620,\n    \"id\": 5\n}");

INSERT IGNORE INTO `wpxd_duplicator_pro_packages` VALUES 
("1","20230607_mercifulwaygroup","f578832a5f4811096755_20230607124002","20","2023-06-07 20:40:08","superadmin89","{\n    \"ID\": 1,\n    \"Created\": \"2023-06-07 12:40:02\",\n    \"Version\": \"4.5.11.1\",\n    \"VersionWP\": \"6.2.2\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"8.0.28\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20230607_mercifulwaygroup\",\n    \"Hash\": \"f578832a5f4811096755_20230607124002\",\n    \"NameHash\": \"20230607_mercifulwaygroup_f578832a5f4811096755_20230607124002\",\n    \"Type\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20230607_mercifulwaygroup_f578832a5f4811096755_20230607124002_scan.json\",\n    \"timer_start\": 1686141621.00156307220458984375,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home2\\/mercifulg6281\\/public_html\\/.opcache\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/.tmb\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/images\\/files\\/aiowps_backups\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/images\\/files\\/backup-guard\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/images\\/files\\/backupbuddy_backups\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/images\\/files\\/backupbuddy_temp\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/images\\/files\\/ithemes-security\\/backups\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/images\\/files\\/mainwp\\/backup\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/images\\/files\\/pb_backupbuddy\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/images\\/files\\/snapshots\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/images\\/files\\/sucuri\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/images\\/files\\/wp-clone\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/images\\/files\\/wp_all_backup\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/images\\/files\\/wpbackitup_backups\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-content\\/ai1wm-backups\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-content\\/backups-dup-lite\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-content\\/backups-dup-pro\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-content\\/backups-dup-pro\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-content\\/backupwordpress\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-content\\/bps-backup\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-content\\/cache\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-content\\/content\\/cache\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-content\\/contents\\/cache\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-content\\/managewp\\/backups\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-content\\/old-cache\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-content\\/updraft\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-content\\/wfcache\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-content\\/wishlist-backup\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-content\\/wpvividbackups\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/.htaccess\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/.user.ini\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-config.php\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/php.ini\",\n            \"\\/home2\\/mercifulg6281\\/public_html\\/web.config\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20230607_mercifulwaygroup_f578832a5f4811096755_20230607124002_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home2\\/mercifulg6281\\/public_html\",\n        \"Size\": 241802808,\n        \"Dirs\": null,\n        \"DirCount\": 1778,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 13747,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20230607_mercifulwaygroup_f578832a5f4811096755_20230607124002_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"+D4K1M+ac4jfN8pkP4KizPlDE0ozck+\\/arrUKUSfZ22hmPtgSxmKjh45TJ8ft6BdpfDEpcj8Ptjt5+1iJ2iDyQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"utf8_general_ci\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MyISAM\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"isNameUpperCase\": false,\n            \"name\": \"mercifulg6281_wp1221021z\",\n            \"tablesBaseCount\": 71,\n            \"tablesFinalCount\": 71,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 35877,\n            \"tablesSizeOnDisk\": 18332724,\n            \"tablesList\": {\n                \"wpxd_actionscheduler_actions\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": false,\n                    \"size\": 147456\n                },\n                \"wpxd_actionscheduler_claims\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wpxd_actionscheduler_groups\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wpxd_actionscheduler_logs\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wpxd_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wpxd_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 98304\n                },\n                \"wpxd_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": false,\n                    \"size\": 11316\n                },\n                \"wpxd_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wpxd_fusion_forms\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wpxd_fusion_form_entries\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wpxd_fusion_form_fields\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wpxd_fusion_form_submissions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wpxd_itsec_distributed_storage\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wpxd_itsec_fingerprints\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wpxd_itsec_geolocation_cache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wpxd_itsec_lockouts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 98304\n                },\n                \"wpxd_itsec_logs\": {\n                    \"inaccurateRows\": 244,\n                    \"insertedRows\": false,\n                    \"size\": 360448\n                },\n                \"wpxd_itsec_mutexes\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wpxd_itsec_opaque_tokens\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wpxd_itsec_temp\": {\n                    \"inaccurateRows\": 193,\n                    \"insertedRows\": false,\n                    \"size\": 81920\n                },\n                \"wpxd_itsec_user_groups\": {\n                    \"inaccurateRows\": 10,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_layerslider\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wpxd_layerslider_drafts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wpxd_layerslider_revisions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wpxd_nf3_actions\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_nf3_action_meta\": {\n                    \"inaccurateRows\": 52,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_nf3_chunks\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_nf3_fields\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_nf3_field_meta\": {\n                    \"inaccurateRows\": 85,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_nf3_forms\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_nf3_form_meta\": {\n                    \"inaccurateRows\": 31,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_nf3_objects\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_nf3_object_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_nf3_relationships\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_nf3_upgrades\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_options\": {\n                    \"inaccurateRows\": 1594,\n                    \"insertedRows\": false,\n                    \"size\": 4472832\n                },\n                \"wpxd_postmeta\": {\n                    \"inaccurateRows\": 226,\n                    \"insertedRows\": false,\n                    \"size\": 229376\n                },\n                \"wpxd_posts\": {\n                    \"inaccurateRows\": 51,\n                    \"insertedRows\": false,\n                    \"size\": 1409024\n                },\n                \"wpxd_smush_dir_images\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wpxd_termmeta\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wpxd_terms\": {\n                    \"inaccurateRows\": 10,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wpxd_term_relationships\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wpxd_term_taxonomy\": {\n                    \"inaccurateRows\": 10,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wpxd_usermeta\": {\n                    \"inaccurateRows\": 33,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wpxd_users\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 65536\n                },\n                \"wpxd_wfblockediplog\": {\n                    \"inaccurateRows\": 3066,\n                    \"insertedRows\": false,\n                    \"size\": 245760\n                },\n                \"wpxd_wfblocks7\": {\n                    \"inaccurateRows\": 17247,\n                    \"insertedRows\": false,\n                    \"size\": 4997120\n                },\n                \"wpxd_wfconfig\": {\n                    \"inaccurateRows\": 268,\n                    \"insertedRows\": false,\n                    \"size\": 1556480\n                },\n                \"wpxd_wfcrawlers\": {\n                    \"inaccurateRows\": 44,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_wffilemods\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_wfhits\": {\n                    \"inaccurateRows\": 18,\n                    \"insertedRows\": false,\n                    \"size\": 65536\n                },\n                \"wpxd_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wpxd_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 81920\n                },\n                \"wpxd_wfknownfilelist\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wpxd_wflocs\": {\n                    \"inaccurateRows\": 127,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_wflogins\": {\n                    \"inaccurateRows\": 2042,\n                    \"insertedRows\": false,\n                    \"size\": 573440\n                },\n                \"wpxd_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wpxd_wfls_role_counts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 0\n                },\n                \"wpxd_wfls_settings\": {\n                    \"inaccurateRows\": 27,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_wfnotifications\": {\n                    \"inaccurateRows\": 8,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 81920\n                },\n                \"wpxd_wfreversecache\": {\n                    \"inaccurateRows\": 34,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_wfsnipcache\": {\n                    \"inaccurateRows\": 9456,\n                    \"insertedRows\": false,\n                    \"size\": 2228224\n                },\n                \"wpxd_wfstatus\": {\n                    \"inaccurateRows\": 953,\n                    \"insertedRows\": false,\n                    \"size\": 229376\n                },\n                \"wpxd_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_wfwaffailures\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wpxd_wpmailsmtp_debug_events\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wpxd_wpmailsmtp_tasks_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server - (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20230607_mercifulwaygroup_f578832a5f4811096755_20230607124002_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - (GPL)\",\n        \"dbStorePathPublic\": \"\\/home2\\/mercifulg6281\\/public_html\\/cms\\/wp-content\\/backups-dup-pro\\/tmp\\/20230607_mercifulwaygroup_f578832a5f4811096755_20230607124002_database.sql\"\n    },\n    \"Status\": 20,\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 1686141623,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"wpxd_users\",\n            \"wpxd_usermeta\",\n            \"wpxd_actionscheduler_actions\",\n            \"wpxd_actionscheduler_claims\",\n            \"wpxd_actionscheduler_groups\",\n            \"wpxd_actionscheduler_logs\",\n            \"wpxd_commentmeta\",\n            \"wpxd_comments\",\n            \"wpxd_duplicator_pro_entities\",\n            \"wpxd_duplicator_pro_packages\",\n            \"wpxd_fusion_forms\",\n            \"wpxd_fusion_form_entries\",\n            \"wpxd_fusion_form_fields\",\n            \"wpxd_fusion_form_submissions\",\n            \"wpxd_itsec_distributed_storage\",\n            \"wpxd_itsec_fingerprints\",\n            \"wpxd_itsec_geolocation_cache\",\n            \"wpxd_itsec_lockouts\",\n            \"wpxd_itsec_logs\",\n            \"wpxd_itsec_mutexes\",\n            \"wpxd_itsec_opaque_tokens\",\n            \"wpxd_itsec_temp\",\n            \"wpxd_itsec_user_groups\",\n            \"wpxd_layerslider\",\n            \"wpxd_layerslider_drafts\",\n            \"wpxd_layerslider_revisions\",\n            \"wpxd_links\",\n            \"wpxd_nf3_actions\",\n            \"wpxd_nf3_action_meta\",\n            \"wpxd_nf3_chunks\",\n            \"wpxd_nf3_fields\",\n            \"wpxd_nf3_field_meta\",\n            \"wpxd_nf3_forms\",\n            \"wpxd_nf3_form_meta\",\n            \"wpxd_nf3_objects\",\n            \"wpxd_nf3_object_meta\",\n            \"wpxd_nf3_relationships\",\n            \"wpxd_nf3_upgrades\",\n            \"wpxd_options\",\n            \"wpxd_postmeta\",\n            \"wpxd_posts\",\n            \"wpxd_smush_dir_images\",\n            \"wpxd_termmeta\",\n            \"wpxd_terms\",\n            \"wpxd_term_relationships\",\n            \"wpxd_term_taxonomy\",\n            \"wpxd_wfblockediplog\",\n            \"wpxd_wfblocks7\",\n            \"wpxd_wfconfig\",\n            \"wpxd_wfcrawlers\",\n            \"wpxd_wffilechanges\",\n            \"wpxd_wffilemods\",\n            \"wpxd_wfhits\",\n            \"wpxd_wfhoover\",\n            \"wpxd_wfissues\",\n            \"wpxd_wfknownfilelist\",\n            \"wpxd_wflivetraffichuman\",\n            \"wpxd_wflocs\",\n            \"wpxd_wflogins\",\n            \"wpxd_wfls_2fa_secrets\",\n            \"wpxd_wfls_role_counts\",\n            \"wpxd_wfls_settings\",\n            \"wpxd_wfnotifications\",\n            \"wpxd_wfpendingissues\",\n            \"wpxd_wfreversecache\",\n            \"wpxd_wfsnipcache\",\n            \"wpxd_wfstatus\",\n            \"wpxd_wftrafficrates\",\n            \"wpxd_wfwaffailures\",\n            \"wpxd_wpmailsmtp_debug_events\",\n            \"wpxd_wpmailsmtp_tasks_meta\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1686141621.011353969573974609375,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 35878,\n            \"tables\": {\n                \"wpxd_users\": {\n                    \"start\": \"1\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_duplicator_pro_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_duplicator_pro_packages\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_fusion_forms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_fusion_form_entries\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_fusion_form_fields\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_fusion_form_submissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_itsec_distributed_storage\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_itsec_fingerprints\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_itsec_geolocation_cache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_itsec_lockouts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_itsec_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_itsec_mutexes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_itsec_opaque_tokens\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_itsec_temp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_itsec_user_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_layerslider\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_layerslider_drafts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_layerslider_revisions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_nf3_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_nf3_action_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_nf3_chunks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_nf3_fields\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_nf3_field_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_nf3_forms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_nf3_form_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_nf3_objects\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_nf3_object_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_nf3_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_nf3_upgrades\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_smush_dir_images\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wfblockediplog\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wfblocks7\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wfconfig\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wfcrawlers\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wffilechanges\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wffilemods\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wfhits\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wfhoover\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wfissues\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wfknownfilelist\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wflivetraffichuman\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wflocs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wflogins\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wfls_2fa_secrets\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wfls_role_counts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wfls_settings\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wfnotifications\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wfpendingissues\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wfreversecache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wfsnipcache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wfstatus\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wftrafficrates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wfwaffailures\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wpmailsmtp_debug_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wpxd_wpmailsmtp_tasks_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"-2\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": null,\n            \"stopped_timestamp\": null,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": 4\n}");

INSERT IGNORE INTO `wpxd_itsec_lockouts` VALUES 
("1","brute_force","2020-12-18 18:47:18","2020-12-18 10:47:18","2020-12-18 19:02:18","2020-12-18 11:02:18","14.192.212.191",NULL,NULL,"1","O:40:\"iThemesSecurity\\Lib\\Lockout\\Host_Context\":5:{s:46:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0host\";s:14:\"14.192.212.191\";s:55:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_user_id\";i:1;s:56:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_username\";N;s:62:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0user_limit_triggered\";b:0;s:51:\"\0iThemesSecurity\\Lib\\Lockout\\Context\0lockout_module\";s:11:\"brute_force\";}");

INSERT IGNORE INTO `wpxd_itsec_logs` VALUES 
("1","0","notification_center","send::hide-backend","a:2:{s:10:\"recipients\";a:2:{i:0;s:17:\"phei@deoworkz.com\";i:1;s:17:\"info@deoworkz.net\";}s:7:\"subject\";s:62:\"[www.mercifulwaygroup.com/cms] WordPress Login Address Changed\";}","debug","2020-10-05 12:05:10","2020-10-05 12:05:10","24143504","24346656","https://www.mercifulwaygroup.com/cms/cms/wp-admin/admin-ajax.php","1","1","14.192.212.205"),
("2","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:20:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:47:\"en-GB,en;q=0.9,zh-CN;q=0.8,zh;q=0.7,en-US;q=0.6\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:12:\"HTTP_REFERER\";s:41:\"https://www.mercifulwaygroup.com/cms/cms/\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.121 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601899690.136006;s:12:\"REQUEST_TIME\";i:1601899690;}}","notice","2020-10-05 12:08:10","2020-10-05 12:08:10","14865504","15022336","https://www.mercifulwaygroup.com/cms/cms/","1","1","14.192.212.205"),
("3","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:20:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:47:\"en-GB,en;q=0.9,zh-CN;q=0.8,zh;q=0.7,en-US;q=0.6\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:12:\"HTTP_REFERER\";s:37:\"https://www.mercifulwaygroup.com/cms/\";s:19:\"HTTP_SEC_FETCH_DEST\";s:5:\"image\";s:19:\"HTTP_SEC_FETCH_MODE\";s:7:\"no-cors\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:11:\"HTTP_ACCEPT\";s:50:\"image/avif,image/webp,image/apng,image/*,*/*;q=0.8\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.121 Safari/537.36\";s:18:\"HTTP_CACHE_CONTROL\";s:8:\"no-cache\";s:11:\"HTTP_PRAGMA\";s:8:\"no-cache\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601899695.70002;s:12:\"REQUEST_TIME\";i:1601899695;}}","notice","2020-10-05 12:08:15","2020-10-05 12:08:15","14670752","14741216","https://www.mercifulwaygroup.com/cms/favicon.ico","1","0","14.192.212.205"),
("4","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:20:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:47:\"en-GB,en;q=0.9,zh-CN;q=0.8,zh;q=0.7,en-US;q=0.6\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:12:\"HTTP_REFERER\";s:37:\"https://www.mercifulwaygroup.com/cms/\";s:19:\"HTTP_SEC_FETCH_DEST\";s:5:\"image\";s:19:\"HTTP_SEC_FETCH_MODE\";s:7:\"no-cors\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:11:\"HTTP_ACCEPT\";s:50:\"image/avif,image/webp,image/apng,image/*,*/*;q=0.8\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.121 Safari/537.36\";s:18:\"HTTP_CACHE_CONTROL\";s:8:\"no-cache\";s:11:\"HTTP_PRAGMA\";s:8:\"no-cache\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601899721.327851;s:12:\"REQUEST_TIME\";i:1601899721;}}","notice","2020-10-05 12:08:41","2020-10-05 12:08:41","14737760","14829712","https://www.mercifulwaygroup.com/cms/favicon.ico","1","0","14.192.212.205"),
("5","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:20:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:47:\"en-GB,en;q=0.9,zh-CN;q=0.8,zh;q=0.7,en-US;q=0.6\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:12:\"HTTP_REFERER\";s:37:\"https://www.mercifulwaygroup.com/cms/\";s:19:\"HTTP_SEC_FETCH_DEST\";s:5:\"image\";s:19:\"HTTP_SEC_FETCH_MODE\";s:7:\"no-cors\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:11:\"HTTP_ACCEPT\";s:50:\"image/avif,image/webp,image/apng,image/*,*/*;q=0.8\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.121 Safari/537.36\";s:18:\"HTTP_CACHE_CONTROL\";s:8:\"no-cache\";s:11:\"HTTP_PRAGMA\";s:8:\"no-cache\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601899723.21436;s:12:\"REQUEST_TIME\";i:1601899723;}}","notice","2020-10-05 12:08:43","2020-10-05 12:08:43","14670752","14741216","https://www.mercifulwaygroup.com/cms/favicon.ico","1","0","14.192.212.205"),
("6","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:20:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:47:\"en-GB,en;q=0.9,zh-CN;q=0.8,zh;q=0.7,en-US;q=0.6\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:12:\"HTTP_REFERER\";s:37:\"https://www.mercifulwaygroup.com/cms/\";s:19:\"HTTP_SEC_FETCH_DEST\";s:5:\"image\";s:19:\"HTTP_SEC_FETCH_MODE\";s:7:\"no-cors\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:11:\"HTTP_ACCEPT\";s:50:\"image/avif,image/webp,image/apng,image/*,*/*;q=0.8\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.121 Safari/537.36\";s:18:\"HTTP_CACHE_CONTROL\";s:8:\"no-cache\";s:11:\"HTTP_PRAGMA\";s:8:\"no-cache\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601899739.534098;s:12:\"REQUEST_TIME\";i:1601899739;}}","notice","2020-10-05 12:08:59","2020-10-05 12:08:59","14670752","14741216","https://www.mercifulwaygroup.com/cms/favicon.ico","1","0","14.192.212.205"),
("7","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:20:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:47:\"en-GB,en;q=0.9,zh-CN;q=0.8,zh;q=0.7,en-US;q=0.6\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:12:\"HTTP_REFERER\";s:37:\"https://www.mercifulwaygroup.com/cms/\";s:19:\"HTTP_SEC_FETCH_DEST\";s:5:\"image\";s:19:\"HTTP_SEC_FETCH_MODE\";s:7:\"no-cors\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:11:\"HTTP_ACCEPT\";s:50:\"image/avif,image/webp,image/apng,image/*,*/*;q=0.8\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.121 Safari/537.36\";s:18:\"HTTP_CACHE_CONTROL\";s:8:\"no-cache\";s:11:\"HTTP_PRAGMA\";s:8:\"no-cache\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601899743.13293;s:12:\"REQUEST_TIME\";i:1601899743;}}","notice","2020-10-05 12:09:03","2020-10-05 12:09:03","14671168","14741632","https://www.mercifulwaygroup.com/cms/favicon.ico","1","0","14.192.212.205"),
("8","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:20:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:47:\"en-GB,en;q=0.9,zh-CN;q=0.8,zh;q=0.7,en-US;q=0.6\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:12:\"HTTP_REFERER\";s:37:\"https://www.mercifulwaygroup.com/cms/\";s:19:\"HTTP_SEC_FETCH_DEST\";s:5:\"image\";s:19:\"HTTP_SEC_FETCH_MODE\";s:7:\"no-cors\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:11:\"HTTP_ACCEPT\";s:50:\"image/avif,image/webp,image/apng,image/*,*/*;q=0.8\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.121 Safari/537.36\";s:18:\"HTTP_CACHE_CONTROL\";s:8:\"no-cache\";s:11:\"HTTP_PRAGMA\";s:8:\"no-cache\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601899756.737622;s:12:\"REQUEST_TIME\";i:1601899756;}}","notice","2020-10-05 12:09:17","2020-10-05 12:09:16","14670752","14741216","https://www.mercifulwaygroup.com/cms/favicon.ico","1","0","14.192.212.205"),
("9","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:49:\"https://www.mercifulwaygroup.com/cms/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601912502.633292;s:12:\"REQUEST_TIME\";i:1601912502;}}","notice","2020-10-05 15:41:42","2020-10-05 15:41:42","14678256","15583840","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","74.208.40.42"),
("10","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:49:\"https://www.mercifulwaygroup.com/cms/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601912519.857132;s:12:\"REQUEST_TIME\";i:1601912519;}}","notice","2020-10-05 15:41:59","2020-10-05 15:41:59","14677776","14747568","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","173.236.246.243"),
("11","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:49:\"https://www.mercifulwaygroup.com/cms/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601921969.134242;s:12:\"REQUEST_TIME\";i:1601921969;}}","notice","2020-10-05 18:19:30","2020-10-05 18:19:29","18510272","19415856","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","149.202.45.11"),
("12","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601927912.648284;s:12:\"REQUEST_TIME\";i:1601927912;}}","notice","2020-10-05 19:58:32","2020-10-05 19:58:32","14678064","14747824","https://www.mercifulwaygroup.com/cms/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php","1","0","3.236.228.11"),
("13","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:15:{s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:14:\"CONTENT_LENGTH\";s:4:\"1739\";s:11:\"HTTP_EXPECT\";s:12:\"100-continue\";s:12:\"CONTENT_TYPE\";s:70:\"multipart/form-data; boundary=------------------------66e3ca93281c7050\";s:15:\"HTTP_USER_AGENT\";s:105:\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:9:\"HTTP_HOST\";s:20:\"mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601929261.264712;s:12:\"REQUEST_TIME\";i:1601929261;}}","notice","2020-10-05 20:21:05","2020-10-05 20:21:01","18630696","19536232","https://www.mercifulwaygroup.com/cms/wp-content/plugins/wp-file-manager/lib/php/connector.minimal.php","1","0","3.236.228.11"),
("14","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:15:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:27:\"HTTP_X_NEWRELIC_TRANSACTION\";s:76:\"PxRTAl4BWwUCBVBTBQNSAgZQFB8EBw8RVU4aBlsAVlEFV1hQAFMBBwBUVkNKQQoDCFdSBABSFTs=\";s:18:\"HTTP_X_NEWRELIC_ID\";s:24:\"VgABUVNQChAEUldVAgQCVQ==\";s:15:\"HTTP_USER_AGENT\";s:133:\"Better Uptime Bot Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601941397.200443;s:12:\"REQUEST_TIME\";i:1601941397;}}","notice","2020-10-05 23:43:17","2020-10-05 23:43:17","14695352","15600008","https://www.mercifulwaygroup.com/cms/check_db.php","1","0","172.105.206.169"),
("15","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:15:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:27:\"HTTP_X_NEWRELIC_TRANSACTION\";s:76:\"PxQAB1FUXgVRAlMBAAUFBQBVFB8EBw8RVU4aVV4PA1QFBF9TUlYHUAdSU0NKQQoDCFdSBABSFTs=\";s:18:\"HTTP_X_NEWRELIC_ID\";s:24:\"VgABUVNQChAEUldVAgQCVQ==\";s:15:\"HTTP_USER_AGENT\";s:133:\"Better Uptime Bot Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601941401.057701;s:12:\"REQUEST_TIME\";i:1601941401;}}","notice","2020-10-05 23:43:21","2020-10-05 23:43:21","14694872","14763736","https://www.mercifulwaygroup.com/cms/check_db.php","1","0","209.222.4.189"),
("16","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:15:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:27:\"HTTP_X_NEWRELIC_TRANSACTION\";s:76:\"PxQDWFFSDQIJUlRaBlUOVwUFFB8EBw8RVU4aVgEPBQcCXA9UCVBXW1VXA0NKQQoDCFdSBABSFTs=\";s:18:\"HTTP_X_NEWRELIC_ID\";s:24:\"VgABUVNQChAEUldVAgQCVQ==\";s:15:\"HTTP_USER_AGENT\";s:133:\"Better Uptime Bot Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601941401.531775;s:12:\"REQUEST_TIME\";i:1601941401;}}","notice","2020-10-05 23:43:21","2020-10-05 23:43:21","14694872","14763736","https://www.mercifulwaygroup.com/cms/check_db.php","1","0","168.119.96.203"),
("17","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:15:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:27:\"HTTP_X_NEWRELIC_TRANSACTION\";s:76:\"PxRVUAUAWlUFBwRaBwYFAFIIFB8EBw8RVU4aAAlbV1BVUFoECVEEUAIADkNKQQoDCFdSBABSFTs=\";s:18:\"HTTP_X_NEWRELIC_ID\";s:24:\"VgABUVNQChAEUldVAgQCVQ==\";s:15:\"HTTP_USER_AGENT\";s:133:\"Better Uptime Bot Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601941402.138727;s:12:\"REQUEST_TIME\";i:1601941402;}}","notice","2020-10-05 23:43:22","2020-10-05 23:43:22","14694872","14763736","https://www.mercifulwaygroup.com/cms/check_db.php","1","0","172.105.190.118"),
("18","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:14:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:20:\"HTTP_ACCEPT_ENCODING\";s:12:\"gzip,deflate\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:58:\"Slackbot-LinkExpanding 1.0 (+https://api.slack.com/robots)\";s:10:\"HTTP_RANGE\";s:13:\"bytes=0-32768\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601941403.858848;s:12:\"REQUEST_TIME\";i:1601941403;}}","notice","2020-10-05 23:43:23","2020-10-05 23:43:23","14695216","14764080","https://www.mercifulwaygroup.com/cms/check_db.php","1","0","34.207.69.250"),
("19","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:14:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:20:\"HTTP_ACCEPT_ENCODING\";s:12:\"gzip,deflate\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:58:\"Slackbot-LinkExpanding 1.0 (+https://api.slack.com/robots)\";s:10:\"HTTP_RANGE\";s:13:\"bytes=0-32768\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601941404.319251;s:12:\"REQUEST_TIME\";i:1601941404;}}","notice","2020-10-05 23:43:24","2020-10-05 23:43:24","14695216","14764080","https://www.mercifulwaygroup.com/cms/check_db.php","1","0","34.235.151.90"),
("20","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:14:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:20:\"HTTP_ACCEPT_ENCODING\";s:12:\"gzip,deflate\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:58:\"Slackbot-LinkExpanding 1.0 (+https://api.slack.com/robots)\";s:10:\"HTTP_RANGE\";s:13:\"bytes=0-32768\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601941405.065436;s:12:\"REQUEST_TIME\";i:1601941405;}}","notice","2020-10-05 23:43:25","2020-10-05 23:43:25","14695472","14764368","https://www.mercifulwaygroup.com/cms/check_db.php\\\\r\\\\nVary","1","0","34.207.69.250"),
("21","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:18:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:5:\"en-US\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_SITE\";s:4:\"none\";s:11:\"HTTP_ACCEPT\";s:124:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:15:\"HTTP_USER_AGENT\";s:133:\"Better Uptime Bot Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601941405.518339;s:12:\"REQUEST_TIME\";i:1601941405;}}","notice","2020-10-05 23:43:25","2020-10-05 23:43:25","14698880","14767104","https://www.mercifulwaygroup.com/cms/check_db.php","1","0","54.243.207.163"),
("22","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:14:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:20:\"HTTP_ACCEPT_ENCODING\";s:12:\"gzip,deflate\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:58:\"Slackbot-LinkExpanding 1.0 (+https://api.slack.com/robots)\";s:10:\"HTTP_RANGE\";s:13:\"bytes=0-32768\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601941405.192521;s:12:\"REQUEST_TIME\";i:1601941405;}}","notice","2020-10-05 23:43:26","2020-10-05 23:43:25","18526824","19431480","https://www.mercifulwaygroup.com/cms/check_db.php","1","0","107.21.173.6"),
("23","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:14:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:20:\"HTTP_ACCEPT_ENCODING\";s:12:\"gzip,deflate\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:58:\"Slackbot-LinkExpanding 1.0 (+https://api.slack.com/robots)\";s:10:\"HTTP_RANGE\";s:13:\"bytes=0-32768\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601941406.558741;s:12:\"REQUEST_TIME\";i:1601941406;}}","notice","2020-10-05 23:43:26","2020-10-05 23:43:26","14695456","14764352","https://www.mercifulwaygroup.com/cms/check_db.php\\\\r\\\\nVary","1","0","34.235.151.90"),
("24","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:15:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:27:\"HTTP_X_NEWRELIC_TRANSACTION\";s:76:\"PxQGVlFXXQIFVAcGAlMPB1AJFB8EBw8RVU4aUw8PAFcCUAkHVVRRWgUCD0NKQQoDCFdSBABSFTs=\";s:18:\"HTTP_X_NEWRELIC_ID\";s:24:\"VgABUVNQChAEUldVAgQCVQ==\";s:15:\"HTTP_USER_AGENT\";s:133:\"Better Uptime Bot Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601941418.100567;s:12:\"REQUEST_TIME\";i:1601941418;}}","notice","2020-10-05 23:43:38","2020-10-05 23:43:38","14696544","15601200","https://www.mercifulwaygroup.com/cms/check_db.php","1","0","209.222.4.180"),
("25","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:15:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:27:\"HTTP_X_NEWRELIC_TRANSACTION\";s:76:\"PxQGAFdTAAQAAQNbD1MOU1QFFB8EBw8RVU4aU1kJBAoEVVwDCFlRW1EGA0NKQQoDCFdSBABSFTs=\";s:18:\"HTTP_X_NEWRELIC_ID\";s:24:\"VgABUVNQChAEUldVAgQCVQ==\";s:15:\"HTTP_USER_AGENT\";s:133:\"Better Uptime Bot Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601941452.91747;s:12:\"REQUEST_TIME\";i:1601941452;}}","notice","2020-10-05 23:44:13","2020-10-05 23:44:12","14696016","14764880","https://www.mercifulwaygroup.com/cms/check_db.php","1","0","209.222.4.189"),
("26","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:15:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:27:\"HTTP_X_NEWRELIC_TRANSACTION\";s:76:\"PxQCUlFWAQIFB1gHVQBVAlIHFB8EBw8RVU4aVwsPAQsCUFpYVAMCAAAAAUNKQQoDCFdSBABSFTs=\";s:18:\"HTTP_X_NEWRELIC_ID\";s:24:\"VgABUVNQChAEUldVAgQCVQ==\";s:15:\"HTTP_USER_AGENT\";s:133:\"Better Uptime Bot Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601941477.362759;s:12:\"REQUEST_TIME\";i:1601941477;}}","notice","2020-10-05 23:44:37","2020-10-05 23:44:37","14695904","14764768","https://www.mercifulwaygroup.com/cms/check_db.php","1","0","209.222.4.189"),
("27","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:15:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:27:\"HTTP_X_NEWRELIC_TRANSACTION\";s:76:\"PxRWBFIHCFUDXFIGVghTA10HFB8EBw8RVU4aA10MUAJVVgFSVQAKBgEPAUNKQQoDCFdSBABSFTs=\";s:18:\"HTTP_X_NEWRELIC_ID\";s:24:\"VgABUVNQChAEUldVAgQCVQ==\";s:15:\"HTTP_USER_AGENT\";s:133:\"Better Uptime Bot Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601941507.807582;s:12:\"REQUEST_TIME\";i:1601941507;}}","notice","2020-10-05 23:45:07","2020-10-05 23:45:07","14651000","14719864","https://www.mercifulwaygroup.com/cms/check_db.php","1","0","209.222.4.189"),
("28","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:15:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:27:\"HTTP_X_NEWRELIC_TRANSACTION\";s:76:\"PxQGVQJTAQRUBlBUUwNUX1JVFB8EBw8RVU4aUwxcBAsEAVtQBwUBAV0AU0NKQQoDCFdSBABSFTs=\";s:18:\"HTTP_X_NEWRELIC_ID\";s:24:\"VgABUVNQChAEUldVAgQCVQ==\";s:15:\"HTTP_USER_AGENT\";s:133:\"Better Uptime Bot Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601941536.521852;s:12:\"REQUEST_TIME\";i:1601941536;}}","notice","2020-10-05 23:45:36","2020-10-05 23:45:36","14651032","14719896","https://www.mercifulwaygroup.com/cms/check_db.php","1","0","168.119.96.203"),
("29","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:15:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:27:\"HTTP_X_NEWRELIC_TRANSACTION\";s:76:\"PxRTUFFaXVFRVAJXVQMHUVIJFB8EBw8RVU4aBgkPDVdRBAkCBAMBUlMAD0NKQQoDCFdSBABSFTs=\";s:18:\"HTTP_X_NEWRELIC_ID\";s:24:\"VgABUVNQChAEUldVAgQCVQ==\";s:15:\"HTTP_USER_AGENT\";s:133:\"Better Uptime Bot Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601941570.520192;s:12:\"REQUEST_TIME\";i:1601941570;}}","notice","2020-10-05 23:46:10","2020-10-05 23:46:10","14651416","14720280","https://www.mercifulwaygroup.com/cms/check_db.php","1","0","139.162.109.252"),
("30","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:15:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:27:\"HTTP_X_NEWRELIC_TRANSACTION\";s:76:\"PxQEAl5WXlUGXAQHUgJUVFUAFB8EBw8RVU4aUVsAAVRVUwEEVAQAAVYHBkNKQQoDCFdSBABSFTs=\";s:18:\"HTTP_X_NEWRELIC_ID\";s:24:\"VgABUVNQChAEUldVAgQCVQ==\";s:15:\"HTTP_USER_AGENT\";s:133:\"Better Uptime Bot Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601941596.938941;s:12:\"REQUEST_TIME\";i:1601941596;}}","notice","2020-10-05 23:46:37","2020-10-05 23:46:36","14654304","15558960","https://www.mercifulwaygroup.com/cms/check_db.php","1","0","168.119.96.202"),
("31","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:15:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:27:\"HTTP_X_NEWRELIC_TRANSACTION\";s:76:\"PxRRUQVUXgJRBVAAUVUEVl1TFB8EBw8RVU4aBAhbA1QCBFhQUwdXUVQPVUNKQQoDCFdSBABSFTs=\";s:18:\"HTTP_X_NEWRELIC_ID\";s:24:\"VgABUVNQChAEUldVAgQCVQ==\";s:15:\"HTTP_USER_AGENT\";s:133:\"Better Uptime Bot Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601941628.354606;s:12:\"REQUEST_TIME\";i:1601941628;}}","notice","2020-10-05 23:47:08","2020-10-05 23:47:08","14653824","14722688","https://www.mercifulwaygroup.com/cms/check_db.php","1","0","209.222.4.189"),
("32","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:15:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:27:\"HTTP_X_NEWRELIC_TRANSACTION\";s:76:\"PxQHVlVTCVcHVwQDUglUUVcIFB8EBw8RVU4aUg8LBANXUgoEUAQLAVMFDkNKQQoDCFdSBABSFTs=\";s:18:\"HTTP_X_NEWRELIC_ID\";s:24:\"VgABUVNQChAEUldVAgQCVQ==\";s:15:\"HTTP_USER_AGENT\";s:133:\"Better Uptime Bot Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601941657.458811;s:12:\"REQUEST_TIME\";i:1601941657;}}","notice","2020-10-05 23:47:37","2020-10-05 23:47:37","14653824","14722688","https://www.mercifulwaygroup.com/cms/check_db.php","1","0","209.222.4.180"),
("33","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:19:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_SITE\";s:10:\"cross-site\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.121 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601949676.646407;s:12:\"REQUEST_TIME\";i:1601949676;}}","notice","2020-10-06 02:01:18","2020-10-06 02:01:16","15869872","16774816","https://www.mercifulwaygroup.com/cms/cms/not_found","1","0","113.210.93.110"),
("34","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:19:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_SITE\";s:10:\"cross-site\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.121 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601949686.460587;s:12:\"REQUEST_TIME\";i:1601949686;}}","notice","2020-10-06 02:01:26","2020-10-06 02:01:26","14662776","14731928","https://www.mercifulwaygroup.com/cms/cms/not_found","1","0","113.210.93.110"),
("35","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:19:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_SITE\";s:10:\"cross-site\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.121 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601949688.640993;s:12:\"REQUEST_TIME\";i:1601949688;}}","notice","2020-10-06 02:01:28","2020-10-06 02:01:28","14662360","14731512","https://www.mercifulwaygroup.com/cms/cms/not_found","1","0","113.210.93.110"),
("36","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:17:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:19:\"HTTP_SEC_FETCH_DEST\";s:5:\"style\";s:19:\"HTTP_SEC_FETCH_MODE\";s:7:\"no-cors\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:11:\"HTTP_ACCEPT\";s:18:\"text/css,*/*;q=0.1\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.121 Safari/537.36\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601960235.966863;s:12:\"REQUEST_TIME\";i:1601960235;}}","notice","2020-10-06 04:57:16","2020-10-06 04:57:15","16592952","16622872","https://www.mercifulwaygroup.com/cms/cms/wp-admin/url(%22https:/fonts.googleapis.com/css2?family=Nunito:wght@400","1","2","113.210.93.110"),
("37","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-06 12:17:31","2020-10-06 12:17:28","20224600","20612552","https://www.mercifulwaygroup.com/cms/robots.txt","1","0","66.249.71.95"),
("38","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:13:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:11:\"HTTP_PRAGMA\";s:8:\"no-cache\";s:12:\"HTTP_REFERER\";s:36:\"https://www.mercifulwaygroup.com/cms\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/527.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1601999029.085696;s:12:\"REQUEST_TIME\";i:1601999029;}}","notice","2020-10-06 15:43:49","2020-10-06 15:43:49","16497656","17403184","https://www.mercifulwaygroup.com/cms/vqmod/xml/betaout.xml?_=1555313087","1","0","45.132.227.175"),
("39","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:54:\"https://www.mercifulwaygroup.com/cms/blog/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602017496.316726;s:12:\"REQUEST_TIME\";i:1602017496;}}","notice","2020-10-06 20:51:36","2020-10-06 20:51:36","16490968","17396552","https://www.mercifulwaygroup.com/cms/blog/wp-login.php","1","0","150.95.109.154"),
("40","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:54:\"https://www.mercifulwaygroup.com/cms/blog/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602017497.337402;s:12:\"REQUEST_TIME\";i:1602017497;}}","notice","2020-10-06 20:51:37","2020-10-06 20:51:37","16490968","17396552","https://www.mercifulwaygroup.com/cms/blog/wp-login.php","1","0","150.95.109.154"),
("41","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:17:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:19:\"HTTP_SEC_FETCH_DEST\";s:5:\"style\";s:19:\"HTTP_SEC_FETCH_MODE\";s:7:\"no-cors\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:11:\"HTTP_ACCEPT\";s:18:\"text/css,*/*;q=0.1\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.121 Safari/537.36\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602036233.908785;s:12:\"REQUEST_TIME\";i:1602036233;}}","notice","2020-10-07 02:03:54","2020-10-07 02:03:53","16595352","16625272","https://www.mercifulwaygroup.com/cms/cms/wp-admin/url(%22https:/fonts.googleapis.com/css2?family=Nunito:wght@400","1","2","113.210.93.110"),
("42","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:17:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:19:\"HTTP_SEC_FETCH_DEST\";s:5:\"style\";s:19:\"HTTP_SEC_FETCH_MODE\";s:7:\"no-cors\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:11:\"HTTP_ACCEPT\";s:18:\"text/css,*/*;q=0.1\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.121 Safari/537.36\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602036246.349187;s:12:\"REQUEST_TIME\";i:1602036246;}}","notice","2020-10-07 02:04:06","2020-10-07 02:04:06","16595352","16625272","https://www.mercifulwaygroup.com/cms/cms/wp-admin/url(%22https:/fonts.googleapis.com/css2?family=Nunito:wght@400","1","2","113.210.93.110"),
("43","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:14:{s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-us,en;q=0.5\";s:15:\"HTTP_USER_AGENT\";s:109:\"Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.1.6) Gecko/20091201 Firefox/3.5.6 (.NET CLR 3.5.30729)\";s:14:\"CONTENT_LENGTH\";s:3:\"399\";s:12:\"CONTENT_TYPE\";s:71:\"multipart/form-data; boundary=---------------------------10901194343953\";s:20:\"HTTP_ACCEPT_ENCODING\";s:12:\"gzip,deflate\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:9:\"HTTP_HOST\";s:20:\"mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602036622.818041;s:12:\"REQUEST_TIME\";i:1602036622;}}","notice","2020-10-07 02:10:23","2020-10-07 02:10:23","20627920","21533440","https://www.mercifulwaygroup.com/cms/admin/index.php?route=common/login","1","0","5.188.62.140"),
("44","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:17:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:19:\"HTTP_SEC_FETCH_DEST\";s:5:\"style\";s:19:\"HTTP_SEC_FETCH_MODE\";s:7:\"no-cors\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:11:\"HTTP_ACCEPT\";s:18:\"text/css,*/*;q=0.1\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.121 Safari/537.36\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602036730.538996;s:12:\"REQUEST_TIME\";i:1602036730;}}","notice","2020-10-07 02:12:10","2020-10-07 02:12:10","16595352","16625272","https://www.mercifulwaygroup.com/cms/cms/wp-admin/url(%22https:/fonts.googleapis.com/css2?family=Nunito:wght@400","1","2","113.210.93.110"),
("45","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:17:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:19:\"HTTP_SEC_FETCH_DEST\";s:5:\"style\";s:19:\"HTTP_SEC_FETCH_MODE\";s:7:\"no-cors\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:11:\"HTTP_ACCEPT\";s:18:\"text/css,*/*;q=0.1\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.121 Safari/537.36\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602036740.569449;s:12:\"REQUEST_TIME\";i:1602036740;}}","notice","2020-10-07 02:12:20","2020-10-07 02:12:20","16735656","16765576","https://www.mercifulwaygroup.com/cms/cms/wp-admin/url(%22https:/fonts.googleapis.com/css2?family=Nunito:wght@400","1","2","113.210.93.110"),
("46","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:17:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:19:\"HTTP_SEC_FETCH_DEST\";s:5:\"style\";s:19:\"HTTP_SEC_FETCH_MODE\";s:7:\"no-cors\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:11:\"HTTP_ACCEPT\";s:18:\"text/css,*/*;q=0.1\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.121 Safari/537.36\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602037118.530224;s:12:\"REQUEST_TIME\";i:1602037118;}}","notice","2020-10-07 02:18:38","2020-10-07 02:18:38","16734920","16764840","https://www.mercifulwaygroup.com/cms/cms/wp-admin/url(%22https:/fonts.googleapis.com/css2?family=Nunito:wght@400","1","2","113.210.93.110"),
("47","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:17:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:19:\"HTTP_SEC_FETCH_DEST\";s:5:\"style\";s:19:\"HTTP_SEC_FETCH_MODE\";s:7:\"no-cors\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:11:\"HTTP_ACCEPT\";s:18:\"text/css,*/*;q=0.1\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.121 Safari/537.36\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602037121.690193;s:12:\"REQUEST_TIME\";i:1602037121;}}","notice","2020-10-07 02:18:41","2020-10-07 02:18:41","16734920","16764840","https://www.mercifulwaygroup.com/cms/cms/wp-admin/url(%22https:/fonts.googleapis.com/css2?family=Nunito:wght@400","1","2","113.210.93.110"),
("48","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:14:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:20:\"HTTP_ACCEPT_ENCODING\";s:15:\"gzip,deflate,br\";s:15:\"HTTP_USER_AGENT\";s:72:\"Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)\";s:9:\"HTTP_FROM\";s:26:\"googlebot(at)googlebot.com\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602041050.392783;s:12:\"REQUEST_TIME\";i:1602041050;}}","notice","2020-10-07 03:24:10","2020-10-07 03:24:10","16640160","16711248","https://www.mercifulwaygroup.com/cms/.well-known/assetlinks.json","1","0","66.249.65.218"),
("49","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:17:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:19:\"HTTP_SEC_FETCH_DEST\";s:5:\"style\";s:19:\"HTTP_SEC_FETCH_MODE\";s:7:\"no-cors\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:11:\"HTTP_ACCEPT\";s:18:\"text/css,*/*;q=0.1\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.121 Safari/537.36\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602041680.453411;s:12:\"REQUEST_TIME\";i:1602041680;}}","notice","2020-10-07 03:34:40","2020-10-07 03:34:40","16768304","16798224","https://www.mercifulwaygroup.com/cms/cms/wp-admin/url(%22https:/fonts.googleapis.com/css2?family=Nunito:wght@400","1","2","113.210.93.110"),
("50","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:17:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:19:\"HTTP_SEC_FETCH_DEST\";s:5:\"style\";s:19:\"HTTP_SEC_FETCH_MODE\";s:7:\"no-cors\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:11:\"HTTP_ACCEPT\";s:18:\"text/css,*/*;q=0.1\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.121 Safari/537.36\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602041687.419373;s:12:\"REQUEST_TIME\";i:1602041687;}}","notice","2020-10-07 03:34:47","2020-10-07 03:34:47","16770032","16927280","https://www.mercifulwaygroup.com/cms/cms/wp-admin/url(%22https:/fonts.googleapis.com/css2?family=Nunito:wght@400","1","2","113.210.93.110"),
("51","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-07 13:12:59","2020-10-07 13:12:56","20370304","20760264","https://www.mercifulwaygroup.com/cms/robots.txt","1","0","66.249.73.209"),
("52","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:14:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:20:\"HTTP_ACCEPT_ENCODING\";s:15:\"gzip,deflate,br\";s:15:\"HTTP_USER_AGENT\";s:72:\"Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)\";s:9:\"HTTP_FROM\";s:26:\"googlebot(at)googlebot.com\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602093600.497229;s:12:\"REQUEST_TIME\";i:1602093600;}}","notice","2020-10-07 18:00:01","2020-10-07 18:00:00","20765440","20858016","https://www.mercifulwaygroup.com/cms/.well-known/assetlinks.json","1","0","66.249.65.218"),
("53","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:49:\"https://www.mercifulwaygroup.com/cms/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602095790.274744;s:12:\"REQUEST_TIME\";i:1602095790;}}","notice","2020-10-07 18:36:30","2020-10-07 18:36:30","16628144","17533728","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","206.189.85.88"),
("54","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:14:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:47:\"en-GB,en;q=0.9,zh-CN;q=0.8,zh;q=0.7,en-US;q=0.6\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.121 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602133715.060624;s:12:\"REQUEST_TIME\";i:1602133715;}}","notice","2020-10-08 05:08:35","2020-10-08 05:08:35","16627472","17533072","https://www.mercifulwaygroup.com/cms/cms/","1","0","113.210.93.110"),
("55","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-08 14:44:15","2020-10-08 14:44:12","20359456","20749416","https://www.mercifulwaygroup.com/cms/robots.txt","1","0","185.191.171.11"),
("56","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:15:\"HTTP_USER_AGENT\";s:22:\"python-requests/2.18.4\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602179163.560194;s:12:\"REQUEST_TIME\";i:1602179163;}}","notice","2020-10-08 17:46:03","2020-10-08 17:46:03","16629904","17534656","https://www.mercifulwaygroup.com/cms/api/order","1","0","116.203.220.177"),
("57","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-09 18:10:20","2020-10-09 18:10:17","20360096","20750064","https://www.mercifulwaygroup.com/cms/","1","0","46.55.23.55"),
("58","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:15:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:23:\"en-US,en;q=0.9,fr;q=0.8\";s:15:\"HTTP_USER_AGENT\";s:152:\"Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:85:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602307634.225327;s:12:\"REQUEST_TIME\";i:1602307634;}}","notice","2020-10-10 05:27:16","2020-10-10 05:27:14","19584888","20489384","https://www.mercifulwaygroup.com/cms/wp-admin/admin-ajax.php?action=revslider_show_image&img=../wp-config.php","1","0","167.172.16.106"),
("59","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:13:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:11:\"HTTP_PRAGMA\";s:8:\"no-cache\";s:12:\"HTTP_REFERER\";s:36:\"https://www.mercifulwaygroup.com/cms\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/527.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602317829.649678;s:12:\"REQUEST_TIME\";i:1602317829;}}","notice","2020-10-10 08:17:09","2020-10-10 08:17:09","16640928","17546424","https://www.mercifulwaygroup.com/cms/import/jscript_file.js?_=1809494352&_=1412718896","1","0","45.132.227.175"),
("60","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:13:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:11:\"HTTP_PRAGMA\";s:8:\"no-cache\";s:12:\"HTTP_REFERER\";s:36:\"https://www.mercifulwaygroup.com/cms\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/527.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602323274.189412;s:12:\"REQUEST_TIME\";i:1602323274;}}","notice","2020-10-10 09:47:54","2020-10-10 09:47:54","16671928","17577440","https://www.mercifulwaygroup.com/cms/catalog/view/javascript/forum.js?_=775324448","1","0","45.132.227.175"),
("61","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:13:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:11:\"HTTP_PRAGMA\";s:8:\"no-cache\";s:12:\"HTTP_REFERER\";s:36:\"https://www.mercifulwaygroup.com/cms\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/527.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602323889.758735;s:12:\"REQUEST_TIME\";i:1602323889;}}","notice","2020-10-10 09:58:09","2020-10-10 09:58:09","16672280","17577744","https://www.mercifulwaygroup.com/cms/catalog/view/theme/default/javascript/d_blog_module/review.js?_=1578209359","1","0","45.132.227.175"),
("62","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:16:{s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:14:\"CONTENT_LENGTH\";s:3:\"402\";s:11:\"HTTP_EXPECT\";s:12:\"100-continue\";s:12:\"CONTENT_TYPE\";s:70:\"multipart/form-data; boundary=------------------------66e3ca93281c7050\";s:15:\"HTTP_USER_AGENT\";s:11:\"curl/7.68.0\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:9:\"HTTP_HOST\";s:20:\"mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602339956.350083;s:12:\"REQUEST_TIME\";i:1602339956;}}","notice","2020-10-10 14:25:56","2020-10-10 14:25:56","16700008","17604744","https://www.mercifulwaygroup.com/cms//wp-content/plugins/wp-file-manager/lib/php/connector.minimal.php","1","0","37.59.54.36"),
("63","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:15:\"HTTP_USER_AGENT\";s:22:\"python-requests/2.24.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602340278.898677;s:12:\"REQUEST_TIME\";i:1602340278;}}","notice","2020-10-10 14:31:19","2020-10-10 14:31:18","16634472","17539128","https://www.mercifulwaygroup.com/cms/api/order","1","0","167.86.104.186"),
("64","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:15:\"HTTP_USER_AGENT\";s:22:\"python-requests/2.24.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602340285.14613;s:12:\"REQUEST_TIME\";i:1602340285;}}","notice","2020-10-10 14:31:25","2020-10-10 14:31:25","16632632","16701496","https://www.mercifulwaygroup.com/cms/api/signup","1","0","167.86.104.186"),
("65","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-10 19:41:33","2020-10-10 19:41:30","20363456","20753416","https://www.mercifulwaygroup.com/cms/robots.txt","1","0","185.191.171.2"),
("66","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:47:\"https://www.mercifulwaygroup.com/cms/humans.txt\";s:15:\"HTTP_USER_AGENT\";s:18:\"Go-http-client/1.1\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602374435.796871;s:12:\"REQUEST_TIME\";i:1602374435;}}","notice","2020-10-11 00:00:35","2020-10-11 00:00:35","16632744","16701608","https://www.mercifulwaygroup.com/cms/humans.txt","1","0","192.71.10.105"),
("67","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:44:\"https://www.mercifulwaygroup.com/cms/ads.txt\";s:15:\"HTTP_USER_AGENT\";s:18:\"Go-http-client/1.1\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602374437.022214;s:12:\"REQUEST_TIME\";i:1602374437;}}","notice","2020-10-11 00:00:37","2020-10-11 00:00:37","16632696","16701576","https://www.mercifulwaygroup.com/cms/ads.txt","1","0","192.71.42.108"),
("68","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:49:\"https://www.mercifulwaygroup.com/cms/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602385528.98441;s:12:\"REQUEST_TIME\";i:1602385528;}}","notice","2020-10-11 03:05:29","2020-10-11 03:05:28","16632192","17537776","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","134.209.123.101"),
("69","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-12 00:05:17","2020-10-12 00:05:14","20361504","20751448","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","178.32.198.183"),
("70","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:49:\"https://www.mercifulwaygroup.com/cms/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602461119.424344;s:12:\"REQUEST_TIME\";i:1602461119;}}","notice","2020-10-12 00:05:20","2020-10-12 00:05:19","20756040","21661624","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","178.32.198.183"),
("71","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:54:\"https://www.mercifulwaygroup.com/cms/blog/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602537452.850437;s:12:\"REQUEST_TIME\";i:1602537452;}}","notice","2020-10-12 21:17:33","2020-10-12 21:17:32","16685768","17591352","https://www.mercifulwaygroup.com/cms/blog/wp-login.php","1","0","104.155.1.22"),
("72","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-13 02:46:10","2020-10-13 02:46:07","20411856","20801824","https://www.mercifulwaygroup.com/cms/","1","0","54.213.190.210"),
("73","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:52:\"https://www.mercifulwaygroup.com/cms/wp/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602562500.092745;s:12:\"REQUEST_TIME\";i:1602562500;}}","notice","2020-10-13 04:15:00","2020-10-13 04:15:00","16686624","17592208","https://www.mercifulwaygroup.com/cms/wp/wp-login.php","1","0","66.198.246.47"),
("74","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-14 03:12:28","2020-10-14 03:12:26","20414240","20804208","https://www.mercifulwaygroup.com/cms/","1","0","132.232.75.2"),
("75","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:49:\"https://www.mercifulwaygroup.com/cms/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602693461.12454;s:12:\"REQUEST_TIME\";i:1602693461;}}","notice","2020-10-14 16:37:41","2020-10-14 16:37:41","16688440","17594024","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","54.38.65.127"),
("76","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:15:\"HTTP_USER_AGENT\";s:18:\"Go-http-client/1.1\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602696191.599061;s:12:\"REQUEST_TIME\";i:1602696191;}}","notice","2020-10-14 17:23:13","2020-10-14 17:23:11","20836912","21741568","https://www.mercifulwaygroup.com/cms/.git/config","1","0","51.68.212.99"),
("77","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-15 03:44:59","2020-10-15 03:44:56","20391920","20781864","https://www.mercifulwaygroup.com/cms/robots.txt","1","0","66.249.71.26"),
("78","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:13:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:11:\"HTTP_PRAGMA\";s:8:\"no-cache\";s:12:\"HTTP_REFERER\";s:36:\"https://www.mercifulwaygroup.com/cms\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/527.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602804181.236884;s:12:\"REQUEST_TIME\";i:1602804181;}}","notice","2020-10-15 23:23:01","2020-10-15 23:23:01","16687088","17592584","https://www.mercifulwaygroup.com/cms/catalog/view/javascript/ecflashsale/countdown.js?_=1542857655","1","0","104.194.220.240"),
("79","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-16 09:40:22","2020-10-16 09:40:20","20382264","20772224","https://www.mercifulwaygroup.com/cms/","1","0","209.17.96.106"),
("80","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:13:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:20:\"HTTP_ACCEPT_ENCODING\";s:15:\"gzip,deflate,br\";s:15:\"HTTP_USER_AGENT\";s:72:\"Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)\";s:9:\"HTTP_FROM\";s:26:\"googlebot(at)googlebot.com\";s:11:\"HTTP_ACCEPT\";s:96:\"text/html,application/xhtml+xml,application/signed-exchange;v=b3,application/xml;q=0.9,*/*;q=0.8\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602850188.647691;s:12:\"REQUEST_TIME\";i:1602850188;}}","notice","2020-10-16 12:09:48","2020-10-16 12:09:48","16655456","16726560","https://www.mercifulwaygroup.com/cms/rrwarcdcuwyao.html","1","0","66.249.64.115"),
("81","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-17 10:57:04","2020-10-17 10:57:00","20381808","20771776","https://www.mercifulwaygroup.com/cms/","1","0","138.246.253.15"),
("82","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:10:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:39:\"GuzzleHttp/6.5.5 curl/7.52.1 PHP/7.4.11\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602937749.548732;s:12:\"REQUEST_TIME\";i:1602937749;}}","notice","2020-10-17 12:29:09","2020-10-17 12:29:09","16648024","17552680","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","165.22.56.234"),
("83","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:14:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:15:\"HTTP_USER_AGENT\";s:73:\"Mozilla/5.0 (Windows NT 10.0; WOW64; rv:45.0) Gecko/20100101 Firefox/45.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602955490.227171;s:12:\"REQUEST_TIME\";i:1602955490;}}","notice","2020-10-17 17:24:50","2020-10-17 17:24:50","16656968","17562552","https://www.mercifulwaygroup.com/cms/mm_tmon_script.php","1","0","185.197.160.54"),
("84","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:14:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:15:\"HTTP_USER_AGENT\";s:73:\"Mozilla/5.0 (Windows NT 10.0; WOW64; rv:45.0) Gecko/20100101 Firefox/45.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1602955491.006925;s:12:\"REQUEST_TIME\";i:1602955491;}}","notice","2020-10-17 17:24:51","2020-10-17 17:24:51","16656600","16726376","https://www.mercifulwaygroup.com/cms/customer/mm_tmon_script.php","1","0","185.197.160.54"),
("85","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-18 11:07:57","2020-10-18 11:07:55","20391664","20781608","https://www.mercifulwaygroup.com/cms/robots.txt","1","0","185.191.171.42"),
("86","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:13:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:15:\"HTTP_USER_AGENT\";s:82:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:52.0) Gecko/20100101 Firefox/52.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603043754.765814;s:12:\"REQUEST_TIME\";i:1603043754;}}","notice","2020-10-18 17:55:55","2020-10-18 17:55:54","16708392","16778104","https://www.mercifulwaygroup.com/cms/cms/wp-content/themes/Avada/includes/lib/assets/min/js/library/%7Bpluginspage","1","0","130.211.62.52"),
("87","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:15:\"HTTP_USER_AGENT\";s:82:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:52.0) Gecko/20100101 Firefox/52.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603043766.353199;s:12:\"REQUEST_TIME\";i:1603043766;}}","notice","2020-10-18 17:56:06","2020-10-18 17:56:06","16651816","17557400","https://www.mercifulwaygroup.com/cms/magento_version","1","0","130.211.62.52"),
("88","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:15:\"HTTP_USER_AGENT\";s:82:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:52.0) Gecko/20100101 Firefox/52.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603043766.341913;s:12:\"REQUEST_TIME\";i:1603043766;}}","notice","2020-10-18 17:56:06","2020-10-18 17:56:06","16651816","17557400","https://www.mercifulwaygroup.com/cms/util/login.aspx","1","0","130.211.62.52"),
("89","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:15:\"HTTP_USER_AGENT\";s:82:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:52.0) Gecko/20100101 Firefox/52.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603043766.351965;s:12:\"REQUEST_TIME\";i:1603043766;}}","notice","2020-10-18 17:56:06","2020-10-18 17:56:06","16651760","17557344","https://www.mercifulwaygroup.com/cms/install.php","1","0","130.211.62.52"),
("90","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:49:\"https://www.mercifulwaygroup.com/cms/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603059947.900585;s:12:\"REQUEST_TIME\";i:1603059947;}}","notice","2020-10-18 22:25:48","2020-10-18 22:25:47","16653280","17558864","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","138.197.146.132"),
("91","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:49:\"https://www.mercifulwaygroup.com/cms/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603089091.870717;s:12:\"REQUEST_TIME\";i:1603089091;}}","notice","2020-10-19 06:31:32","2020-10-19 06:31:31","16652784","17558368","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","195.154.230.207"),
("92","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-19 11:13:16","2020-10-19 11:13:13","20391504","20781448","https://www.mercifulwaygroup.com/cms/robots.txt","1","0","185.191.171.33"),
("93","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:11:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:63:\"/home/admin/domains/mercifulwaygroup.com/private_html/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:15:\"HTTP_USER_AGENT\";s:42:\"Mozilla/5.0 (compatible; Dataprovider.com)\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603106531.788232;s:12:\"REQUEST_TIME\";i:1603106531;}}","notice","2020-10-19 11:22:11","2020-10-19 11:22:11","16660008","16728872","https://www.mercifulwaygroup.com/cms/ads.txt","1","0","51.222.43.142"),
("94","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-20 11:45:36","2020-10-20 11:45:34","20430240","20820208","https://www.mercifulwaygroup.com/cms/","1","0","54.186.139.212"),
("95","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:56:\"https://www.mercifulwaygroup.com/cms/backup/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603222489.973679;s:12:\"REQUEST_TIME\";i:1603222489;}}","notice","2020-10-20 19:34:50","2020-10-20 19:34:49","16707528","17613112","https://www.mercifulwaygroup.com/cms/backup/wp-login.php","1","0","101.133.174.69"),
("96","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:49:\"https://www.mercifulwaygroup.com/cms/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603262300.490734;s:12:\"REQUEST_TIME\";i:1603262300;}}","notice","2020-10-21 06:38:20","2020-10-21 06:38:20","16662504","17568088","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","146.59.172.42"),
("97","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-21 12:28:38","2020-10-21 12:28:36","20401376","20791320","https://www.mercifulwaygroup.com/cms/robots.txt","1","0","185.191.171.38"),
("98","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-22 12:50:51","2020-10-22 12:50:48","20389360","20779304","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","67.205.143.140"),
("99","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:49:\"https://www.mercifulwaygroup.com/cms/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603371053.319571;s:12:\"REQUEST_TIME\";i:1603371053;}}","notice","2020-10-22 12:50:54","2020-10-22 12:50:53","20784560","21690144","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","67.205.143.140"),
("100","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-23 15:32:49","2020-10-23 15:32:46","20390528","20780472","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","81.19.215.19"),
("101","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:49:\"https://www.mercifulwaygroup.com/cms/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603467170.850805;s:12:\"REQUEST_TIME\";i:1603467170;}}","notice","2020-10-23 15:32:51","2020-10-23 15:32:50","16662912","17568496","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","81.19.215.19"),
("102","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-23 16:49:14","2020-10-23 16:49:13","20397144","20780184","https://www.mercifulwaygroup.com/cms/robots.txt","1","0","66.249.71.5"),
("103","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-24 17:46:42","2020-10-24 17:46:40","20401584","20791552","https://www.mercifulwaygroup.com/cms/","1","0","209.17.96.106"),
("104","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:49:\"https://www.mercifulwaygroup.com/cms/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603602701.736738;s:12:\"REQUEST_TIME\";i:1603602701;}}","notice","2020-10-25 05:11:42","2020-10-25 05:11:41","16668304","17573888","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","64.202.184.249"),
("105","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:13:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:107:\"https://www.mercifulwaygroup.com/cms/.well-known/acme-challenge/5NuEduZmc5JzRCioYSXfYebQv7Uh1XwsBek3HSUlzYI\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:88:\"Mozilla/5.0 (compatible; Let\\\'s Encrypt validation server; +https://www.letsencrypt.org)\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603642357.717094;s:12:\"REQUEST_TIME\";i:1603642357;}}","notice","2020-10-25 16:12:37","2020-10-25 16:12:37","16703384","17608120","https://www.mercifulwaygroup.com/cms/.well-known/acme-challenge/5NuEduZmc5JzRCioYSXfYebQv7Uh1XwsBek3HSUlzYI","1","0","18.196.96.172"),
("106","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-25 18:37:26","2020-10-25 18:37:24","20411048","20801008","https://www.mercifulwaygroup.com/cms/","1","0","66.249.71.6"),
("107","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:49:\"https://www.mercifulwaygroup.com/cms/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603670289.408094;s:12:\"REQUEST_TIME\";i:1603670289;}}","notice","2020-10-25 23:58:09","2020-10-25 23:58:09","16668384","17573968","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","62.210.185.4"),
("108","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:85:\"https://www.mercifulwaygroup.com/cms:80/wp-content/plugins/wp-file-manager/readme.txt\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603707619.824745;s:12:\"REQUEST_TIME\";i:1603707619;}}","notice","2020-10-26 10:20:20","2020-10-26 10:20:19","16700832","17606384","https://www.mercifulwaygroup.com/cms/wp-content/plugins/wp-file-manager/readme.txt","1","0","193.27.229.26"),
("109","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-26 20:58:18","2020-10-26 20:58:12","20645336","21035280","https://www.mercifulwaygroup.com/cms/robots.txt","1","0","66.249.71.25"),
("110","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-26 21:48:16","2020-10-26 21:48:15","20444288","20827344","https://www.mercifulwaygroup.com/cms/","1","0","66.249.71.6"),
("111","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:49:\"https://www.mercifulwaygroup.com/cms/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603778626.752084;s:12:\"REQUEST_TIME\";i:1603778626;}}","notice","2020-10-27 06:03:46","2020-10-27 06:03:46","16671184","17576768","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","62.210.75.68"),
("112","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:13:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:107:\"https://www.mercifulwaygroup.com/cms/.well-known/acme-challenge/eCJxA_pRGVccXbSrthK4kJvzOF-CgbLBHoiJEoLxuSc\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:88:\"Mozilla/5.0 (compatible; Let\\\'s Encrypt validation server; +https://www.letsencrypt.org)\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603815117.916825;s:12:\"REQUEST_TIME\";i:1603815117;}}","notice","2020-10-27 16:11:58","2020-10-27 16:11:57","16705704","17610440","https://www.mercifulwaygroup.com/cms/.well-known/acme-challenge/eCJxA_pRGVccXbSrthK4kJvzOF-CgbLBHoiJEoLxuSc","1","0","18.196.96.172"),
("113","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:13:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:107:\"https://www.mercifulwaygroup.com/cms/.well-known/acme-challenge/eCJxA_pRGVccXbSrthK4kJvzOF-CgbLBHoiJEoLxuSc\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:88:\"Mozilla/5.0 (compatible; Let\\\'s Encrypt validation server; +https://www.letsencrypt.org)\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603815139.683235;s:12:\"REQUEST_TIME\";i:1603815139;}}","notice","2020-10-27 16:12:19","2020-10-27 16:12:19","16705704","17610440","https://www.mercifulwaygroup.com/cms/.well-known/acme-challenge/eCJxA_pRGVccXbSrthK4kJvzOF-CgbLBHoiJEoLxuSc","1","0","3.22.70.135"),
("114","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-27 23:33:59","2020-10-27 23:33:56","20418872","20808816","https://www.mercifulwaygroup.com/cms/contact-us/","1","0","66.249.71.6"),
("115","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:49:\"https://www.mercifulwaygroup.com/cms/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603853380.582747;s:12:\"REQUEST_TIME\";i:1603853380;}}","notice","2020-10-28 02:49:40","2020-10-28 02:49:40","16672216","17577800","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","64.202.184.249"),
("116","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:49:\"https://www.mercifulwaygroup.com/cms/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603894696.205016;s:12:\"REQUEST_TIME\";i:1603894696;}}","notice","2020-10-28 14:18:16","2020-10-28 14:18:16","16672752","17578336","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","63.143.37.10"),
("117","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:88:\"Mozilla/5.0 (compatible; Let\\\'s Encrypt validation server; +https://www.letsencrypt.org)\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603901542.414849;s:12:\"REQUEST_TIME\";i:1603901542;}}","notice","2020-10-28 16:12:24","2020-10-28 16:12:22","20845304","21750040","https://www.mercifulwaygroup.com/cms/.well-known/acme-challenge/ai8td5V1HQF7jH5Oe3m_fbNBDutCzRngTwlDpa5-IYE","1","0","34.211.6.84"),
("118","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:88:\"Mozilla/5.0 (compatible; Let\\\'s Encrypt validation server; +https://www.letsencrypt.org)\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603901543.572526;s:12:\"REQUEST_TIME\";i:1603901543;}}","notice","2020-10-28 16:12:24","2020-10-28 16:12:23","20827872","21732608","https://www.mercifulwaygroup.com/cms/.well-known/acme-challenge/ai8td5V1HQF7jH5Oe3m_fbNBDutCzRngTwlDpa5-IYE","1","0","18.196.96.172"),
("119","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:88:\"Mozilla/5.0 (compatible; Let\\\'s Encrypt validation server; +https://www.letsencrypt.org)\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603901548.125222;s:12:\"REQUEST_TIME\";i:1603901548;}}","notice","2020-10-28 16:12:28","2020-10-28 16:12:28","16706760","17611496","https://www.mercifulwaygroup.com/cms/.well-known/acme-challenge/ai8td5V1HQF7jH5Oe3m_fbNBDutCzRngTwlDpa5-IYE","1","0","52.28.236.88"),
("120","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:88:\"Mozilla/5.0 (compatible; Let\\\'s Encrypt validation server; +https://www.letsencrypt.org)\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603901548.180812;s:12:\"REQUEST_TIME\";i:1603901548;}}","notice","2020-10-28 16:12:28","2020-10-28 16:12:28","16704760","16773704","https://www.mercifulwaygroup.com/cms/.well-known/acme-challenge/ai8td5V1HQF7jH5Oe3m_fbNBDutCzRngTwlDpa5-IYE","1","0","3.22.70.135"),
("121","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-29 02:31:13","2020-10-29 02:31:10","20408992","20798952","https://www.mercifulwaygroup.com/cms/cms/","1","0","113.210.65.203"),
("122","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:14:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:59:\"en-GB,en;q=0.9,zh-CN;q=0.8,zh;q=0.7,en-US;q=0.6,zh-TW;q=0.5\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.111 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603938675.205223;s:12:\"REQUEST_TIME\";i:1603938675;}}","notice","2020-10-29 02:31:15","2020-10-29 02:31:15","16671504","17577104","https://www.mercifulwaygroup.com/cms/cms/","1","0","113.210.65.203"),
("123","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:19:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:59:\"en-GB,en;q=0.9,zh-CN;q=0.8,zh;q=0.7,en-US;q=0.6,zh-TW;q=0.5\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_SITE\";s:4:\"none\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.111 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603938696.538889;s:12:\"REQUEST_TIME\";i:1603938696;}}","notice","2020-10-29 02:31:37","2020-10-29 02:31:36","16705512","16774664","https://www.mercifulwaygroup.com/cms/cms/not_found","1","0","113.210.65.203"),
("124","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:13:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:20:\"HTTP_ACCEPT_ENCODING\";s:15:\"gzip,deflate,br\";s:15:\"HTTP_USER_AGENT\";s:72:\"Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)\";s:9:\"HTTP_FROM\";s:26:\"googlebot(at)googlebot.com\";s:11:\"HTTP_ACCEPT\";s:96:\"text/html,application/xhtml+xml,application/signed-exchange;v=b3,application/xml;q=0.9,*/*;q=0.8\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603976560.170985;s:12:\"REQUEST_TIME\";i:1603976560;}}","notice","2020-10-29 13:02:40","2020-10-29 13:02:40","16685616","16756720","https://www.mercifulwaygroup.com/cms/sfdpufrxr.html","1","0","66.249.66.213"),
("125","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:49:\"https://www.mercifulwaygroup.com/cms/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1603988938.292689;s:12:\"REQUEST_TIME\";i:1603988938;}}","notice","2020-10-29 16:28:58","2020-10-29 16:28:58","16674256","17579840","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","46.101.95.65"),
("126","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-30 04:37:28","2020-10-30 04:37:25","20410960","20800928","https://www.mercifulwaygroup.com/cms/","1","0","66.249.66.59"),
("127","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:88:\"Mozilla/5.0 (compatible; Let\\\'s Encrypt validation server; +https://www.letsencrypt.org)\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1604074336.323446;s:12:\"REQUEST_TIME\";i:1604074336;}}","notice","2020-10-30 16:12:18","2020-10-30 16:12:16","20848240","21752976","https://www.mercifulwaygroup.com/cms/.well-known/acme-challenge/-m4ww13yq-XmvXEnDnwmfx55s8RQhTM8Qo-BDZs2dhA","1","0","3.128.26.105"),
("128","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:88:\"Mozilla/5.0 (compatible; Let\\\'s Encrypt validation server; +https://www.letsencrypt.org)\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1604074340.420013;s:12:\"REQUEST_TIME\";i:1604074340;}}","notice","2020-10-30 16:12:20","2020-10-30 16:12:20","16707760","16776704","https://www.mercifulwaygroup.com/cms/.well-known/acme-challenge/-m4ww13yq-XmvXEnDnwmfx55s8RQhTM8Qo-BDZs2dhA","1","0","18.196.96.172"),
("129","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:88:\"Mozilla/5.0 (compatible; Let\\\'s Encrypt validation server; +https://www.letsencrypt.org)\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1604074343.662435;s:12:\"REQUEST_TIME\";i:1604074343;}}","notice","2020-10-30 16:12:23","2020-10-30 16:12:23","16707760","16776704","https://www.mercifulwaygroup.com/cms/.well-known/acme-challenge/-m4ww13yq-XmvXEnDnwmfx55s8RQhTM8Qo-BDZs2dhA","1","0","34.209.232.166"),
("130","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:88:\"Mozilla/5.0 (compatible; Let\\\'s Encrypt validation server; +https://www.letsencrypt.org)\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1604074349.515494;s:12:\"REQUEST_TIME\";i:1604074349;}}","notice","2020-10-30 16:12:29","2020-10-30 16:12:29","16707760","16776704","https://www.mercifulwaygroup.com/cms/.well-known/acme-challenge/-m4ww13yq-XmvXEnDnwmfx55s8RQhTM8Qo-BDZs2dhA","1","0","34.209.232.166"),
("131","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:15:\"HTTP_USER_AGENT\";s:88:\"Mozilla/5.0 (compatible; Let\\\'s Encrypt validation server; +https://www.letsencrypt.org)\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1604074350.303896;s:12:\"REQUEST_TIME\";i:1604074350;}}","notice","2020-10-30 16:12:30","2020-10-30 16:12:30","16707760","16776704","https://www.mercifulwaygroup.com/cms/.well-known/acme-challenge/-m4ww13yq-XmvXEnDnwmfx55s8RQhTM8Qo-BDZs2dhA","1","0","3.128.26.105"),
("132","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-10-31 12:13:41","2020-10-31 12:13:39","20409304","20799248","https://www.mercifulwaygroup.com/cms/robots.txt","1","0","157.55.39.0"),
("133","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:49:\"https://www.mercifulwaygroup.com/cms/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1604151847.316924;s:12:\"REQUEST_TIME\";i:1604151847;}}","notice","2020-10-31 13:44:07","2020-10-31 13:44:07","16675064","17580648","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","167.71.124.33"),
("134","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:49:\"https://www.mercifulwaygroup.com/cms/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1604169598.02372;s:12:\"REQUEST_TIME\";i:1604169598;}}","notice","2020-10-31 18:39:58","2020-10-31 18:39:58","16674568","17580152","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","45.118.144.77"),
("135","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-11-01 15:09:16","2020-11-01 15:09:13","20402272","20792240","https://www.mercifulwaygroup.com/cms/","1","0","89.147.68.112"),
("136","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:62:\"/home/admin/domains/mercifulwaygroup.com/public_html/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:20:\"HTTP_ACCEPT_ENCODING\";s:4:\"gzip\";s:12:\"HTTP_REFERER\";s:49:\"https://www.mercifulwaygroup.com/cms/wp-login.php\";s:15:\"HTTP_USER_AGENT\";s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1604254843.458709;s:12:\"REQUEST_TIME\";i:1604254843;}}","notice","2020-11-01 18:20:43","2020-11-01 18:20:43","16676032","17581616","https://www.mercifulwaygroup.com/cms/wp-login.php","1","0","124.158.12.202"),
("137","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-11-08 03:33:39","2020-11-08 03:33:38","20386496","20843304","https://www.mercifulwaygroup.com/cms/cms/index.php","1","0","185.12.108.186"),
("138","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-11-08 03:33:57","2020-11-08 03:33:56","21851344","22202376","https://www.mercifulwaygroup.com/cms/cms/wp-admin/admin-ajax.php?action=wordfence_testAjax","1","0","103.21.182.249"),
("139","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-11-15 08:53:52","2020-11-15 08:53:49","20490760","20879352","https://www.mercifulwaygroup.com/cms/cms/installer-backup.php","1","0","91.191.172.219"),
("140","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1605430429.303927;s:12:\"REQUEST_TIME\";i:1605430429;}}","notice","2020-11-15 08:53:53","2020-11-15 08:53:49","21068304","21973872","https://www.mercifulwaygroup.com/cms/cms/installer-backup.php","1","0","91.191.172.219"),
("141","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1605430428.28941;s:12:\"REQUEST_TIME\";i:1605430428;}}","notice","2020-11-15 08:53:54","2020-11-15 08:53:48","21125248","22030832","https://www.mercifulwaygroup.com/cms/cms/installer.php","1","0","91.191.172.219"),
("142","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-11-15 08:54:28","2020-11-15 08:54:27","17604168","17655288","https://www.mercifulwaygroup.com/cms/cms/wp-admin/admin-ajax.php?action=wordfence_testAjax","1","0","103.21.182.249"),
("143","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-11-16 09:30:23","2020-11-16 09:30:20","20487256","20877200","https://www.mercifulwaygroup.com/cms/cms/Archive.zip","1","0","203.150.228.128"),
("144","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1605519020.1788;s:12:\"REQUEST_TIME\";i:1605519020;}}","notice","2020-11-16 09:30:23","2020-11-16 09:30:20","21069496","21975080","https://www.mercifulwaygroup.com/cms/cms/Archive.zip","1","0","203.150.228.128"),
("145","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1605519033.718206;s:12:\"REQUEST_TIME\";i:1605519033;}}","notice","2020-11-16 09:30:33","2020-11-16 09:30:33","16758224","16828016","https://www.mercifulwaygroup.com/cms/cms/site.zip","1","0","208.67.16.234"),
("146","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1605519044.404823;s:12:\"REQUEST_TIME\";i:1605519044;}}","notice","2020-11-16 09:30:44","2020-11-16 09:30:44","16776264","16846056","https://www.mercifulwaygroup.com/cms/cms/wp-config.php~","1","0","50.63.194.161"),
("147","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1605519067.560154;s:12:\"REQUEST_TIME\";i:1605519067;}}","notice","2020-11-16 09:31:07","2020-11-16 09:31:07","16757920","16827712","https://www.mercifulwaygroup.com/cms/cms/wp-config.php.bak","1","0","50.62.176.125"),
("148","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1605519101.206717;s:12:\"REQUEST_TIME\";i:1605519101;}}","notice","2020-11-16 09:31:41","2020-11-16 09:31:41","16775840","17681424","https://www.mercifulwaygroup.com/cms/cms/wp-config.php.orig","1","0","50.62.208.52"),
("149","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1605519138.505348;s:12:\"REQUEST_TIME\";i:1605519138;}}","notice","2020-11-16 09:32:18","2020-11-16 09:32:18","16757920","16827712","https://www.mercifulwaygroup.com/cms/cms/wp-config.php.save","1","0","190.107.177.250"),
("150","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1605519150.697554;s:12:\"REQUEST_TIME\";i:1605519150;}}","notice","2020-11-16 09:32:30","2020-11-16 09:32:30","16757776","16827568","https://www.mercifulwaygroup.com/cms/cms/wp-config","1","0","31.209.177.21"),
("151","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1605519167.328218;s:12:\"REQUEST_TIME\";i:1605519167;}}","notice","2020-11-16 09:32:49","2020-11-16 09:32:47","20896944","21802528","https://www.mercifulwaygroup.com/cms/cms/1.txt","1","0","5.249.141.102"),
("152","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1605519173.229283;s:12:\"REQUEST_TIME\";i:1605519173;}}","notice","2020-11-16 09:32:53","2020-11-16 09:32:53","16760048","17665632","https://www.mercifulwaygroup.com/cms/cms/public_html.zip","1","0","160.153.147.143"),
("153","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1605519174.873344;s:12:\"REQUEST_TIME\";i:1605519174;}}","notice","2020-11-16 09:32:55","2020-11-16 09:32:54","16758200","16827992","https://www.mercifulwaygroup.com/cms/cms/wordpress.zip","1","0","93.90.146.112"),
("154","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1605519183.48231;s:12:\"REQUEST_TIME\";i:1605519183;}}","notice","2020-11-16 09:33:03","2020-11-16 09:33:03","16758192","16827984","https://www.mercifulwaygroup.com/cms/cms/.well-known.zip","1","0","35.214.250.123"),
("155","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1605519195.769467;s:12:\"REQUEST_TIME\";i:1605519195;}}","notice","2020-11-16 09:33:15","2020-11-16 09:33:15","16758096","16827888","https://www.mercifulwaygroup.com/cms/cms/backup.zip","1","0","160.153.154.5"),
("156","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1605519206.549051;s:12:\"REQUEST_TIME\";i:1605519206;}}","notice","2020-11-16 09:33:26","2020-11-16 09:33:26","16758160","16827952","https://www.mercifulwaygroup.com/cms/cms/cgi-bin.zip","1","0","46.41.148.252");

INSERT IGNORE INTO `wpxd_itsec_logs` VALUES 
("157","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1605519230.093827;s:12:\"REQUEST_TIME\";i:1605519230;}}","notice","2020-11-16 09:33:50","2020-11-16 09:33:50","16776536","16846312","https://www.mercifulwaygroup.com/cms/cms/mercifulwaygroup.com.zip","1","0","66.113.223.208"),
("158","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1605519242.405774;s:12:\"REQUEST_TIME\";i:1605519242;}}","notice","2020-11-16 09:34:02","2020-11-16 09:34:02","16758368","16828144","https://www.mercifulwaygroup.com/cms/cms/mercifulwaygroup.zip","1","0","72.52.216.50"),
("159","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-11-19 05:57:38","2020-11-19 05:57:35","17586592","18043416","https://www.mercifulwaygroup.com/cms/cms/","1","0","113.210.123.222"),
("160","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:19:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_SITE\";s:4:\"none\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.183 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1605765455.812162;s:12:\"REQUEST_TIME\";i:1605765455;}}","notice","2020-11-19 05:57:38","2020-11-19 05:57:35","18235888","19140848","https://www.mercifulwaygroup.com/cms/cms/","1","0","113.210.123.222"),
("161","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-11-19 05:58:07","2020-11-19 05:58:06","16299080","16407976","https://www.mercifulwaygroup.com/cms/cms/","1","0","113.210.123.222"),
("162","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:18:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:67:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.9\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_SITE\";s:4:\"none\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.183 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1605765486.284687;s:12:\"REQUEST_TIME\";i:1605765486;}}","notice","2020-11-19 05:58:07","2020-11-19 05:58:06","16953728","17858688","https://www.mercifulwaygroup.com/cms/cms/","1","0","113.210.123.222"),
("163","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-11-24 13:36:35","2020-11-24 13:36:28","20730312","21118920","https://www.mercifulwaygroup.com/cms/cms/site.zip","1","0","51.38.227.167"),
("164","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606224987.939895;s:12:\"REQUEST_TIME\";i:1606224987;}}","notice","2020-11-24 13:36:35","2020-11-24 13:36:28","21307720","22213304","https://www.mercifulwaygroup.com/cms/cms/site.zip","1","0","51.38.227.167"),
("165","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606224999.637868;s:12:\"REQUEST_TIME\";i:1606224999;}}","notice","2020-11-24 13:36:39","2020-11-24 13:36:39","16827264","16897056","https://www.mercifulwaygroup.com/cms/cms/wp-config.php~","1","0","173.201.196.30"),
("166","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606225001.114861;s:12:\"REQUEST_TIME\";i:1606225001;}}","notice","2020-11-24 13:36:41","2020-11-24 13:36:41","16825408","16895200","https://www.mercifulwaygroup.com/cms/cms/Archive.zip","1","0","198.71.238.5"),
("167","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606225009.826805;s:12:\"REQUEST_TIME\";i:1606225009;}}","notice","2020-11-24 13:36:50","2020-11-24 13:36:49","16825472","16895264","https://www.mercifulwaygroup.com/cms/cms/well-known.zip","1","0","184.168.193.187"),
("168","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-11-24 13:37:10","2020-11-24 13:37:09","18747320","19027248","https://www.mercifulwaygroup.com/cms/cms/wp-admin/admin-ajax.php?action=wordfence_testAjax","1","0","103.21.182.249"),
("169","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606225034.476071;s:12:\"REQUEST_TIME\";i:1606225034;}}","notice","2020-11-24 13:37:14","2020-11-24 13:37:14","16805816","17711400","https://www.mercifulwaygroup.com/cms/cms/wp-config.php.old","1","0","184.168.193.105"),
("170","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606225044.112252;s:12:\"REQUEST_TIME\";i:1606225044;}}","notice","2020-11-24 13:37:24","2020-11-24 13:37:24","16803024","16872800","https://www.mercifulwaygroup.com/cms/cms/wp-config.php.resetwp_bak","1","0","49.51.49.254"),
("171","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606225046.649813;s:12:\"REQUEST_TIME\";i:1606225046;}}","notice","2020-11-24 13:37:26","2020-11-24 13:37:26","16802832","16872624","https://www.mercifulwaygroup.com/cms/cms/wp-config.php.bak","1","0","184.168.193.187"),
("172","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606225055.648767;s:12:\"REQUEST_TIME\";i:1606225055;}}","notice","2020-11-24 13:37:35","2020-11-24 13:37:35","16804040","16873832","https://www.mercifulwaygroup.com/cms/cms/wp-config.php.orig","1","0","160.153.146.79"),
("173","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606225082.897672;s:12:\"REQUEST_TIME\";i:1606225082;}}","notice","2020-11-24 13:38:03","2020-11-24 13:38:02","16803928","16873720","https://www.mercifulwaygroup.com/cms/cms/wp-config","1","0","209.237.150.165"),
("174","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606225089.500839;s:12:\"REQUEST_TIME\";i:1606225089;}}","notice","2020-11-24 13:38:09","2020-11-24 13:38:09","16802864","16872656","https://www.mercifulwaygroup.com/cms/cms/wp-config.php.save","1","0","51.38.227.167"),
("175","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606225113.878877;s:12:\"REQUEST_TIME\";i:1606225113;}}","notice","2020-11-24 13:38:34","2020-11-24 13:38:33","16775552","16845344","https://www.mercifulwaygroup.com/cms/cms/wordpress.zip","1","0","43.229.84.119"),
("176","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606225124.962817;s:12:\"REQUEST_TIME\";i:1606225124;}}","notice","2020-11-24 13:38:45","2020-11-24 13:38:44","16791272","16861064","https://www.mercifulwaygroup.com/cms/cms/1.txt","1","0","198.71.239.44"),
("177","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606225144.482043;s:12:\"REQUEST_TIME\";i:1606225144;}}","notice","2020-11-24 13:39:05","2020-11-24 13:39:04","20897568","21803152","https://www.mercifulwaygroup.com/cms/cms/backup.zip","1","0","160.153.147.160"),
("178","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606225147.419665;s:12:\"REQUEST_TIME\";i:1606225147;}}","notice","2020-11-24 13:39:07","2020-11-24 13:39:07","16774416","16844208","https://www.mercifulwaygroup.com/cms/cms/public_html.zip","1","0","184.168.193.196"),
("179","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606225155.872777;s:12:\"REQUEST_TIME\";i:1606225155;}}","notice","2020-11-24 13:39:16","2020-11-24 13:39:15","16774752","16844544","https://www.mercifulwaygroup.com/cms/cms/cgi-bin.zip","1","0","203.205.21.159"),
("180","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606225167.449407;s:12:\"REQUEST_TIME\";i:1606225167;}}","notice","2020-11-24 13:39:27","2020-11-24 13:39:27","16775968","16845760","https://www.mercifulwaygroup.com/cms/cms/wp-admin.zip","1","0","160.153.147.142"),
("181","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606225176.867289;s:12:\"REQUEST_TIME\";i:1606225176;}}","notice","2020-11-24 13:39:37","2020-11-24 13:39:36","16774824","16844600","https://www.mercifulwaygroup.com/cms/cms/mercifulwaygroup.com.zip","1","0","173.201.196.119"),
("182","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606225189.011919;s:12:\"REQUEST_TIME\";i:1606225189;}}","notice","2020-11-24 13:39:50","2020-11-24 13:39:49","16794224","16864000","https://www.mercifulwaygroup.com/cms/cms/mercifulwaygroup.zip","1","0","66.199.191.89"),
("183","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-11-26 10:47:59","2020-11-26 10:47:57","20419976","20809920","https://www.mercifulwaygroup.com/cms/cms/installer.php","1","0","50.62.160.232"),
("184","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606387677.008377;s:12:\"REQUEST_TIME\";i:1606387677;}}","notice","2020-11-26 10:47:59","2020-11-26 10:47:57","21006640","21912224","https://www.mercifulwaygroup.com/cms/cms/installer.php","1","0","50.62.160.232"),
("185","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606387678.069731;s:12:\"REQUEST_TIME\";i:1606387678;}}","notice","2020-11-26 10:48:00","2020-11-26 10:47:58","20929616","21835184","https://www.mercifulwaygroup.com/cms/cms/installer-backup.php","1","0","50.62.160.232"),
("186","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-11-29 22:38:29","2020-11-29 22:38:27","20518472","20975280","https://www.mercifulwaygroup.com/cms/cms/installer.php","1","0","46.243.69.2"),
("187","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606689505.703936;s:12:\"REQUEST_TIME\";i:1606689505;}}","notice","2020-11-29 22:38:29","2020-11-29 22:38:25","20940376","21845944","https://www.mercifulwaygroup.com/cms/cms/installer-backup.php","1","0","46.243.69.2"),
("188","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606689506.707182;s:12:\"REQUEST_TIME\";i:1606689506;}}","notice","2020-11-29 22:38:30","2020-11-29 22:38:27","21167120","22072704","https://www.mercifulwaygroup.com/cms/cms/installer.php","1","0","46.243.69.2"),
("189","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-11-29 22:39:06","2020-11-29 22:39:04","21864816","22206000","https://www.mercifulwaygroup.com/cms/cms/wp-admin/admin-ajax.php?action=wordfence_testAjax","1","0","103.21.182.249"),
("190","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-12-01 18:18:35","2020-12-01 18:18:29","20741152","21129760","https://www.mercifulwaygroup.com/cms/cms//?author=1","1","0","40.86.214.253"),
("191","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-12-01 23:57:43","2020-12-01 23:57:41","20531760","20914800","https://www.mercifulwaygroup.com/cms/cms/wp-config.php.bak","1","0","198.71.239.46"),
("192","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606867061.297119;s:12:\"REQUEST_TIME\";i:1606867061;}}","notice","2020-12-01 23:57:43","2020-12-01 23:57:41","21118432","22024016","https://www.mercifulwaygroup.com/cms/cms/wp-config.php.bak","1","0","198.71.239.46"),
("193","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606867083.47474;s:12:\"REQUEST_TIME\";i:1606867083;}}","notice","2020-12-01 23:58:03","2020-12-01 23:58:03","16813680","16883456","https://www.mercifulwaygroup.com/cms/cms/wp-config.php.resetwp_bak","1","0","193.194.69.98"),
("194","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606867118.271785;s:12:\"REQUEST_TIME\";i:1606867118;}}","notice","2020-12-01 23:58:38","2020-12-01 23:58:38","16815640","17721208","https://www.mercifulwaygroup.com/cms/cms/wp-config.php.bak.a2","1","0","198.71.239.31"),
("195","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606867149.628191;s:12:\"REQUEST_TIME\";i:1606867149;}}","notice","2020-12-01 23:59:09","2020-12-01 23:59:09","16813736","16883528","https://www.mercifulwaygroup.com/cms/cms/wordpress.zip","1","0","184.168.193.99"),
("196","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606867161.041793;s:12:\"REQUEST_TIME\";i:1606867161;}}","notice","2020-12-01 23:59:21","2020-12-01 23:59:21","16785232","16855024","https://www.mercifulwaygroup.com/cms/cms/public_html.zip","1","0","184.168.27.69"),
("197","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606867171.96845;s:12:\"REQUEST_TIME\";i:1606867171;}}","notice","2020-12-01 23:59:32","2020-12-01 23:59:31","16785216","16855008","https://www.mercifulwaygroup.com/cms/cms/.well-known.zip","1","0","198.71.239.44"),
("198","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606867183.390622;s:12:\"REQUEST_TIME\";i:1606867183;}}","notice","2020-12-01 23:59:43","2020-12-01 23:59:43","16784760","16854552","https://www.mercifulwaygroup.com/cms/cms/backup.zip","1","0","184.168.46.123"),
("199","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606867194.178959;s:12:\"REQUEST_TIME\";i:1606867194;}}","notice","2020-12-01 23:59:54","2020-12-01 23:59:54","16785184","16854976","https://www.mercifulwaygroup.com/cms/cms/cgi-bin.zip","1","0","66.113.223.208"),
("200","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606867217.485613;s:12:\"REQUEST_TIME\";i:1606867217;}}","notice","2020-12-02 00:00:18","2020-12-02 00:00:17","20907888","21813456","https://www.mercifulwaygroup.com/cms/cms/mercifulwaygroup.com.zip","1","0","160.153.147.143"),
("201","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1606867230.732665;s:12:\"REQUEST_TIME\";i:1606867230;}}","notice","2020-12-02 00:00:30","2020-12-02 00:00:30","16785616","16855392","https://www.mercifulwaygroup.com/cms/cms/mercifulwaygroup.zip","1","0","203.205.21.159"),
("202","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-12-03 00:37:36","2020-12-03 00:37:33","20518816","20907424","https://www.mercifulwaygroup.com/cms/cms//?author=1","1","0","34.239.150.43"),
("203","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607009890.223772;s:12:\"REQUEST_TIME\";i:1607009890;}}","notice","2020-12-03 15:38:12","2020-12-03 15:38:10","20926320","21831904","https://www.mercifulwaygroup.com/cms/cms/installer.php","1","0","195.74.38.129"),
("204","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607009891.292071;s:12:\"REQUEST_TIME\";i:1607009891;}}","notice","2020-12-03 15:38:12","2020-12-03 15:38:11","20909520","21815088","https://www.mercifulwaygroup.com/cms/cms/installer-backup.php","1","0","195.74.38.129"),
("205","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-12-04 06:45:49","2020-12-04 06:45:47","20520280","20908888","https://www.mercifulwaygroup.com/cms/cms//?author=1","1","0","3.133.152.150"),
("206","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-12-07 03:36:46","2020-12-07 03:36:44","20445192","20901984","https://www.mercifulwaygroup.com/cms/cms/installer-backup.php","1","0","75.103.66.9"),
("207","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607312204.539531;s:12:\"REQUEST_TIME\";i:1607312204;}}","notice","2020-12-07 03:36:46","2020-12-07 03:36:44","21093928","21999496","https://www.mercifulwaygroup.com/cms/cms/installer-backup.php","1","0","75.103.66.9"),
("208","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607312203.50809;s:12:\"REQUEST_TIME\";i:1607312203;}}","notice","2020-12-07 03:36:47","2020-12-07 03:36:43","21025216","21930800","https://www.mercifulwaygroup.com/cms/cms/installer.php","1","0","75.103.66.9"),
("209","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-12-07 03:37:00","2020-12-07 03:37:00","21870888","22217640","https://www.mercifulwaygroup.com/cms/cms/wp-admin/admin-ajax.php?action=wordfence_testAjax","1","0","103.21.182.249"),
("210","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-12-08 18:52:48","2020-12-08 18:52:42","20764832","21153440","https://www.mercifulwaygroup.com/cms/cms//?author=1","1","0","40.75.117.244"),
("211","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607502437.227795;s:12:\"REQUEST_TIME\";i:1607502437;}}","notice","2020-12-09 08:27:19","2020-12-09 08:27:17","20928584","21834168","https://www.mercifulwaygroup.com/cms/cms/Archive.zip","1","0","104.238.120.73"),
("212","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607502459.042219;s:12:\"REQUEST_TIME\";i:1607502459;}}","notice","2020-12-09 08:27:39","2020-12-09 08:27:39","16787008","16856800","https://www.mercifulwaygroup.com/cms/cms/wp-config.php~","1","0","203.205.21.159"),
("213","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607502469.35049;s:12:\"REQUEST_TIME\";i:1607502469;}}","notice","2020-12-09 08:27:49","2020-12-09 08:27:49","16805360","17710944","https://www.mercifulwaygroup.com/cms/cms/well-known.zip","1","0","160.153.154.11"),
("214","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607502473.073404;s:12:\"REQUEST_TIME\";i:1607502473;}}","notice","2020-12-09 08:27:53","2020-12-09 08:27:53","16786024","16855816","https://www.mercifulwaygroup.com/cms/cms/site.zip","1","0","160.153.147.142"),
("215","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607502481.841753;s:12:\"REQUEST_TIME\";i:1607502481;}}","notice","2020-12-09 08:28:02","2020-12-09 08:28:01","16785864","16855656","https://www.mercifulwaygroup.com/cms/cms/wp-config.php.bak","1","0","201.150.35.113"),
("216","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607502484.013184;s:12:\"REQUEST_TIME\";i:1607502484;}}","notice","2020-12-09 08:28:04","2020-12-09 08:28:04","16785832","16855624","https://www.mercifulwaygroup.com/cms/cms/wp-config.php~","1","0","173.201.196.31"),
("217","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607502492.406573;s:12:\"REQUEST_TIME\";i:1607502492;}}","notice","2020-12-09 08:28:12","2020-12-09 08:28:12","16785864","16855656","https://www.mercifulwaygroup.com/cms/cms/wp-config.php.old","1","0","198.71.239.13"),
("218","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607502503.522013;s:12:\"REQUEST_TIME\";i:1607502503;}}","notice","2020-12-09 08:28:23","2020-12-09 08:28:23","16786024","16855800","https://www.mercifulwaygroup.com/cms/cms/wp-config.php.resetwp_bak","1","0","67.227.241.68"),
("219","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607502513.423145;s:12:\"REQUEST_TIME\";i:1607502513;}}","notice","2020-12-09 08:28:33","2020-12-09 08:28:33","16785864","16855656","https://www.mercifulwaygroup.com/cms/cms/wp-config.php.orig","1","0","160.153.153.28"),
("220","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607502572.695806;s:12:\"REQUEST_TIME\";i:1607502572;}}","notice","2020-12-09 08:29:32","2020-12-09 08:29:32","16803504","16873296","https://www.mercifulwaygroup.com/cms/cms/wordpress.zip","1","0","160.153.154.19"),
("221","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607502586.119169;s:12:\"REQUEST_TIME\";i:1607502586;}}","notice","2020-12-09 08:29:48","2020-12-09 08:29:46","20926200","21831784","https://www.mercifulwaygroup.com/cms/cms/1.txt","1","0","176.223.121.235"),
("222","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607502595.500283;s:12:\"REQUEST_TIME\";i:1607502595;}}","notice","2020-12-09 08:29:55","2020-12-09 08:29:55","16786136","16855928","https://www.mercifulwaygroup.com/cms/cms/.well-known.zip","1","0","185.25.241.245"),
("223","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607502609.330522;s:12:\"REQUEST_TIME\";i:1607502609;}}","notice","2020-12-09 08:30:09","2020-12-09 08:30:09","16786152","16855944","https://www.mercifulwaygroup.com/cms/cms/public_html.zip","1","0","160.153.156.134"),
("224","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607502618.506838;s:12:\"REQUEST_TIME\";i:1607502618;}}","notice","2020-12-09 08:30:18","2020-12-09 08:30:18","16787944","17693528","https://www.mercifulwaygroup.com/cms/cms/cgi-bin.zip","1","0","149.56.44.141"),
("225","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607502652.372076;s:12:\"REQUEST_TIME\";i:1607502652;}}","notice","2020-12-09 08:30:52","2020-12-09 08:30:52","16803400","16873192","https://www.mercifulwaygroup.com/cms/cms/backup.zip","1","0","134.0.11.154"),
("226","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607502653.935683;s:12:\"REQUEST_TIME\";i:1607502653;}}","notice","2020-12-09 08:30:54","2020-12-09 08:30:53","16786144","16855936","https://www.mercifulwaygroup.com/cms/cms/wp-admin.zip","1","0","173.219.72.14"),
("227","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"HEAD\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:20:\"en-us;q=0.7,en;q=0.3\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607502665.539775;s:12:\"REQUEST_TIME\";i:1607502665;}}","notice","2020-12-09 08:31:05","2020-12-09 08:31:05","16786336","16856112","https://www.mercifulwaygroup.com/cms/cms/mercifulwaygroup.com.zip","1","0","138.68.105.248"),
("228","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-12-10 18:47:30","2020-12-10 18:47:27","20441648","20895792","https://www.mercifulwaygroup.com/cms/cms/installer.php","1","0","160.153.146.165"),
("229","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607626047.325054;s:12:\"REQUEST_TIME\";i:1607626047;}}","notice","2020-12-10 18:47:30","2020-12-10 18:47:27","21090320","21995904","https://www.mercifulwaygroup.com/cms/cms/installer.php","1","0","160.153.146.165"),
("230","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607626048.366905;s:12:\"REQUEST_TIME\";i:1607626048;}}","notice","2020-12-10 18:47:31","2020-12-10 18:47:28","21025736","21931304","https://www.mercifulwaygroup.com/cms/cms/installer-backup.php","1","0","160.153.146.165"),
("231","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-12-14 10:53:50","2020-12-14 10:53:48","20527016","20915624","https://www.mercifulwaygroup.com/cms/cms/installer.php","1","0","209.237.150.168"),
("232","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607943226.742194;s:12:\"REQUEST_TIME\";i:1607943226;}}","notice","2020-12-14 10:53:51","2020-12-14 10:53:47","20951816","21857384","https://www.mercifulwaygroup.com/cms/cms/installer-backup.php","1","0","209.237.150.168"),
("233","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607943228.009502;s:12:\"REQUEST_TIME\";i:1607943228;}}","notice","2020-12-14 10:53:51","2020-12-14 10:53:48","21110128","22015712","https://www.mercifulwaygroup.com/cms/cms/installer.php","1","0","209.237.150.168"),
("234","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607943243.468801;s:12:\"REQUEST_TIME\";i:1607943243;}}","notice","2020-12-14 10:54:03","2020-12-14 10:54:03","16817112","17722696","https://www.mercifulwaygroup.com/cms/cms/installer.php","1","0","184.168.200.45"),
("235","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:12:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:11:\"HTTP_ACCEPT\";s:3:\"*/*\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1607943243.697748;s:12:\"REQUEST_TIME\";i:1607943243;}}","notice","2020-12-14 10:54:03","2020-12-14 10:54:03","16816448","16886224","https://www.mercifulwaygroup.com/cms/cms/installer-backup.php","1","0","184.168.200.45"),
("236","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2020-12-18 08:42:51","2020-12-18 08:42:51","20447712","20901856","https://www.mercifulwaygroup.com/cms/cms/index.php","1","0","89.46.7.7"),
("237","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:14:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:59:\"en-GB,en;q=0.9,zh-CN;q=0.8,zh;q=0.7,en-US;q=0.6,zh-TW;q=0.5\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1608288073.542816;s:12:\"REQUEST_TIME\";i:1608288073;}}","notice","2020-12-18 10:41:13","2020-12-18 10:41:13","16800840","17706440","https://www.mercifulwaygroup.com/cms/cms/","1","0","14.192.212.191"),
("238","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:14:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:59:\"en-GB,en;q=0.9,zh-CN;q=0.8,zh;q=0.7,en-US;q=0.6,zh-TW;q=0.5\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1608288297.71178;s:12:\"REQUEST_TIME\";i:1608288297;}}","notice","2020-12-18 10:44:58","2020-12-18 10:44:57","16800848","17706448","https://www.mercifulwaygroup.com/cms/cms/","1","0","14.192.212.191"),
("239","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:14:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:59:\"en-GB,en;q=0.9,zh-CN;q=0.8,zh;q=0.7,en-US;q=0.6,zh-TW;q=0.5\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1608288302.497743;s:12:\"REQUEST_TIME\";i:1608288302;}}","notice","2020-12-18 10:45:02","2020-12-18 10:45:02","16803352","17708952","https://www.mercifulwaygroup.com/cms/cms/CPS","1","0","14.192.212.191"),
("240","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:14:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:59:\"en-GB,en;q=0.9,zh-CN;q=0.8,zh;q=0.7,en-US;q=0.6,zh-TW;q=0.5\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1608288308.246867;s:12:\"REQUEST_TIME\";i:1608288308;}}","notice","2020-12-18 10:45:08","2020-12-18 10:45:08","16801608","16871400","https://www.mercifulwaygroup.com/cms/cms/not_found","1","0","14.192.212.191"),
("241","0","four_oh_four","found_404","a:1:{s:6:\"SERVER\";a:14:{s:14:\"REQUEST_METHOD\";s:3:\"GET\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:15:\"SCRIPT_FILENAME\";s:46:\"/home2/mercifulg6281/public_html/cms/index.php\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:59:\"en-GB,en;q=0.9,zh-CN;q=0.8,zh;q=0.7,en-US;q=0.6,zh-TW;q=0.5\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1608288428.322813;s:12:\"REQUEST_TIME\";i:1608288428;}}","notice","2020-12-18 10:47:08","2020-12-18 10:47:08","16800848","17706448","https://www.mercifulwaygroup.com/cms/cms/","1","0","14.192.212.191"),
("242","0","brute_force","invalid-login::user-1","a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:12:\"wp-login.php\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:233:\"<strong>ERROR</strong>: The username or password you entered is incorrect. <a href=\"https://www.mercifulwaygroup.com/cms/cms/wp-login.php?itsec-hb-token=cps&action=lostpassword\" title=\"Password Lost and Found\">Lost your password</a>?\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:12:\"superadmin89\";s:7:\"user_id\";i:1;s:6:\"SERVER\";a:24:{s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/2.0\";s:15:\"SCRIPT_FILENAME\";s:70:\"/home/admin/domains/mercifulwaygroup.com/private_html/cms/wp-login.php\";s:14:\"REQUEST_SCHEME\";s:5:\"https\";s:9:\"HTTP_HOST\";s:24:\"www.mercifulwaygroup.com\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:59:\"en-GB,en;q=0.9,zh-CN;q=0.8,zh;q=0.7,en-US;q=0.6,zh-TW;q=0.5\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:12:\"HTTP_REFERER\";s:72:\"https://www.mercifulwaygroup.com/cms/cms/wp-login.php?itsec-hb-token=cps\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:11:\"HTTP_ORIGIN\";s:36:\"https://www.mercifulwaygroup.com/cms\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:14:\"CONTENT_LENGTH\";s:3:\"133\";s:5:\"HTTPS\";s:2:\"on\";s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:18:\"REQUEST_TIME_FLOAT\";d:1608288438.867485;s:12:\"REQUEST_TIME\";i:1608288438;}}","notice","2020-12-18 10:47:20","2020-12-18 10:47:18","16696656","17090728","https://www.mercifulwaygroup.com/cms/cms/wp-login.php?itsec-hb-token=cps","1","0","14.192.212.191"),
("243","0","lockout","host-lockout::14.192.212.191","a:14:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";s:14:\"14.192.212.191\";s:7:\"user_id\";b:0;s:8:\"username\";b:0;s:14:\"module_details\";a:5:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:27:\"too many bad login attempts\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:0;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2020-12-18 18:47:18\";s:17:\"lockout_start_gmt\";s:19:\"2020-12-18 10:47:18\";s:15:\"lockout_context\";s:413:\"O:40:\"iThemesSecurity\\Lib\\Lockout\\Host_Context\":5:{s:46:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0host\";s:14:\"14.192.212.191\";s:55:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_user_id\";i:1;s:56:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_username\";N;s:62:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0user_limit_triggered\";b:0;s:51:\"\0iThemesSecurity\\Lib\\Lockout\\Context\0lockout_module\";s:11:\"brute_force\";}\";s:14:\"lockout_expire\";s:19:\"2020-12-18 19:02:18\";s:18:\"lockout_expire_gmt\";s:19:\"2020-12-18 11:02:18\";s:12:\"lockout_host\";s:14:\"14.192.212.191\";}","action","2020-12-18 10:47:20","2020-12-18 10:47:18","16743632","17090728","https://www.mercifulwaygroup.com/cms/cms/wp-login.php?itsec-hb-token=cps","1","0","14.192.212.191"),
("244","0","notification_center","send::lockout","a:2:{s:10:\"recipients\";a:2:{i:0;s:17:\"phei@deoworkz.com\";i:1;s:17:\"info@deoworkz.net\";}s:7:\"subject\";s:56:\"[www.mercifulwaygroup.com/cms] Site Lockout Notification\";}","debug","2020-12-18 10:47:20","2020-12-18 10:47:18","16980520","17203032","https://www.mercifulwaygroup.com/cms/cms/wp-login.php?itsec-hb-token=cps","1","0","14.192.212.191");

INSERT IGNORE INTO `wpxd_itsec_temp` VALUES 
("1","four_oh_four","2020-10-05 20:08:10","2020-10-05 12:08:10","14.192.212.205",NULL,NULL),
("2","four_oh_four","2020-10-05 20:08:15","2020-10-05 12:08:15","14.192.212.205",NULL,NULL),
("3","four_oh_four","2020-10-05 20:08:41","2020-10-05 12:08:41","14.192.212.205",NULL,NULL),
("4","four_oh_four","2020-10-05 20:08:43","2020-10-05 12:08:43","14.192.212.205",NULL,NULL),
("5","four_oh_four","2020-10-05 20:08:59","2020-10-05 12:08:59","14.192.212.205",NULL,NULL),
("6","four_oh_four","2020-10-05 20:09:03","2020-10-05 12:09:03","14.192.212.205",NULL,NULL),
("7","four_oh_four","2020-10-05 20:09:16","2020-10-05 12:09:16","14.192.212.205",NULL,NULL),
("8","four_oh_four","2020-10-05 23:41:42","2020-10-05 15:41:42","74.208.40.42",NULL,NULL),
("9","four_oh_four","2020-10-05 23:41:59","2020-10-05 15:41:59","173.236.246.243",NULL,NULL),
("10","four_oh_four","2020-10-06 02:19:29","2020-10-05 18:19:29","149.202.45.11",NULL,NULL),
("11","four_oh_four","2020-10-06 03:58:32","2020-10-05 19:58:32","3.236.228.11",NULL,NULL),
("12","four_oh_four","2020-10-06 04:21:01","2020-10-05 20:21:01","3.236.228.11",NULL,NULL),
("13","four_oh_four","2020-10-06 07:43:17","2020-10-05 23:43:17","172.105.206.169",NULL,NULL),
("14","four_oh_four","2020-10-06 07:43:21","2020-10-05 23:43:21","209.222.4.189",NULL,NULL),
("15","four_oh_four","2020-10-06 07:43:21","2020-10-05 23:43:21","168.119.96.203",NULL,NULL),
("16","four_oh_four","2020-10-06 07:43:22","2020-10-05 23:43:22","172.105.190.118",NULL,NULL),
("17","four_oh_four","2020-10-06 07:43:23","2020-10-05 23:43:23","34.207.69.250",NULL,NULL),
("18","four_oh_four","2020-10-06 07:43:24","2020-10-05 23:43:24","34.235.151.90",NULL,NULL),
("19","four_oh_four","2020-10-06 07:43:25","2020-10-05 23:43:25","34.207.69.250",NULL,NULL),
("20","four_oh_four","2020-10-06 07:43:25","2020-10-05 23:43:25","54.243.207.163",NULL,NULL),
("21","four_oh_four","2020-10-06 07:43:25","2020-10-05 23:43:25","107.21.173.6",NULL,NULL),
("22","four_oh_four","2020-10-06 07:43:26","2020-10-05 23:43:26","34.235.151.90",NULL,NULL),
("23","four_oh_four","2020-10-06 07:43:38","2020-10-05 23:43:38","209.222.4.180",NULL,NULL),
("24","four_oh_four","2020-10-06 07:44:12","2020-10-05 23:44:12","209.222.4.189",NULL,NULL),
("25","four_oh_four","2020-10-06 07:44:37","2020-10-05 23:44:37","209.222.4.189",NULL,NULL),
("26","four_oh_four","2020-10-06 07:45:07","2020-10-05 23:45:07","209.222.4.189",NULL,NULL),
("27","four_oh_four","2020-10-06 07:45:36","2020-10-05 23:45:36","168.119.96.203",NULL,NULL),
("28","four_oh_four","2020-10-06 07:46:10","2020-10-05 23:46:10","139.162.109.252",NULL,NULL),
("29","four_oh_four","2020-10-06 07:46:36","2020-10-05 23:46:36","168.119.96.202",NULL,NULL),
("30","four_oh_four","2020-10-06 07:47:08","2020-10-05 23:47:08","209.222.4.189",NULL,NULL),
("31","four_oh_four","2020-10-06 07:47:37","2020-10-05 23:47:37","209.222.4.180",NULL,NULL),
("32","four_oh_four","2020-10-06 10:01:16","2020-10-06 02:01:16","113.210.93.110",NULL,NULL),
("33","four_oh_four","2020-10-06 10:01:26","2020-10-06 02:01:26","113.210.93.110",NULL,NULL),
("34","four_oh_four","2020-10-06 10:01:28","2020-10-06 02:01:28","113.210.93.110",NULL,NULL),
("35","four_oh_four","2020-10-06 12:57:15","2020-10-06 04:57:15","113.210.93.110",NULL,NULL),
("36","four_oh_four","2020-10-06 23:43:49","2020-10-06 15:43:49","45.132.227.175",NULL,NULL),
("37","four_oh_four","2020-10-07 04:51:36","2020-10-06 20:51:36","150.95.109.154",NULL,NULL),
("38","four_oh_four","2020-10-07 04:51:37","2020-10-06 20:51:37","150.95.109.154",NULL,NULL),
("39","four_oh_four","2020-10-07 10:03:53","2020-10-07 02:03:53","113.210.93.110",NULL,NULL),
("40","four_oh_four","2020-10-07 10:04:06","2020-10-07 02:04:06","113.210.93.110",NULL,NULL),
("41","four_oh_four","2020-10-07 10:10:23","2020-10-07 02:10:23","5.188.62.140",NULL,NULL),
("42","four_oh_four","2020-10-07 10:12:10","2020-10-07 02:12:10","113.210.93.110",NULL,NULL),
("43","four_oh_four","2020-10-07 10:12:20","2020-10-07 02:12:20","113.210.93.110",NULL,NULL),
("44","four_oh_four","2020-10-07 10:18:38","2020-10-07 02:18:38","113.210.93.110",NULL,NULL),
("45","four_oh_four","2020-10-07 10:18:41","2020-10-07 02:18:41","113.210.93.110",NULL,NULL),
("46","four_oh_four","2020-10-07 11:24:10","2020-10-07 03:24:10","66.249.65.218",NULL,NULL),
("47","four_oh_four","2020-10-07 11:34:40","2020-10-07 03:34:40","113.210.93.110",NULL,NULL),
("48","four_oh_four","2020-10-07 11:34:47","2020-10-07 03:34:47","113.210.93.110",NULL,NULL),
("49","four_oh_four","2020-10-08 02:00:00","2020-10-07 18:00:00","66.249.65.218",NULL,NULL),
("50","four_oh_four","2020-10-08 02:36:30","2020-10-07 18:36:30","206.189.85.88",NULL,NULL),
("51","four_oh_four","2020-10-08 13:08:35","2020-10-08 05:08:35","113.210.93.110",NULL,NULL),
("52","four_oh_four","2020-10-09 01:46:03","2020-10-08 17:46:03","116.203.220.177",NULL,NULL),
("53","four_oh_four","2020-10-10 13:27:14","2020-10-10 05:27:14","167.172.16.106",NULL,NULL),
("54","four_oh_four","2020-10-10 16:17:09","2020-10-10 08:17:09","45.132.227.175",NULL,NULL),
("55","four_oh_four","2020-10-10 17:47:54","2020-10-10 09:47:54","45.132.227.175",NULL,NULL),
("56","four_oh_four","2020-10-10 17:58:09","2020-10-10 09:58:09","45.132.227.175",NULL,NULL),
("57","four_oh_four","2020-10-10 22:25:56","2020-10-10 14:25:56","37.59.54.36",NULL,NULL),
("58","four_oh_four","2020-10-10 22:31:18","2020-10-10 14:31:18","167.86.104.186",NULL,NULL),
("59","four_oh_four","2020-10-10 22:31:25","2020-10-10 14:31:25","167.86.104.186",NULL,NULL),
("60","four_oh_four","2020-10-11 08:00:35","2020-10-11 00:00:35","192.71.10.105",NULL,NULL),
("61","four_oh_four","2020-10-11 08:00:37","2020-10-11 00:00:37","192.71.42.108",NULL,NULL),
("62","four_oh_four","2020-10-11 11:05:28","2020-10-11 03:05:28","134.209.123.101",NULL,NULL),
("63","four_oh_four","2020-10-12 08:05:19","2020-10-12 00:05:19","178.32.198.183",NULL,NULL),
("64","four_oh_four","2020-10-13 05:17:32","2020-10-12 21:17:32","104.155.1.22",NULL,NULL),
("65","four_oh_four","2020-10-13 12:15:00","2020-10-13 04:15:00","66.198.246.47",NULL,NULL),
("66","four_oh_four","2020-10-15 00:37:41","2020-10-14 16:37:41","54.38.65.127",NULL,NULL),
("67","four_oh_four","2020-10-15 01:23:11","2020-10-14 17:23:11","51.68.212.99",NULL,NULL),
("68","four_oh_four","2020-10-16 07:23:01","2020-10-15 23:23:01","104.194.220.240",NULL,NULL),
("69","four_oh_four","2020-10-16 20:09:48","2020-10-16 12:09:48","66.249.64.115",NULL,NULL),
("70","four_oh_four","2020-10-17 20:29:09","2020-10-17 12:29:09","165.22.56.234",NULL,NULL),
("71","four_oh_four","2020-10-18 01:24:50","2020-10-17 17:24:50","185.197.160.54",NULL,NULL),
("72","four_oh_four","2020-10-18 01:24:51","2020-10-17 17:24:51","185.197.160.54",NULL,NULL),
("73","four_oh_four","2020-10-19 01:55:54","2020-10-18 17:55:54","130.211.62.52",NULL,NULL),
("74","four_oh_four","2020-10-19 01:56:06","2020-10-18 17:56:06","130.211.62.52",NULL,NULL),
("75","four_oh_four","2020-10-19 01:56:06","2020-10-18 17:56:06","130.211.62.52",NULL,NULL),
("76","four_oh_four","2020-10-19 01:56:06","2020-10-18 17:56:06","130.211.62.52",NULL,NULL),
("77","four_oh_four","2020-10-19 06:25:47","2020-10-18 22:25:47","138.197.146.132",NULL,NULL),
("78","four_oh_four","2020-10-19 14:31:31","2020-10-19 06:31:31","195.154.230.207",NULL,NULL),
("79","four_oh_four","2020-10-19 19:22:11","2020-10-19 11:22:11","51.222.43.142",NULL,NULL),
("80","four_oh_four","2020-10-21 03:34:49","2020-10-20 19:34:49","101.133.174.69",NULL,NULL),
("81","four_oh_four","2020-10-21 14:38:20","2020-10-21 06:38:20","146.59.172.42",NULL,NULL),
("82","four_oh_four","2020-10-22 20:50:53","2020-10-22 12:50:53","67.205.143.140",NULL,NULL),
("83","four_oh_four","2020-10-23 23:32:50","2020-10-23 15:32:50","81.19.215.19",NULL,NULL),
("84","four_oh_four","2020-10-25 13:11:41","2020-10-25 05:11:41","64.202.184.249",NULL,NULL),
("85","four_oh_four","2020-10-26 00:12:37","2020-10-25 16:12:37","18.196.96.172",NULL,NULL),
("86","four_oh_four","2020-10-26 07:58:09","2020-10-25 23:58:09","62.210.185.4",NULL,NULL),
("87","four_oh_four","2020-10-26 18:20:19","2020-10-26 10:20:19","193.27.229.26",NULL,NULL),
("88","four_oh_four","2020-10-27 14:03:46","2020-10-27 06:03:46","62.210.75.68",NULL,NULL),
("89","four_oh_four","2020-10-28 00:11:57","2020-10-27 16:11:57","18.196.96.172",NULL,NULL),
("90","four_oh_four","2020-10-28 00:12:19","2020-10-27 16:12:19","3.22.70.135",NULL,NULL),
("91","four_oh_four","2020-10-28 10:49:40","2020-10-28 02:49:40","64.202.184.249",NULL,NULL),
("92","four_oh_four","2020-10-28 22:18:16","2020-10-28 14:18:16","63.143.37.10",NULL,NULL),
("93","four_oh_four","2020-10-29 00:12:22","2020-10-28 16:12:22","34.211.6.84",NULL,NULL),
("94","four_oh_four","2020-10-29 00:12:23","2020-10-28 16:12:23","18.196.96.172",NULL,NULL),
("95","four_oh_four","2020-10-29 00:12:28","2020-10-28 16:12:28","52.28.236.88",NULL,NULL),
("96","four_oh_four","2020-10-29 00:12:28","2020-10-28 16:12:28","3.22.70.135",NULL,NULL),
("97","four_oh_four","2020-10-29 10:31:15","2020-10-29 02:31:15","113.210.65.203",NULL,NULL),
("98","four_oh_four","2020-10-29 10:31:36","2020-10-29 02:31:36","113.210.65.203",NULL,NULL),
("99","four_oh_four","2020-10-29 21:02:40","2020-10-29 13:02:40","66.249.66.213",NULL,NULL),
("100","four_oh_four","2020-10-30 00:28:58","2020-10-29 16:28:58","46.101.95.65",NULL,NULL),
("101","four_oh_four","2020-10-31 00:12:16","2020-10-30 16:12:16","3.128.26.105",NULL,NULL),
("102","four_oh_four","2020-10-31 00:12:20","2020-10-30 16:12:20","18.196.96.172",NULL,NULL),
("103","four_oh_four","2020-10-31 00:12:23","2020-10-30 16:12:23","34.209.232.166",NULL,NULL),
("104","four_oh_four","2020-10-31 00:12:29","2020-10-30 16:12:29","34.209.232.166",NULL,NULL),
("105","four_oh_four","2020-10-31 00:12:30","2020-10-30 16:12:30","3.128.26.105",NULL,NULL),
("106","four_oh_four","2020-10-31 21:44:07","2020-10-31 13:44:07","167.71.124.33",NULL,NULL),
("107","four_oh_four","2020-11-01 02:39:58","2020-10-31 18:39:58","45.118.144.77",NULL,NULL),
("108","four_oh_four","2020-11-02 02:20:43","2020-11-01 18:20:43","124.158.12.202",NULL,NULL),
("109","four_oh_four","2020-11-15 16:53:49","2020-11-15 08:53:49","91.191.172.219",NULL,NULL),
("110","four_oh_four","2020-11-15 16:53:48","2020-11-15 08:53:48","91.191.172.219",NULL,NULL),
("111","four_oh_four","2020-11-16 17:30:20","2020-11-16 09:30:20","203.150.228.128",NULL,NULL),
("112","four_oh_four","2020-11-16 17:30:33","2020-11-16 09:30:33","208.67.16.234",NULL,NULL),
("113","four_oh_four","2020-11-16 17:30:44","2020-11-16 09:30:44","50.63.194.161",NULL,NULL),
("114","four_oh_four","2020-11-16 17:31:07","2020-11-16 09:31:07","50.62.176.125",NULL,NULL),
("115","four_oh_four","2020-11-16 17:31:41","2020-11-16 09:31:41","50.62.208.52",NULL,NULL),
("116","four_oh_four","2020-11-16 17:32:18","2020-11-16 09:32:18","190.107.177.250",NULL,NULL),
("117","four_oh_four","2020-11-16 17:32:30","2020-11-16 09:32:30","31.209.177.21",NULL,NULL),
("118","four_oh_four","2020-11-16 17:32:47","2020-11-16 09:32:47","5.249.141.102",NULL,NULL),
("119","four_oh_four","2020-11-16 17:32:53","2020-11-16 09:32:53","160.153.147.143",NULL,NULL),
("120","four_oh_four","2020-11-16 17:32:54","2020-11-16 09:32:54","93.90.146.112",NULL,NULL),
("121","four_oh_four","2020-11-16 17:33:03","2020-11-16 09:33:03","35.214.250.123",NULL,NULL),
("122","four_oh_four","2020-11-16 17:33:15","2020-11-16 09:33:15","160.153.154.5",NULL,NULL),
("123","four_oh_four","2020-11-16 17:33:26","2020-11-16 09:33:26","46.41.148.252",NULL,NULL),
("124","four_oh_four","2020-11-16 17:33:50","2020-11-16 09:33:50","66.113.223.208",NULL,NULL),
("125","four_oh_four","2020-11-16 17:34:02","2020-11-16 09:34:02","72.52.216.50",NULL,NULL),
("126","four_oh_four","2020-11-19 13:57:35","2020-11-19 05:57:35","113.210.123.222",NULL,NULL),
("127","four_oh_four","2020-11-19 13:58:06","2020-11-19 05:58:06","113.210.123.222",NULL,NULL),
("128","four_oh_four","2020-11-24 21:36:28","2020-11-24 13:36:28","51.38.227.167",NULL,NULL),
("129","four_oh_four","2020-11-24 21:36:39","2020-11-24 13:36:39","173.201.196.30",NULL,NULL),
("130","four_oh_four","2020-11-24 21:36:41","2020-11-24 13:36:41","198.71.238.5",NULL,NULL),
("131","four_oh_four","2020-11-24 21:36:49","2020-11-24 13:36:49","184.168.193.187",NULL,NULL),
("132","four_oh_four","2020-11-24 21:37:14","2020-11-24 13:37:14","184.168.193.105",NULL,NULL),
("133","four_oh_four","2020-11-24 21:37:24","2020-11-24 13:37:24","49.51.49.254",NULL,NULL),
("134","four_oh_four","2020-11-24 21:37:26","2020-11-24 13:37:26","184.168.193.187",NULL,NULL),
("135","four_oh_four","2020-11-24 21:37:35","2020-11-24 13:37:35","160.153.146.79",NULL,NULL),
("136","four_oh_four","2020-11-24 21:38:02","2020-11-24 13:38:02","209.237.150.165",NULL,NULL),
("137","four_oh_four","2020-11-24 21:38:09","2020-11-24 13:38:09","51.38.227.167",NULL,NULL),
("138","four_oh_four","2020-11-24 21:38:33","2020-11-24 13:38:33","43.229.84.119",NULL,NULL),
("139","four_oh_four","2020-11-24 21:38:44","2020-11-24 13:38:44","198.71.239.44",NULL,NULL),
("140","four_oh_four","2020-11-24 21:39:04","2020-11-24 13:39:04","160.153.147.160",NULL,NULL),
("141","four_oh_four","2020-11-24 21:39:07","2020-11-24 13:39:07","184.168.193.196",NULL,NULL),
("142","four_oh_four","2020-11-24 21:39:15","2020-11-24 13:39:15","203.205.21.159",NULL,NULL),
("143","four_oh_four","2020-11-24 21:39:27","2020-11-24 13:39:27","160.153.147.142",NULL,NULL),
("144","four_oh_four","2020-11-24 21:39:36","2020-11-24 13:39:36","173.201.196.119",NULL,NULL),
("145","four_oh_four","2020-11-24 21:39:49","2020-11-24 13:39:49","66.199.191.89",NULL,NULL),
("146","four_oh_four","2020-11-26 18:47:57","2020-11-26 10:47:57","50.62.160.232",NULL,NULL),
("147","four_oh_four","2020-11-26 18:47:58","2020-11-26 10:47:58","50.62.160.232",NULL,NULL),
("148","four_oh_four","2020-11-30 06:38:25","2020-11-29 22:38:25","46.243.69.2",NULL,NULL),
("149","four_oh_four","2020-11-30 06:38:27","2020-11-29 22:38:27","46.243.69.2",NULL,NULL),
("150","four_oh_four","2020-12-02 07:57:41","2020-12-01 23:57:41","198.71.239.46",NULL,NULL),
("151","four_oh_four","2020-12-02 07:58:03","2020-12-01 23:58:03","193.194.69.98",NULL,NULL),
("152","four_oh_four","2020-12-02 07:58:38","2020-12-01 23:58:38","198.71.239.31",NULL,NULL),
("153","four_oh_four","2020-12-02 07:59:09","2020-12-01 23:59:09","184.168.193.99",NULL,NULL),
("154","four_oh_four","2020-12-02 07:59:21","2020-12-01 23:59:21","184.168.27.69",NULL,NULL),
("155","four_oh_four","2020-12-02 07:59:31","2020-12-01 23:59:31","198.71.239.44",NULL,NULL),
("156","four_oh_four","2020-12-02 07:59:43","2020-12-01 23:59:43","184.168.46.123",NULL,NULL),
("157","four_oh_four","2020-12-02 07:59:54","2020-12-01 23:59:54","66.113.223.208",NULL,NULL),
("158","four_oh_four","2020-12-02 08:00:17","2020-12-02 00:00:17","160.153.147.143",NULL,NULL),
("159","four_oh_four","2020-12-02 08:00:30","2020-12-02 00:00:30","203.205.21.159",NULL,NULL),
("160","four_oh_four","2020-12-03 23:38:10","2020-12-03 15:38:10","195.74.38.129",NULL,NULL),
("161","four_oh_four","2020-12-03 23:38:11","2020-12-03 15:38:11","195.74.38.129",NULL,NULL),
("162","four_oh_four","2020-12-07 11:36:44","2020-12-07 03:36:44","75.103.66.9",NULL,NULL),
("163","four_oh_four","2020-12-07 11:36:43","2020-12-07 03:36:43","75.103.66.9",NULL,NULL),
("164","four_oh_four","2020-12-09 16:27:17","2020-12-09 08:27:17","104.238.120.73",NULL,NULL),
("165","four_oh_four","2020-12-09 16:27:39","2020-12-09 08:27:39","203.205.21.159",NULL,NULL),
("166","four_oh_four","2020-12-09 16:27:49","2020-12-09 08:27:49","160.153.154.11",NULL,NULL),
("167","four_oh_four","2020-12-09 16:27:53","2020-12-09 08:27:53","160.153.147.142",NULL,NULL),
("168","four_oh_four","2020-12-09 16:28:01","2020-12-09 08:28:01","201.150.35.113",NULL,NULL),
("169","four_oh_four","2020-12-09 16:28:04","2020-12-09 08:28:04","173.201.196.31",NULL,NULL),
("170","four_oh_four","2020-12-09 16:28:12","2020-12-09 08:28:12","198.71.239.13",NULL,NULL),
("171","four_oh_four","2020-12-09 16:28:23","2020-12-09 08:28:23","67.227.241.68",NULL,NULL),
("172","four_oh_four","2020-12-09 16:28:33","2020-12-09 08:28:33","160.153.153.28",NULL,NULL),
("173","four_oh_four","2020-12-09 16:29:32","2020-12-09 08:29:32","160.153.154.19",NULL,NULL),
("174","four_oh_four","2020-12-09 16:29:46","2020-12-09 08:29:46","176.223.121.235",NULL,NULL),
("175","four_oh_four","2020-12-09 16:29:55","2020-12-09 08:29:55","185.25.241.245",NULL,NULL),
("176","four_oh_four","2020-12-09 16:30:09","2020-12-09 08:30:09","160.153.156.134",NULL,NULL),
("177","four_oh_four","2020-12-09 16:30:18","2020-12-09 08:30:18","149.56.44.141",NULL,NULL),
("178","four_oh_four","2020-12-09 16:30:52","2020-12-09 08:30:52","134.0.11.154",NULL,NULL),
("179","four_oh_four","2020-12-09 16:30:53","2020-12-09 08:30:53","173.219.72.14",NULL,NULL),
("180","four_oh_four","2020-12-09 16:31:05","2020-12-09 08:31:05","138.68.105.248",NULL,NULL),
("181","four_oh_four","2020-12-11 02:47:27","2020-12-10 18:47:27","160.153.146.165",NULL,NULL),
("182","four_oh_four","2020-12-11 02:47:28","2020-12-10 18:47:28","160.153.146.165",NULL,NULL),
("183","four_oh_four","2020-12-14 18:53:47","2020-12-14 10:53:47","209.237.150.168",NULL,NULL),
("184","four_oh_four","2020-12-14 18:53:48","2020-12-14 10:53:48","209.237.150.168",NULL,NULL),
("185","four_oh_four","2020-12-14 18:54:03","2020-12-14 10:54:03","184.168.200.45",NULL,NULL),
("186","four_oh_four","2020-12-14 18:54:03","2020-12-14 10:54:03","184.168.200.45",NULL,NULL),
("187","four_oh_four","2020-12-18 18:41:13","2020-12-18 10:41:13","14.192.212.191",NULL,NULL),
("188","four_oh_four","2020-12-18 18:44:57","2020-12-18 10:44:57","14.192.212.191",NULL,NULL),
("189","four_oh_four","2020-12-18 18:45:02","2020-12-18 10:45:02","14.192.212.191",NULL,NULL),
("190","four_oh_four","2020-12-18 18:45:08","2020-12-18 10:45:08","14.192.212.191",NULL,NULL),
("191","four_oh_four","2020-12-18 18:47:08","2020-12-18 10:47:08","14.192.212.191",NULL,NULL),
("192","brute_force","2020-12-18 18:47:18","2020-12-18 10:47:18","14.192.212.191",NULL,NULL),
("193","brute_force","2020-12-18 18:47:18","2020-12-18 10:47:18",NULL,"1","superadmin89");

INSERT IGNORE INTO `wpxd_itsec_user_groups` VALUES 
("08a24140-d87c-44b8-b243-48bd5a882d70","Administrator Users","","administrator","","","2020-10-05 12:03:42"),
("2a6e914e-09e0-460d-b5d4-0efed5b1f1a4","Subscriber Users","","subscriber","","","2020-10-05 12:03:42"),
("2b8841cb-3a5a-4913-a30e-448b049fcfbc","Editor Users","","editor","","","2020-10-05 12:03:41"),
("439fae80-b95c-4264-88ad-3915a3244874","Author Users","","author","","","2020-10-05 12:03:42"),
("4facac3a-9813-4cb3-a03d-c01f1852330e","Administrator Users","","administrator","","","2020-10-05 12:03:41"),
("86361ca0-58ec-4a3b-a89b-b555fc37c50c","Contributor Users","","contributor","","","2020-10-05 12:03:41"),
("d0367d8d-f6a2-4c0b-8349-1a01aa7d57d2","Author Users","","author","","","2020-10-05 12:03:41"),
("ddbf4674-926c-4ef7-92e8-2ce515a8da0d","Subscriber Users","","subscriber","","","2020-10-05 12:03:41"),
("ed5b5585-8146-4b39-9b21-8e40b47305f2","Contributor Users","","contributor","","","2020-10-05 12:03:42"),
("f33bc67b-d8a1-4a74-b6e6-74348f809621","Editor Users","","editor","","","2020-10-05 12:03:42");

INSERT IGNORE INTO `wpxd_layerslider` VALUES 
("1",NULL,"2","Home Slider","","{\"properties\":{\"title\":\"Home Slider\",\"slug\":\"\",\"sliderVersion\":\"6.11.2\",\"status\":true,\"schedule_start\":\"\",\"schedule_end\":\"\",\"type\":\"responsive\",\"width\":1920,\"height\":600,\"maxwidth\":\"\",\"responsiveunder\":\"\",\"fullSizeMode\":\"normal\",\"fitScreenWidth\":true,\"maxRatio\":\"\",\"insertMethod\":\"prependTo\",\"insertSelector\":\"\",\"clipSlideTransition\":\"disabled\",\"preventSliderClip\":true,\"hideunder\":\"\",\"hideover\":\"\",\"slideOnSwipe\":true,\"optimizeForMobile\":true,\"firstlayer\":\"1\",\"autostart\":true,\"startinviewport\":true,\"pauseonhover\":\"enabled\",\"keybnav\":true,\"touchnav\":true,\"playByScrollSpeed\":\"1\",\"loops\":\"0\",\"forceloopnum\":true,\"skin\":\"v6\",\"sliderfadeinduration\":\"350\",\"sliderclass\":\"\",\"sliderstyle\":\"margin-bottom: 0px;\",\"backgroundcolor\":\"\",\"backgroundimageId\":\"\",\"backgroundimage\":\"\",\"globalBGRepeat\":\"no-repeat\",\"globalBGAttachment\":\"scroll\",\"globalBGPosition\":\"50% 50%\",\"globalBGSize\":\"auto\",\"navprevnext\":true,\"navstartstop\":true,\"navbuttons\":true,\"hoverprevnext\":true,\"circletimer\":true,\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autoplayvideos\":true,\"rememberUnmuteState\":true,\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"popupPositionHorizontal\":\"center\",\"popupPositionVertical\":\"middle\",\"popupWidth\":\"640\",\"popupHeight\":\"360\",\"popupDistanceLeft\":\"10\",\"popupDistanceRight\":\"10\",\"popupDistanceTop\":\"10\",\"popupDistanceBottom\":\"10\",\"popupShowOnTimeout\":\"\",\"popupShowOnIdle\":\"\",\"popupShowOnScroll\":\"\",\"popupShowOnClick\":\"\",\"popupCloseOnTimeout\":\"\",\"popupCloseOnScroll\":\"\",\"popup_repeat\":true,\"popup_repeat_days\":\"\",\"popupShowOnce\":true,\"popup_pages_custom\":\"\",\"popup_pages_exclude\":\"\",\"popup_roles_administrator\":true,\"popup_roles_editor\":true,\"popup_roles_author\":true,\"popup_roles_contributor\":true,\"popup_roles_subscriber\":true,\"popup_roles_customer\":true,\"popup_roles_visitor\":true,\"popupTransitionIn\":\"fade\",\"popupDurationIn\":\"1000\",\"popupDelayIn\":\"200\",\"popupTransitionOut\":\"fade\",\"popupDurationOut\":\"500\",\"popupResetOnClose\":\"slide\",\"popupShowCloseButton\":true,\"popupCloseButtonStyle\":\"\",\"popupOverlayClickToClose\":true,\"popupOverlayBackground\":\"rgba(0,0,0,.85)\",\"popupOverlayTransitionIn\":\"fade\",\"popupOverlayDurationIn\":\"400\",\"popupOverlayTransitionOut\":\"fade\",\"popupOverlayDurationOut\":\"400\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: -10px; top: -10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"slideBGSize\":\"cover\",\"slideBGPosition\":\"50% 50%\",\"parallaxSensitivity\":\"10\",\"parallaxCenterLayers\":\"center\",\"parallaxCenterDegree\":\"40\",\"forceLayersOutDuration\":\"750\",\"useSrcset\":true,\"preferBlendMode\":\"disabled\",\"previewId\":\"\",\"preview\":\"\",\"allowFullscreen\":false,\"createdWith\":\"6.11.2\"},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":35,\"background\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/banner-01.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"Linked to WP Page: ABOUT US\",\"linkId\":\"9\",\"linkName\":\"ABOUT US\",\"linkType\":\"page\",\"layer_link_target\":\"_blank\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"customProperties\":[],\"backgroundThumb\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/banner-01-300x94.jpg\",\"post_content\":false},\"sublayers\":[],\"meta\":{\"undoStackIndex\":3},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"background\":\"\",\"backgroundId\":\"\",\"backgroundThumb\":\"\"},\"redo\":{\"background\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/banner-01.jpg\",\"backgroundId\":35,\"backgroundThumb\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/banner-01.jpg\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"slidedelay\":\"\"},\"redo\":{\"slidedelay\":\"3000\"}}]},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"},\"redo\":{\"layer_link\":\"Linked to WP Page: ABOUT US\",\"linkId\":9,\"linkName\":\"ABOUT US\",\"linkType\":\"page\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"layer_link_target\":\"_self\"},\"redo\":{\"layer_link_target\":\"_blank\"}}]}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":36,\"background\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/banner-02.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"customProperties\":[],\"backgroundThumb\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/banner-02-300x94.jpg\",\"post_content\":false},\"sublayers\":[],\"meta\":{\"undoStackIndex\":1},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":1,\"undo\":{\"background\":\"\",\"backgroundId\":\"\",\"backgroundThumb\":\"\"},\"redo\":{\"background\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/banner-02.jpg\",\"backgroundId\":36,\"backgroundThumb\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/banner-02.jpg\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"slidedelay\":\"\"},\"redo\":{\"slidedelay\":\"3000\"}}]}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":37,\"background\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/banner-03.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"customProperties\":[],\"backgroundThumb\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/banner-03-300x94.jpg\",\"post_content\":false},\"sublayers\":[],\"meta\":{\"undoStackIndex\":1},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":2,\"undo\":{\"background\":\"\",\"backgroundId\":\"\",\"backgroundThumb\":\"\"},\"redo\":{\"background\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/banner-03.jpg\",\"backgroundId\":37,\"backgroundThumb\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/banner-03.jpg\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"slidedelay\":\"\"},\"redo\":{\"slidedelay\":\"3000\"}}]}]}]}","1601960234","1602037130","0","0","0","0","0","0","0"),
("2",NULL,"2","Mobile Slider","","{\"properties\":{\"title\":\"Mobile Slider\",\"slug\":\"\",\"sliderVersion\":\"6.11.2\",\"status\":true,\"schedule_start\":\"\",\"schedule_end\":\"\",\"type\":\"responsive\",\"width\":\"700\",\"height\":\"538\",\"maxwidth\":\"\",\"responsiveunder\":\"\",\"fullSizeMode\":\"normal\",\"fitScreenWidth\":true,\"allowFullscreen\":false,\"maxRatio\":\"\",\"insertMethod\":\"prependTo\",\"insertSelector\":\"\",\"clipSlideTransition\":\"disabled\",\"preventSliderClip\":true,\"hideunder\":\"\",\"hideover\":\"\",\"slideOnSwipe\":true,\"optimizeForMobile\":true,\"firstlayer\":\"1\",\"autostart\":true,\"startinviewport\":true,\"pauseonhover\":\"enabled\",\"keybnav\":true,\"touchnav\":true,\"playByScrollSpeed\":\"1\",\"loops\":\"0\",\"forceloopnum\":true,\"skin\":\"v6\",\"sliderfadeinduration\":\"350\",\"sliderclass\":\"\",\"sliderstyle\":\"margin-bottom: 0px;\",\"backgroundcolor\":\"\",\"backgroundimageId\":\"\",\"backgroundimage\":\"\",\"globalBGRepeat\":\"no-repeat\",\"globalBGAttachment\":\"scroll\",\"globalBGPosition\":\"50% 50%\",\"globalBGSize\":\"auto\",\"navprevnext\":true,\"navstartstop\":true,\"navbuttons\":true,\"hoverprevnext\":true,\"circletimer\":true,\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autoplayvideos\":true,\"rememberUnmuteState\":true,\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"popupPositionHorizontal\":\"center\",\"popupPositionVertical\":\"middle\",\"popupWidth\":\"640\",\"popupHeight\":\"360\",\"popupDistanceLeft\":\"10\",\"popupDistanceRight\":\"10\",\"popupDistanceTop\":\"10\",\"popupDistanceBottom\":\"10\",\"popupShowOnTimeout\":\"\",\"popupShowOnIdle\":\"\",\"popupShowOnScroll\":\"\",\"popupShowOnClick\":\"\",\"popupCloseOnTimeout\":\"\",\"popupCloseOnScroll\":\"\",\"popup_repeat\":true,\"popup_repeat_days\":\"\",\"popupShowOnce\":true,\"popup_pages_custom\":\"\",\"popup_pages_exclude\":\"\",\"popup_roles_administrator\":true,\"popup_roles_editor\":true,\"popup_roles_author\":true,\"popup_roles_contributor\":true,\"popup_roles_subscriber\":true,\"popup_roles_customer\":true,\"popup_roles_visitor\":true,\"popupTransitionIn\":\"fade\",\"popupDurationIn\":\"1000\",\"popupDelayIn\":\"200\",\"popupTransitionOut\":\"fade\",\"popupDurationOut\":\"500\",\"popupResetOnClose\":\"slide\",\"popupShowCloseButton\":true,\"popupCloseButtonStyle\":\"\",\"popupOverlayClickToClose\":true,\"popupOverlayBackground\":\"rgba(0,0,0,.85)\",\"popupOverlayTransitionIn\":\"fade\",\"popupOverlayDurationIn\":\"400\",\"popupOverlayTransitionOut\":\"fade\",\"popupOverlayDurationOut\":\"400\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: -10px; top: -10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"slideBGSize\":\"cover\",\"slideBGPosition\":\"50% 50%\",\"parallaxSensitivity\":\"10\",\"parallaxCenterLayers\":\"center\",\"parallaxCenterDegree\":\"40\",\"forceLayersOutDuration\":\"750\",\"useSrcset\":true,\"preferBlendMode\":\"disabled\",\"previewId\":\"\",\"preview\":\"\",\"createdWith\":\"6.11.2\"},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":49,\"background\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/mobile-slider-01.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"Linked to WP Page: ABOUT US\",\"linkId\":\"9\",\"linkName\":\"ABOUT US\",\"linkType\":\"page\",\"layer_link_target\":\"_blank\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"customProperties\":[],\"backgroundThumb\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/mobile-slider-01.jpg\",\"post_content\":false},\"sublayers\":[],\"meta\":{\"undoStackIndex\":3},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"background\":\"\",\"backgroundId\":\"\",\"backgroundThumb\":\"\"},\"redo\":{\"background\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/mobile-slider-01.jpg\",\"backgroundId\":49,\"backgroundThumb\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/mobile-slider-01.jpg\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"slidedelay\":\"\"},\"redo\":{\"slidedelay\":\"3000\"}}]},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"},\"redo\":{\"layer_link\":\"Linked to WP Page: ABOUT US\",\"linkId\":9,\"linkName\":\"ABOUT US\",\"linkType\":\"page\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"layer_link_target\":\"_self\"},\"redo\":{\"layer_link_target\":\"_blank\"}}]}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":50,\"background\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/mobile-slider-02.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"Linked to WP Page: SERVICES\",\"linkId\":\"10\",\"linkName\":\"SERVICES\",\"linkType\":\"page\",\"layer_link_target\":\"_blank\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"customProperties\":[],\"backgroundThumb\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/mobile-slider-02.jpg\",\"post_content\":false},\"sublayers\":[],\"meta\":{\"undoStackIndex\":3},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":1,\"undo\":{\"background\":\"\",\"backgroundId\":\"\",\"backgroundThumb\":\"\"},\"redo\":{\"background\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/mobile-slider-02.jpg\",\"backgroundId\":50,\"backgroundThumb\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/mobile-slider-02.jpg\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"slidedelay\":\"\"},\"redo\":{\"slidedelay\":\"3000\"}}]},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":1,\"undo\":{\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"},\"redo\":{\"layer_link\":\"Linked to WP Page: SERVICES\",\"linkId\":10,\"linkName\":\"SERVICES\",\"linkType\":\"page\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"layer_link_target\":\"_self\"},\"redo\":{\"layer_link_target\":\"_blank\"}}]}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":51,\"background\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/mobile-slider-03.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"Linked to WP Page: SERVICES\",\"linkId\":\"10\",\"linkName\":\"SERVICES\",\"linkType\":\"page\",\"layer_link_target\":\"_blank\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"customProperties\":[],\"backgroundThumb\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/mobile-slider-03.jpg\",\"post_content\":false},\"sublayers\":[],\"meta\":{\"undoStackIndex\":3},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":2,\"undo\":{\"background\":\"\",\"backgroundId\":\"\",\"backgroundThumb\":\"\"},\"redo\":{\"background\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/mobile-slider-03.jpg\",\"backgroundId\":51,\"backgroundThumb\":\"https:\\/\\/www.mercifulwaygroup.com\\/cms\\/cms\\/images\\/files\\/2020\\/10\\/mobile-slider-03.jpg\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"slidedelay\":\"\"},\"redo\":{\"slidedelay\":\"3000\"}}]},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":2,\"undo\":{\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"},\"redo\":{\"layer_link\":\"Linked to WP Page: SERVICES\",\"linkId\":10,\"linkName\":\"SERVICES\",\"linkType\":\"page\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"layer_link_target\":\"_self\"},\"redo\":{\"layer_link_target\":\"_blank\"}}]}]}]}","1602036244","1602037113","0","0","0","0","0","0","0");

INSERT IGNORE INTO `wpxd_nf3_actions` VALUES 
("5",NULL,NULL,"successmessage","1","2","2020-10-06 12:07:13","2020-10-06 12:07:13","Success Message"),
("6",NULL,NULL,"email","1","2","2020-10-06 12:07:13","2020-10-06 12:07:13","Admin Email"),
("7",NULL,NULL,"save","1","2","2020-10-06 12:07:13","2020-10-06 12:07:13","Store Submission");

INSERT IGNORE INTO `wpxd_nf3_action_meta` VALUES 
("79","5","objectType","Action","objectType","Action"),
("80","5","objectDomain","actions","objectDomain","actions"),
("81","5","editActive","","editActive",""),
("82","5","message","Your form has been successfully submitted.","message","Your form has been successfully submitted."),
("83","5","order","1","order","1"),
("84","5","to","{wp:admin_email}","to","{wp:admin_email}"),
("85","5","reply_to","","reply_to",""),
("86","5","email_subject","Ninja Forms Submission","email_subject","Ninja Forms Submission"),
("87","5","email_message","{fields_table}","email_message","{fields_table}"),
("88","5","email_message_plain","","email_message_plain",""),
("89","5","from_name","","from_name",""),
("90","5","from_address","","from_address",""),
("91","5","email_format","html","email_format","html"),
("92","5","cc","","cc",""),
("93","5","bcc","","bcc",""),
("94","5","success_msg","Your form has been successfully submitted.","success_msg","Your form has been successfully submitted."),
("95","6","objectType","Action","objectType","Action"),
("96","6","objectDomain","actions","objectDomain","actions"),
("97","6","editActive","","editActive",""),
("98","6","order","2","order","2"),
("99","6","to","info@mercifulwaygroup.com","to","info@mercifulwaygroup.com"),
("100","6","reply_to","{field:email_1601957160168}","reply_to","{field:email_1601957160168}"),
("101","6","email_subject","Enquiry Form from Mercifulwaygroup.com","email_subject","Enquiry Form from Mercifulwaygroup.com"),
("102","6","email_message","<p>Name:&nbsp;{field:name_1601957169385}</p><p>Email:&nbsp;{field:email_1601957160168}</p><p>Phone:&nbsp;{field:phone_number_1601957175283}</p><p>Message:&nbsp;{field:message_1601957247397}</p>","email_message","<p>Name:&nbsp;{field:name_1601957169385}</p><p>Email:&nbsp;{field:email_1601957160168}</p><p>Phone:&nbsp;{field:phone_number_1601957175283}</p><p>Message:&nbsp;{field:message_1601957247397}</p>"),
("103","6","email_message_plain","","email_message_plain",""),
("104","6","from_name","","from_name",""),
("105","6","from_address","","from_address",""),
("106","6","email_format","html","email_format","html"),
("107","6","cc","","cc",""),
("108","6","bcc","","bcc",""),
("109","6","drawerDisabled","","drawerDisabled",""),
("110","7","objectType","Action","objectType","Action"),
("111","7","objectDomain","actions","objectDomain","actions"),
("112","7","editActive","","editActive",""),
("113","7","order","3","order","3"),
("114","7","to","{wp:admin_email}","to","{wp:admin_email}"),
("115","7","reply_to","","reply_to",""),
("116","7","email_subject","Ninja Forms Submission","email_subject","Ninja Forms Submission"),
("117","7","email_message","{fields_table}","email_message","{fields_table}"),
("118","7","email_message_plain","","email_message_plain",""),
("119","7","from_name","","from_name",""),
("120","7","from_address","","from_address",""),
("121","7","email_format","html","email_format","html"),
("122","7","cc","","cc",""),
("123","7","bcc","","bcc",""),
("124","7","success_msg","Your form has been successfully submitted.","success_msg","Your form has been successfully submitted."),
("125","7","redirect_url","","redirect_url",""),
("126","7","submitter_email","email_1601957160168","submitter_email","email_1601957160168"),
("127","7","fields-save-toggle","save_all","fields-save-toggle","save_all"),
("128","7","exception_fields","a:0:{}","exception_fields","a:0:{}"),
("129","7","set_subs_to_expire","0","set_subs_to_expire","0"),
("130","7","subs_expire_time","90","subs_expire_time","90");

INSERT IGNORE INTO `wpxd_nf3_fields` VALUES 
("5","Name","name_1601957169385","firstname","2","2020-10-06 12:07:13",NULL,"Name","name_1601957169385","999","1","","default","1"),
("6","Email","email_1601957160168","email","2","2020-10-06 12:07:13",NULL,"Email","email_1601957160168","999","1","","default","1"),
("7","Phone Number","phone_number_1601957175283","phone","2","2020-10-06 12:07:13",NULL,"Phone Number","phone_number_1601957175283","999","1","","default","1"),
("8","Message","message_1601957247397","textarea","2","2020-10-06 17:04:51",NULL,"Message","message_1601957247397","999","1","","default","0"),
("9","Submit","submit_1601957260366","submit","2","2020-10-06 12:07:13",NULL,"Submit","submit_1601957260366","9999","0","","","0");

INSERT IGNORE INTO `wpxd_nf3_field_meta` VALUES 
("253","5","editActive","","editActive",""),
("254","5","order","999","order","999"),
("255","5","type","firstname","type","firstname"),
("256","5","label","Name","label","Name"),
("257","5","key","name_1601957169385","key","name_1601957169385"),
("258","5","label_pos","default","label_pos","default"),
("259","5","required","1","required","1"),
("260","5","default","","default",""),
("261","5","placeholder","","placeholder",""),
("262","5","container_class","","container_class",""),
("263","5","element_class","","element_class",""),
("264","5","admin_label","","admin_label",""),
("265","5","help_text","","help_text",""),
("266","5","custom_name_attribute","fname","custom_name_attribute","fname"),
("267","5","personally_identifiable","1","personally_identifiable","1"),
("268","5","value","","value",""),
("269","6","editActive","","editActive",""),
("270","6","order","999","order","999"),
("271","6","type","email","type","email"),
("272","6","label","Email","label","Email"),
("273","6","key","email_1601957160168","key","email_1601957160168"),
("274","6","label_pos","default","label_pos","default"),
("275","6","required","1","required","1"),
("276","6","default","","default",""),
("277","6","placeholder","","placeholder",""),
("278","6","container_class","","container_class",""),
("279","6","element_class","","element_class",""),
("280","6","admin_label","","admin_label",""),
("281","6","help_text","","help_text",""),
("282","6","custom_name_attribute","email","custom_name_attribute","email"),
("283","6","personally_identifiable","1","personally_identifiable","1"),
("284","6","value","","value",""),
("285","7","editActive","","editActive",""),
("286","7","order","999","order","999"),
("287","7","type","phone","type","phone"),
("288","7","label","Phone Number","label","Phone Number"),
("289","7","key","phone_number_1601957175283","key","phone_number_1601957175283"),
("290","7","label_pos","default","label_pos","default"),
("291","7","required","1","required","1"),
("292","7","default","","default",""),
("293","7","placeholder","","placeholder",""),
("294","7","container_class","","container_class",""),
("295","7","element_class","","element_class",""),
("296","7","input_limit","","input_limit",""),
("297","7","input_limit_type","characters","input_limit_type","characters"),
("298","7","input_limit_msg","Character(s) left","input_limit_msg","Character(s) left"),
("299","7","manual_key","","manual_key",""),
("300","7","admin_label","","admin_label",""),
("301","7","help_text","","help_text",""),
("302","7","mask","","mask",""),
("303","7","custom_mask","","custom_mask",""),
("304","7","custom_name_attribute","phone","custom_name_attribute","phone"),
("305","7","personally_identifiable","1","personally_identifiable","1"),
("306","7","value","","value",""),
("307","7","drawerDisabled","","drawerDisabled",""),
("308","8","editActive","","editActive",""),
("309","8","order","999","order","999"),
("310","8","type","textarea","type","textarea"),
("311","8","label","Message","label","Message"),
("312","8","key","message_1601957247397","key","message_1601957247397"),
("313","8","label_pos","default","label_pos","default"),
("314","8","required","1","required","1"),
("315","8","default","","default",""),
("316","8","placeholder","","placeholder",""),
("317","8","container_class","","container_class",""),
("318","8","element_class","","element_class",""),
("319","8","input_limit","","input_limit",""),
("320","8","input_limit_type","characters","input_limit_type","characters"),
("321","8","input_limit_msg","Character(s) left","input_limit_msg","Character(s) left"),
("322","8","manual_key","","manual_key",""),
("323","8","admin_label","","admin_label",""),
("324","8","help_text","","help_text",""),
("325","8","textarea_rte","","textarea_rte",""),
("326","8","disable_rte_mobile","","disable_rte_mobile",""),
("327","8","textarea_media","","textarea_media",""),
("328","8","value","","value",""),
("329","8","drawerDisabled","","drawerDisabled",""),
("330","9","editActive","","editActive",""),
("331","9","order","9999","order","9999"),
("332","9","type","submit","type","submit"),
("333","9","label","Submit","label","Submit"),
("334","9","processing_label","Processing","processing_label","Processing"),
("335","9","container_class","","container_class",""),
("336","9","element_class","","element_class",""),
("337","9","key","submit_1601957260366","key","submit_1601957260366");

INSERT IGNORE INTO `wpxd_nf3_forms` VALUES 
("2","Enquiry Form",NULL,"2020-10-07 11:34:13","2020-10-06 12:07:13",NULL,NULL,"Enquiry Form","above","0","1","1","0","3");

INSERT IGNORE INTO `wpxd_nf3_form_meta` VALUES 
("99","2","objectType","Form Setting","objectType","Form Setting"),
("100","2","editActive","1","editActive","1"),
("101","2","show_title","0","show_title","0"),
("102","2","allow_public_link","0","allow_public_link","0"),
("103","2","embed_form","","embed_form",""),
("104","2","clear_complete","1","clear_complete","1"),
("105","2","hide_complete","1","hide_complete","1"),
("106","2","default_label_pos","above","default_label_pos","above"),
("107","2","wrapper_class","","wrapper_class",""),
("108","2","element_class","","element_class",""),
("109","2","key","","key",""),
("110","2","add_submit","1","add_submit","1"),
("111","2","changeEmailErrorMsg","","changeEmailErrorMsg",""),
("112","2","changeDateErrorMsg","","changeDateErrorMsg",""),
("113","2","confirmFieldErrorMsg","","confirmFieldErrorMsg",""),
("114","2","fieldNumberNumMinError","","fieldNumberNumMinError",""),
("115","2","fieldNumberNumMaxError","","fieldNumberNumMaxError",""),
("116","2","fieldNumberIncrementBy","","fieldNumberIncrementBy",""),
("117","2","formErrorsCorrectErrors","","formErrorsCorrectErrors",""),
("118","2","validateRequiredField","","validateRequiredField",""),
("119","2","honeypotHoneypotError","","honeypotHoneypotError",""),
("120","2","fieldsMarkedRequired","","fieldsMarkedRequired",""),
("121","2","currency","","currency",""),
("122","2","unique_field_error","A form with this value has already been submitted.","unique_field_error","A form with this value has already been submitted."),
("123","2","logged_in","","logged_in",""),
("124","2","not_logged_in_msg","","not_logged_in_msg",""),
("125","2","sub_limit_msg","The form has reached its submission limit.","sub_limit_msg","The form has reached its submission limit."),
("126","2","calculations","a:0:{}","calculations","a:0:{}"),
("127","2","formContentData","a:5:{i:0;s:18:\"name_1601957169385\";i:1;s:19:\"email_1601957160168\";i:2;s:26:\"phone_number_1601957175283\";i:3;s:21:\"message_1601957247397\";i:4;s:20:\"submit_1601957260366\";}","formContentData","a:5:{i:0;s:18:\"name_1601957169385\";i:1;s:19:\"email_1601957160168\";i:2;s:26:\"phone_number_1601957175283\";i:3;s:21:\"message_1601957247397\";i:4;s:20:\"submit_1601957260366\";}"),
("128","2","drawerDisabled","","drawerDisabled",""),
("129","2","_seq_num","3","_seq_num","3");

INSERT IGNORE INTO `wpxd_nf3_upgrades` VALUES 
("2","a:7:{s:2:\"id\";i:2;s:20:\"show_publish_options\";b:0;s:6:\"fields\";a:5:{i:0;a:2:{s:8:\"settings\";a:18:{s:10:\"objectType\";s:5:\"Field\";s:12:\"objectDomain\";s:6:\"fields\";s:10:\"editActive\";b:0;s:5:\"order\";i:999;s:4:\"type\";s:9:\"firstname\";s:5:\"label\";s:4:\"Name\";s:3:\"key\";s:18:\"name_1601957169385\";s:9:\"label_pos\";s:7:\"default\";s:8:\"required\";i:1;s:7:\"default\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:15:\"container_class\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:11:\"admin_label\";s:0:\"\";s:9:\"help_text\";s:0:\"\";s:21:\"custom_name_attribute\";s:5:\"fname\";s:23:\"personally_identifiable\";s:1:\"1\";s:5:\"value\";s:0:\"\";}s:2:\"id\";s:1:\"5\";}i:1;a:2:{s:8:\"settings\";a:18:{s:10:\"objectType\";s:5:\"Field\";s:12:\"objectDomain\";s:6:\"fields\";s:10:\"editActive\";b:0;s:5:\"order\";i:999;s:4:\"type\";s:5:\"email\";s:5:\"label\";s:5:\"Email\";s:3:\"key\";s:19:\"email_1601957160168\";s:9:\"label_pos\";s:7:\"default\";s:8:\"required\";i:1;s:7:\"default\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:15:\"container_class\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:11:\"admin_label\";s:0:\"\";s:9:\"help_text\";s:0:\"\";s:21:\"custom_name_attribute\";s:5:\"email\";s:23:\"personally_identifiable\";s:1:\"1\";s:5:\"value\";s:0:\"\";}s:2:\"id\";s:1:\"6\";}i:2;a:2:{s:8:\"settings\";a:25:{s:10:\"objectType\";s:5:\"Field\";s:12:\"objectDomain\";s:6:\"fields\";s:10:\"editActive\";b:0;s:5:\"order\";i:999;s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:12:\"Phone Number\";s:3:\"key\";s:26:\"phone_number_1601957175283\";s:9:\"label_pos\";s:7:\"default\";s:8:\"required\";i:1;s:7:\"default\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:15:\"container_class\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:11:\"input_limit\";s:0:\"\";s:16:\"input_limit_type\";s:10:\"characters\";s:15:\"input_limit_msg\";s:17:\"Character(s) left\";s:10:\"manual_key\";b:0;s:11:\"admin_label\";s:0:\"\";s:9:\"help_text\";s:0:\"\";s:4:\"mask\";s:0:\"\";s:11:\"custom_mask\";s:0:\"\";s:21:\"custom_name_attribute\";s:5:\"phone\";s:23:\"personally_identifiable\";s:1:\"1\";s:5:\"value\";s:0:\"\";s:14:\"drawerDisabled\";b:0;}s:2:\"id\";s:1:\"7\";}i:3;a:2:{s:8:\"settings\";a:24:{s:10:\"objectType\";s:5:\"Field\";s:12:\"objectDomain\";s:6:\"fields\";s:10:\"editActive\";b:0;s:5:\"order\";i:999;s:4:\"type\";s:8:\"textarea\";s:5:\"label\";s:7:\"Message\";s:3:\"key\";s:21:\"message_1601957247397\";s:9:\"label_pos\";s:7:\"default\";s:8:\"required\";i:1;s:7:\"default\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:15:\"container_class\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:11:\"input_limit\";s:0:\"\";s:16:\"input_limit_type\";s:10:\"characters\";s:15:\"input_limit_msg\";s:17:\"Character(s) left\";s:10:\"manual_key\";b:0;s:11:\"admin_label\";s:0:\"\";s:9:\"help_text\";s:0:\"\";s:12:\"textarea_rte\";s:0:\"\";s:18:\"disable_rte_mobile\";s:0:\"\";s:14:\"textarea_media\";s:0:\"\";s:5:\"value\";s:0:\"\";s:14:\"drawerDisabled\";b:0;}s:2:\"id\";s:1:\"8\";}i:4;a:2:{s:8:\"settings\";a:10:{s:10:\"objectType\";s:5:\"Field\";s:12:\"objectDomain\";s:6:\"fields\";s:10:\"editActive\";b:0;s:5:\"order\";i:9999;s:4:\"type\";s:6:\"submit\";s:5:\"label\";s:6:\"Submit\";s:16:\"processing_label\";s:10:\"Processing\";s:15:\"container_class\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:3:\"key\";s:20:\"submit_1601957260366\";}s:2:\"id\";s:1:\"9\";}}s:7:\"actions\";a:3:{i:0;a:2:{s:8:\"settings\";a:20:{s:10:\"objectType\";s:6:\"Action\";s:12:\"objectDomain\";s:7:\"actions\";s:10:\"editActive\";b:0;s:4:\"type\";s:14:\"successmessage\";s:6:\"active\";s:1:\"1\";s:10:\"created_at\";s:19:\"2020-10-06 12:07:13\";s:5:\"label\";s:15:\"Success Message\";s:7:\"message\";s:42:\"Your form has been successfully submitted.\";s:5:\"order\";s:1:\"1\";s:2:\"to\";s:16:\"{wp:admin_email}\";s:8:\"reply_to\";s:0:\"\";s:13:\"email_subject\";s:22:\"Ninja Forms Submission\";s:13:\"email_message\";s:14:\"{fields_table}\";s:19:\"email_message_plain\";s:0:\"\";s:9:\"from_name\";s:0:\"\";s:12:\"from_address\";s:0:\"\";s:12:\"email_format\";s:4:\"html\";s:2:\"cc\";s:0:\"\";s:3:\"bcc\";s:0:\"\";s:11:\"success_msg\";s:42:\"Your form has been successfully submitted.\";}s:2:\"id\";i:5;}i:1;a:2:{s:8:\"settings\";a:19:{s:10:\"objectType\";s:6:\"Action\";s:12:\"objectDomain\";s:7:\"actions\";s:10:\"editActive\";b:0;s:4:\"type\";s:5:\"email\";s:6:\"active\";s:1:\"1\";s:10:\"created_at\";s:19:\"2020-10-06 12:07:13\";s:5:\"label\";s:11:\"Admin Email\";s:5:\"order\";s:1:\"2\";s:2:\"to\";s:25:\"info@mercifulwaygroup.com\";s:8:\"reply_to\";s:27:\"{field:email_1601957160168}\";s:13:\"email_subject\";s:38:\"Enquiry Form from Mercifulwaygroup.com\";s:13:\"email_message\";s:193:\"<p>Name:&nbsp;{field:name_1601957169385}</p><p>Email:&nbsp;{field:email_1601957160168}</p><p>Phone:&nbsp;{field:phone_number_1601957175283}</p><p>Message:&nbsp;{field:message_1601957247397}</p>\";s:19:\"email_message_plain\";s:0:\"\";s:9:\"from_name\";s:0:\"\";s:12:\"from_address\";s:0:\"\";s:12:\"email_format\";s:4:\"html\";s:2:\"cc\";s:0:\"\";s:3:\"bcc\";s:0:\"\";s:14:\"drawerDisabled\";b:0;}s:2:\"id\";i:6;}i:2;a:2:{s:8:\"settings\";a:25:{s:10:\"objectType\";s:6:\"Action\";s:12:\"objectDomain\";s:7:\"actions\";s:10:\"editActive\";b:0;s:4:\"type\";s:4:\"save\";s:6:\"active\";s:1:\"1\";s:10:\"created_at\";s:19:\"2020-10-06 12:07:13\";s:5:\"label\";s:16:\"Store Submission\";s:5:\"order\";s:1:\"3\";s:2:\"to\";s:16:\"{wp:admin_email}\";s:8:\"reply_to\";s:0:\"\";s:13:\"email_subject\";s:22:\"Ninja Forms Submission\";s:13:\"email_message\";s:14:\"{fields_table}\";s:19:\"email_message_plain\";s:0:\"\";s:9:\"from_name\";s:0:\"\";s:12:\"from_address\";s:0:\"\";s:12:\"email_format\";s:4:\"html\";s:2:\"cc\";s:0:\"\";s:3:\"bcc\";s:0:\"\";s:11:\"success_msg\";s:42:\"Your form has been successfully submitted.\";s:12:\"redirect_url\";s:0:\"\";s:15:\"submitter_email\";s:19:\"email_1601957160168\";s:18:\"fields-save-toggle\";s:8:\"save_all\";s:16:\"exception_fields\";a:0:{}s:18:\"set_subs_to_expire\";s:1:\"0\";s:16:\"subs_expire_time\";s:2:\"90\";}s:2:\"id\";i:7;}}s:8:\"settings\";a:31:{s:10:\"objectType\";s:12:\"Form Setting\";s:10:\"editActive\";b:1;s:5:\"title\";s:12:\"Enquiry Form\";s:10:\"show_title\";i:0;s:17:\"allow_public_link\";i:0;s:10:\"embed_form\";s:0:\"\";s:14:\"clear_complete\";i:1;s:13:\"hide_complete\";i:1;s:17:\"default_label_pos\";s:5:\"above\";s:13:\"wrapper_class\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:3:\"key\";s:0:\"\";s:10:\"add_submit\";i:1;s:19:\"changeEmailErrorMsg\";s:0:\"\";s:18:\"changeDateErrorMsg\";s:0:\"\";s:20:\"confirmFieldErrorMsg\";s:0:\"\";s:22:\"fieldNumberNumMinError\";s:0:\"\";s:22:\"fieldNumberNumMaxError\";s:0:\"\";s:22:\"fieldNumberIncrementBy\";s:0:\"\";s:23:\"formErrorsCorrectErrors\";s:0:\"\";s:21:\"validateRequiredField\";s:0:\"\";s:21:\"honeypotHoneypotError\";s:0:\"\";s:20:\"fieldsMarkedRequired\";s:0:\"\";s:8:\"currency\";s:0:\"\";s:18:\"unique_field_error\";s:50:\"A form with this value has already been submitted.\";s:9:\"logged_in\";b:0;s:17:\"not_logged_in_msg\";s:0:\"\";s:13:\"sub_limit_msg\";s:42:\"The form has reached its submission limit.\";s:12:\"calculations\";a:0:{}s:15:\"formContentData\";a:5:{i:0;s:18:\"name_1601957169385\";i:1;s:19:\"email_1601957160168\";i:2;s:26:\"phone_number_1601957175283\";i:3;s:21:\"message_1601957247397\";i:4;s:20:\"submit_1601957260366\";}s:14:\"drawerDisabled\";b:0;}s:14:\"deleted_fields\";a:0:{}s:15:\"deleted_actions\";a:0:{}}","4","0");

INSERT IGNORE INTO `wpxd_options` VALUES 
("1","siteurl","https://www.mercifulwaygroup.com/cms","yes"),
("2","home","https://www.mercifulwaygroup.com/cms","yes"),
("3","blogname","Merciful Way Group","yes"),
("4","blogdescription","","yes"),
("5","users_can_register","0","yes"),
("6","admin_email","deoworkz@gmail.com","yes"),
("7","start_of_week","1","yes"),
("8","use_balanceTags","0","yes"),
("9","use_smilies","1","yes"),
("10","require_name_email","","yes"),
("11","comments_notify","","yes"),
("12","posts_per_rss","10","yes"),
("13","rss_use_excerpt","0","yes"),
("14","mailserver_url","mail.example.com","yes"),
("15","mailserver_login","login@example.com","yes"),
("16","mailserver_pass","password","yes"),
("17","mailserver_port","110","yes"),
("18","default_category","1","yes"),
("19","default_comment_status","","yes"),
("20","default_ping_status","","yes"),
("21","default_pingback_flag","","yes"),
("22","posts_per_page","10","yes"),
("23","date_format","F j, Y","yes"),
("24","time_format","g:i a","yes"),
("25","links_updated_date_format","F j, Y g:i a","yes"),
("26","comment_moderation","","yes"),
("27","moderation_notify","","yes"),
("28","permalink_structure","/%postname%/","yes"),
("29","rewrite_rules","a:300:{s:29:\"^ninja-forms/([a-zA-Z0-9]+)/?\";s:36:\"index.php?nf_public_link=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:18:\"portfolio-items/?$\";s:35:\"index.php?post_type=avada_portfolio\";s:48:\"portfolio-items/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=avada_portfolio&feed=$matches[1]\";s:43:\"portfolio-items/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=avada_portfolio&feed=$matches[1]\";s:35:\"portfolio-items/page/([0-9]{1,})/?$\";s:53:\"index.php?post_type=avada_portfolio&paged=$matches[1]\";s:12:\"faq-items/?$\";s:29:\"index.php?post_type=avada_faq\";s:42:\"faq-items/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=avada_faq&feed=$matches[1]\";s:37:\"faq-items/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=avada_faq&feed=$matches[1]\";s:29:\"faq-items/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=avada_faq&paged=$matches[1]\";s:44:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"fusion_tb_layout/([^/]+)/embed/?$\";s:49:\"index.php?fusion_tb_layout=$matches[1]&embed=true\";s:37:\"fusion_tb_layout/([^/]+)/trackback/?$\";s:43:\"index.php?fusion_tb_layout=$matches[1]&tb=1\";s:45:\"fusion_tb_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?fusion_tb_layout=$matches[1]&paged=$matches[2]\";s:52:\"fusion_tb_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?fusion_tb_layout=$matches[1]&cpage=$matches[2]\";s:41:\"fusion_tb_layout/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?fusion_tb_layout=$matches[1]&page=$matches[2]\";s:33:\"fusion_tb_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"fusion_tb_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"fusion_tb_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"fusion_tb_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"fusion_tb_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"fusion_tb_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"fusion_tb_section/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"fusion_tb_section/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"fusion_tb_section/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"fusion_tb_section/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"fusion_tb_section/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"fusion_tb_section/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"fusion_tb_section/([^/]+)/embed/?$\";s:50:\"index.php?fusion_tb_section=$matches[1]&embed=true\";s:38:\"fusion_tb_section/([^/]+)/trackback/?$\";s:44:\"index.php?fusion_tb_section=$matches[1]&tb=1\";s:46:\"fusion_tb_section/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?fusion_tb_section=$matches[1]&paged=$matches[2]\";s:53:\"fusion_tb_section/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?fusion_tb_section=$matches[1]&cpage=$matches[2]\";s:42:\"fusion_tb_section/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?fusion_tb_section=$matches[1]&page=$matches[2]\";s:34:\"fusion_tb_section/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"fusion_tb_section/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"fusion_tb_section/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"fusion_tb_section/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"fusion_tb_section/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"fusion_tb_section/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"fusion_tb_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:71:\"index.php?taxonomy=fusion_tb_category&term=$matches[1]&feed=$matches[2]\";s:54:\"fusion_tb_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:71:\"index.php?taxonomy=fusion_tb_category&term=$matches[1]&feed=$matches[2]\";s:35:\"fusion_tb_category/([^/]+)/embed/?$\";s:65:\"index.php?taxonomy=fusion_tb_category&term=$matches[1]&embed=true\";s:47:\"fusion_tb_category/([^/]+)/page/?([0-9]{1,})/?$\";s:72:\"index.php?taxonomy=fusion_tb_category&term=$matches[1]&paged=$matches[2]\";s:29:\"fusion_tb_category/([^/]+)/?$\";s:54:\"index.php?taxonomy=fusion_tb_category&term=$matches[1]\";s:39:\"fusion_form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"fusion_form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"fusion_form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"fusion_form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"fusion_form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"fusion_form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"fusion_form/([^/]+)/embed/?$\";s:44:\"index.php?fusion_form=$matches[1]&embed=true\";s:32:\"fusion_form/([^/]+)/trackback/?$\";s:38:\"index.php?fusion_form=$matches[1]&tb=1\";s:40:\"fusion_form/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?fusion_form=$matches[1]&paged=$matches[2]\";s:47:\"fusion_form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?fusion_form=$matches[1]&cpage=$matches[2]\";s:36:\"fusion_form/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?fusion_form=$matches[1]&page=$matches[2]\";s:28:\"fusion_form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"fusion_form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"fusion_form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"fusion_form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"fusion_form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"fusion_form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:34:\"nf_sub/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"nf_sub/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"nf_sub/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"nf_sub/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"nf_sub/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"nf_sub/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"nf_sub/([^/]+)/embed/?$\";s:39:\"index.php?nf_sub=$matches[1]&embed=true\";s:27:\"nf_sub/([^/]+)/trackback/?$\";s:33:\"index.php?nf_sub=$matches[1]&tb=1\";s:35:\"nf_sub/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?nf_sub=$matches[1]&paged=$matches[2]\";s:42:\"nf_sub/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?nf_sub=$matches[1]&cpage=$matches[2]\";s:31:\"nf_sub/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?nf_sub=$matches[1]&page=$matches[2]\";s:23:\"nf_sub/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"nf_sub/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"nf_sub/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"nf_sub/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"nf_sub/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"nf_sub/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"portfolio-items/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"portfolio-items/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"portfolio-items/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"portfolio-items/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"portfolio-items/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"portfolio-items/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"portfolio-items/([^/]+)/embed/?$\";s:48:\"index.php?avada_portfolio=$matches[1]&embed=true\";s:36:\"portfolio-items/([^/]+)/trackback/?$\";s:42:\"index.php?avada_portfolio=$matches[1]&tb=1\";s:56:\"portfolio-items/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?avada_portfolio=$matches[1]&feed=$matches[2]\";s:51:\"portfolio-items/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?avada_portfolio=$matches[1]&feed=$matches[2]\";s:44:\"portfolio-items/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?avada_portfolio=$matches[1]&paged=$matches[2]\";s:51:\"portfolio-items/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?avada_portfolio=$matches[1]&cpage=$matches[2]\";s:40:\"portfolio-items/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?avada_portfolio=$matches[1]&page=$matches[2]\";s:32:\"portfolio-items/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"portfolio-items/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"portfolio-items/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"portfolio-items/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"portfolio-items/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"portfolio-items/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:35:\"portfolio_category/([^/]+)/embed/?$\";s:51:\"index.php?portfolio_category=$matches[1]&embed=true\";s:47:\"portfolio_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio_category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio_category/([^/]+)/?$\";s:40:\"index.php?portfolio_category=$matches[1]\";s:57:\"portfolio_skills/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?portfolio_skills=$matches[1]&feed=$matches[2]\";s:52:\"portfolio_skills/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?portfolio_skills=$matches[1]&feed=$matches[2]\";s:33:\"portfolio_skills/([^/]+)/embed/?$\";s:49:\"index.php?portfolio_skills=$matches[1]&embed=true\";s:45:\"portfolio_skills/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?portfolio_skills=$matches[1]&paged=$matches[2]\";s:27:\"portfolio_skills/([^/]+)/?$\";s:38:\"index.php?portfolio_skills=$matches[1]\";s:55:\"portfolio_tags/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\";s:50:\"portfolio_tags/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\";s:31:\"portfolio_tags/([^/]+)/embed/?$\";s:47:\"index.php?portfolio_tags=$matches[1]&embed=true\";s:43:\"portfolio_tags/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?portfolio_tags=$matches[1]&paged=$matches[2]\";s:25:\"portfolio_tags/([^/]+)/?$\";s:36:\"index.php?portfolio_tags=$matches[1]\";s:37:\"faq-items/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"faq-items/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"faq-items/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"faq-items/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"faq-items/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"faq-items/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"faq-items/([^/]+)/embed/?$\";s:42:\"index.php?avada_faq=$matches[1]&embed=true\";s:30:\"faq-items/([^/]+)/trackback/?$\";s:36:\"index.php?avada_faq=$matches[1]&tb=1\";s:50:\"faq-items/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?avada_faq=$matches[1]&feed=$matches[2]\";s:45:\"faq-items/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?avada_faq=$matches[1]&feed=$matches[2]\";s:38:\"faq-items/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?avada_faq=$matches[1]&paged=$matches[2]\";s:45:\"faq-items/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?avada_faq=$matches[1]&cpage=$matches[2]\";s:34:\"faq-items/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?avada_faq=$matches[1]&page=$matches[2]\";s:26:\"faq-items/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"faq-items/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"faq-items/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"faq-items/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"faq-items/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"faq-items/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"faq_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?faq_category=$matches[1]&feed=$matches[2]\";s:48:\"faq_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?faq_category=$matches[1]&feed=$matches[2]\";s:29:\"faq_category/([^/]+)/embed/?$\";s:45:\"index.php?faq_category=$matches[1]&embed=true\";s:41:\"faq_category/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?faq_category=$matches[1]&paged=$matches[2]\";s:23:\"faq_category/([^/]+)/?$\";s:34:\"index.php?faq_category=$matches[1]\";s:33:\"slide/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"slide/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"slide/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"slide/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"slide/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"slide/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"slide/([^/]+)/embed/?$\";s:38:\"index.php?slide=$matches[1]&embed=true\";s:26:\"slide/([^/]+)/trackback/?$\";s:32:\"index.php?slide=$matches[1]&tb=1\";s:34:\"slide/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?slide=$matches[1]&paged=$matches[2]\";s:41:\"slide/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?slide=$matches[1]&cpage=$matches[2]\";s:30:\"slide/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?slide=$matches[1]&page=$matches[2]\";s:22:\"slide/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"slide/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"slide/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"slide/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"slide/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"slide/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:51:\"slide-page/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?taxonomy=slide-page&term=$matches[1]&feed=$matches[2]\";s:46:\"slide-page/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?taxonomy=slide-page&term=$matches[1]&feed=$matches[2]\";s:27:\"slide-page/([^/]+)/embed/?$\";s:57:\"index.php?taxonomy=slide-page&term=$matches[1]&embed=true\";s:39:\"slide-page/([^/]+)/page/?([0-9]{1,})/?$\";s:64:\"index.php?taxonomy=slide-page&term=$matches[1]&paged=$matches[2]\";s:21:\"slide-page/([^/]+)/?$\";s:46:\"index.php?taxonomy=slide-page&term=$matches[1]\";s:43:\"fusion_template/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"fusion_template/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"fusion_template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"fusion_template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"fusion_template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"fusion_template/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"fusion_template/([^/]+)/embed/?$\";s:48:\"index.php?fusion_template=$matches[1]&embed=true\";s:36:\"fusion_template/([^/]+)/trackback/?$\";s:42:\"index.php?fusion_template=$matches[1]&tb=1\";s:44:\"fusion_template/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?fusion_template=$matches[1]&paged=$matches[2]\";s:51:\"fusion_template/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?fusion_template=$matches[1]&cpage=$matches[2]\";s:40:\"fusion_template/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?fusion_template=$matches[1]&page=$matches[2]\";s:32:\"fusion_template/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"fusion_template/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"fusion_template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"fusion_template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"fusion_template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"fusion_template/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"fusion_element/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"fusion_element/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"fusion_element/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"fusion_element/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"fusion_element/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"fusion_element/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"fusion_element/([^/]+)/embed/?$\";s:47:\"index.php?fusion_element=$matches[1]&embed=true\";s:35:\"fusion_element/([^/]+)/trackback/?$\";s:41:\"index.php?fusion_element=$matches[1]&tb=1\";s:43:\"fusion_element/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?fusion_element=$matches[1]&paged=$matches[2]\";s:50:\"fusion_element/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?fusion_element=$matches[1]&cpage=$matches[2]\";s:39:\"fusion_element/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?fusion_element=$matches[1]&page=$matches[2]\";s:31:\"fusion_element/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"fusion_element/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"fusion_element/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"fusion_element/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"fusion_element/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"fusion_element/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"element_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?taxonomy=element_category&term=$matches[1]&feed=$matches[2]\";s:52:\"element_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?taxonomy=element_category&term=$matches[1]&feed=$matches[2]\";s:33:\"element_category/([^/]+)/embed/?$\";s:63:\"index.php?taxonomy=element_category&term=$matches[1]&embed=true\";s:45:\"element_category/([^/]+)/page/?([0-9]{1,})/?$\";s:70:\"index.php?taxonomy=element_category&term=$matches[1]&paged=$matches[2]\";s:27:\"element_category/([^/]+)/?$\";s:52:\"index.php?taxonomy=element_category&term=$matches[1]\";s:58:\"template_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:70:\"index.php?taxonomy=template_category&term=$matches[1]&feed=$matches[2]\";s:53:\"template_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:70:\"index.php?taxonomy=template_category&term=$matches[1]&feed=$matches[2]\";s:34:\"template_category/([^/]+)/embed/?$\";s:64:\"index.php?taxonomy=template_category&term=$matches[1]&embed=true\";s:46:\"template_category/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?taxonomy=template_category&term=$matches[1]&paged=$matches[2]\";s:28:\"template_category/([^/]+)/?$\";s:53:\"index.php?taxonomy=template_category&term=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=8&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","yes"),
("30","hack_file","0","yes"),
("31","blog_charset","UTF-8","yes"),
("32","moderation_keys","","no"),
("33","active_plugins","a:15:{i:0;s:27:\"LayerSlider/layerslider.php\";i:1;s:33:\"classic-editor/classic-editor.php\";i:2;s:39:\"custom-login-logo/custom-login-logo.php\";i:3;s:33:\"duplicator-pro/duplicator-pro.php\";i:4;s:44:\"facebook-pagelike-widget/facebook_widget.php\";i:5;s:33:\"fusion-builder/fusion-builder.php\";i:6;s:27:\"fusion-core/fusion-core.php\";i:7;s:39:\"heartbeat-control/heartbeat-control.php\";i:8;s:35:\"insert-headers-and-footers/ihaf.php\";i:9;s:27:\"ninja-forms/ninja-forms.php\";i:10;s:37:\"tinymce-advanced/tinymce-advanced.php\";i:11;s:23:\"wordfence/wordfence.php\";i:12;s:29:\"wp-dbmanager/wp-dbmanager.php\";i:13;s:35:\"wp-fastest-cache/wpFastestCache.php\";i:14;s:29:\"wp-mail-smtp/wp_mail_smtp.php\";}","yes"),
("34","category_base","","yes"),
("35","ping_sites","http://rpc.pingomatic.com/","yes"),
("36","comment_max_links","2","yes"),
("37","gmt_offset","8","yes"),
("38","default_email_category","1","yes"),
("39","recently_edited","","no"),
("40","template","Avada","yes"),
("41","stylesheet","Avada","yes"),
("42","comment_registration","","yes"),
("43","html_type","text/html","yes"),
("44","use_trackback","0","yes"),
("45","default_role","subscriber","yes"),
("46","db_version","53496","yes"),
("47","uploads_use_yearmonth_folders","1","yes"),
("48","upload_path","","yes"),
("49","blog_public","1","yes"),
("50","default_link_category","2","yes"),
("51","show_on_front","page","yes"),
("52","tag_base","","yes"),
("53","show_avatars","","yes"),
("54","avatar_rating","G","yes"),
("55","upload_url_path","","yes"),
("56","thumbnail_size_w","150","yes"),
("57","thumbnail_size_h","150","yes"),
("58","thumbnail_crop","1","yes"),
("59","medium_size_w","300","yes"),
("60","medium_size_h","300","yes"),
("61","avatar_default","mystery","yes"),
("62","large_size_w","1024","yes"),
("63","large_size_h","1024","yes"),
("64","image_default_link_type","none","yes"),
("65","image_default_size","","yes"),
("66","image_default_align","","yes"),
("67","close_comments_for_old_posts","","yes"),
("68","close_comments_days_old","14","yes"),
("69","thread_comments","","yes"),
("70","thread_comments_depth","5","yes"),
("71","page_comments","","yes"),
("72","comments_per_page","50","yes"),
("73","default_comments_page","newest","yes"),
("74","comment_order","asc","yes"),
("75","sticky_posts","a:0:{}","yes"),
("76","widget_categories","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("77","widget_text","a:3:{i:2;a:15:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:319:\"<img class=\"alignnone size-full wp-image-19\" src=\"https://www.mercifulwaygroup.com/cms/cms/images/files/2020/10/logo-white.png\" alt=\"\" width=\"240\" height=\"140\" />\r\n\r\nWe are experienced in providing full service in general goods trading, sourcing &amp; supplying premium quality gifts to our valued customers nationwide.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:20:\"fusion_display_title\";s:3:\"yes\";s:20:\"fusion_padding_color\";s:0:\"\";s:13:\"fusion_margin\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:5:\"solid\";s:19:\"fusion_border_color\";s:0:\"\";s:20:\"fusion_divider_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}i:3;a:15:{s:5:\"title\";s:7:\"CONTACT\";s:4:\"text\";s:367:\"<i class=\"fas fa-map-marker-alt\" style=\"font-size: 16px;\"></i> No 19, Tingkat 1, Jalan Perniagaan Gemilang 1, Pusat Perniagaan Gemilng, 14000 Bukit Mertajam, Penang.\r\n\r\n<i class=\"fa fa-phone\" style=\"font-size: 16px;\"></i> +604 548 9552\r\n\r\n<i class=\"fa fa-envelope\" style=\"font-size: 16px;\"></i> <a href=\"mailto:info@mercifulwaygroup.com\">info@mercifulwaygroup.com</a>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:20:\"fusion_display_title\";s:3:\"yes\";s:20:\"fusion_padding_color\";s:0:\"\";s:13:\"fusion_margin\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:5:\"solid\";s:19:\"fusion_border_color\";s:0:\"\";s:20:\"fusion_divider_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("78","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("79","uninstall_plugins","a:3:{s:27:\"LayerSlider/layerslider.php\";s:29:\"layerslider_uninstall_scripts\";s:41:\"better-wp-security/better-wp-security.php\";a:2:{i:0;s:10:\"ITSEC_Core\";i:1;s:16:\"handle_uninstall\";}s:27:\"ninja-forms/ninja-forms.php\";s:21:\"ninja_forms_uninstall\";}","no"),
("80","timezone_string","","yes"),
("81","page_for_posts","11","yes"),
("82","page_on_front","8","yes"),
("83","default_post_format","0","yes"),
("84","link_manager_enabled","0","yes"),
("85","finished_splitting_shared_terms","1","yes"),
("86","site_icon","64","yes"),
("87","medium_large_size_w","768","yes"),
("88","medium_large_size_h","0","yes"),
("89","wp_page_for_privacy_policy","3","yes"),
("90","show_comments_cookies_opt_in","","yes"),
("91","admin_email_lifespan","1686705001","yes"),
("92","disallowed_keys","","no"),
("93","comment_previously_approved","","yes"),
("94","auto_plugin_theme_update_emails","a:0:{}","no"),
("95","initial_db_version","48748","yes"),
("96","wpxd_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:75:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:20:\"wpcode_edit_snippets\";b:1;s:24:\"wpcode_activate_snippets\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes"),
("97","fresh_site","0","yes"),
("98","widget_search","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("99","widget_recent-posts","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes"),
("100","widget_recent-comments","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes"),
("101","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("102","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("103","sidebars_widgets","a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:18:\"avada-blog-sidebar\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:21:\"avada-footer-widget-1\";a:1:{i:0;s:6:\"text-2\";}s:21:\"avada-footer-widget-2\";a:1:{i:0;s:10:\"nav_menu-2\";}s:21:\"avada-footer-widget-3\";a:1:{i:0;s:6:\"text-3\";}s:21:\"avada-footer-widget-4\";a:1:{i:0;s:8:\"fbw_id-2\";}s:25:\"avada-slidingbar-widget-1\";a:0:{}s:25:\"avada-slidingbar-widget-2\";a:0:{}s:13:\"array_version\";i:3;}","yes"),
("104","cron","a:25:{i:1671861521;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1671861566;a:1:{s:35:\"wordfence_batchReportFailedAttempts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1671861581;a:1:{s:40:\"wordfence_completeCoreUpdateNotification\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1671863847;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1671866018;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1671874048;a:1:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1671903447;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1671923147;a:1:{s:27:\"wordfence_processAttackData\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1671926400;a:1:{s:22:\"wdev_logger_clear_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1671940629;a:1:{s:36:\"wordfence_batchReportBlockedAttempts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1671946646;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1671946661;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1671946663;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1672142717;a:1:{s:26:\"nf_weekly_promotion_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:9:\"nf-weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1672142841;a:1:{s:22:\"nf_marketing_feed_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:9:\"nf-weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1672205846;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1674302841;a:1:{s:13:\"nf_optin_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"nf-monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2678400;}}}i:1686137345;a:1:{s:23:\"wordfence_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1686139594;a:1:{s:35:\"wordfence_refreshUpdateNotification\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1686141464;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1686141469;a:2:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1686280710;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1686556800;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1686943564;a:1:{s:26:\"wpcode_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","yes"),
("105","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("106","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("107","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("108","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("109","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("110","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("111","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("112","widget_nav_menu","a:2:{i:2;a:13:{s:5:\"title\";s:8:\"DISCOVER\";s:8:\"nav_menu\";i:2;s:20:\"fusion_display_title\";s:3:\"yes\";s:20:\"fusion_padding_color\";s:0:\"\";s:13:\"fusion_margin\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:5:\"solid\";s:19:\"fusion_border_color\";s:0:\"\";s:20:\"fusion_divider_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("113","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("115","theme_mods_twentytwenty","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1601897992;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}","yes"),
("116","recovery_keys","a:1:{s:22:\"yGVJUHXXMfOXMwqPJj7DXu\";a:2:{s:10:\"hashed_key\";s:34:\"$P$BTQlHDpx5x9/Hu1UcWaI1SAzysDx/V/\";s:10:\"created_at\";i:1686137118;}}","yes"),
("141","recently_activated","a:1:{s:23:\"wp-smushit/wp-smush.php\";i:1686141527;}","yes"),
("144","finished_updating_comment_type","1","yes"),
("176","WPLANG","","yes"),
("186","current_theme","Avada","yes"),
("187","theme_mods_Avada","a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:15:\"main_navigation\";i:2;}s:18:\"custom_css_post_id\";i:-1;}","yes"),
("188","theme_switched","","yes"),
("189","avada_version","7.10.1","yes"),
("196","shop_catalog_image_size","a:3:{s:5:\"width\";i:500;s:6:\"height\";s:0:\"\";i:0;i:0;}","yes"),
("197","shop_single_image_size","a:3:{s:5:\"width\";i:700;s:6:\"height\";s:0:\"\";i:0;i:0;}","yes"),
("198","shop_thumbnail_image_size","a:3:{s:5:\"width\";i:120;s:6:\"height\";s:0:\"\";i:0;i:0;}","yes"),
("199","woocommerce_single_image_width","700","yes"),
("200","woocommerce_thumbnail_image_width","500","yes"),
("201","woocommerce_thumbnail_cropping","uncropped","yes"),
("202","fusion_dynamic_css_posts","a:5:{s:6:\"global\";b:1;i:8;b:1;i:12;b:1;i:10;b:1;i:9;b:1;}","yes"),
("203","fusion_dynamic_css_ids","a:5:{s:6:\"global\";s:32:\"d64e4d1777459b552a7edaf9a5f51b1e\";i:8;s:32:\"a37fd7b2d8de06bd8f56824338dfc106\";i:12;s:32:\"19315e8a58119069f7d0f5c9f1c176af\";i:10;s:32:\"c7a5abd4ca29340e4c94aaa95d7d3642\";i:9;s:32:\"19315e8a58119069f7d0f5c9f1c176af\";}","yes"),
("205","revslider-valid-notice","false","yes"),
("217","fusion_applied_patches","a:10:{i:0;i:418102;i:1;i:418111;i:2;i:418109;i:3;i:418534;i:4;i:418537;i:5;i:418539;i:6;i:418540;i:7;i:420688;i:8;i:420731;i:9;i:420819;}","no"),
("266","fusion_options","a:1033:{s:8:\"last_tab\";s:0:\"\";s:6:\"layout\";s:4:\"wide\";s:10:\"site_width\";s:6:\"1200px\";s:13:\"margin_offset\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";}s:13:\"scroll_offset\";s:4:\"full\";s:18:\"boxed_modal_shadow\";s:0:\"\";s:12:\"main_padding\";a:2:{s:3:\"top\";s:4:\"60px\";s:6:\"bottom\";s:4:\"60px\";}s:13:\"page_template\";s:9:\"100_width\";s:16:\"hundredp_padding\";s:4:\"30px\";s:13:\"sidebar_width\";s:3:\"24%\";s:14:\"sidebar_gutter\";s:2:\"6%\";s:17:\"sidebar_2_1_width\";s:3:\"20%\";s:17:\"sidebar_2_2_width\";s:3:\"20%\";s:19:\"dual_sidebar_gutter\";s:2:\"4%\";s:10:\"responsive\";s:1:\"1\";s:21:\"grid_main_break_point\";s:4:\"1000\";s:23:\"side_header_break_point\";s:3:\"800\";s:19:\"content_break_point\";s:3:\"800\";s:19:\"sidebar_break_point\";s:3:\"800\";s:11:\"mobile_zoom\";s:1:\"1\";s:16:\"visibility_small\";s:3:\"640\";s:17:\"visibility_medium\";s:4:\"1024\";s:22:\"typography_sensitivity\";s:1:\"0\";s:17:\"typography_factor\";s:3:\"1.5\";s:13:\"color_palette\";a:17:{s:6:\"color1\";a:2:{s:5:\"label\";s:7:\"Color 1\";s:5:\"color\";s:19:\"rgba(255,255,255,1)\";}s:6:\"color2\";a:2:{s:5:\"label\";s:7:\"Color 2\";s:5:\"color\";s:19:\"rgba(249,249,251,1)\";}s:6:\"color3\";a:2:{s:5:\"label\";s:7:\"Color 3\";s:5:\"color\";s:19:\"rgba(242,243,245,1)\";}s:6:\"color4\";a:2:{s:5:\"label\";s:7:\"Color 4\";s:5:\"color\";s:19:\"rgba(226,226,226,1)\";}s:6:\"color5\";a:2:{s:5:\"label\";s:7:\"Color 5\";s:5:\"color\";s:17:\"rgba(98,187,70,1)\";}s:6:\"color6\";a:2:{s:5:\"label\";s:7:\"Color 6\";s:5:\"color\";s:19:\"rgba(101,101,101,1)\";}s:6:\"color7\";a:2:{s:5:\"label\";s:7:\"Color 7\";s:5:\"color\";s:16:\"rgba(74,78,87,1)\";}s:6:\"color8\";a:2:{s:5:\"label\";s:7:\"Color 8\";s:5:\"color\";s:16:\"rgba(33,41,52,1)\";}s:8:\"custom10\";a:2:{s:5:\"label\";s:9:\"Custom 10\";s:5:\"color\";s:19:\"rgba(101,188,123,1)\";}s:8:\"custom11\";a:2:{s:5:\"label\";s:9:\"Custom 11\";s:5:\"color\";s:14:\"rgba(0,0,90,1)\";}s:8:\"custom12\";a:2:{s:5:\"label\";s:9:\"Custom 12\";s:5:\"color\";s:16:\"rgba(51,51,51,1)\";}s:8:\"custom13\";a:2:{s:5:\"label\";s:9:\"Custom 13\";s:5:\"color\";s:21:\"rgba(255,255,255,0.8)\";}s:8:\"custom14\";a:2:{s:5:\"label\";s:9:\"Custom 14\";s:5:\"color\";s:19:\"rgba(158,160,164,1)\";}s:8:\"custom15\";a:2:{s:5:\"label\";s:9:\"Custom 15\";s:5:\"color\";s:21:\"rgba(242,243,245,0.7)\";}s:8:\"custom16\";a:2:{s:5:\"label\";s:9:\"Custom 16\";s:5:\"color\";s:21:\"rgba(255,255,255,0.6)\";}s:8:\"custom17\";a:2:{s:5:\"label\";s:9:\"Custom 17\";s:5:\"color\";s:16:\"rgba(0,43,100,1)\";}s:8:\"custom18\";a:2:{s:5:\"label\";s:9:\"Custom 18\";s:5:\"color\";s:21:\"rgba(242,243,245,0.8)\";}}s:13:\"primary_color\";s:7:\"#62bb46\";s:15:\"header_position\";s:3:\"top\";s:13:\"header_layout\";s:2:\"v4\";s:15:\"slider_position\";s:5:\"below\";s:19:\"header_left_content\";s:12:\"contact_info\";s:20:\"header_right_content\";s:12:\"social_links\";s:17:\"header_v4_content\";s:6:\"search\";s:13:\"header_number\";s:61:\"A Company on Malaysia Based Premium Corporate Gifts Supplier.\";s:12:\"header_email\";s:0:\"\";s:14:\"header_tagline\";s:19:\"Insert Tagline Here\";s:18:\"header_banner_code\";s:0:\"\";s:15:\"header_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:14:\"header_bg_full\";s:1:\"0\";s:18:\"header_bg_parallax\";s:1:\"1\";s:16:\"header_bg_repeat\";s:9:\"no-repeat\";s:17:\"side_header_width\";s:3:\"280\";s:14:\"header_padding\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:13:\"header_shadow\";s:1:\"0\";s:16:\"header_100_width\";s:1:\"0\";s:15:\"header_bg_color\";s:7:\"#ffffff\";s:23:\"archive_header_bg_color\";s:7:\"#ffffff\";s:19:\"header_border_color\";s:21:\"rgba(193,193,193,0.4)\";s:19:\"header_top_bg_color\";s:7:\"#002b64\";s:17:\"tagline_font_size\";s:4:\"16px\";s:18:\"tagline_font_color\";s:7:\"#747474\";s:13:\"header_sticky\";s:1:\"0\";s:20:\"header_sticky_tablet\";s:1:\"0\";s:20:\"header_sticky_mobile\";s:1:\"0\";s:23:\"header_sticky_shrinkage\";s:1:\"0\";s:26:\"header_sticky_type2_layout\";s:9:\"menu_only\";s:20:\"header_sticky_shadow\";s:1:\"1\";s:22:\"header_sticky_bg_color\";s:7:\"#ffffff\";s:24:\"header_sticky_menu_color\";s:7:\"#333333\";s:25:\"header_sticky_nav_padding\";s:2:\"35\";s:27:\"header_sticky_nav_font_size\";s:4:\"14px\";s:10:\"nav_height\";s:2:\"50\";s:20:\"menu_highlight_style\";s:9:\"textcolor\";s:25:\"menu_highlight_background\";s:7:\"#65bc7b\";s:15:\"menu_arrow_size\";a:2:{s:5:\"width\";s:4:\"23px\";s:6:\"height\";s:4:\"12px\";}s:20:\"nav_highlight_border\";s:1:\"3\";s:11:\"nav_padding\";s:2:\"48\";s:18:\"mobile_nav_padding\";s:2:\"25\";s:15:\"megamenu_shadow\";s:1:\"1\";s:28:\"main_menu_sub_menu_animation\";s:4:\"fade\";s:29:\"dropdown_menu_top_border_size\";s:1:\"3\";s:19:\"dropdown_menu_width\";s:3:\"200\";s:34:\"mainmenu_dropdown_vertical_padding\";s:2:\"12\";s:33:\"mainmenu_dropdown_display_divider\";s:1:\"0\";s:31:\"menu_display_dropdown_indicator\";s:4:\"none\";s:20:\"main_nav_search_icon\";s:1:\"0\";s:22:\"main_nav_search_layout\";s:7:\"overlay\";s:20:\"main_nav_icon_circle\";s:1:\"0\";s:25:\"main_nav_highlight_radius\";s:3:\"2px\";s:17:\"menu_sub_bg_color\";s:7:\"#ffffff\";s:19:\"menu_bg_hover_color\";s:7:\"#f9f9fb\";s:18:\"menu_sub_sep_color\";s:7:\"#e2e2e2\";s:17:\"menu_h45_bg_color\";s:7:\"#ffffff\";s:14:\"nav_typography\";a:8:{s:11:\"font-family\";s:7:\"Poppins\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:7:\"regular\";s:9:\"font-size\";s:4:\"16px\";s:14:\"letter-spacing\";s:1:\"0\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#3e3e3e\";}s:15:\"menu_text_align\";s:4:\"left\";s:22:\"menu_hover_first_color\";s:7:\"#002b64\";s:14:\"menu_sub_color\";s:7:\"#212934\";s:22:\"nav_dropdown_font_size\";s:4:\"14px\";s:26:\"flyout_menu_icon_font_size\";s:4:\"20px\";s:24:\"flyout_nav_icons_padding\";s:2:\"32\";s:22:\"flyout_menu_icon_color\";s:7:\"#212934\";s:28:\"flyout_menu_icon_hover_color\";s:7:\"#65bc7b\";s:28:\"flyout_menu_background_color\";s:22:\"rgba(255,255,255,0.96)\";s:21:\"flyout_menu_direction\";s:4:\"fade\";s:24:\"flyout_menu_item_padding\";s:2:\"32\";s:23:\"topmenu_dropwdown_width\";s:3:\"200\";s:29:\"header_top_first_border_color\";s:16:\"rgba(0,0,0,0.06)\";s:23:\"header_top_sub_bg_color\";s:7:\"#ffffff\";s:30:\"header_top_menu_bg_hover_color\";s:7:\"#f9f9fb\";s:29:\"header_top_menu_sub_sep_color\";s:7:\"#e2e2e2\";s:14:\"snav_font_size\";s:4:\"12px\";s:11:\"sec_menu_lh\";s:4:\"48px\";s:10:\"snav_color\";s:7:\"#ffffff\";s:25:\"header_top_menu_sub_color\";s:7:\"#4a4e57\";s:31:\"header_top_menu_sub_hover_color\";s:7:\"#65bc7b\";s:18:\"mobile_menu_design\";s:6:\"flyout\";s:28:\"mobile_menu_icons_top_margin\";s:2:\"40\";s:22:\"mobile_menu_nav_height\";s:2:\"42\";s:27:\"mobile_nav_submenu_slideout\";s:1:\"1\";s:18:\"mobile_menu_search\";s:1:\"1\";s:29:\"mobile_menu_submenu_indicator\";s:1:\"1\";s:22:\"mobile_header_bg_color\";s:7:\"#ffffff\";s:30:\"mobile_archive_header_bg_color\";s:7:\"#ffffff\";s:28:\"mobile_menu_background_color\";s:7:\"#ffffff\";s:23:\"mobile_menu_hover_color\";s:7:\"#f9f9fb\";s:24:\"mobile_menu_border_color\";s:7:\"#e2e2e2\";s:24:\"mobile_menu_toggle_color\";s:7:\"#9ea0a4\";s:22:\"mobile_menu_typography\";a:9:{s:11:\"font-family\";s:7:\"Poppins\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:7:\"regular\";s:9:\"font-size\";s:4:\"14px\";s:11:\"line-height\";s:4:\"42px\";s:14:\"letter-spacing\";s:1:\"0\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#3e3e3e\";}s:28:\"mobile_menu_font_hover_color\";s:7:\"#00005a\";s:22:\"mobile_menu_text_align\";s:4:\"left\";s:14:\"megamenu_width\";s:10:\"site_width\";s:18:\"megamenu_max_width\";s:4:\"1200\";s:31:\"megamenu_interior_content_width\";s:14:\"viewport_width\";s:19:\"megamenu_title_size\";s:4:\"18px\";s:30:\"megamenu_item_vertical_padding\";s:1:\"7\";s:29:\"megamenu_item_display_divider\";s:1:\"0\";s:18:\"menu_icon_position\";s:4:\"left\";s:14:\"menu_icon_size\";s:2:\"14\";s:15:\"menu_icon_color\";s:7:\"#212934\";s:21:\"menu_icon_hover_color\";s:7:\"#65bc7b\";s:19:\"menu_thumbnail_size\";a:2:{s:5:\"width\";s:4:\"26px\";s:6:\"height\";s:4:\"14px\";}s:14:\"logo_alignment\";s:4:\"left\";s:11:\"logo_margin\";a:4:{s:3:\"top\";s:4:\"31px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:15:\"logo_background\";s:1:\"0\";s:21:\"logo_background_color\";s:7:\"#65bc7b\";s:16:\"logo_custom_link\";s:0:\"\";s:4:\"logo\";a:5:{s:3:\"url\";s:66:\"https://www.mercifulwaygroup.com/cms/images/files/2020/10/logo.png\";s:2:\"id\";s:2:\"18\";s:6:\"height\";s:3:\"140\";s:5:\"width\";s:3:\"240\";s:9:\"thumbnail\";s:74:\"https://www.mercifulwaygroup.com/cms/images/files/2020/10/logo-150x140.png\";}s:11:\"logo_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"sticky_header_logo\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:25:\"sticky_header_logo_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:11:\"mobile_logo\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"mobile_logo_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:8:\"fav_icon\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:20:\"fav_icon_apple_touch\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:16:\"fav_icon_android\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:13:\"fav_icon_edge\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:14:\"page_title_bar\";s:15:\"bar_and_content\";s:17:\"page_title_bar_bs\";s:11:\"breadcrumbs\";s:19:\"page_title_bar_text\";s:1:\"1\";s:20:\"page_title_100_width\";s:1:\"0\";s:17:\"page_title_height\";s:5:\"140px\";s:24:\"page_title_mobile_height\";s:5:\"160px\";s:19:\"page_title_bg_color\";s:7:\"#002b64\";s:23:\"page_title_border_color\";s:19:\"rgba(226,226,226,0)\";s:20:\"page_title_font_size\";s:4:\"30px\";s:22:\"page_title_line_height\";s:6:\"normal\";s:16:\"page_title_color\";s:7:\"#ffffff\";s:30:\"page_title_subheader_font_size\";s:4:\"18px\";s:26:\"page_title_subheader_color\";s:7:\"#ffffff\";s:20:\"page_title_alignment\";s:6:\"center\";s:13:\"page_title_bg\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:20:\"page_title_bg_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"page_title_bg_full\";s:1:\"0\";s:22:\"page_title_bg_parallax\";s:1:\"0\";s:17:\"page_title_fading\";s:1:\"0\";s:17:\"breadcrumb_mobile\";s:1:\"0\";s:16:\"breacrumb_prefix\";s:0:\"\";s:20:\"breadcrumb_separator\";s:1:\"/\";s:21:\"breadcrumbs_font_size\";s:4:\"13px\";s:22:\"breadcrumbs_text_color\";s:7:\"#ffffff\";s:28:\"breadcrumbs_text_hover_color\";s:7:\"#62bb46\";s:26:\"breadcrumb_show_categories\";s:1:\"1\";s:33:\"breadcrumb_show_post_type_archive\";s:1:\"0\";s:20:\"breadcrumb_show_leaf\";s:1:\"1\";s:18:\"slidingbar_widgets\";s:1:\"0\";s:25:\"mobile_slidingbar_widgets\";s:1:\"0\";s:23:\"slidingbar_open_on_load\";s:1:\"0\";s:19:\"slidingbar_position\";s:3:\"top\";s:16:\"slidingbar_width\";s:5:\"300px\";s:17:\"slidingbar_sticky\";s:1:\"1\";s:26:\"slidingbar_widgets_columns\";s:1:\"2\";s:27:\"slidingbar_column_alignment\";s:7:\"stacked\";s:26:\"slidingbar_content_padding\";a:4:{s:3:\"top\";s:4:\"60px\";s:5:\"right\";s:4:\"30px\";s:6:\"bottom\";s:4:\"60px\";s:4:\"left\";s:4:\"30px\";}s:24:\"slidingbar_content_align\";s:4:\"left\";s:23:\"slidingbar_toggle_style\";s:6:\"circle\";s:19:\"slidingbar_bg_color\";s:7:\"#212934\";s:24:\"slidingbar_divider_color\";s:7:\"#26303e\";s:28:\"slidingbar_toggle_icon_color\";s:7:\"#ffffff\";s:20:\"slidingbar_font_size\";s:4:\"14px\";s:25:\"slidingbar_headings_color\";s:7:\"#ffffff\";s:21:\"slidingbar_text_color\";s:21:\"rgba(255,255,255,0.6)\";s:21:\"slidingbar_link_color\";s:22:\"rgba(255,255,255,0.86)\";s:27:\"slidingbar_link_color_hover\";s:7:\"#ffffff\";s:17:\"slidingbar_border\";s:1:\"0\";s:14:\"footer_widgets\";s:1:\"1\";s:22:\"footer_widgets_columns\";s:1:\"4\";s:29:\"footer_widgets_center_content\";s:1:\"0\";s:22:\"footer_special_effects\";s:4:\"none\";s:16:\"footer_copyright\";s:1:\"1\";s:31:\"footer_copyright_center_content\";s:1:\"1\";s:11:\"footer_text\";s:116:\"Copyright &copy; <script>document.write(new Date().getFullYear());</script> Merciful Way Group | All Rights Reserved\";s:16:\"footerw_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:15:\"footerw_bg_full\";s:1:\"0\";s:17:\"footerw_bg_repeat\";s:9:\"no-repeat\";s:14:\"footerw_bg_pos\";s:13:\"center center\";s:16:\"footer_100_width\";s:1:\"0\";s:19:\"footer_area_padding\";a:4:{s:3:\"top\";s:4:\"60px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:4:\"64px\";s:4:\"left\";s:3:\"0px\";}s:15:\"footer_bg_color\";s:7:\"#073066\";s:18:\"footer_border_size\";s:1:\"0\";s:19:\"footer_border_color\";s:7:\"#e2e2e2\";s:19:\"footer_divider_line\";s:1:\"0\";s:24:\"footer_divider_line_size\";s:1:\"1\";s:25:\"footer_divider_line_style\";s:5:\"solid\";s:20:\"footer_divider_color\";s:16:\"rgba(38,48,62,0)\";s:22:\"footer_widgets_padding\";s:4:\"16px\";s:17:\"copyright_padding\";a:2:{s:3:\"top\";s:4:\"20px\";s:6:\"bottom\";s:4:\"20px\";}s:18:\"copyright_bg_color\";s:7:\"#022553\";s:21:\"copyright_border_size\";s:1:\"0\";s:22:\"copyright_border_color\";s:16:\"rgba(38,48,62,0)\";s:26:\"footer_headings_typography\";a:9:{s:11:\"font-family\";s:7:\"Poppins\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"600\";s:9:\"font-size\";s:4:\"16px\";s:11:\"line-height\";s:3:\"1.5\";s:14:\"letter-spacing\";s:1:\"0\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#ffffff\";}s:17:\"footer_text_color\";s:21:\"rgba(255,255,255,0.8)\";s:17:\"footer_link_color\";s:21:\"rgba(255,255,255,0.8)\";s:23:\"footer_link_color_hover\";s:7:\"#62bb46\";s:20:\"copyright_text_color\";s:21:\"rgba(255,255,255,0.6)\";s:20:\"copyright_link_color\";s:21:\"rgba(255,255,255,0.6)\";s:26:\"copyright_link_color_hover\";s:7:\"#62bb46\";s:19:\"copyright_font_size\";s:4:\"14px\";s:24:\"responsive_sidebar_order\";s:25:\"content,sidebar,sidebar-2\";s:14:\"sidebar_sticky\";s:4:\"none\";s:15:\"sidebar_padding\";s:3:\"0px\";s:16:\"sidebar_bg_color\";s:19:\"rgba(255,255,255,0)\";s:23:\"sidebar_widget_bg_color\";s:19:\"rgba(255,255,255,0)\";s:15:\"sidew_font_size\";s:4:\"18px\";s:21:\"sidebar_heading_color\";s:7:\"#212934\";s:13:\"pages_sidebar\";s:4:\"None\";s:15:\"pages_sidebar_2\";s:4:\"None\";s:20:\"pages_global_sidebar\";s:1:\"0\";s:19:\"default_sidebar_pos\";s:5:\"Right\";s:17:\"portfolio_sidebar\";s:4:\"None\";s:19:\"portfolio_sidebar_2\";s:4:\"None\";s:24:\"portfolio_global_sidebar\";s:1:\"0\";s:26:\"portfolio_sidebar_position\";s:5:\"Right\";s:25:\"portfolio_archive_sidebar\";s:4:\"None\";s:27:\"portfolio_archive_sidebar_2\";s:4:\"None\";s:13:\"posts_sidebar\";s:4:\"None\";s:15:\"posts_sidebar_2\";s:4:\"None\";s:20:\"posts_global_sidebar\";s:1:\"0\";s:21:\"blog_sidebar_position\";s:5:\"Right\";s:20:\"blog_archive_sidebar\";s:4:\"None\";s:22:\"blog_archive_sidebar_2\";s:4:\"None\";s:14:\"search_sidebar\";s:12:\"Blog Sidebar\";s:16:\"search_sidebar_2\";s:4:\"None\";s:23:\"search_sidebar_position\";s:5:\"Right\";s:8:\"bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:7:\"bg_full\";s:1:\"0\";s:9:\"bg_repeat\";s:9:\"no-repeat\";s:8:\"bg_color\";s:7:\"#e2e2e2\";s:17:\"bg_pattern_option\";s:1:\"0\";s:10:\"bg_pattern\";s:8:\"pattern1\";s:16:\"content_bg_color\";s:7:\"#ffffff\";s:16:\"content_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:15:\"content_bg_full\";s:1:\"0\";s:17:\"content_bg_repeat\";s:9:\"no-repeat\";s:15:\"typography_sets\";a:5:{s:11:\"typography1\";a:8:{s:5:\"label\";s:8:\"Headings\";s:11:\"font-family\";s:5:\"Inter\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:7:\"variant\";s:3:\"600\";s:9:\"font-size\";s:4:\"46px\";s:11:\"line-height\";s:3:\"1.2\";s:14:\"letter-spacing\";s:8:\"-0.015em\";s:14:\"text-transform\";s:4:\"none\";}s:11:\"typography2\";a:8:{s:5:\"label\";s:11:\"Subheadings\";s:11:\"font-family\";s:5:\"Inter\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:7:\"variant\";s:3:\"600\";s:9:\"font-size\";s:4:\"24px\";s:11:\"line-height\";s:3:\"1.1\";s:14:\"letter-spacing\";s:1:\"0\";s:14:\"text-transform\";s:4:\"none\";}s:11:\"typography3\";a:8:{s:5:\"label\";s:4:\"Lead\";s:11:\"font-family\";s:5:\"Inter\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:7:\"variant\";s:3:\"500\";s:9:\"font-size\";s:4:\"16px\";s:11:\"line-height\";s:3:\"1.2\";s:14:\"letter-spacing\";s:7:\"0.015em\";s:14:\"text-transform\";s:4:\"none\";}s:11:\"typography4\";a:8:{s:5:\"label\";s:4:\"Body\";s:11:\"font-family\";s:5:\"Inter\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:7:\"variant\";s:3:\"400\";s:9:\"font-size\";s:4:\"16px\";s:11:\"line-height\";s:4:\"1.72\";s:14:\"letter-spacing\";s:7:\"0.015em\";s:14:\"text-transform\";s:4:\"none\";}s:11:\"typography5\";a:8:{s:5:\"label\";s:5:\"Small\";s:11:\"font-family\";s:5:\"Inter\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:7:\"variant\";s:3:\"400\";s:9:\"font-size\";s:4:\"13px\";s:11:\"line-height\";s:4:\"1.72\";s:14:\"letter-spacing\";s:7:\"0.015em\";s:14:\"text-transform\";s:4:\"none\";}}s:15:\"body_typography\";a:8:{s:11:\"font-family\";s:7:\"Poppins\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"300\";s:9:\"font-size\";s:4:\"16px\";s:11:\"line-height\";s:3:\"1.8\";s:14:\"letter-spacing\";s:1:\"0\";s:5:\"color\";s:7:\"#656565\";}s:10:\"link_color\";s:7:\"#656565\";s:16:\"link_hover_color\";s:7:\"#62bb46\";s:15:\"link_decoration\";s:1:\"0\";s:25:\"link_decoration_exclusion\";a:4:{i:0;s:7:\"buttons\";i:1;s:5:\"menus\";i:2;s:4:\"tocs\";i:3;s:11:\"tabstoggles\";}s:20:\"link_decoration_line\";s:4:\"none\";s:21:\"link_decoration_style\";s:5:\"solid\";s:25:\"link_decoration_thickness\";s:3:\"1px\";s:26:\"link_decoration_line_hover\";s:4:\"none\";s:27:\"link_decoration_style_hover\";s:5:\"solid\";s:31:\"link_decoration_thickness_hover\";s:3:\"1px\";s:13:\"h1_typography\";a:11:{s:11:\"font-family\";s:7:\"Poppins\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"700\";s:9:\"font-size\";s:4:\"35px\";s:11:\"line-height\";s:4:\"1.16\";s:14:\"letter-spacing\";s:1:\"0\";s:10:\"margin-top\";s:3:\"0em\";s:13:\"margin-bottom\";s:3:\"1em\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#00005a\";}s:13:\"h2_typography\";a:11:{s:11:\"font-family\";s:7:\"Poppins\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"500\";s:9:\"font-size\";s:4:\"35px\";s:11:\"line-height\";s:3:\"1.2\";s:14:\"letter-spacing\";s:1:\"0\";s:10:\"margin-top\";s:3:\"0em\";s:13:\"margin-bottom\";s:5:\"1.1em\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#00005a\";}s:13:\"h3_typography\";a:11:{s:11:\"font-family\";s:7:\"Poppins\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"32px\";s:11:\"line-height\";s:3:\"1.3\";s:14:\"letter-spacing\";s:1:\"0\";s:10:\"margin-top\";s:3:\"1em\";s:13:\"margin-bottom\";s:3:\"1em\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#212934\";}s:13:\"h4_typography\";a:11:{s:11:\"font-family\";s:7:\"Poppins\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"500\";s:9:\"font-size\";s:4:\"25px\";s:11:\"line-height\";s:4:\"1.36\";s:14:\"letter-spacing\";s:1:\"0\";s:10:\"margin-top\";s:6:\"1.33em\";s:13:\"margin-bottom\";s:6:\"1.33em\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#292972\";}s:13:\"h5_typography\";a:11:{s:11:\"font-family\";s:7:\"Poppins\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"500\";s:9:\"font-size\";s:4:\"22px\";s:11:\"line-height\";s:3:\"1.4\";s:14:\"letter-spacing\";s:1:\"0\";s:10:\"margin-top\";s:3:\"1em\";s:13:\"margin-bottom\";s:3:\"1em\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#00005a\";}s:13:\"h6_typography\";a:11:{s:11:\"font-family\";s:7:\"Poppins\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"500\";s:9:\"font-size\";s:4:\"18px\";s:11:\"line-height\";s:3:\"1.5\";s:14:\"letter-spacing\";s:1:\"0\";s:10:\"margin-top\";s:5:\"0.5em\";s:13:\"margin-bottom\";s:5:\"0.5em\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#00005a\";}s:21:\"post_title_typography\";a:9:{s:11:\"font-family\";s:7:\"Poppins\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"500\";s:9:\"font-size\";s:4:\"32px\";s:11:\"line-height\";s:3:\"1.3\";s:14:\"letter-spacing\";s:1:\"0\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#212934\";}s:29:\"post_titles_extras_typography\";a:9:{s:11:\"font-family\";s:7:\"Poppins\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"500\";s:9:\"font-size\";s:4:\"18px\";s:11:\"line-height\";s:3:\"1.5\";s:14:\"letter-spacing\";s:1:\"0\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#212934\";}s:12:\"custom_fonts\";a:7:{s:25:\"fusionredux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}s:4:\"name\";a:1:{i:0;s:0:\"\";}s:5:\"woff2\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:4:\"woff\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:3:\"ttf\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:3:\"eot\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:3:\"svg\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}}s:14:\"adobe_fonts_id\";s:0:\"\";s:19:\"blog_page_title_bar\";s:15:\"bar_and_content\";s:24:\"blog_show_page_title_bar\";s:15:\"bar_and_content\";s:10:\"blog_title\";s:4:\"Blog\";s:13:\"blog_subtitle\";s:0:\"\";s:11:\"blog_layout\";s:6:\"medium\";s:19:\"blog_archive_layout\";s:6:\"medium\";s:20:\"blog_pagination_type\";s:10:\"pagination\";s:36:\"blog_load_more_posts_button_bg_color\";s:21:\"rgba(242,243,245,0.7)\";s:38:\"blog_load_more_posts_button_text_color\";s:7:\"#333333\";s:42:\"blog_load_more_posts_hover_button_bg_color\";s:21:\"rgba(242,243,245,0.8)\";s:44:\"blog_load_more_posts_hover_button_text_color\";s:7:\"#333333\";s:25:\"blog_archive_grid_columns\";s:1:\"3\";s:32:\"blog_archive_grid_column_spacing\";s:2:\"40\";s:18:\"blog_equal_heights\";s:1:\"0\";s:25:\"blog_archive_grid_padding\";a:4:{s:3:\"top\";s:4:\"30px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"20px\";s:4:\"left\";s:4:\"25px\";}s:21:\"blog_layout_alignment\";s:0:\"\";s:14:\"content_length\";s:7:\"excerpt\";s:19:\"excerpt_length_blog\";s:2:\"60\";s:18:\"strip_html_excerpt\";s:1:\"1\";s:15:\"featured_images\";s:1:\"1\";s:15:\"dates_box_color\";s:7:\"#f2f3f5\";s:32:\"alternate_date_format_month_year\";s:4:\"m, Y\";s:25:\"alternate_date_format_day\";s:1:\"j\";s:20:\"timeline_date_format\";s:3:\"F Y\";s:14:\"blog_width_100\";s:1:\"0\";s:22:\"featured_images_single\";s:1:\"0\";s:11:\"blog_pn_nav\";s:1:\"1\";s:15:\"blog_post_title\";s:5:\"above\";s:23:\"blog_post_meta_position\";s:13:\"below_article\";s:18:\"social_sharing_box\";s:1:\"1\";s:11:\"author_info\";s:1:\"0\";s:13:\"related_posts\";s:1:\"1\";s:13:\"blog_comments\";s:1:\"0\";s:9:\"post_meta\";s:1:\"1\";s:16:\"post_meta_author\";s:1:\"0\";s:14:\"post_meta_date\";s:1:\"1\";s:14:\"post_meta_cats\";s:1:\"1\";s:18:\"post_meta_comments\";s:1:\"0\";s:14:\"post_meta_read\";s:1:\"1\";s:14:\"post_meta_tags\";s:1:\"0\";s:14:\"meta_font_size\";s:4:\"13px\";s:11:\"date_format\";s:0:\"\";s:24:\"portfolio_archive_layout\";s:4:\"grid\";s:37:\"portfolio_archive_featured_image_size\";s:4:\"full\";s:25:\"portfolio_archive_columns\";s:1:\"1\";s:32:\"portfolio_archive_column_spacing\";s:2:\"20\";s:23:\"portfolio_equal_heights\";s:1:\"0\";s:42:\"portfolio_archive_one_column_text_position\";s:5:\"below\";s:23:\"portfolio_archive_items\";s:2:\"10\";s:29:\"portfolio_archive_text_layout\";s:7:\"no_text\";s:32:\"portfolio_archive_content_length\";s:7:\"excerpt\";s:32:\"portfolio_archive_excerpt_length\";s:2:\"10\";s:36:\"portfolio_archive_strip_html_excerpt\";s:1:\"1\";s:31:\"portfolio_archive_title_display\";s:3:\"all\";s:32:\"portfolio_archive_text_alignment\";s:4:\"left\";s:32:\"portfolio_archive_layout_padding\";a:4:{s:3:\"top\";s:4:\"25px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"25px\";s:4:\"left\";s:4:\"25px\";}s:33:\"portfolio_archive_pagination_type\";s:10:\"pagination\";s:49:\"portfolio_archive_load_more_posts_button_bg_color\";s:21:\"rgba(242,243,245,0.7)\";s:51:\"portfolio_archive_load_more_posts_button_text_color\";s:7:\"#333333\";s:55:\"portfolio_archive_load_more_posts_hover_button_bg_color\";s:21:\"rgba(242,243,245,0.8)\";s:57:\"portfolio_archive_load_more_posts_hover_button_text_color\";s:7:\"#333333\";s:14:\"portfolio_slug\";s:15:\"portfolio-items\";s:24:\"portfolio_meta_font_size\";s:4:\"13px\";s:16:\"portfolio_pn_nav\";s:1:\"1\";s:19:\"portfolio_width_100\";s:1:\"0\";s:30:\"portfolio_featured_image_width\";s:4:\"full\";s:25:\"portfolio_featured_images\";s:1:\"1\";s:25:\"show_first_featured_image\";s:1:\"1\";s:28:\"portfolio_project_desc_title\";s:1:\"1\";s:25:\"portfolio_project_details\";s:1:\"1\";s:26:\"portfolio_link_icon_target\";s:1:\"0\";s:16:\"portfolio_author\";s:1:\"0\";s:28:\"portfolio_social_sharing_box\";s:1:\"1\";s:23:\"portfolio_related_posts\";s:1:\"1\";s:18:\"portfolio_comments\";s:1:\"0\";s:18:\"social_media_icons\";a:6:{s:25:\"fusionredux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}s:4:\"icon\";a:1:{i:0;s:8:\"facebook\";}s:9:\"icon_mark\";a:1:{i:0;s:0:\"\";}s:3:\"url\";a:1:{i:0;s:37:\"https://www.facebook.com/mercifulway/\";}s:12:\"custom_title\";a:1:{i:0;s:0:\"\";}s:13:\"custom_source\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}}s:29:\"header_social_links_font_size\";s:4:\"16px\";s:30:\"header_social_links_color_type\";s:6:\"custom\";s:30:\"header_social_links_icon_color\";s:7:\"#ffffff\";s:25:\"header_social_links_boxed\";s:1:\"0\";s:29:\"header_social_links_box_color\";s:7:\"#ffffff\";s:32:\"header_social_links_boxed_radius\";s:3:\"4px\";s:33:\"header_social_links_boxed_padding\";s:3:\"8px\";s:12:\"icons_footer\";s:1:\"0\";s:29:\"footer_social_links_font_size\";s:4:\"16px\";s:30:\"footer_social_links_color_type\";s:6:\"custom\";s:30:\"footer_social_links_icon_color\";s:21:\"rgba(255,255,255,0.8)\";s:25:\"footer_social_links_boxed\";s:1:\"0\";s:29:\"footer_social_links_box_color\";s:7:\"#222222\";s:32:\"footer_social_links_boxed_radius\";s:3:\"4px\";s:33:\"footer_social_links_boxed_padding\";s:3:\"8px\";s:22:\"sharing_social_tagline\";s:39:\"Share This Story, Choose Your Platform!\";s:30:\"sharing_box_tagline_text_color\";s:7:\"#212934\";s:15:\"social_bg_color\";s:7:\"#f9f9fb\";s:22:\"social_sharing_padding\";a:4:{s:3:\"top\";s:6:\"1.33em\";s:5:\"right\";s:4:\"20px\";s:6:\"bottom\";s:6:\"1.33em\";s:4:\"left\";s:4:\"20px\";}s:14:\"social_sharing\";a:10:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";i:2;s:6:\"reddit\";i:3;s:8:\"linkedin\";i:4;s:8:\"whatsapp\";i:5;s:6:\"tumblr\";i:6;s:9:\"pinterest\";i:7;s:2:\"vk\";i:8;s:4:\"xing\";i:9;s:5:\"email\";}s:30:\"sharing_social_links_font_size\";s:4:\"16px\";s:31:\"sharing_social_links_color_type\";s:6:\"custom\";s:31:\"sharing_social_links_icon_color\";s:7:\"#9ea0a4\";s:26:\"sharing_social_links_boxed\";s:1:\"0\";s:30:\"sharing_social_links_box_color\";s:7:\"#e8e8e8\";s:33:\"sharing_social_links_boxed_radius\";s:3:\"4px\";s:34:\"sharing_social_links_boxed_padding\";s:3:\"8px\";s:22:\"posts_slideshow_number\";s:1:\"5\";s:18:\"slideshow_autoplay\";s:1:\"1\";s:23:\"slideshow_smooth_height\";s:1:\"0\";s:15:\"slideshow_speed\";s:4:\"7000\";s:22:\"pagination_video_slide\";s:1:\"0\";s:25:\"slider_nav_box_dimensions\";a:2:{s:5:\"width\";s:4:\"30px\";s:6:\"height\";s:4:\"30px\";}s:17:\"slider_arrow_size\";s:4:\"14px\";s:15:\"tfes_dimensions\";a:2:{s:5:\"width\";s:4:\"100%\";s:6:\"height\";s:5:\"400px\";}s:14:\"tfes_animation\";s:5:\"sides\";s:13:\"tfes_autoplay\";s:1:\"1\";s:13:\"tfes_interval\";s:4:\"3000\";s:10:\"tfes_speed\";s:3:\"800\";s:10:\"tfes_width\";s:3:\"150\";s:18:\"es_title_font_size\";s:4:\"42px\";s:20:\"es_caption_font_size\";s:4:\"20px\";s:14:\"es_title_color\";s:7:\"#212934\";s:16:\"es_caption_color\";s:7:\"#4a4e57\";s:15:\"status_lightbox\";s:1:\"1\";s:22:\"status_lightbox_single\";s:1:\"1\";s:17:\"lightbox_behavior\";s:3:\"all\";s:13:\"lightbox_skin\";s:11:\"metro-white\";s:13:\"lightbox_path\";s:8:\"vertical\";s:24:\"lightbox_animation_speed\";s:6:\"normal\";s:15:\"lightbox_arrows\";s:1:\"1\";s:16:\"lightbox_gallery\";s:1:\"1\";s:17:\"lightbox_autoplay\";s:1:\"0\";s:24:\"lightbox_slideshow_speed\";s:4:\"5000\";s:16:\"lightbox_opacity\";s:3:\"0.9\";s:14:\"lightbox_title\";s:1:\"1\";s:13:\"lightbox_desc\";s:1:\"1\";s:15:\"lightbox_social\";s:1:\"1\";s:20:\"lightbox_deeplinking\";s:1:\"1\";s:20:\"lightbox_post_images\";s:1:\"1\";s:25:\"lightbox_video_dimensions\";a:2:{s:5:\"width\";s:6:\"1280px\";s:6:\"height\";s:5:\"720px\";}s:17:\"form_input_height\";s:4:\"50px\";s:14:\"form_text_size\";s:4:\"16px\";s:13:\"form_bg_color\";s:7:\"#ffffff\";s:15:\"form_text_color\";s:7:\"#9ea0a4\";s:17:\"form_border_width\";a:4:{s:3:\"top\";s:3:\"1px\";s:5:\"right\";s:3:\"1px\";s:6:\"bottom\";s:3:\"1px\";s:4:\"left\";s:3:\"1px\";}s:17:\"form_border_color\";s:7:\"#e2e2e2\";s:23:\"form_focus_border_color\";s:7:\"#65bc7b\";s:18:\"form_border_radius\";s:1:\"6\";s:19:\"form_views_counting\";s:3:\"all\";s:17:\"recaptcha_version\";s:2:\"v3\";s:16:\"recaptcha_public\";s:0:\"\";s:17:\"recaptcha_private\";s:0:\"\";s:22:\"recaptcha_color_scheme\";s:5:\"light\";s:15:\"recaptcha_score\";s:3:\"0.5\";s:24:\"recaptcha_badge_position\";s:6:\"inline\";s:20:\"recaptcha_login_form\";s:1:\"0\";s:11:\"hubspot_api\";s:3:\"off\";s:11:\"hubspot_key\";s:0:\"\";s:13:\"mailchimp_api\";s:3:\"off\";s:13:\"mailchimp_key\";s:0:\"\";s:13:\"email_address\";s:0:\"\";s:24:\"contact_comment_position\";s:5:\"below\";s:29:\"contact_form_privacy_checkbox\";s:1:\"0\";s:26:\"contact_form_privacy_label\";s:152:\"By checking this box, you confirm that you have read and are agreeing to our terms of use regarding the storage of the data submitted through this form.\";s:8:\"gmap_api\";s:0:\"\";s:13:\"gmap_api_type\";s:2:\"js\";s:18:\"gmap_embed_address\";s:0:\"\";s:19:\"gmap_embed_map_type\";s:7:\"roadmap\";s:12:\"gmap_address\";s:49:\"775 New York Ave, Brooklyn, Kings, New York 11203\";s:9:\"gmap_type\";s:7:\"roadmap\";s:15:\"gmap_dimensions\";a:2:{s:5:\"width\";s:4:\"100%\";s:6:\"height\";s:5:\"415px\";}s:14:\"gmap_topmargin\";s:4:\"55px\";s:14:\"map_zoom_level\";s:1:\"8\";s:7:\"map_pin\";s:1:\"1\";s:18:\"gmap_pin_animation\";s:1:\"1\";s:9:\"map_popup\";s:1:\"0\";s:15:\"map_scrollwheel\";s:1:\"1\";s:9:\"map_scale\";s:1:\"1\";s:15:\"map_zoomcontrol\";s:1:\"1\";s:11:\"map_styling\";s:7:\"default\";s:17:\"map_overlay_color\";s:7:\"#65bc7b\";s:19:\"map_infobox_styling\";s:7:\"default\";s:19:\"map_infobox_content\";s:0:\"\";s:20:\"map_infobox_bg_color\";s:19:\"rgba(255,255,255,0)\";s:22:\"map_infobox_text_color\";s:7:\"#ffffff\";s:22:\"map_custom_marker_icon\";s:0:\"\";s:21:\"search_filter_results\";s:1:\"0\";s:14:\"search_content\";a:4:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:15:\"avada_portfolio\";i:3;s:9:\"avada_faq\";}s:27:\"search_limit_to_post_titles\";s:1:\"0\";s:18:\"search_form_design\";s:5:\"clean\";s:11:\"live_search\";s:1:\"0\";s:26:\"live_search_min_char_count\";s:1:\"4\";s:28:\"live_search_results_per_page\";s:3:\"100\";s:26:\"live_search_results_height\";s:3:\"250\";s:34:\"live_search_display_featured_image\";s:1:\"1\";s:29:\"live_search_display_post_type\";s:1:\"1\";s:13:\"search_layout\";s:4:\"grid\";s:23:\"search_results_per_page\";s:2:\"10\";s:22:\"search_pagination_type\";s:10:\"pagination\";s:19:\"search_grid_columns\";s:1:\"3\";s:26:\"search_grid_column_spacing\";s:2:\"40\";s:21:\"search_content_length\";s:7:\"excerpt\";s:21:\"search_excerpt_length\";s:2:\"10\";s:25:\"search_strip_html_excerpt\";s:1:\"1\";s:22:\"search_featured_images\";s:1:\"1\";s:11:\"search_meta\";a:5:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";i:4;s:9:\"read_more\";}s:26:\"search_new_search_position\";s:3:\"top\";s:18:\"gfonts_load_method\";s:3:\"cdn\";s:14:\"privacy_embeds\";s:1:\"0\";s:14:\"privacy_expiry\";s:2:\"30\";s:19:\"privacy_embed_types\";a:8:{i:0;s:7:\"youtube\";i:1;s:5:\"vimeo\";i:2;s:10:\"soundcloud\";i:3;s:8:\"facebook\";i:4;s:6:\"flickr\";i:5;s:7:\"twitter\";i:6;s:5:\"gmaps\";i:7;s:8:\"tracking\";}s:22:\"privacy_embed_defaults\";a:0:{}s:16:\"privacy_bg_color\";s:15:\"rgba(0,0,0,0.1)\";s:13:\"privacy_color\";s:15:\"rgba(0,0,0,0.3)\";s:11:\"privacy_bar\";s:1:\"0\";s:19:\"privacy_bar_padding\";a:4:{s:3:\"top\";s:4:\"15px\";s:5:\"right\";s:4:\"30px\";s:6:\"bottom\";s:4:\"15px\";s:4:\"left\";s:4:\"30px\";}s:20:\"privacy_bar_bg_color\";s:7:\"#363839\";s:21:\"privacy_bar_font_size\";s:4:\"13px\";s:17:\"privacy_bar_color\";s:7:\"#8c8989\";s:22:\"privacy_bar_link_color\";s:7:\"#bfbfbf\";s:28:\"privacy_bar_link_hover_color\";s:7:\"#65bc7b\";s:16:\"privacy_bar_text\";s:51:\"This website uses cookies and third party services.\";s:23:\"privacy_bar_button_text\";s:2:\"OK\";s:23:\"privacy_bar_button_save\";s:1:\"0\";s:16:\"privacy_bar_more\";s:1:\"0\";s:21:\"privacy_bar_more_text\";s:8:\"Settings\";s:23:\"privacy_bar_update_text\";s:15:\"Update Settings\";s:30:\"privacy_bar_headings_font_size\";s:4:\"13px\";s:26:\"privacy_bar_headings_color\";s:7:\"#dddddd\";s:19:\"privacy_bar_content\";a:4:{s:25:\"fusionredux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}s:4:\"type\";a:1:{i:0;s:0:\"\";}s:5:\"title\";a:1:{i:0;s:0:\"\";}s:11:\"description\";a:1:{i:0;s:0:\"\";}}s:18:\"privacy_bar_reject\";s:1:\"0\";s:23:\"privacy_bar_reject_text\";s:6:\"Reject\";s:16:\"sidenav_behavior\";s:5:\"hover\";s:18:\"side_nav_font_size\";s:4:\"16px\";s:10:\"post_views\";s:9:\"page_load\";s:19:\"post_views_counting\";s:3:\"all\";s:26:\"featured_image_placeholder\";s:1:\"1\";s:12:\"excerpt_base\";s:5:\"words\";s:16:\"disable_excerpts\";s:1:\"1\";s:24:\"excerpt_read_more_symbol\";s:6:\" [...]\";s:14:\"link_read_more\";s:1:\"0\";s:12:\"avatar_shape\";s:6:\"circle\";s:14:\"comments_pages\";s:1:\"0\";s:21:\"featured_images_pages\";s:1:\"1\";s:21:\"nofollow_social_links\";s:1:\"0\";s:16:\"social_icons_new\";s:1:\"1\";s:14:\"totop_position\";s:5:\"right\";s:19:\"totop_border_radius\";s:1:\"6\";s:22:\"totop_scroll_down_only\";s:1:\"1\";s:16:\"custom_scrollbar\";s:1:\"0\";s:20:\"scrollbar_background\";s:17:\"var(--awb-color2)\";s:16:\"scrollbar_handle\";s:17:\"var(--awb-color4)\";s:8:\"faq_slug\";s:9:\"faq-items\";s:13:\"cloning_posts\";s:1:\"1\";s:20:\"related_posts_layout\";s:17:\"title_on_rollover\";s:20:\"number_related_posts\";s:1:\"4\";s:21:\"related_posts_columns\";s:1:\"4\";s:28:\"related_posts_column_spacing\";s:2:\"48\";s:24:\"related_posts_image_size\";s:7:\"cropped\";s:22:\"related_posts_autoplay\";s:1:\"0\";s:19:\"related_posts_speed\";s:4:\"2500\";s:24:\"related_posts_navigation\";s:1:\"1\";s:19:\"related_posts_swipe\";s:1:\"0\";s:25:\"related_posts_swipe_items\";s:1:\"0\";s:14:\"image_rollover\";s:1:\"1\";s:24:\"image_rollover_direction\";s:4:\"left\";s:24:\"image_rollover_icon_size\";s:4:\"15px\";s:20:\"image_rollover_icons\";s:8:\"linkzoom\";s:20:\"title_image_rollover\";s:1:\"1\";s:19:\"cats_image_rollover\";s:1:\"1\";s:26:\"icon_circle_image_rollover\";s:1:\"1\";s:24:\"image_gradient_top_color\";s:7:\"#62bb46\";s:27:\"image_gradient_bottom_color\";s:7:\"#62bb46\";s:25:\"image_rollover_text_color\";s:7:\"#ffffff\";s:25:\"image_rollover_icon_color\";s:7:\"#595959\";s:17:\"pagination_sizing\";s:12:\"width_height\";s:23:\"pagination_width_height\";s:2:\"30\";s:22:\"pagination_box_padding\";a:2:{s:5:\"width\";s:3:\"6px\";s:6:\"height\";s:3:\"2px\";}s:23:\"pagination_border_width\";s:1:\"1\";s:24:\"pagination_border_radius\";s:1:\"0\";s:23:\"pagination_text_display\";s:1:\"1\";s:20:\"pagination_font_size\";s:4:\"13px\";s:16:\"pagination_range\";s:1:\"1\";s:26:\"pagination_start_end_range\";s:1:\"0\";s:17:\"timeline_bg_color\";s:19:\"rgba(255,255,255,0)\";s:14:\"timeline_color\";s:7:\"#f2f3f5\";s:25:\"grid_separator_style_type\";s:12:\"double|solid\";s:20:\"grid_separator_color\";s:7:\"#e2e2e2\";s:18:\"masonry_grid_ratio\";s:3:\"1.5\";s:20:\"masonry_width_double\";s:4:\"2000\";s:23:\"enable_language_updates\";s:1:\"1\";s:19:\"dependencies_status\";s:1:\"1\";s:27:\"disable_code_block_encoding\";s:1:\"1\";s:16:\"disable_megamenu\";s:1:\"1\";s:19:\"status_widget_areas\";s:1:\"1\";s:19:\"status_avada_studio\";s:1:\"1\";s:16:\"avada_rev_styles\";s:1:\"1\";s:22:\"avada_styles_dropdowns\";s:1:\"1\";s:27:\"disable_mobile_image_hovers\";s:1:\"1\";s:9:\"status_yt\";s:1:\"1\";s:12:\"status_vimeo\";s:1:\"1\";s:11:\"status_gmap\";s:1:\"1\";s:12:\"status_totop\";s:7:\"desktop\";s:18:\"status_fontawesome\";a:3:{i:0;s:3:\"fab\";i:1;s:3:\"far\";i:2;s:3:\"fas\";}s:28:\"fontawesome_v4_compatibility\";s:1:\"0\";s:22:\"status_fontawesome_pro\";s:1:\"0\";s:14:\"status_outline\";s:1:\"0\";s:16:\"status_opengraph\";s:1:\"1\";s:31:\"disable_date_rich_snippet_pages\";s:1:\"1\";s:26:\"disable_rich_snippet_title\";s:1:\"1\";s:27:\"disable_rich_snippet_author\";s:1:\"1\";s:25:\"disable_rich_snippet_date\";s:1:\"1\";s:24:\"disable_rich_snippet_faq\";s:1:\"1\";s:34:\"enable_block_editor_backend_styles\";s:1:\"1\";s:17:\"load_block_styles\";s:2:\"on\";s:16:\"google_analytics\";s:0:\"\";s:10:\"space_head\";s:0:\"\";s:10:\"space_body\";s:0:\"\";s:20:\"status_fusion_slider\";s:1:\"1\";s:14:\"status_eslider\";s:1:\"0\";s:19:\"status_fusion_forms\";s:1:\"1\";s:21:\"status_awb_Off_Canvas\";s:1:\"1\";s:23:\"status_fusion_portfolio\";s:1:\"1\";s:18:\"status_fusion_faqs\";s:1:\"1\";s:16:\"maintenance_mode\";s:0:\"\";s:24:\"maintenance_redirect_url\";s:0:\"\";s:20:\"maintenance_template\";s:1:\"0\";s:22:\"maintenance_user_roles\";a:0:{}s:19:\"maintenance_exclude\";s:0:\"\";s:22:\"maintenance_page_title\";s:0:\"\";s:23:\"maintenance_robots_meta\";s:7:\"noindex\";s:10:\"svg_upload\";s:8:\"disabled\";s:15:\"pw_jpeg_quality\";s:2:\"82\";s:27:\"wp_big_image_size_threshold\";s:4:\"2560\";s:9:\"lazy_load\";s:4:\"none\";s:17:\"lazy_load_iframes\";s:4:\"none\";s:17:\"font_face_display\";s:5:\"block\";s:13:\"preload_fonts\";s:4:\"none\";s:22:\"preload_fonts_variants\";a:1:{i:0;s:3:\"400\";}s:21:\"preload_fonts_subsets\";a:1:{i:0;s:5:\"latin\";}s:15:\"emojis_disabled\";s:7:\"enabled\";s:23:\"jquery_migrate_disabled\";s:7:\"enabled\";s:12:\"defer_jquery\";s:1:\"0\";s:12:\"defer_styles\";s:1:\"0\";s:11:\"gzip_status\";s:1:\"0\";s:12:\"video_facade\";s:3:\"off\";s:18:\"clear_object_cache\";s:1:\"0\";s:16:\"css_cache_method\";s:4:\"file\";s:30:\"css_combine_third_party_assets\";s:1:\"1\";s:19:\"media_queries_async\";s:1:\"0\";s:12:\"critical_css\";s:1:\"0\";s:15:\"cache_server_ip\";s:0:\"\";s:11:\"js_compiler\";s:1:\"0\";s:10:\"custom_css\";s:60:\".fusion-header-v4 .fusion-header {\r\n    padding-top: 0px;\r\n}\";s:13:\"info_bg_color\";s:7:\"#ffffff\";s:17:\"info_accent_color\";s:7:\"#4a4e57\";s:15:\"danger_bg_color\";s:20:\"rgba(219,75,104,0.1)\";s:19:\"danger_accent_color\";s:7:\"#db4b68\";s:16:\"success_bg_color\";s:20:\"rgba(18,184,120,0.1)\";s:20:\"success_accent_color\";s:7:\"#12b878\";s:16:\"warning_bg_color\";s:20:\"rgba(241,174,42,0.1)\";s:20:\"warning_accent_color\";s:7:\"#f1ae2a\";s:20:\"alert_box_text_align\";s:6:\"center\";s:24:\"alert_box_text_transform\";s:6:\"normal\";s:21:\"alert_box_dismissable\";s:3:\"yes\";s:16:\"alert_box_shadow\";s:2:\"no\";s:17:\"alert_border_size\";s:1:\"1\";s:16:\"animation_offset\";s:13:\"top-into-view\";s:21:\"status_css_animations\";s:7:\"desktop\";s:15:\"audio_max_width\";s:4:\"100%\";s:22:\"audio_background_color\";s:7:\"#1d242d\";s:23:\"audio_progressbar_color\";s:7:\"#ffffff\";s:27:\"audio_controls_color_scheme\";s:5:\"light\";s:17:\"audio_border_size\";s:1:\"0\";s:18:\"audio_border_color\";s:0:\"\";s:19:\"audio_border_radius\";a:4:{s:8:\"top_left\";s:3:\"0px\";s:9:\"top_right\";s:3:\"0px\";s:12:\"bottom_right\";s:3:\"0px\";s:11:\"bottom_left\";s:3:\"0px\";}s:17:\"blog_grid_columns\";s:1:\"3\";s:24:\"blog_grid_column_spacing\";s:2:\"40\";s:17:\"blog_grid_padding\";a:4:{s:3:\"top\";s:4:\"30px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"25px\";s:4:\"left\";s:4:\"25px\";}s:12:\"blog_excerpt\";s:3:\"yes\";s:19:\"blog_excerpt_length\";s:2:\"10\";s:44:\"blog_element_load_more_posts_button_bg_color\";s:21:\"rgba(242,243,245,0.7)\";s:46:\"blog_element_load_more_posts_button_text_color\";s:7:\"#212934\";s:50:\"blog_element_load_more_posts_hover_button_bg_color\";s:7:\"#f2f3f5\";s:52:\"blog_element_load_more_posts_hover_button_text_color\";s:7:\"#212934\";s:14:\"button_padding\";a:4:{s:3:\"top\";s:4:\"13px\";s:5:\"right\";s:4:\"29px\";s:6:\"bottom\";s:4:\"13px\";s:4:\"left\";s:4:\"29px\";}s:11:\"button_span\";s:2:\"no\";s:11:\"button_type\";s:4:\"Flat\";s:17:\"button_typography\";a:8:{s:11:\"font-family\";s:7:\"Poppins\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:7:\"regular\";s:9:\"font-size\";s:4:\"14px\";s:11:\"line-height\";s:4:\"17px\";s:14:\"letter-spacing\";s:1:\"0\";s:14:\"text-transform\";s:4:\"none\";}s:25:\"button_gradient_top_color\";s:7:\"#0e67b1\";s:28:\"button_gradient_bottom_color\";s:7:\"#0e67b1\";s:31:\"button_gradient_top_color_hover\";s:7:\"#084b87\";s:34:\"button_gradient_bottom_color_hover\";s:7:\"#084b87\";s:21:\"button_gradient_start\";s:1:\"0\";s:19:\"button_gradient_end\";s:3:\"100\";s:20:\"button_gradient_type\";s:6:\"linear\";s:21:\"button_gradient_angle\";s:3:\"180\";s:23:\"button_radial_direction\";s:13:\"center center\";s:19:\"button_accent_color\";s:7:\"#ffffff\";s:25:\"button_accent_hover_color\";s:7:\"#ffffff\";s:18:\"button_bevel_color\";s:7:\"#5db072\";s:24:\"button_bevel_color_hover\";s:7:\"#5db072\";s:19:\"button_border_width\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:20:\"button_border_radius\";a:4:{s:8:\"top_left\";s:3:\"0px\";s:9:\"top_right\";s:3:\"0px\";s:12:\"bottom_right\";s:3:\"0px\";s:11:\"bottom_left\";s:3:\"0px\";}s:19:\"button_border_color\";s:7:\"#ffffff\";s:25:\"button_border_hover_color\";s:7:\"#ffffff\";s:14:\"button_presets\";s:1:\"1\";s:18:\"carousel_nav_color\";s:18:\"rgba(29,36,45,0.7)\";s:20:\"carousel_hover_color\";s:18:\"rgba(29,36,45,0.8)\";s:14:\"carousel_speed\";s:4:\"2500\";s:21:\"chart_legend_position\";s:3:\"top\";s:19:\"chart_show_tooltips\";s:3:\"yes\";s:14:\"chart_bg_color\";s:19:\"rgba(255,255,255,0)\";s:21:\"chart_axis_text_color\";s:7:\"#4a4e57\";s:20:\"chart_gridline_color\";s:15:\"rgba(0,0,0,0.1)\";s:21:\"checklist_icons_color\";s:7:\"#ffffff\";s:16:\"checklist_circle\";s:1:\"1\";s:22:\"checklist_circle_color\";s:7:\"#65bc7b\";s:20:\"checklist_text_color\";s:7:\"#656565\";s:19:\"checklist_item_size\";s:4:\"16px\";s:22:\"checklist_item_padding\";a:4:{s:3:\"top\";s:6:\"0.35em\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:6:\"0.35em\";s:4:\"left\";s:1:\"0\";}s:17:\"checklist_divider\";s:2:\"no\";s:23:\"checklist_divider_color\";s:0:\"\";s:25:\"checklist_odd_row_bgcolor\";s:19:\"rgba(255,255,255,0)\";s:26:\"checklist_even_row_bgcolor\";s:19:\"rgba(255,255,255,0)\";s:10:\"col_margin\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:4:\"20px\";}s:11:\"col_spacing\";s:2:\"4%\";s:16:\"col_width_medium\";s:18:\"inherit_from_large\";s:15:\"col_width_small\";s:3:\"1_1\";s:25:\"container_padding_default\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:21:\"container_padding_100\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:4:\"30px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:4:\"30px\";}s:19:\"full_width_bg_color\";s:19:\"rgba(255,255,255,0)\";s:31:\"full_width_gradient_start_color\";s:19:\"rgba(255,255,255,0)\";s:29:\"full_width_gradient_end_color\";s:19:\"rgba(255,255,255,0)\";s:23:\"full_width_border_sizes\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:23:\"full_width_border_color\";s:7:\"#e2e2e2\";s:29:\"container_scroll_nav_bg_color\";s:15:\"rgba(0,0,0,0.2)\";s:33:\"container_scroll_nav_bullet_color\";s:7:\"#e2e2e2\";s:35:\"container_hundred_percent_animation\";s:4:\"fade\";s:44:\"container_hundred_percent_scroll_sensitivity\";s:3:\"450\";s:41:\"container_hundred_percent_animation_speed\";s:3:\"800\";s:41:\"container_hundred_percent_dots_navigation\";s:1:\"1\";s:39:\"container_hundred_percent_height_mobile\";s:1:\"0\";s:24:\"container_legacy_support\";s:1:\"0\";s:20:\"content_box_bg_color\";s:19:\"rgba(255,255,255,0)\";s:22:\"content_box_title_size\";s:2:\"24\";s:23:\"content_box_title_color\";s:7:\"#212934\";s:22:\"content_box_body_color\";s:7:\"#4a4e57\";s:21:\"content_box_icon_size\";s:2:\"20\";s:22:\"content_box_icon_color\";s:7:\"#ffffff\";s:23:\"content_box_icon_circle\";s:3:\"yes\";s:30:\"content_box_icon_circle_radius\";s:3:\"50%\";s:25:\"content_box_icon_bg_color\";s:7:\"#212934\";s:38:\"content_box_icon_bg_inner_border_color\";s:7:\"#212934\";s:37:\"content_box_icon_bg_inner_border_size\";s:1:\"1\";s:38:\"content_box_icon_bg_outer_border_color\";s:19:\"rgba(255,255,255,0)\";s:37:\"content_box_icon_bg_outer_border_size\";s:1:\"1\";s:27:\"content_box_icon_hover_type\";s:4:\"fade\";s:40:\"content_box_hover_animation_accent_color\";s:7:\"#65bc7b\";s:21:\"content_box_link_type\";s:4:\"text\";s:23:\"content_box_button_span\";s:2:\"no\";s:21:\"content_box_link_area\";s:9:\"link-icon\";s:23:\"content_box_link_target\";s:5:\"_self\";s:18:\"content_box_margin\";a:2:{s:3:\"top\";s:0:\"\";s:6:\"bottom\";s:0:\"\";}s:18:\"countdown_timezone\";s:9:\"site_time\";s:16:\"countdown_layout\";s:7:\"floated\";s:20:\"countdown_show_weeks\";s:2:\"no\";s:24:\"countdown_label_position\";s:9:\"text_flow\";s:26:\"countdown_background_color\";s:7:\"#65bc7b\";s:26:\"countdown_background_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:27:\"countdown_background_repeat\";s:9:\"no-repeat\";s:29:\"countdown_background_position\";s:13:\"center center\";s:29:\"countdown_counter_box_spacing\";s:4:\"10px\";s:27:\"countdown_counter_box_color\";s:7:\"#212934\";s:25:\"countdown_counter_padding\";a:4:{s:3:\"top\";s:5:\"0.6em\";s:5:\"right\";s:5:\"1.1em\";s:6:\"bottom\";s:5:\"0.6em\";s:4:\"left\";s:5:\"1.1em\";}s:29:\"countdown_counter_border_size\";s:1:\"0\";s:30:\"countdown_counter_border_color\";s:7:\"#1d242d\";s:31:\"countdown_counter_border_radius\";s:3:\"4px\";s:27:\"countdown_counter_font_size\";s:4:\"18px\";s:28:\"countdown_counter_text_color\";s:7:\"#ffffff\";s:25:\"countdown_label_font_size\";s:4:\"18px\";s:21:\"countdown_label_color\";s:7:\"#ffffff\";s:27:\"countdown_heading_font_size\";s:4:\"18px\";s:28:\"countdown_heading_text_color\";s:7:\"#ffffff\";s:30:\"countdown_subheading_font_size\";s:4:\"14px\";s:31:\"countdown_subheading_text_color\";s:7:\"#ffffff\";s:25:\"countdown_link_text_color\";s:7:\"#ffffff\";s:21:\"countdown_link_target\";s:5:\"_self\";s:17:\"counter_box_speed\";s:4:\"1000\";s:17:\"counter_box_color\";s:7:\"#65bc7b\";s:22:\"counter_box_title_size\";s:2:\"50\";s:21:\"counter_box_icon_size\";s:2:\"50\";s:22:\"counter_box_body_color\";s:7:\"#4a4e57\";s:21:\"counter_box_body_size\";s:2:\"14\";s:24:\"counter_box_border_color\";s:7:\"#e2e2e2\";s:20:\"counter_box_icon_top\";s:2:\"no\";s:20:\"counter_filled_color\";s:7:\"#65bc7b\";s:22:\"counter_unfilled_color\";s:7:\"#f2f3f5\";s:13:\"dropcap_color\";s:7:\"#65bc7b\";s:18:\"dropcap_text_color\";s:4:\"#fff\";s:18:\"faq_featured_image\";s:1:\"0\";s:11:\"faq_filters\";s:3:\"yes\";s:18:\"faq_accordion_type\";s:10:\"accordions\";s:24:\"faq_accordion_boxed_mode\";s:1:\"0\";s:25:\"faq_accordion_border_size\";s:1:\"1\";s:26:\"faq_accordian_border_color\";s:7:\"#e2e2e2\";s:30:\"faq_accordian_background_color\";s:7:\"#ffffff\";s:25:\"faq_accordian_hover_color\";s:7:\"#f9f9fb\";s:26:\"faq_accordion_divider_line\";s:1:\"1\";s:27:\"faq_accordion_divider_color\";s:7:\"#e2e2e2\";s:33:\"faq_accordion_divider_hover_color\";s:7:\"#e2e2e2\";s:30:\"faq_accordion_title_typography\";a:9:{s:11:\"font-family\";s:7:\"Poppins\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"500\";s:9:\"font-size\";s:4:\"28px\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#656565\";}s:23:\"faq_accordion_icon_size\";s:2:\"16\";s:24:\"faq_accordian_icon_color\";s:7:\"#ffffff\";s:24:\"faq_accordion_icon_boxed\";s:1:\"1\";s:28:\"faq_accordian_inactive_color\";s:7:\"#212934\";s:32:\"faq_accordion_content_typography\";a:9:{s:11:\"font-family\";s:7:\"Poppins\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"300\";s:9:\"font-size\";s:4:\"16px\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#656565\";}s:24:\"faq_accordion_icon_align\";s:4:\"left\";s:26:\"faq_accordian_active_color\";s:7:\"#65bc7b\";s:33:\"faq_accordian_active_accent_color\";s:0:\"\";s:22:\"flip_boxes_flip_effect\";s:7:\"classic\";s:25:\"flip_boxes_flip_direction\";s:5:\"right\";s:24:\"flip_boxes_flip_duration\";s:3:\"0.8\";s:24:\"flip_boxes_equal_heights\";s:2:\"no\";s:19:\"flip_boxes_front_bg\";s:7:\"#212934\";s:24:\"flip_boxes_front_heading\";s:7:\"#f9f9fb\";s:21:\"flip_boxes_front_text\";s:7:\"#4a4e57\";s:18:\"flip_boxes_back_bg\";s:7:\"#65bc7b\";s:23:\"flip_boxes_back_heading\";s:7:\"#ffffff\";s:20:\"flip_boxes_back_text\";s:21:\"rgba(255,255,255,0.8)\";s:22:\"flip_boxes_border_size\";s:1:\"1\";s:23:\"flip_boxes_border_color\";s:13:\"rgba(0,0,0,0)\";s:24:\"flip_boxes_border_radius\";s:3:\"6px\";s:13:\"gallery_limit\";s:2:\"-1\";s:23:\"gallery_pagination_type\";s:6:\"button\";s:29:\"gallery_load_more_button_text\";s:9:\"Load More\";s:20:\"gallery_picture_size\";s:4:\"auto\";s:14:\"gallery_layout\";s:4:\"grid\";s:15:\"gallery_columns\";s:1:\"3\";s:22:\"gallery_column_spacing\";s:2:\"10\";s:18:\"gallery_hover_type\";s:4:\"none\";s:24:\"gallery_lightbox_content\";s:4:\"none\";s:19:\"gallery_border_size\";s:1:\"0\";s:20:\"gallery_border_color\";s:7:\"#e2e2e2\";s:21:\"gallery_border_radius\";s:3:\"0px\";s:19:\"google_map_api_type\";s:2:\"js\";s:9:\"icon_size\";s:2:\"32\";s:10:\"icon_color\";s:7:\"#ffffff\";s:16:\"icon_color_hover\";s:7:\"#ffffff\";s:11:\"icon_circle\";s:3:\"yes\";s:17:\"icon_circle_color\";s:7:\"#4a4e57\";s:23:\"icon_circle_color_hover\";s:7:\"#65bc7b\";s:16:\"icon_border_size\";s:1:\"1\";s:17:\"icon_border_color\";s:7:\"#4a4e57\";s:23:\"icon_border_color_hover\";s:7:\"#65bc7b\";s:18:\"icon_border_radius\";a:4:{s:8:\"top_left\";s:3:\"50%\";s:9:\"top_right\";s:3:\"50%\";s:12:\"bottom_right\";s:3:\"50%\";s:11:\"bottom_left\";s:3:\"50%\";}s:15:\"icon_hover_type\";s:4:\"fade\";s:17:\"before_after_type\";s:12:\"before_after\";s:22:\"before_after_font_size\";s:2:\"14\";s:25:\"before_after_accent_color\";s:7:\"#ffffff\";s:28:\"before_after_label_placement\";s:14:\"image-centered\";s:24:\"before_after_handle_type\";s:7:\"default\";s:25:\"before_after_handle_color\";s:7:\"#ffffff\";s:22:\"before_after_handle_bg\";s:19:\"rgba(255,255,255,0)\";s:19:\"before_after_offset\";s:2:\"50\";s:24:\"before_after_orientation\";s:10:\"horizontal\";s:28:\"before_after_handle_movement\";s:10:\"drag_click\";s:28:\"before_after_transition_time\";s:3:\"0.5\";s:24:\"before_after_border_size\";s:1:\"0\";s:25:\"before_after_border_color\";s:7:\"#e2e2e2\";s:26:\"before_after_border_radius\";s:3:\"0px\";s:21:\"imageframe_style_type\";s:4:\"none\";s:15:\"imageframe_blur\";s:1:\"3\";s:20:\"imgframe_style_color\";s:7:\"#000000\";s:22:\"imageframe_border_size\";s:1:\"0\";s:21:\"imgframe_border_color\";s:7:\"#e2e2e2\";s:24:\"imageframe_border_radius\";s:3:\"0px\";s:23:\"instagram_cache_timeout\";s:4:\"hour\";s:14:\"modal_bg_color\";s:7:\"#ffffff\";s:18:\"modal_border_color\";s:7:\"#e2e2e2\";s:23:\"openstreetmap_map_style\";s:9:\"osm-carto\";s:33:\"openstreetmap_mapbox_access_token\";s:0:\"\";s:13:\"person_margin\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:23:\"person_background_color\";s:13:\"rgba(0,0,0,0)\";s:16:\"person_pic_style\";s:4:\"none\";s:21:\"person_pic_style_blur\";s:1:\"3\";s:18:\"person_style_color\";s:7:\"#000000\";s:19:\"person_border_color\";s:7:\"#e2e2e2\";s:18:\"person_border_size\";s:1:\"0\";s:20:\"person_border_radius\";s:3:\"0px\";s:16:\"person_alignment\";s:4:\"Left\";s:20:\"person_icon_position\";s:3:\"Top\";s:24:\"popover_heading_bg_color\";s:7:\"#f9f9fb\";s:24:\"popover_content_bg_color\";s:7:\"#ffffff\";s:20:\"popover_border_color\";s:7:\"#e2e2e2\";s:18:\"popover_text_color\";s:7:\"#4a4e57\";s:17:\"popover_placement\";s:3:\"Top\";s:29:\"portfolio_featured_image_size\";s:4:\"full\";s:17:\"portfolio_columns\";s:1:\"3\";s:24:\"portfolio_column_spacing\";s:2:\"30\";s:15:\"portfolio_items\";s:2:\"10\";s:21:\"portfolio_text_layout\";s:7:\"unboxed\";s:24:\"portfolio_content_length\";s:7:\"excerpt\";s:24:\"portfolio_excerpt_length\";s:2:\"10\";s:28:\"portfolio_strip_html_excerpt\";s:1:\"1\";s:23:\"portfolio_title_display\";s:3:\"all\";s:24:\"portfolio_text_alignment\";s:4:\"left\";s:24:\"portfolio_layout_padding\";a:4:{s:3:\"top\";s:4:\"25px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"25px\";s:4:\"left\";s:4:\"25px\";}s:25:\"portfolio_pagination_type\";s:10:\"pagination\";s:49:\"portfolio_element_load_more_posts_button_bg_color\";s:21:\"rgba(242,243,245,0.7)\";s:51:\"portfolio_element_load_more_posts_button_text_color\";s:7:\"#212934\";s:55:\"portfolio_element_load_more_posts_hover_button_bg_color\";s:7:\"#f2f3f5\";s:57:\"portfolio_element_load_more_posts_hover_button_text_color\";s:7:\"#212934\";s:36:\"full_boxed_pricing_box_heading_color\";s:7:\"#212934\";s:29:\"sep_pricing_box_heading_color\";s:7:\"#212934\";s:17:\"pricing_box_color\";s:7:\"#65bc7b\";s:16:\"pricing_bg_color\";s:7:\"#ffffff\";s:30:\"pricing_background_color_hover\";s:0:\"\";s:20:\"pricing_border_color\";s:7:\"#f2f3f5\";s:21:\"pricing_divider_color\";s:7:\"#e2e2e2\";s:25:\"progressbar_text_position\";s:6:\"on_bar\";s:22:\"progressbar_text_color\";s:7:\"#ffffff\";s:18:\"progressbar_height\";s:4:\"48px\";s:24:\"progressbar_filled_color\";s:7:\"#65bc7b\";s:26:\"progressbar_unfilled_color\";s:7:\"#f2f3f5\";s:30:\"progressbar_filled_border_size\";s:1:\"0\";s:31:\"progressbar_filled_border_color\";s:7:\"#ffffff\";s:24:\"scroll_progress_position\";s:4:\"flow\";s:22:\"scroll_progress_height\";s:4:\"10px\";s:32:\"scroll_progress_background_color\";s:17:\"var(--awb-color2)\";s:30:\"scroll_progress_progress_color\";s:17:\"var(--awb-color4)\";s:27:\"scroll_progress_border_size\";s:1:\"0\";s:28:\"scroll_progress_border_color\";s:17:\"var(--awb-color1)\";s:29:\"scroll_progress_border_radius\";a:4:{s:8:\"top_left\";s:3:\"0px\";s:9:\"top_right\";s:3:\"0px\";s:12:\"bottom_right\";s:3:\"0px\";s:11:\"bottom_left\";s:3:\"0px\";}s:23:\"section_sep_border_size\";s:1:\"1\";s:14:\"section_sep_bg\";s:7:\"#f9f9fb\";s:24:\"section_sep_border_color\";s:7:\"#e2e2e2\";s:20:\"separator_style_type\";s:6:\"double\";s:9:\"sep_color\";s:7:\"#e2e2e2\";s:21:\"separator_border_size\";s:1:\"3\";s:19:\"separator_icon_size\";s:2:\"16\";s:20:\"separator_icon_color\";s:7:\"#e2e2e2\";s:16:\"separator_circle\";s:1:\"1\";s:25:\"separator_circle_bg_color\";s:19:\"rgba(255,255,255,0)\";s:19:\"social_links_margin\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:30:\"social_links_tooltip_placement\";s:3:\"Top\";s:22:\"social_links_font_size\";s:4:\"16px\";s:23:\"social_links_color_type\";s:6:\"custom\";s:23:\"social_links_icon_color\";s:7:\"#9ea0a4\";s:29:\"social_links_icon_color_hover\";s:21:\"rgba(158,160,164,0.8)\";s:18:\"social_links_boxed\";s:1:\"0\";s:26:\"social_links_boxed_padding\";s:3:\"8px\";s:22:\"social_links_box_color\";s:7:\"#f2f3f5\";s:28:\"social_links_box_color_hover\";s:21:\"rgba(242,243,245,0.8)\";s:19:\"social_links_border\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:25:\"social_links_boxed_radius\";s:3:\"4px\";s:25:\"social_links_border_color\";s:17:\"var(--awb-color3)\";s:31:\"social_links_border_color_hover\";s:17:\"var(--awb-color4)\";s:22:\"stripe_button_api_mode\";s:4:\"test\";s:29:\"stripe_button_test_secret_key\";s:0:\"\";s:29:\"stripe_button_live_secret_key\";s:0:\"\";s:24:\"syntax_highlighter_theme\";s:7:\"default\";s:31:\"syntax_highlighter_line_numbers\";s:3:\"yes\";s:47:\"syntax_highlighter_line_number_background_color\";s:0:\"\";s:41:\"syntax_highlighter_line_number_text_color\";s:0:\"\";s:32:\"syntax_highlighter_line_wrapping\";s:6:\"scroll\";s:36:\"syntax_highlighter_copy_to_clipboard\";s:3:\"yes\";s:41:\"syntax_highlighter_copy_to_clipboard_text\";s:17:\"Copy to Clipboard\";s:28:\"syntax_highlighter_font_size\";s:2:\"14\";s:35:\"syntax_highlighter_background_color\";s:0:\"\";s:30:\"syntax_highlighter_border_size\";s:1:\"1\";s:31:\"syntax_highlighter_border_color\";s:0:\"\";s:31:\"syntax_highlighter_border_style\";s:5:\"solid\";s:25:\"syntax_highlighter_margin\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:13:\"tabs_bg_color\";s:7:\"#ffffff\";s:19:\"tabs_inactive_color\";s:7:\"#f9f9fb\";s:24:\"tabs_title_border_radius\";a:4:{s:8:\"top_left\";s:3:\"0px\";s:9:\"top_right\";s:3:\"0px\";s:12:\"bottom_right\";s:3:\"0px\";s:11:\"bottom_left\";s:3:\"0px\";}s:17:\"tabs_border_color\";s:7:\"#e2e2e2\";s:18:\"tabs_title_padding\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:20:\"tabs_content_padding\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:18:\"tabs_icon_position\";s:4:\"left\";s:14:\"tabs_icon_size\";s:2:\"16\";s:15:\"tabs_icon_color\";s:0:\"\";s:22:\"tabs_icon_active_color\";s:0:\"\";s:16:\"tabs_title_color\";s:0:\"\";s:23:\"tabs_active_title_color\";s:0:\"\";s:22:\"tabs_mobile_breakpoint\";s:5:\"small\";s:16:\"tabs_mobile_mode\";s:9:\"accordion\";s:23:\"tabs_mobile_sticky_tabs\";s:2:\"no\";s:11:\"tagcloud_bg\";s:22:\"rgba(255, 255, 255, 0)\";s:17:\"tagcloud_bg_hover\";s:17:\"var(--awb-color4)\";s:14:\"tagcloud_color\";s:97:\"hsla(var(--awb-color1-h),var(--awb-color1-s),var(--awb-color1-l),calc(var(--awb-color1-a) - 20%))\";s:20:\"tagcloud_color_hover\";s:17:\"var(--awb-color1)\";s:21:\"tagcloud_border_color\";s:17:\"var(--awb-color8)\";s:27:\"tagcloud_border_color_hover\";s:17:\"var(--awb-color4)\";s:10:\"tagline_bg\";s:7:\"#f9f9fb\";s:20:\"tagline_border_color\";s:19:\"rgba(226,226,226,0)\";s:14:\"tagline_margin\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:4:\"20px\";}s:20:\"testimonial_bg_color\";s:7:\"#f9f9fb\";s:22:\"testimonial_text_color\";s:7:\"#4a4e57\";s:18:\"testimonials_speed\";s:4:\"4000\";s:19:\"testimonials_random\";s:1:\"0\";s:12:\"text_columns\";s:1:\"1\";s:21:\"text_column_min_width\";s:5:\"100px\";s:19:\"text_column_spacing\";s:3:\"2em\";s:15:\"text_rule_style\";s:4:\"none\";s:14:\"text_rule_size\";s:1:\"1\";s:15:\"text_rule_color\";s:0:\"\";s:20:\"title_text_transform\";s:0:\"\";s:16:\"title_style_type\";s:12:\"double solid\";s:18:\"title_border_color\";s:7:\"#e2e2e2\";s:12:\"title_margin\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:19:\"title_margin_mobile\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:14:\"accordion_type\";s:10:\"accordions\";s:20:\"accordion_boxed_mode\";s:1:\"0\";s:21:\"accordion_border_size\";s:1:\"1\";s:22:\"accordian_border_color\";s:7:\"#e2e2e2\";s:26:\"accordian_background_color\";s:7:\"#ffffff\";s:21:\"accordian_hover_color\";s:7:\"#f9f9fb\";s:22:\"accordion_divider_line\";s:1:\"1\";s:23:\"accordion_divider_color\";s:7:\"#e2e2e2\";s:29:\"accordion_divider_hover_color\";s:7:\"#e2e2e2\";s:26:\"accordion_title_typography\";a:9:{s:11:\"font-family\";s:7:\"Poppins\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"500\";s:9:\"font-size\";s:4:\"28px\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#656565\";}s:19:\"accordion_icon_size\";s:2:\"16\";s:20:\"accordian_icon_color\";s:7:\"#ffffff\";s:20:\"accordion_icon_boxed\";s:1:\"1\";s:24:\"accordian_inactive_color\";s:7:\"#212934\";s:28:\"accordion_content_typography\";a:9:{s:11:\"font-family\";s:7:\"Poppins\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"300\";s:9:\"font-size\";s:4:\"16px\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#656565\";}s:22:\"accordian_active_color\";s:7:\"#65bc7b\";s:29:\"accordian_active_accent_color\";s:0:\"\";s:20:\"accordion_icon_align\";s:4:\"left\";s:21:\"user_login_text_align\";s:6:\"center\";s:28:\"user_login_form_field_layout\";s:7:\"stacked\";s:27:\"user_login_form_show_labels\";s:2:\"no\";s:33:\"user_login_form_show_placeholders\";s:3:\"yes\";s:32:\"user_login_form_show_remember_me\";s:2:\"no\";s:32:\"user_login_form_background_color\";s:7:\"#f9f9fb\";s:15:\"video_max_width\";s:4:\"100%\";s:14:\"video_controls\";s:3:\"yes\";s:13:\"video_preload\";s:4:\"auto\";s:22:\"widget_area_title_size\";s:4:\"28px\";s:23:\"widget_area_title_color\";s:7:\"#212934\";s:22:\"adobe_cache_fonts_info\";s:0:\"\";s:37:\"header_social_links_tooltip_placement\";s:6:\"Bottom\";s:37:\"footer_social_links_tooltip_placement\";s:3:\"Top\";s:38:\"sharing_social_links_tooltip_placement\";s:3:\"Top\";s:19:\"reset_hubspot_cache\";s:0:\"\";s:21:\"reset_mailchimp_cache\";s:0:\"\";s:19:\"reset_caches_button\";s:0:\"\";s:22:\"reset_instagram_caches\";s:0:\"\";s:30:\"stripe_button_validate_test_sk\";s:0:\"\";s:30:\"stripe_button_validate_live_sk\";s:0:\"\";}","yes"),
("267","fusion_options-transients","a:2:{s:14:\"changed_values\";a:1:{s:13:\"page_template\";s:10:\"site_width\";}s:9:\"last_save\";i:1686141366;}","yes"),
("272","fusion_registration_data","a:1:{s:5:\"avada\";a:5:{s:5:\"token\";s:0:\"\";s:13:\"purchase_code\";s:0:\"\";s:8:\"is_valid\";b:1;s:6:\"scopes\";a:5:{i:0;s:7:\"default\";i:1;s:13:\"user:username\";i:2;s:17:\"purchase:download\";i:3;s:13:\"purchase:list\";i:4;s:15:\"purchase:verify\";}s:6:\"errors\";s:0:\"\";}}","yes"),
("301","fusion_dynamic_css_time","1624303880","yes"),
("324","fusion_core_version","5.10.1","yes"),
("325","widget_ad_125_125-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("326","widget_fusion_author-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("327","widget_contact_info-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("328","widget_pyre_tabs-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("329","widget_recent_works-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("330","widget_tweets-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("331","widget_flickr-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("332","widget_social_links-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("333","widget_facebook-like-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("334","widget_menu-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("335","widget_avada-vertical-menu-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("358","fusion_builder_version","3.10.1","yes"),
("382","ls-plugin-version","7.7.5","yes"),
("383","ls-db-version","7.0.0","yes"),
("384","ls-installed","1","yes"),
("385","ls-date-installed","1601899192","yes"),
("386","ls_gsap_sandboxing","1","yes"),
("388","fusion_supported_plugins_active","a:1:{i:0;s:17:\"LS_PLUGIN_VERSION\";}","yes"),
("389","widget_layerslider_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("405","layerslider_update_info","O:8:\"stdClass\":7:{s:5:\"basic\";O:8:\"stdClass\":12:{s:4:\"slug\";s:11:\"LayerSlider\";s:6:\"plugin\";s:27:\"LayerSlider/layerslider.php\";s:7:\"version\";s:5:\"7.7.7\";s:8:\"released\";s:10:\"2023-06-06\";s:5:\"icons\";a:3:{s:2:\"1x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-128x128.png?ver=6.9.2\";s:2:\"2x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";s:7:\"default\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";}s:7:\"banners\";a:3:{s:3:\"low\";s:94:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-772x250.png?ver=6.9.2\";s:4:\"high\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";s:7:\"default\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";}s:3:\"url\";s:24:\"https://layerslider.com/\";s:7:\"package\";s:0:\"\";s:8:\"requires\";s:3:\"4.4\";s:6:\"tested\";s:5:\"6.2.2\";s:12:\"requires_php\";s:5:\"5.4.0\";s:14:\"upgrade_notice\";s:148:\"In addition to more than 9000 objects and millions of royalty-free stock photos, LayerSlider\'s Assets Library now also offers stock videos for free.\";}s:4:\"full\";O:8:\"stdClass\":21:{s:4:\"name\";s:14:\"LayerSlider WP\";s:8:\"homepage\";s:24:\"https://layerslider.com/\";s:5:\"p_url\";s:32:\"https://layerslider.com/pricing/\";s:7:\"version\";s:5:\"7.7.7\";s:12:\"last_updated\";s:10:\"2023-06-06\";s:8:\"requires\";s:3:\"4.4\";s:6:\"tested\";s:5:\"6.2.2\";s:12:\"requires_php\";s:5:\"5.4.0\";s:6:\"rating\";s:2:\"95\";s:11:\"num_ratings\";i:3208;s:14:\"upgrade_notice\";a:3:{s:6:\"stable\";s:148:\"In addition to more than 9000 objects and millions of royalty-free stock photos, LayerSlider\'s Assets Library now also offers stock videos for free.\";s:4:\"beta\";s:148:\"In addition to more than 9000 objects and millions of royalty-free stock photos, LayerSlider\'s Assets Library now also offers stock videos for free.\";s:4:\"edge\";s:148:\"In addition to more than 9000 objects and millions of royalty-free stock photos, LayerSlider\'s Assets Library now also offers stock videos for free.\";}s:6:\"author\";s:71:\"<a href=\"https://kreaturamedia.com/\" target=\"_blank\">Kreatura Media</a>\";s:3:\"url\";s:24:\"https://layerslider.com/\";s:8:\"external\";b:1;s:9:\"file_name\";s:10:\"plugin.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-128x128.png?ver=6.9.2\";s:2:\"2x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";s:7:\"default\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";}s:7:\"banners\";a:3:{s:3:\"low\";s:94:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-772x250.png?ver=6.9.2\";s:4:\"high\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";s:7:\"default\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";}s:8:\"sections\";a:3:{s:9:\"changelog\";s:329:\"<p style=\"text-align: justify;\">\n	<a href=\"https://layerslider.com/release-log/\" target=\"_blank\">Click here to see the release log.</a> Don’t forget, the release log and all product-related news are also integrated right into LayerSlider. Look for the “LayerSlider News” section at the bottom of its main admin screen.\n</p>\";s:12:\"installation\";s:549:\"<p style=\"text-align: justify;\">\n	Updating the plugin won’t touch your sliders or settings. New versions always have backward compatibility. You don’t have to worry about losing your work. Not sure how to update? Check the <a href=\"https://layerslider.com/documentation/#updating\" target=\"_blank\">Updating</a> section of our online documentation.\n</p>\n\n<p style=\"text-align: justify;\">\n	If you’re experiencing unwanted changes, it is always a good idea to check your settings since there are probably new options to control those changes.\n</p>\";s:3:\"faq\";s:537:\"<p style=\"text-align: justify;\">\n	Please visit our <a href=\"https://layerslider.com/help/\" target=\"_blank\">Help</a> page, where you can find all sorts of useful assets like <a href=\"https://layerslider.com/faq/\" target=\"_blank\">FAQs</a>, <a href=\"https://layerslider.com/documentation/\" target=\"_blank\">online documentation</a>, <a href=\"https://layerslider.com/documentation/#troubleshooting\" target=\"_blank\">troubleshooting</a>, and <a href=\"https://layerslider.com/documentation/#support\" target=\"_blank\">support</a> information.\n</p>\";}s:4:\"slug\";s:11:\"LayerSlider\";s:7:\"package\";s:0:\"\";s:13:\"download_link\";s:0:\"\";}s:15:\"_latest_version\";s:5:\"7.7.7\";s:17:\"_important_notice\";a:9:{s:4:\"date\";s:10:\"2023-05-22\";s:5:\"title\";s:58:\"Celebrating LayerSlider’s New Home with a Special Offer!\";s:7:\"message\";s:748:\"We’re saying goodbye to Envato Market: LayerSlider is now fully independent and available exclusively on <a href=\"https://layerslider.com/\" target=\"_blank\">layerslider.com</a>. Don’t worry! LayerSlider is thriving and evolving faster than ever, and Envato customers continue to receive the same benefits. To celebrate this occasion, you can <span style=\"font-weight: 500\">purchase LayerSlider 15% OFF for a limited time with coupon code <span style=\"font-weight: 800; color: #007cba;\">INDIE15</span></span>.<br><br><a class=\"button button-primary\" href=\"https://layerslider.com/leaving-envato/\" target=\"_blank\">full announcement</a> <a class=\"button button-primary\" href=\"https://layerslider.com/pricing/\" target=\"_blank\">Grab your discount</a>\";s:5:\"image\";s:0:\"\";s:6:\"banner\";a:5:{s:5:\"class\";s:0:\"\";s:5:\"style\";s:132:\"height: auto; margin: 39px auto 0 auto !important; min-width: 700px; max-width: 1700px; padding-right: 20px; box-sizing: border-box;\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:6:\"_blank\";s:7:\"content\";s:3901:\"\n\n		<style>\n		@import url(\"https://fonts.googleapis.com/css2?family=Montserrat:wght@200;300;400;500&display=swap\");\n		</style>\n		<style>\n\n			.layerslider_notice_img {\n				padding-right: 30px !important;\n				max-width: none !important;\n				min-width: 0 !important;\n			}\n\n\n			#lspr-inner {\n				position: relative;\n				height: auto;\n				background-image: 	linear-gradient(150deg, rgb(56, 103, 189) 0%, rgba(76, 119, 199, 0.5) 28%, rgba(69, 110, 186, 0) 68%),\n									linear-gradient(45deg, rgb(41, 10, 102) 50%, rgb(111, 32, 214) 100%);\n				border-radius: 6px;\n			}\n\n			#lspr-grid {\n				position: relative;\n				height: auto;\n				display: flex;\n				margin: 0 auto !important;\n				justify-content: space-between;\n				align-items: stretch;\n				flex-flow: row wrap;\n				max-width: 1500px;\n				padding: 20px;\n			}\n\n			#lspr-left,\n			#lspr-right {\n				position: relative;\n				box-sizing: border-box;\n			}\n\n			#lspr-left {\n				flex: 70% 1 0;\n			}\n\n			#lspr-right {\n				flex: 30% 1 0;\n				min-width: 270px;\n				display: flex;\n				align-items: center;\n				justify-content: center;\n			}\n\n			#lspr-scroll {\n				position: absolute;\n				left: 0;\n				top: 0;\n				right: 0;\n				bottom: 0;\n				z-index: 1;\n				overflow: hidden;\n				border-radius: 1rem;\n			}\n\n			.lspr-over {\n				position: relative;\n				z-index: 2;\n			}\n\n			#lspr-heading {\n				text-align: center;\n				color: white;\n				font-size: 18px;\n				font-weight: 500;\n				line-height: 20px;\n				font-family: Montserrat, sans-serif;\n			}\n\n			.lspr-nowrap {\n				white-space: nowrap;\n			}\n\n			.lspr-text {\n				position: relative;\n				padding-top: 15px;\n				z-index: 200;\n				color: white;\n				font-family: Montserrat, sans-serif;\n				font-size: 15px;\n				font-weight: 300;\n				line-height: 22px;\n				text-align: justify;\n			}\n\n			.lspr-text a {\n				font-weight: 500;\n				text-decoration: none;\n				padding: 0 3px;\n				margin-right: 2px;\n				background-color: white;\n				color: #363088;\n				border-radius: 3px;\n			}\n\n			.lspr-text a:hover {\n				background-color: #e3177d;\n				color: white;\n			}\n\n			#lspr-buttons {\n				text-align: center;\n			}\n\n			#lspr-buttons a {\n				margin: 0 1rem;\n				text-decoration: none;\n				color: white;\n				text-transform: uppercase;\n				font-family: Montserrat, sans-serif;\n				font-weight: 500;\n				display: inline-block;\n				border-radius: 100px;\n				background-color: #e3177d;\n				line-height: 32px;\n				font-size: 14px;\n				transition: all 0.2s;\n				box-shadow: none;\n				cursor: pointer;\n				width: 240px;\n				box-sizing: border-box;\n			}\n\n			#lspr-buttons a:last-child {\n				margin-top: 15px;\n			}\n\n			#lspr-buttons a:hover {\n				filter: contrast(170%);\n			}\n\n			.layerslider_notice_img  .dashicons-dismiss {\n				right: 30px;\n			}\n\n		</style>\n		<div id=\"lspr-inner\">\n			<div id=\"lspr-grid\">\n				<div id=\"lspr-left\">\n					<div id=\"lspr-heading\" class=\"lspr-over\">\n						<span class=\"lspr-nowrap\">Celebrating LayerSlider’s New Home<span> <span class=\"lspr-nowrap\">with a Special Offer!<span>\n					</div>\n\n					<div class=\"lspr-text\" class=\"lspr-over\">\n						<span>\n							We’re saying goodbye to Envato Market: LayerSlider is now fully independent and available exclusively on <a href=\"https://layerslider.com/\" target=\"_blank\">layerslider.com</a>. Don’t worry! LayerSlider is thriving and evolving faster than ever, and Envato customers continue to receive the same benefits. To celebrate this occasion, you can <span style=\"font-weight: 500\">purchase LayerSlider 15% OFF for a limited time with coupon code <span style=\"color: #ff55af\">INDIE15</span></span>.\n						</span>\n					</div>\n				</div>\n				<div id=\"lspr-right\">\n					<div id=\"lspr-buttons\" class=\"lspr-over\">\n						<a href=\"https://layerslider.com/leaving-envato/\" target=\"_blank\">full announcement</a>\n                    	<a href=\"https://layerslider.com/pricing/\" target=\"_blank\">Grab your discount</a>\n                    </div>\n				</div>\n			</div>\n		</div>\n		\";}s:11:\"min_version\";s:0:\"\";s:11:\"max_version\";s:0:\"\";s:11:\"unactivated\";b:0;s:10:\"url_filter\";s:11:\"layerslider\";}s:14:\"_not_activated\";b:1;s:16:\"_sub_deactivated\";b:0;s:7:\"checked\";i:1686141541;}","yes"),
("423","ls-latest-version","7.7.7","yes"),
("424","ls-p-url","https://layerslider.com/pricing/","yes"),
("452","itsec-storage","a:8:{s:6:\"global\";a:35:{s:15:\"lockout_message\";s:5:\"error\";s:20:\"user_lockout_message\";s:64:\"You have been locked out due to too many invalid login attempts.\";s:25:\"community_lockout_message\";s:77:\"Your IP address has been flagged as a threat by the iThemes Security network.\";s:9:\"blacklist\";b:1;s:15:\"blacklist_count\";i:3;s:16:\"blacklist_period\";i:7;s:14:\"lockout_period\";i:15;s:18:\"lockout_white_list\";a:0:{}s:12:\"log_rotation\";i:60;s:17:\"file_log_rotation\";i:180;s:8:\"log_type\";s:8:\"database\";s:12:\"log_location\";s:71:\"/home2/mercifulg6281/public_html/cms/images/files/ithemes-security/logs\";s:8:\"log_info\";s:0:\"\";s:14:\"allow_tracking\";b:0;s:11:\"write_files\";b:1;s:10:\"nginx_file\";s:47:\"/home2/mercifulg6281/public_html/cms/nginx.conf\";s:24:\"infinitewp_compatibility\";b:0;s:11:\"did_upgrade\";b:0;s:9:\"lock_file\";b:0;s:5:\"proxy\";s:14:\"security-check\";s:12:\"proxy_header\";s:20:\"HTTP_X_FORWARDED_FOR\";s:14:\"hide_admin_bar\";b:0;s:16:\"show_error_codes\";b:0;s:19:\"show_security_check\";b:0;s:5:\"build\";i:4119;s:13:\"initial_build\";i:4119;s:20:\"activation_timestamp\";i:1601899411;s:11:\"cron_status\";i:0;s:8:\"use_cron\";b:0;s:14:\"cron_test_time\";i:1608320092;s:19:\"enable_grade_report\";b:0;s:10:\"server_ips\";a:1:{i:0;s:14:\"103.21.182.249\";}s:13:\"feature_flags\";a:0:{}s:12:\"manage_group\";a:0:{}s:24:\"licensed_hostname_prompt\";b:0;}s:11:\"user-groups\";a:1:{s:14:\"default_groups\";a:5:{s:13:\"administrator\";s:36:\"4facac3a-9813-4cb3-a03d-c01f1852330e\";s:6:\"editor\";s:36:\"2b8841cb-3a5a-4913-a30e-448b049fcfbc\";s:6:\"author\";s:36:\"d0367d8d-f6a2-4c0b-8349-1a01aa7d57d2\";s:11:\"contributor\";s:36:\"86361ca0-58ec-4a3b-a89b-b555fc37c50c\";s:10:\"subscriber\";s:36:\"ddbf4674-926c-4ef7-92e8-2ce515a8da0d\";}}s:18:\"security-check-pro\";a:6:{s:19:\"last_scan_timestamp\";i:1604243373;s:15:\"remote_ip_index\";s:11:\"REMOTE_ADDR\";s:13:\"ssl_supported\";b:1;s:20:\"remote_ips_timestamp\";i:1604243373;s:10:\"remote_ips\";a:2:{i:0;s:12:\"69.16.197.31\";i:1;s:14:\"69.167.144.232\";}s:8:\"key_salt\";s:60:\"<!O^YLH_$wW<AN}0=U1T.LPdLX5Se:Mt+J*?$Yx$uxoE8O{:!JYISoO-)>=d\";}s:21:\"password-requirements\";a:2:{s:20:\"requirement_settings\";a:1:{s:8:\"strength\";a:1:{s:5:\"group\";a:6:{i:0;s:36:\"2b8841cb-3a5a-4913-a30e-448b049fcfbc\";i:1;s:36:\"4facac3a-9813-4cb3-a03d-c01f1852330e\";i:2;s:36:\"86361ca0-58ec-4a3b-a89b-b555fc37c50c\";i:3;s:36:\"d0367d8d-f6a2-4c0b-8349-1a01aa7d57d2\";i:4;s:36:\"ddbf4674-926c-4ef7-92e8-2ce515a8da0d\";i:5;s:14:\"everybody-else\";}}}s:20:\"enabled_requirements\";a:1:{s:8:\"strength\";b:0;}}s:16:\"wordpress-tweaks\";a:13:{s:11:\"file_editor\";b:1;s:14:\"disable_xmlrpc\";i:2;s:22:\"allow_xmlrpc_multiauth\";b:0;s:8:\"rest_api\";s:15:\"restrict-access\";s:12:\"login_errors\";b:1;s:21:\"force_unique_nicename\";b:1;s:27:\"disable_unused_author_pages\";b:1;s:16:\"block_tabnapping\";b:1;s:21:\"valid_user_login_type\";s:4:\"both\";s:26:\"patch_thumb_file_traversal\";b:1;s:18:\"wlwmanifest_header\";b:0;s:14:\"edituri_header\";b:0;s:12:\"comment_spam\";b:0;}s:19:\"network-brute-force\";a:5:{s:7:\"api_key\";s:32:\"73efP0fm37J3V2Ocll7u2KLdTd71Vwn9\";s:10:\"api_secret\";s:128:\"RrP02f2WUL9HMO1BDeXgYwa9W4gGGRc6xb6WnEdDASs64rJzMvpDsy9Ydi1qXsB03F0Yu2r4S5HTWbw4Mbh42383s8cJbzDbQ3lJPjMo2p6HlQK5d5yJA4I44dXXc00Q\";s:10:\"enable_ban\";b:1;s:13:\"updates_optin\";b:0;s:7:\"api_nag\";b:0;}s:12:\"hide-backend\";a:6:{s:7:\"enabled\";b:1;s:4:\"slug\";s:3:\"cps\";s:12:\"theme_compat\";b:1;s:17:\"theme_compat_slug\";s:9:\"not_found\";s:16:\"post_logout_slug\";s:0:\"\";s:8:\"register\";s:13:\"wp-signup.php\";}s:19:\"notification-center\";a:8:{s:9:\"last_sent\";a:1:{s:6:\"digest\";i:1608280971;}s:9:\"resend_at\";a:0:{}s:4:\"data\";a:1:{s:6:\"digest\";a:0:{}}s:15:\"last_mail_error\";s:0:\"\";s:13:\"notifications\";a:4:{s:6:\"digest\";a:5:{s:8:\"schedule\";s:5:\"daily\";s:7:\"enabled\";b:1;s:9:\"user_list\";a:1:{i:0;s:18:\"role:administrator\";}s:14:\"recipient_type\";s:7:\"default\";s:7:\"subject\";N;}s:7:\"lockout\";a:4:{s:7:\"enabled\";b:1;s:9:\"user_list\";a:1:{i:0;s:18:\"role:administrator\";}s:14:\"recipient_type\";s:7:\"default\";s:7:\"subject\";N;}s:6:\"backup\";a:2:{s:10:\"email_list\";a:1:{i:0;s:17:\"info@deoworkz.net\";}s:7:\"subject\";N;}s:12:\"hide-backend\";a:4:{s:9:\"user_list\";a:1:{i:0;s:18:\"role:administrator\";}s:14:\"recipient_type\";s:7:\"default\";s:7:\"subject\";N;s:7:\"message\";s:0:\"\";}}s:12:\"admin_emails\";a:0:{}s:10:\"from_email\";s:0:\"\";s:18:\"default_recipients\";a:1:{s:9:\"user_list\";a:1:{i:0;s:18:\"role:administrator\";}}}}","yes");

INSERT IGNORE INTO `wpxd_options` VALUES 
("454","wordfence_version","7.9.3","yes"),
("455","wordfence_case","1","yes"),
("456","wordfence_installed","1","yes"),
("457","wordfenceActivated","1","yes"),
("458","wf_plugin_act_error","","yes"),
("459","wp_mail_smtp_initial_version","2.4.0","no"),
("460","wp_mail_smtp_version","3.8.0","no"),
("461","wp_mail_smtp","a:8:{s:4:\"mail\";a:6:{s:10:\"from_email\";s:25:\"info@mercifulwaygroup.com\";s:9:\"from_name\";s:20:\"MercifulWayGroup.com\";s:6:\"mailer\";s:4:\"mail\";s:11:\"return_path\";b:0;s:16:\"from_email_force\";b:1;s:15:\"from_name_force\";b:1;}s:4:\"smtp\";a:7:{s:7:\"autotls\";s:3:\"yes\";s:4:\"auth\";s:3:\"yes\";s:4:\"host\";s:0:\"\";s:10:\"encryption\";s:4:\"none\";s:4:\"port\";s:0:\"\";s:4:\"user\";s:0:\"\";s:4:\"pass\";s:0:\"\";}s:7:\"smtpcom\";a:2:{s:7:\"api_key\";s:0:\"\";s:7:\"channel\";s:0:\"\";}s:10:\"sendinblue\";a:1:{s:7:\"api_key\";s:0:\"\";}s:7:\"mailgun\";a:3:{s:7:\"api_key\";s:0:\"\";s:6:\"domain\";s:0:\"\";s:6:\"region\";s:2:\"US\";}s:8:\"sendgrid\";a:1:{s:7:\"api_key\";s:0:\"\";}s:5:\"gmail\";a:2:{s:9:\"client_id\";s:0:\"\";s:13:\"client_secret\";s:0:\"\";}s:7:\"general\";a:1:{s:29:\"summary_report_email_disabled\";b:1;}}","no"),
("462","wp_mail_smtp_activated_time","1601899418","no"),
("463","wp_mail_smtp_activated","a:1:{s:4:\"lite\";i:1601899418;}","yes"),
("464","dbmanager_options","a:16:{s:13:\"mysqldumppath\";s:18:\"/usr/bin/mysqldump\";s:9:\"mysqlpath\";s:14:\"/usr/bin/mysql\";s:4:\"path\";s:57:\"/home2/mercifulg6281/public_html/cms/wp-content/backup-db\";s:10:\"max_backup\";i:10;s:6:\"backup\";i:1;s:11:\"backup_gzip\";i:0;s:13:\"backup_period\";i:604800;s:12:\"backup_email\";s:17:\"info@deoworkz.net\";s:17:\"backup_email_from\";s:17:\"info@deoworkz.net\";s:22:\"backup_email_from_name\";s:32:\"Merciful Way Group Administrator\";s:20:\"backup_email_subject\";s:62:\"%SITE_NAME% Database Backup File For %POST_DATE% @ %POST_TIME%\";s:8:\"optimize\";i:3;s:15:\"optimize_period\";i:86400;s:6:\"repair\";i:2;s:13:\"repair_period\";i:604800;s:18:\"hide_admin_notices\";i:0;}","yes"),
("465","tadv_settings","a:10:{s:7:\"options\";s:44:\"menubar,advlist,menubar_block,merge_toolbars\";s:7:\"plugins\";s:104:\"anchor,code,insertdatetime,nonbreaking,print,searchreplace,table,visualblocks,visualchars,advlist,wptadv\";s:9:\"toolbar_1\";s:106:\"formatselect,bold,italic,blockquote,bullist,numlist,alignleft,aligncenter,alignright,link,unlink,undo,redo\";s:9:\"toolbar_2\";s:103:\"fontselect,fontsizeselect,outdent,indent,pastetext,removeformat,charmap,wp_more,forecolor,table,wp_help\";s:9:\"toolbar_3\";s:0:\"\";s:9:\"toolbar_4\";s:0:\"\";s:21:\"toolbar_classic_block\";s:123:\"formatselect,bold,italic,blockquote,bullist,numlist,alignleft,aligncenter,alignright,link,forecolor,backcolor,table,wp_help\";s:13:\"toolbar_block\";s:67:\"core/code,core/image,core/strikethrough,tadv/mark,tadv/removeformat\";s:18:\"toolbar_block_side\";s:46:\"core/superscript,core/subscript,core/underline\";s:12:\"panels_block\";s:44:\"tadv/color-panel,tadv/background-color-panel\";}","yes"),
("466","tadv_admin_settings","a:1:{s:7:\"options\";s:86:\"classic_paragraph_block,table_resize_bars,table_grid,table_tab_navigation,table_advtab\";}","yes"),
("467","tadv_version","5900","yes"),
("470","itsec_temp_whitelist_ip","a:2:{s:14:\"103.21.182.249\";i:1602119893;s:14:\"113.210.93.110\";i:1602138024;}","no"),
("471","action_scheduler_hybrid_store_demarkation","7","yes"),
("472","schema-ActionScheduler_StoreSchema","6.0.1666336648","yes"),
("473","schema-ActionScheduler_LoggerSchema","3.0.1666336648","yes"),
("475","wp_mail_smtp_migration_version","5","yes"),
("478","wp_mail_smtp_review_notice","a:2:{s:4:\"time\";i:1601899423;s:9:\"dismissed\";b:0;}","yes"),
("479","action_scheduler_lock_async-request-runner","1686141656","yes"),
("483","insert-headers-and-footers_welcome_dismissed_key","1","yes"),
("484","itsec_active_modules","a:9:{s:9:\"ban-users\";b:1;s:6:\"backup\";b:1;s:11:\"brute-force\";b:1;s:19:\"network-brute-force\";b:1;s:16:\"wordpress-tweaks\";b:1;s:18:\"security-check-pro\";b:1;s:3:\"ssl\";b:1;s:13:\"404-detection\";b:1;s:13:\"system-tweaks\";b:1;}","yes"),
("487","wp_mail_smtp_debug","a:0:{}","no"),
("488","itsec_dismissed_notices","a:1:{i:0;s:20:\"release-site-scanner\";}","no"),
("492","wp_mail_smtp_notifications","a:4:{s:6:\"update\";i:1686137184;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:1:{i:0;s:2:\"29\";}}","yes"),
("556","wordfence_syncAttackDataAttempts","0","no"),
("557","wordfence_syncingAttackData","0","no"),
("559","wordfence_lastSyncAttackData","1686094986","no"),
("595","avada_disable_encoding","1","yes"),
("615","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","yes"),
("811","widget_fbw_id","a:2:{i:2;a:24:{s:17:\"data_small_header\";s:0:\"\";s:26:\"data_adapt_container_width\";s:0:\"\";s:15:\"data_hide_cover\";s:0:\"\";s:18:\"data_show_facepile\";s:2:\"on\";s:15:\"data_show_posts\";s:2:\"on\";s:9:\"data_tabs\";s:8:\"timeline\";s:5:\"title\";s:8:\"FACEBOOK\";s:6:\"app_id\";s:0:\"\";s:6:\"fb_url\";s:36:\"https://www.facebook.com/mercifulway\";s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:10:\"custom_css\";s:0:\"\";s:10:\"select_lng\";s:5:\"en_US\";s:20:\"fusion_display_title\";s:3:\"yes\";s:20:\"fusion_padding_color\";s:0:\"\";s:13:\"fusion_margin\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:5:\"solid\";s:19:\"fusion_border_color\";s:0:\"\";s:20:\"fusion_divider_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("812","fb-widget-activation-date","1601955884","no"),
("959","ninja_forms_oauth_client_secret","MF16u8HF4iwbUgUWTwSgrFu6ZVVC91oDzyeYXSJL","yes"),
("960","ninja_forms_version","3.6.24","yes"),
("961","ninja_forms_db_version","1.4","no"),
("962","ninja_forms_required_updates","a:6:{s:19:\"CacheCollateActions\";s:19:\"2020-10-06 04:05:10\";s:17:\"CacheCollateForms\";s:19:\"2020-10-06 04:05:10\";s:18:\"CacheCollateFields\";s:19:\"2020-10-06 04:05:10\";s:19:\"CacheCollateObjects\";s:19:\"2020-10-06 04:05:10\";s:19:\"CacheCollateCleanup\";s:19:\"2020-10-06 04:05:10\";s:25:\"CacheFieldReconcilliation\";s:19:\"2020-10-06 04:05:10\";}","yes"),
("963","ninja_forms_settings","a:11:{s:11:\"date_format\";s:5:\"m/d/Y\";s:8:\"currency\";s:3:\"USD\";s:18:\"recaptcha_site_key\";s:0:\"\";s:20:\"recaptcha_secret_key\";s:0:\"\";s:14:\"recaptcha_lang\";s:0:\"\";s:19:\"delete_on_uninstall\";i:0;s:21:\"disable_admin_notices\";i:0;s:16:\"builder_dev_mode\";i:0;s:18:\"opinionated_styles\";s:5:\"light\";s:20:\"recaptcha_site_key_3\";s:0:\"\";s:22:\"recaptcha_secret_key_3\";s:0:\"\";}","yes"),
("964","ninja_forms_zuul","34","no"),
("965","wp_nf_update_fields_batch_5a78c1e112a0fb4cfcbc3ca1154f2fad","a:4:{i:0;a:2:{s:2:\"id\";i:1;s:8:\"settings\";a:70:{s:5:\"label\";s:4:\"Name\";s:3:\"key\";s:4:\"name\";s:9:\"parent_id\";i:1;s:4:\"type\";s:7:\"textbox\";s:10:\"created_at\";s:19:\"2020-10-06 12:05:11\";s:9:\"label_pos\";s:5:\"above\";s:8:\"required\";s:1:\"1\";s:5:\"order\";s:1:\"1\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"wrapper_class\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:10:\"objectType\";s:5:\"Field\";s:12:\"objectDomain\";s:6:\"fields\";s:10:\"editActive\";s:0:\"\";s:15:\"container_class\";s:0:\"\";s:11:\"input_limit\";s:0:\"\";s:16:\"input_limit_type\";s:10:\"characters\";s:15:\"input_limit_msg\";s:17:\"Character(s) left\";s:10:\"manual_key\";s:0:\"\";s:13:\"disable_input\";s:0:\"\";s:11:\"admin_label\";s:0:\"\";s:9:\"help_text\";s:0:\"\";s:9:\"desc_text\";s:0:\"\";s:28:\"disable_browser_autocomplete\";s:0:\"\";s:4:\"mask\";s:0:\"\";s:11:\"custom_mask\";s:0:\"\";s:28:\"wrap_styles_background-color\";s:0:\"\";s:18:\"wrap_styles_border\";s:0:\"\";s:24:\"wrap_styles_border-style\";s:0:\"\";s:24:\"wrap_styles_border-color\";s:0:\"\";s:17:\"wrap_styles_color\";s:0:\"\";s:18:\"wrap_styles_height\";s:0:\"\";s:17:\"wrap_styles_width\";s:0:\"\";s:21:\"wrap_styles_font-size\";s:0:\"\";s:18:\"wrap_styles_margin\";s:0:\"\";s:19:\"wrap_styles_padding\";s:0:\"\";s:19:\"wrap_styles_display\";s:0:\"\";s:17:\"wrap_styles_float\";s:0:\"\";s:29:\"wrap_styles_show_advanced_css\";s:1:\"0\";s:20:\"wrap_styles_advanced\";s:0:\"\";s:29:\"label_styles_background-color\";s:0:\"\";s:19:\"label_styles_border\";s:0:\"\";s:25:\"label_styles_border-style\";s:0:\"\";s:25:\"label_styles_border-color\";s:0:\"\";s:18:\"label_styles_color\";s:0:\"\";s:19:\"label_styles_height\";s:0:\"\";s:18:\"label_styles_width\";s:0:\"\";s:22:\"label_styles_font-size\";s:0:\"\";s:19:\"label_styles_margin\";s:0:\"\";s:20:\"label_styles_padding\";s:0:\"\";s:20:\"label_styles_display\";s:0:\"\";s:18:\"label_styles_float\";s:0:\"\";s:30:\"label_styles_show_advanced_css\";s:1:\"0\";s:21:\"label_styles_advanced\";s:0:\"\";s:31:\"element_styles_background-color\";s:0:\"\";s:21:\"element_styles_border\";s:0:\"\";s:27:\"element_styles_border-style\";s:0:\"\";s:27:\"element_styles_border-color\";s:0:\"\";s:20:\"element_styles_color\";s:0:\"\";s:21:\"element_styles_height\";s:0:\"\";s:20:\"element_styles_width\";s:0:\"\";s:24:\"element_styles_font-size\";s:0:\"\";s:21:\"element_styles_margin\";s:0:\"\";s:22:\"element_styles_padding\";s:0:\"\";s:22:\"element_styles_display\";s:0:\"\";s:20:\"element_styles_float\";s:0:\"\";s:32:\"element_styles_show_advanced_css\";s:1:\"0\";s:23:\"element_styles_advanced\";s:0:\"\";s:7:\"cellcid\";s:5:\"c3277\";}}i:1;a:2:{s:2:\"id\";i:2;s:8:\"settings\";a:62:{s:5:\"label\";s:5:\"Email\";s:3:\"key\";s:5:\"email\";s:9:\"parent_id\";i:1;s:4:\"type\";s:5:\"email\";s:10:\"created_at\";s:19:\"2020-10-06 12:05:11\";s:9:\"label_pos\";s:5:\"above\";s:8:\"required\";s:1:\"1\";s:5:\"order\";s:1:\"2\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"wrapper_class\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:10:\"objectType\";s:5:\"Field\";s:12:\"objectDomain\";s:6:\"fields\";s:10:\"editActive\";s:0:\"\";s:15:\"container_class\";s:0:\"\";s:11:\"admin_label\";s:0:\"\";s:9:\"help_text\";s:0:\"\";s:9:\"desc_text\";s:0:\"\";s:28:\"wrap_styles_background-color\";s:0:\"\";s:18:\"wrap_styles_border\";s:0:\"\";s:24:\"wrap_styles_border-style\";s:0:\"\";s:24:\"wrap_styles_border-color\";s:0:\"\";s:17:\"wrap_styles_color\";s:0:\"\";s:18:\"wrap_styles_height\";s:0:\"\";s:17:\"wrap_styles_width\";s:0:\"\";s:21:\"wrap_styles_font-size\";s:0:\"\";s:18:\"wrap_styles_margin\";s:0:\"\";s:19:\"wrap_styles_padding\";s:0:\"\";s:19:\"wrap_styles_display\";s:0:\"\";s:17:\"wrap_styles_float\";s:0:\"\";s:29:\"wrap_styles_show_advanced_css\";s:1:\"0\";s:20:\"wrap_styles_advanced\";s:0:\"\";s:29:\"label_styles_background-color\";s:0:\"\";s:19:\"label_styles_border\";s:0:\"\";s:25:\"label_styles_border-style\";s:0:\"\";s:25:\"label_styles_border-color\";s:0:\"\";s:18:\"label_styles_color\";s:0:\"\";s:19:\"label_styles_height\";s:0:\"\";s:18:\"label_styles_width\";s:0:\"\";s:22:\"label_styles_font-size\";s:0:\"\";s:19:\"label_styles_margin\";s:0:\"\";s:20:\"label_styles_padding\";s:0:\"\";s:20:\"label_styles_display\";s:0:\"\";s:18:\"label_styles_float\";s:0:\"\";s:30:\"label_styles_show_advanced_css\";s:1:\"0\";s:21:\"label_styles_advanced\";s:0:\"\";s:31:\"element_styles_background-color\";s:0:\"\";s:21:\"element_styles_border\";s:0:\"\";s:27:\"element_styles_border-style\";s:0:\"\";s:27:\"element_styles_border-color\";s:0:\"\";s:20:\"element_styles_color\";s:0:\"\";s:21:\"element_styles_height\";s:0:\"\";s:20:\"element_styles_width\";s:0:\"\";s:24:\"element_styles_font-size\";s:0:\"\";s:21:\"element_styles_margin\";s:0:\"\";s:22:\"element_styles_padding\";s:0:\"\";s:22:\"element_styles_display\";s:0:\"\";s:20:\"element_styles_float\";s:0:\"\";s:32:\"element_styles_show_advanced_css\";s:1:\"0\";s:23:\"element_styles_advanced\";s:0:\"\";s:7:\"cellcid\";s:5:\"c3281\";}}i:2;a:2:{s:2:\"id\";i:3;s:8:\"settings\";a:71:{s:5:\"label\";s:7:\"Message\";s:3:\"key\";s:7:\"message\";s:9:\"parent_id\";i:1;s:4:\"type\";s:8:\"textarea\";s:10:\"created_at\";s:19:\"2020-10-06 12:05:11\";s:9:\"label_pos\";s:5:\"above\";s:8:\"required\";s:1:\"1\";s:5:\"order\";s:1:\"3\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"wrapper_class\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:10:\"objectType\";s:5:\"Field\";s:12:\"objectDomain\";s:6:\"fields\";s:10:\"editActive\";s:0:\"\";s:15:\"container_class\";s:0:\"\";s:11:\"input_limit\";s:0:\"\";s:16:\"input_limit_type\";s:10:\"characters\";s:15:\"input_limit_msg\";s:17:\"Character(s) left\";s:10:\"manual_key\";s:0:\"\";s:13:\"disable_input\";s:0:\"\";s:11:\"admin_label\";s:0:\"\";s:9:\"help_text\";s:0:\"\";s:9:\"desc_text\";s:0:\"\";s:28:\"disable_browser_autocomplete\";s:0:\"\";s:12:\"textarea_rte\";s:0:\"\";s:18:\"disable_rte_mobile\";s:0:\"\";s:14:\"textarea_media\";s:0:\"\";s:28:\"wrap_styles_background-color\";s:0:\"\";s:18:\"wrap_styles_border\";s:0:\"\";s:24:\"wrap_styles_border-style\";s:0:\"\";s:24:\"wrap_styles_border-color\";s:0:\"\";s:17:\"wrap_styles_color\";s:0:\"\";s:18:\"wrap_styles_height\";s:0:\"\";s:17:\"wrap_styles_width\";s:0:\"\";s:21:\"wrap_styles_font-size\";s:0:\"\";s:18:\"wrap_styles_margin\";s:0:\"\";s:19:\"wrap_styles_padding\";s:0:\"\";s:19:\"wrap_styles_display\";s:0:\"\";s:17:\"wrap_styles_float\";s:0:\"\";s:29:\"wrap_styles_show_advanced_css\";s:1:\"0\";s:20:\"wrap_styles_advanced\";s:0:\"\";s:29:\"label_styles_background-color\";s:0:\"\";s:19:\"label_styles_border\";s:0:\"\";s:25:\"label_styles_border-style\";s:0:\"\";s:25:\"label_styles_border-color\";s:0:\"\";s:18:\"label_styles_color\";s:0:\"\";s:19:\"label_styles_height\";s:0:\"\";s:18:\"label_styles_width\";s:0:\"\";s:22:\"label_styles_font-size\";s:0:\"\";s:19:\"label_styles_margin\";s:0:\"\";s:20:\"label_styles_padding\";s:0:\"\";s:20:\"label_styles_display\";s:0:\"\";s:18:\"label_styles_float\";s:0:\"\";s:30:\"label_styles_show_advanced_css\";s:1:\"0\";s:21:\"label_styles_advanced\";s:0:\"\";s:31:\"element_styles_background-color\";s:0:\"\";s:21:\"element_styles_border\";s:0:\"\";s:27:\"element_styles_border-style\";s:0:\"\";s:27:\"element_styles_border-color\";s:0:\"\";s:20:\"element_styles_color\";s:0:\"\";s:21:\"element_styles_height\";s:0:\"\";s:20:\"element_styles_width\";s:0:\"\";s:24:\"element_styles_font-size\";s:0:\"\";s:21:\"element_styles_margin\";s:0:\"\";s:22:\"element_styles_padding\";s:0:\"\";s:22:\"element_styles_display\";s:0:\"\";s:20:\"element_styles_float\";s:0:\"\";s:32:\"element_styles_show_advanced_css\";s:1:\"0\";s:23:\"element_styles_advanced\";s:0:\"\";s:7:\"cellcid\";s:5:\"c3284\";}}i:3;a:2:{s:2:\"id\";i:4;s:8:\"settings\";a:69:{s:5:\"label\";s:6:\"Submit\";s:3:\"key\";s:6:\"submit\";s:9:\"parent_id\";i:1;s:4:\"type\";s:6:\"submit\";s:10:\"created_at\";s:19:\"2020-10-06 12:05:11\";s:16:\"processing_label\";s:10:\"Processing\";s:5:\"order\";s:1:\"5\";s:10:\"objectType\";s:5:\"Field\";s:12:\"objectDomain\";s:6:\"fields\";s:10:\"editActive\";s:0:\"\";s:15:\"container_class\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:28:\"wrap_styles_background-color\";s:0:\"\";s:18:\"wrap_styles_border\";s:0:\"\";s:24:\"wrap_styles_border-style\";s:0:\"\";s:24:\"wrap_styles_border-color\";s:0:\"\";s:17:\"wrap_styles_color\";s:0:\"\";s:18:\"wrap_styles_height\";s:0:\"\";s:17:\"wrap_styles_width\";s:0:\"\";s:21:\"wrap_styles_font-size\";s:0:\"\";s:18:\"wrap_styles_margin\";s:0:\"\";s:19:\"wrap_styles_padding\";s:0:\"\";s:19:\"wrap_styles_display\";s:0:\"\";s:17:\"wrap_styles_float\";s:0:\"\";s:29:\"wrap_styles_show_advanced_css\";s:1:\"0\";s:20:\"wrap_styles_advanced\";s:0:\"\";s:29:\"label_styles_background-color\";s:0:\"\";s:19:\"label_styles_border\";s:0:\"\";s:25:\"label_styles_border-style\";s:0:\"\";s:25:\"label_styles_border-color\";s:0:\"\";s:18:\"label_styles_color\";s:0:\"\";s:19:\"label_styles_height\";s:0:\"\";s:18:\"label_styles_width\";s:0:\"\";s:22:\"label_styles_font-size\";s:0:\"\";s:19:\"label_styles_margin\";s:0:\"\";s:20:\"label_styles_padding\";s:0:\"\";s:20:\"label_styles_display\";s:0:\"\";s:18:\"label_styles_float\";s:0:\"\";s:30:\"label_styles_show_advanced_css\";s:1:\"0\";s:21:\"label_styles_advanced\";s:0:\"\";s:31:\"element_styles_background-color\";s:0:\"\";s:21:\"element_styles_border\";s:0:\"\";s:27:\"element_styles_border-style\";s:0:\"\";s:27:\"element_styles_border-color\";s:0:\"\";s:20:\"element_styles_color\";s:0:\"\";s:21:\"element_styles_height\";s:0:\"\";s:20:\"element_styles_width\";s:0:\"\";s:24:\"element_styles_font-size\";s:0:\"\";s:21:\"element_styles_margin\";s:0:\"\";s:22:\"element_styles_padding\";s:0:\"\";s:22:\"element_styles_display\";s:0:\"\";s:20:\"element_styles_float\";s:0:\"\";s:32:\"element_styles_show_advanced_css\";s:1:\"0\";s:23:\"element_styles_advanced\";s:0:\"\";s:44:\"submit_element_hover_styles_background-color\";s:0:\"\";s:34:\"submit_element_hover_styles_border\";s:0:\"\";s:40:\"submit_element_hover_styles_border-style\";s:0:\"\";s:40:\"submit_element_hover_styles_border-color\";s:0:\"\";s:33:\"submit_element_hover_styles_color\";s:0:\"\";s:34:\"submit_element_hover_styles_height\";s:0:\"\";s:33:\"submit_element_hover_styles_width\";s:0:\"\";s:37:\"submit_element_hover_styles_font-size\";s:0:\"\";s:34:\"submit_element_hover_styles_margin\";s:0:\"\";s:35:\"submit_element_hover_styles_padding\";s:0:\"\";s:35:\"submit_element_hover_styles_display\";s:0:\"\";s:33:\"submit_element_hover_styles_float\";s:0:\"\";s:45:\"submit_element_hover_styles_show_advanced_css\";s:1:\"0\";s:36:\"submit_element_hover_styles_advanced\";s:0:\"\";s:7:\"cellcid\";s:5:\"c3287\";}}}","no"),
("967","widget_ninja_forms_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("968","ninja-forms-views-secret","95HGkADevfjZRtQ4wv8QukMbt3GZ6PYO2ATMqscU","yes"),
("969","ninja_forms_needs_updates","0","yes"),
("970","nf_admin_notice","a:1:{s:16:\"one_week_support\";a:3:{s:5:\"start\";s:10:\"10/13/2020\";s:3:\"int\";i:7;s:9:\"dismissed\";i:1;}}","yes"),
("971","nf_form_tel_data","1,2","no"),
("972","ninja_forms_do_not_allow_tracking","1","yes"),
("973","ninja_forms_optin_reported","1","yes"),
("976","nf_sub_expiration","a:0:{}","yes"),
("1153","ls-store-last-updated","1654746430","yes"),
("1154","ls-store-data","a:5:{s:12:\"last_updated\";s:10:\"2022-05-02\";s:7:\"sliders\";a:102:{s:14:\"save-the-world\";a:7:{s:8:\"released\";s:10:\"2022-05-02\";s:4:\"name\";s:14:\"Save the World\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.2.1\";s:6:\"groups\";s:49:\"new,premium,sliders,specialeffects,static,landing\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/save-the-world/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/save-the-world.jpg\";}s:7:\"new-era\";a:7:{s:8:\"released\";s:10:\"2022-04-21\";s:4:\"name\";s:7:\"New Era\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.2.0\";s:6:\"groups\";s:64:\"new,premium,sliders,specialeffects,parallax,loop,fullwidth,blend\";s:3:\"url\";s:40:\"https://layerslider.com/sliders/new-era/\";s:7:\"preview\";s:68:\"https://repository.kreaturamedia.com/v4/sliders/packages/new-era.jpg\";}s:15:\"virtual-reality\";a:7:{s:8:\"released\";s:10:\"2022-03-21\";s:4:\"name\";s:15:\"Virtual Reality\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.0.8\";s:6:\"groups\";s:53:\"new,premium,sliders,specialeffects,parallax,loop,text\";s:3:\"url\";s:48:\"https://layerslider.com/sliders/virtual-reality/\";s:7:\"preview\";s:76:\"https://repository.kreaturamedia.com/v4/sliders/packages/virtual-reality.jpg\";}s:12:\"fruit-juices\";a:7:{s:8:\"released\";s:10:\"2022-02-21\";s:4:\"name\";s:12:\"Fruit Juices\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.0.8\";s:6:\"groups\";s:43:\"new,premium,sliders,specialeffects,parallax\";s:3:\"url\";s:45:\"https://layerslider.com/sliders/fruit-juices/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/fruit-juices.jpg\";}s:12:\"before-after\";a:7:{s:8:\"released\";s:10:\"2022-02-14\";s:4:\"name\";s:14:\"Before | After\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.0.8\";s:6:\"groups\";s:36:\"new,premium,sliders,experiments,text\";s:3:\"url\";s:45:\"https://layerslider.com/sliders/before-after/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/before-after.jpg\";}s:16:\"panoramic-slider\";a:7:{s:8:\"released\";s:10:\"2022-02-08\";s:4:\"name\";s:16:\"Panoramic Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.0.7\";s:6:\"groups\";s:19:\"new,premium,sliders\";s:3:\"url\";s:49:\"https://layerslider.com/sliders/panoramic-slider/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/panoramic-slider.jpg\";}s:20:\"modern-home-for-sale\";a:7:{s:8:\"released\";s:10:\"2022-01-25\";s:4:\"name\";s:20:\"Modern Home for Sale\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.0.7\";s:6:\"groups\";s:41:\"new,premium,sliders,text,landing,parallax\";s:3:\"url\";s:53:\"https://layerslider.com/sliders/modern-home-for-sale/\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/modern-home-for-sale.jpg\";}s:22:\"day-and-night-on-earth\";a:7:{s:8:\"released\";s:10:\"2022-01-17\";s:4:\"name\";s:22:\"Day and Night on Earth\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.0.7\";s:6:\"groups\";s:34:\"new,premium,sliders,specialeffects\";s:3:\"url\";s:55:\"https://layerslider.com/sliders/day-and-night-on-earth/\";s:7:\"preview\";s:83:\"https://repository.kreaturamedia.com/v4/sliders/packages/day-and-night-on-earth.jpg\";}s:16:\"cosmetics-slider\";a:7:{s:8:\"released\";s:10:\"2022-01-11\";s:4:\"name\";s:16:\"Cosmetics Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.0.7\";s:6:\"groups\";s:19:\"new,premium,sliders\";s:3:\"url\";s:49:\"https://layerslider.com/sliders/cosmetics-slider/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/cosmetics-slider.jpg\";}s:15:\"back-to-the-80s\";a:7:{s:8:\"released\";s:10:\"2020-09-29\";s:4:\"name\";s:15:\"Back To The 80s\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:50:\"premium,sliders,parallax,loop,blend,specialeffects\";s:3:\"url\";s:48:\"https://layerslider.com/sliders/back-to-the-80s/\";s:7:\"preview\";s:76:\"https://repository.kreaturamedia.com/v4/sliders/packages/back-to-the-80s.jpg\";}s:17:\"love-with-flowers\";a:7:{s:8:\"released\";s:10:\"2020-07-28\";s:4:\"name\";s:17:\"LOVE with Flowers\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:34:\"free,landing,sliders,parallax,loop\";s:3:\"url\";s:50:\"https://layerslider.com/sliders/love-with-flowers/\";s:7:\"preview\";s:78:\"https://repository.kreaturamedia.com/v4/sliders/packages/love-with-flowers.jpg\";}s:6:\"people\";a:7:{s:8:\"released\";s:10:\"2020-07-13\";s:4:\"name\";s:6:\"People\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:43:\"premium,landing,blend,static,specialeffects\";s:3:\"url\";s:39:\"https://layerslider.com/sliders/people/\";s:7:\"preview\";s:67:\"https://repository.kreaturamedia.com/v4/sliders/packages/people.jpg\";}s:16:\"music-is-my-life\";a:7:{s:8:\"released\";s:10:\"2020-07-06\";s:4:\"name\";s:16:\"Music Is My Life\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:20:\"premium,slider,blend\";s:3:\"url\";s:49:\"https://layerslider.com/sliders/music-is-my-life/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/music-is-my-life.jpg\";}s:21:\"product-showcase-dark\";a:7:{s:8:\"released\";s:10:\"2020-07-01\";s:4:\"name\";s:25:\"Product Showcase – Dark\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:14:\"premium,slider\";s:3:\"url\";s:54:\"https://layerslider.com/sliders/product-showcase-dark/\";s:7:\"preview\";s:82:\"https://repository.kreaturamedia.com/v4/sliders/packages/product-showcase-dark.jpg\";}s:13:\"team-showcase\";a:7:{s:8:\"released\";s:10:\"2020-06-24\";s:4:\"name\";s:13:\"Team Showcase\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:21:\"premium,slider,static\";s:3:\"url\";s:46:\"https://layerslider.com/sliders/team-showcase/\";s:7:\"preview\";s:74:\"https://repository.kreaturamedia.com/v4/sliders/packages/team-showcase.jpg\";}s:14:\"furniture-shop\";a:7:{s:8:\"released\";s:10:\"2020-06-09\";s:4:\"name\";s:14:\"Furniture Shop\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:23:\"premium,landing,website\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/furniture-shop/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/furniture-shop.jpg\";}s:14:\"product-banner\";a:7:{s:8:\"released\";s:10:\"2020-06-02\";s:4:\"name\";s:14:\"Product Banner\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:18:\"free,slider,static\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/product-banner/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/product-banner.jpg\";}s:19:\"architecture-slider\";a:7:{s:8:\"released\";s:10:\"2020-05-26\";s:4:\"name\";s:19:\"Architecture Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:18:\"free,slider,static\";s:3:\"url\";s:52:\"https://layerslider.com/sliders/architecture-slider/\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/architecture-slider.jpg\";}s:22:\"product-showcase-light\";a:7:{s:8:\"released\";s:10:\"2020-05-18\";s:4:\"name\";s:26:\"Product Showcase – Light\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:21:\"premium,slider,static\";s:3:\"url\";s:55:\"https://layerslider.com/sliders/product-showcase-light/\";s:7:\"preview\";s:83:\"https://repository.kreaturamedia.com/v4/sliders/packages/product-showcase-light.jpg\";}s:12:\"fashion-shop\";a:7:{s:8:\"released\";s:10:\"2020-05-12\";s:4:\"name\";s:12:\"Fashion Shop\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:18:\"free,slider,static\";s:3:\"url\";s:45:\"https://layerslider.com/sliders/fashion-shop/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/fashion-shop.jpg\";}s:12:\"pixel-agency\";a:7:{s:8:\"released\";s:10:\"2020-05-05\";s:4:\"name\";s:12:\"PIXEL Agency\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:51:\"premium,fullwidth,landing,website,text,popup,static\";s:3:\"url\";s:45:\"https://layerslider.com/sliders/pixel-agency/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/pixel-agency.jpg\";}s:11:\"mode-slider\";a:7:{s:8:\"released\";s:10:\"2020-04-28\";s:4:\"name\";s:11:\"Mode Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:26:\"free,fullwidth,slider,text\";s:3:\"url\";s:44:\"https://layerslider.com/sliders/mode-slider/\";s:7:\"preview\";s:72:\"https://repository.kreaturamedia.com/v4/sliders/packages/mode-slider.jpg\";}s:13:\"mountain-bike\";a:7:{s:8:\"released\";s:10:\"2020-04-22\";s:4:\"name\";s:13:\"Mountain Bike\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:41:\"premium,fullsize,landing,pack,static,text\";s:3:\"url\";s:46:\"https://layerslider.com/sliders/mountain-bike/\";s:7:\"preview\";s:74:\"https://repository.kreaturamedia.com/v4/sliders/packages/mountain-bike.jpg\";}s:18:\"aerial-photography\";a:7:{s:8:\"released\";s:10:\"2020-04-14\";s:4:\"name\";s:18:\"Aerial Photography\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:35:\"premium,slider,static,text,kenburns\";s:3:\"url\";s:51:\"https://layerslider.com/sliders/aerial-photography/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/aerial-photography.jpg\";}s:24:\"simple-fullscreen-slider\";a:7:{s:8:\"released\";s:10:\"2020-04-07\";s:4:\"name\";s:24:\"Simple Fullscreen Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:42:\"free,fullsize,landing,static,text,kenburns\";s:3:\"url\";s:57:\"https://layerslider.com/sliders/simple-fullscreen-slider/\";s:7:\"preview\";s:85:\"https://repository.kreaturamedia.com/v4/sliders/packages/simple-fullscreen-slider.jpg\";}s:21:\"covid-19-notification\";a:8:{s:8:\"released\";s:10:\"2020-04-01\";s:4:\"name\";s:21:\"COVID-19 Notification\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:13:\"premium,popup\";s:3:\"url\";s:53:\"https://layerslider.com/popups/#covid-19-notification\";s:7:\"preview\";s:82:\"https://repository.kreaturamedia.com/v4/sliders/packages/covid-19-notification.jpg\";}s:19:\"covid-19-bottom-bar\";a:8:{s:8:\"released\";s:10:\"2020-04-01\";s:4:\"name\";s:19:\"COVID-19 Bottom Bar\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:13:\"premium,popup\";s:3:\"url\";s:51:\"https://layerslider.com/popups/#covid-19-bottom-bar\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/covid-19-bottom-bar.jpg\";}s:14:\"top-bar-notice\";a:8:{s:8:\"released\";s:10:\"2020-04-01\";s:4:\"name\";s:14:\"Top Bar Notice\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:13:\"premium,popup\";s:3:\"url\";s:46:\"https://layerslider.com/popups/#top-bar-notice\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/top-bar-notice.jpg\";}s:20:\"christmas-snow-globe\";a:8:{s:8:\"released\";s:10:\"2019-12-19\";s:4:\"name\";s:20:\"Christmas Snow Globe\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:34:\"premium,parallax,popup,loop,filter\";s:3:\"url\";s:52:\"https://layerslider.com/popups/#christmas-snow-globe\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/christmas-snow-globe.jpg\";}s:9:\"xmas-2019\";a:7:{s:8:\"released\";s:10:\"2019-12-19\";s:4:\"name\";s:9:\"Xmas 2019\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:32:\"free,parallax,slider,loop,filter\";s:3:\"url\";s:42:\"https://layerslider.com/sliders/xmas-2019/\";s:7:\"preview\";s:70:\"https://repository.kreaturamedia.com/v4/sliders/packages/xmas-2019.jpg\";}s:18:\"creative-portraits\";a:7:{s:8:\"released\";s:10:\"2019-12-09\";s:4:\"name\";s:18:\"Creative Portraits\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:32:\"premium,fullwidth,landing,static\";s:3:\"url\";s:51:\"https://layerslider.com/sliders/creative-portraits/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/creative-portraits.jpg\";}s:13:\"parallax-city\";a:7:{s:8:\"released\";s:10:\"2019-12-02\";s:4:\"name\";s:13:\"Parallax City\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:58:\"premium,landing,pack,parallax,text,blend,fullwidth,website\";s:3:\"url\";s:46:\"https://layerslider.com/sliders/parallax-city/\";s:7:\"preview\";s:74:\"https://repository.kreaturamedia.com/v4/sliders/packages/parallax-city.jpg\";}s:10:\"cybertruck\";a:7:{s:8:\"released\";s:10:\"2019-11-28\";s:4:\"name\";s:10:\"Cybertruck\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:39:\"premium,fullsize,landing,specialeffects\";s:3:\"url\";s:43:\"https://layerslider.com/sliders/cybertruck/\";s:7:\"preview\";s:71:\"https://repository.kreaturamedia.com/v4/sliders/packages/cybertruck.jpg\";}s:17:\"summer-collection\";a:7:{s:8:\"released\";s:10:\"2019-11-21\";s:4:\"name\";s:17:\"Summer Collection\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:21:\"free,fullwidth,slider\";s:3:\"url\";s:50:\"https://layerslider.com/sliders/summer-collection/\";s:7:\"preview\";s:78:\"https://repository.kreaturamedia.com/v4/sliders/packages/summer-collection.jpg\";}s:18:\"nature-slider-pack\";a:7:{s:8:\"released\";s:10:\"2019-11-14\";s:4:\"name\";s:18:\"Nature Slider PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.9.0\";s:6:\"groups\";s:62:\"premium,text,blend,fullwidth,media,landing,packs,popup,website\";s:3:\"url\";s:51:\"https://layerslider.com/sliders/nature-slider-pack/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/nature-slider-pack.jpg\";}s:20:\"catering-xmas-slider\";a:7:{s:8:\"released\";s:10:\"2017-12-22\";s:4:\"name\";s:25:\"Catering Christmas Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:32:\"premium,static,text,blend,slider\";s:3:\"url\";s:58:\"https://layerslider.com/sliders/catering-christmas-slider/\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/catering-xmas-slider.jpg\";}s:20:\"discover-the-details\";a:7:{s:8:\"released\";s:10:\"2017-12-19\";s:4:\"name\";s:20:\"Discover the Details\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:50:\"free,loop,parallax,blendmode,specialeffects,slider\";s:3:\"url\";s:53:\"https://layerslider.com/sliders/discover-the-details/\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/discover-the-details.jpg\";}s:10:\"rainforest\";a:7:{s:8:\"released\";s:10:\"2017-12-17\";s:4:\"name\";s:10:\"Rainforest\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:57:\"free,loop,filter,blendmode,fullsize,specialeffects,slider\";s:3:\"url\";s:43:\"https://layerslider.com/sliders/rainforest/\";s:7:\"preview\";s:71:\"https://repository.kreaturamedia.com/v4/sliders/packages/rainforest.jpg\";}s:30:\"ecommerce-global-hover-example\";a:7:{s:8:\"released\";s:10:\"2017-12-15\";s:4:\"name\";s:30:\"eCommerce Global Hover Example\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:26:\"premium,experiments,slider\";s:3:\"url\";s:63:\"https://layerslider.com/sliders/ecommerce-global-hover-example/\";s:7:\"preview\";s:91:\"https://repository.kreaturamedia.com/v4/sliders/packages/ecommerce-global-hover-example.jpg\";}s:20:\"3d-canyon-experience\";a:7:{s:8:\"released\";s:10:\"2017-12-13\";s:4:\"name\";s:20:\"3D Canyon Experience\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:40:\"premium,parallax,experiments,text,slider\";s:3:\"url\";s:53:\"https://layerslider.com/sliders/3d-canyon-experience/\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/3d-canyon-experience.jpg\";}s:14:\"vintage-photos\";a:7:{s:8:\"released\";s:10:\"2017-12-08\";s:4:\"name\";s:14:\"Vintage Photos\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:50:\"premium,fullsize,loop,filter,specialeffects,slider\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/vintage-photos/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/vintage-photos.jpg\";}s:8:\"aquarium\";a:7:{s:8:\"released\";s:10:\"2017-12-04\";s:4:\"name\";s:8:\"Aquarium\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:71:\"premium,parallax,fullsize,loop,filter,experiments,specialeffects,slider\";s:3:\"url\";s:41:\"https://layerslider.com/sliders/aquarium/\";s:7:\"preview\";s:69:\"https://repository.kreaturamedia.com/v4/sliders/packages/aquarium.jpg\";}s:16:\"what-is-the-time\";a:7:{s:8:\"released\";s:10:\"2017-08-25\";s:4:\"name\";s:17:\"What is the time?\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:54:\"premium,parallax,text,blendmode,experiments,api,slider\";s:3:\"url\";s:49:\"https://layerslider.com/sliders/what-is-the-time/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/what-is-the-time.jpg\";}s:18:\"personal-page-pack\";a:7:{s:8:\"released\";s:10:\"2017-08-23\";s:4:\"name\";s:18:\"Personal Page PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:62:\"premium,fullsize,fullwidth,landing,text,parallax,packs,website\";s:3:\"url\";s:51:\"https://layerslider.com/sliders/personal-page-pack/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/personal-page-pack.jpg\";}s:19:\"marketing-page-pack\";a:7:{s:8:\"released\";s:10:\"2017-08-21\";s:4:\"name\";s:19:\"Marketing Page PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:69:\"premium,fullsize,fullwidth,landing,parallax,static,loop,packs,website\";s:3:\"url\";s:52:\"https://layerslider.com/sliders/marketing-page-pack/\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/marketing-page-pack.jpg\";}s:14:\"dynamic-slider\";a:7:{s:8:\"released\";s:10:\"2017-08-18\";s:4:\"name\";s:14:\"Dynamic Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:32:\"premium,fullwidth,landing,static\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/dynamic-slider/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/dynamic-slider.jpg\";}s:14:\"colorful-cases\";a:7:{s:8:\"released\";s:10:\"2017-08-16\";s:4:\"name\";s:14:\"Colorful Cases\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:50:\"premium,text,loop,parallax,static,blendmode,slider\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/colorful-cases/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/colorful-cases.jpg\";}s:16:\"beauty-shop-pack\";a:7:{s:8:\"released\";s:10:\"2017-08-14\";s:4:\"name\";s:16:\"Beauty Shop PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:44:\"premium,fullwidth,text,landing,packs,website\";s:3:\"url\";s:49:\"https://layerslider.com/sliders/beauty-shop-pack/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/beauty-shop-pack.jpg\";}s:14:\"discount-popup\";a:8:{s:8:\"released\";s:10:\"2017-12-10\";s:4:\"name\";s:14:\"Discount Popup\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:13:\"premium,popup\";s:3:\"url\";s:46:\"https://layerslider.com/popups/#discount-popup\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/discount-popup.jpg\";}s:18:\"social-share-popup\";a:8:{s:8:\"released\";s:10:\"2017-12-06\";s:4:\"name\";s:18:\"Social Share Popup\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:17:\"premium,popup,api\";s:3:\"url\";s:50:\"https://layerslider.com/popups/#social-share-popup\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/social-share-popup.jpg\";}s:16:\"popup-guide-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:16:\"Popup Guide Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:27:\"premium,popup,parallax,text\";s:3:\"url\";s:48:\"https://layerslider.com/popups/#popup-guide-demo\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-guide-demo.jpg\";}s:18:\"popup-welcome-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Welcome Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:27:\"premium,popup,parallax,text\";s:3:\"url\";s:50:\"https://layerslider.com/popups/#popup-welcome-demo\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-welcome-demo.jpg\";}s:22:\"popup-transparent-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:22:\"Popup Transparent Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:27:\"premium,popup,parallax,loop\";s:3:\"url\";s:54:\"https://layerslider.com/popups/#popup-transparent-demo\";s:7:\"preview\";s:83:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-transparent-demo.jpg\";}s:18:\"popup-sidebar-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Sidebar Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:40:\"premium,popup,experiments,blendmode,text\";s:3:\"url\";s:50:\"https://layerslider.com/popups/#popup-sidebar-demo\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-sidebar-demo.jpg\";}s:19:\"popup-photo-gallery\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:19:\"Popup Photo Gallery\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:22:\"premium,popup,kenburns\";s:3:\"url\";s:51:\"https://layerslider.com/popups/#popup-photo-gallery\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-photo-gallery.jpg\";}s:16:\"popup-modal-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:16:\"Popup Modal Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:20:\"premium,popup,static\";s:3:\"url\";s:48:\"https://layerslider.com/popups/#popup-modal-demo\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-modal-demo.jpg\";}s:18:\"popup-infobar-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Infobar Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:30:\"premium,popup,experiments,text\";s:3:\"url\";s:50:\"https://layerslider.com/popups/#popup-infobar-demo\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-infobar-demo.jpg\";}s:24:\"popup-fullsize-desk-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:24:\"Popup Fullsize Desk Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:43:\"premium,popup,experiments,fullsize,parallax\";s:3:\"url\";s:56:\"https://layerslider.com/popups/#popup-fullsize-desk-demo\";s:7:\"preview\";s:85:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-fullsize-desk-demo.jpg\";}s:18:\"conversation-popup\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Conversation Popup\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:25:\"premium,popup,experiments\";s:3:\"url\";s:50:\"https://layerslider.com/popups/#conversation-popup\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/conversation-popup.jpg\";}s:20:\"global-hover-example\";a:7:{s:8:\"released\";s:10:\"2017-05-02\";s:4:\"name\";s:20:\"Global Hover Example\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.4.0\";s:6:\"groups\";s:55:\"premium,experiments,specialeffects,parallax,text,slider\";s:3:\"url\";s:53:\"https://layerslider.com/sliders/global-hover-example/\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/global-hover-example.jpg\";}s:10:\"gastronomy\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:10:\"Gastronomy\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.2.2\";s:6:\"groups\";s:35:\"premium,kenburns,filter,text,slider\";s:3:\"url\";s:43:\"https://layerslider.com/sliders/gastronomy/\";s:7:\"preview\";s:71:\"https://repository.kreaturamedia.com/v4/sliders/packages/gastronomy.jpg\";}s:13:\"police-lights\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:13:\"Police Lights\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:50:\"free,specialeffects,loop,blendmode,parallax,slider\";s:3:\"url\";s:46:\"https://layerslider.com/sliders/police-lights/\";s:7:\"preview\";s:74:\"https://repository.kreaturamedia.com/v4/sliders/packages/police-lights.jpg\";}s:16:\"beautiful-sunset\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:16:\"Beautiful Sunset\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:41:\"free,specialeffects,loop,blendmode,slider\";s:3:\"url\";s:49:\"https://layerslider.com/sliders/beautiful-sunset/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/beautiful-sunset.jpg\";}s:23:\"blend-mode-experiment-1\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:23:\"Blend Mode Experiment 1\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:67:\"free,specialeffects,text,blendmode,experiments,loop,parallax,slider\";s:3:\"url\";s:56:\"https://layerslider.com/sliders/blend-mode-experiment-1/\";s:7:\"preview\";s:84:\"https://repository.kreaturamedia.com/v4/sliders/packages/blend-mode-experiment-1.jpg\";}s:16:\"flying-banners-2\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:16:\"Flying Banners 2\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:47:\"premium,parallax,specialeffects,fullsize,slider\";s:3:\"url\";s:49:\"https://layerslider.com/sliders/flying-banners-2/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/flying-banners-2.jpg\";}s:14:\"layerslider-v6\";a:7:{s:8:\"released\";s:10:\"2017-03-08\";s:4:\"name\";s:14:\"LayerSlider v6\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.6\";s:6:\"groups\";s:75:\"premium,specialeffects,parallax,fullsize,landing,loop,text,media,api,slider\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/layerslider-v6/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/layerslider-v6.jpg\";}s:16:\"flying-banners-1\";a:7:{s:8:\"released\";s:10:\"2017-03-08\";s:4:\"name\";s:16:\"Flying Banners 1\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:45:\"free,parallax,loop,text,specialeffects,slider\";s:3:\"url\";s:49:\"https://layerslider.com/sliders/flying-banners-1/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/flying-banners-1.jpg\";}s:18:\"anniversary-slider\";a:7:{s:8:\"released\";s:10:\"2017-03-08\";s:4:\"name\";s:18:\"Anniversary Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:47:\"free,parallax,experiments,specialeffects,slider\";s:3:\"url\";s:51:\"https://layerslider.com/sliders/anniversary-slider/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/anniversary-slider.jpg\";}s:7:\"origami\";a:7:{s:8:\"released\";s:10:\"2016-12-07\";s:4:\"name\";s:7:\"Origami\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:61:\"premium,experiments,specialeffects,3dtransition,slider,addons\";s:3:\"url\";s:40:\"https://layerslider.com/sliders/origami/\";s:7:\"preview\";s:68:\"https://repository.kreaturamedia.com/v4/sliders/packages/origami.jpg\";}s:17:\"origami-buildings\";a:7:{s:8:\"released\";s:10:\"2016-12-07\";s:4:\"name\";s:17:\"Origami Buildings\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:70:\"premium,experiments,specialeffects,kenburns,3dtransition,slider,addons\";s:3:\"url\";s:50:\"https://layerslider.com/sliders/origami-buildings/\";s:7:\"preview\";s:78:\"https://repository.kreaturamedia.com/v4/sliders/packages/origami-buildings.jpg\";}s:17:\"autumn-experiment\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:17:\"Autumn Experiment\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:52:\"experiments,free,loop,parallax,specialeffects,slider\";s:3:\"url\";s:50:\"https://layerslider.com/sliders/autumn-experiment/\";s:7:\"preview\";s:78:\"https://repository.kreaturamedia.com/v4/sliders/packages/autumn-experiment.jpg\";}s:28:\"features-parallax-experiment\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:32:\"Features | A Parallax Experiment\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:47:\"experiments,free,parallax,specialeffects,slider\";s:3:\"url\";s:61:\"https://layerslider.com/sliders/features-parallax-experiment/\";s:7:\"preview\";s:89:\"https://repository.kreaturamedia.com/v4/sliders/packages/features-parallax-experiment.jpg\";}s:16:\"furniture-slider\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:16:\"Furniture Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:40:\"fullwidth,parallax,premium,static,slider\";s:3:\"url\";s:49:\"https://layerslider.com/sliders/furniture-slider/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/furniture-slider.jpg\";}s:15:\"room-experiment\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:15:\"Room Experiment\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.6\";s:6:\"groups\";s:72:\"api,experiments,media,parallax,premium,specialeffects,static,text,slider\";s:3:\"url\";s:48:\"https://layerslider.com/sliders/room-experiment/\";s:7:\"preview\";s:76:\"https://repository.kreaturamedia.com/v4/sliders/packages/room-experiment.jpg\";}s:11:\"drag-n-drop\";a:6:{s:4:\"name\";s:11:\"Drag & Drop\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:44:\"premium,fullwidth,specialeffects,text,slider\";s:3:\"url\";s:44:\"https://layerslider.com/sliders/drag-n-drop/\";s:7:\"preview\";s:72:\"https://repository.kreaturamedia.com/v4/sliders/packages/drag-n-drop.jpg\";}s:10:\"headphones\";a:6:{s:4:\"name\";s:10:\"Headphones\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:21:\"premium,static,slider\";s:3:\"url\";s:43:\"https://layerslider.com/sliders/headphones/\";s:7:\"preview\";s:71:\"https://repository.kreaturamedia.com/v4/sliders/packages/headphones.jpg\";}s:14:\"play-by-scroll\";a:6:{s:4:\"name\";s:19:\"Play By Scroll demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:80:\"premium,fullsize,text,experiments,specialeffects,playbyscroll,loop,slider,addons\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/play-by-scroll/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/play-by-scroll.jpg\";}s:3:\"sky\";a:6:{s:4:\"name\";s:14:\"Sky Experience\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:70:\"premium,fullwidth,text,experiments,parallax,specialeffects,loop,slider\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/sky-experience/\";s:7:\"preview\";s:64:\"https://repository.kreaturamedia.com/v4/sliders/packages/sky.jpg\";}s:9:\"halloween\";a:6:{s:4:\"name\";s:16:\"Happy Halloween!\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:42:\"free,fullsize,text,experiments,loop,slider\";s:3:\"url\";s:48:\"https://layerslider.com/sliders/happy-halloween/\";s:7:\"preview\";s:70:\"https://repository.kreaturamedia.com/v4/sliders/packages/halloween.jpg\";}s:15:\"creative-agency\";a:6:{s:4:\"name\";s:6:\"Agency\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:49:\"premium,fullsize,kenburns,parallax,landing,filter\";s:3:\"url\";s:48:\"https://layerslider.com/sliders/creative-agency/\";s:7:\"preview\";s:76:\"https://repository.kreaturamedia.com/v4/sliders/packages/creative-agency.jpg\";}s:18:\"interactive-slider\";a:6:{s:4:\"name\";s:18:\"Interactive Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:47:\"premium,fullsize,parallax,kenburns,text,landing\";s:3:\"url\";s:51:\"https://layerslider.com/sliders/interactive-slider/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/interactive-slider.jpg\";}s:9:\"ecommerce\";a:6:{s:4:\"name\";s:9:\"eCommerce\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:24:\"premium,fullwidth,slider\";s:3:\"url\";s:42:\"https://layerslider.com/sliders/ecommerce/\";s:7:\"preview\";s:70:\"https://repository.kreaturamedia.com/v4/sliders/packages/ecommerce.jpg\";}s:17:\"landing-page-pack\";a:6:{s:4:\"name\";s:17:\"Landing Page PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:62:\"premium,fullsize,fullwidth,landing,parallax,text,packs,website\";s:3:\"url\";s:45:\"https://layerslider.com/sliders/landing-page/\";s:7:\"preview\";s:78:\"https://repository.kreaturamedia.com/v4/sliders/packages/landing-page-pack.jpg\";}s:6:\"hiking\";a:6:{s:4:\"name\";s:6:\"Hiking\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:24:\"premium,fullwidth,slider\";s:3:\"url\";s:39:\"https://layerslider.com/sliders/hiking/\";s:7:\"preview\";s:67:\"https://repository.kreaturamedia.com/v4/sliders/packages/hiking.jpg\";}s:12:\"movie-slider\";a:6:{s:4:\"name\";s:12:\"Movie Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:24:\"premium,fullwidth,slider\";s:3:\"url\";s:45:\"https://layerslider.com/sliders/movie-slider/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/movie-slider.jpg\";}s:12:\"photo-studio\";a:6:{s:4:\"name\";s:12:\"Photo Studio\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:70:\"premium,fullsize,filter,text,parallax,specialeffects,blendmode,landing\";s:3:\"url\";s:45:\"https://layerslider.com/sliders/photo-studio/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/photo-studio.jpg\";}s:5:\"shoes\";a:6:{s:4:\"name\";s:5:\"Shoes\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:42:\"premium,fullwidth,parallax,carousel,slider\";s:3:\"url\";s:38:\"https://layerslider.com/sliders/shoes/\";s:7:\"preview\";s:66:\"https://repository.kreaturamedia.com/v4/sliders/packages/shoes.jpg\";}s:11:\"mini-cooper\";a:6:{s:4:\"name\";s:18:\"Mini Cooper Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:47:\"premium,fullsize,parallax,specialeffects,slider\";s:3:\"url\";s:51:\"https://layerslider.com/sliders/mini-cooper-slider/\";s:7:\"preview\";s:72:\"https://repository.kreaturamedia.com/v4/sliders/packages/mini-cooper.jpg\";}s:4:\"xmas\";a:6:{s:4:\"name\";s:16:\"Merry Christmas!\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:64:\"free,parallax,filter,experiments,specialeffects,text,loop,slider\";s:3:\"url\";s:48:\"https://layerslider.com/sliders/merry-christmas/\";s:7:\"preview\";s:65:\"https://repository.kreaturamedia.com/v4/sliders/packages/xmas.jpg\";}s:5:\"clock\";a:6:{s:4:\"name\";s:32:\"Vintage Clock | shows valid time\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:44:\"premium,fullsize,api,experiments,loop,slider\";s:3:\"url\";s:46:\"https://layerslider.com/sliders/vintage-clock/\";s:7:\"preview\";s:66:\"https://repository.kreaturamedia.com/v4/sliders/packages/clock.jpg\";}s:8:\"car-show\";a:6:{s:4:\"name\";s:8:\"Car Show\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:45:\"premium,fullwidth,experiments,api,loop,slider\";s:3:\"url\";s:41:\"https://layerslider.com/sliders/car-show/\";s:7:\"preview\";s:69:\"https://repository.kreaturamedia.com/v4/sliders/packages/car-show.jpg\";}s:8:\"carousel\";a:6:{s:4:\"name\";s:8:\"Carousel\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:20:\"free,carousel,slider\";s:3:\"url\";s:41:\"https://layerslider.com/sliders/carousel/\";s:7:\"preview\";s:69:\"https://repository.kreaturamedia.com/v4/sliders/packages/carousel.jpg\";}s:14:\"fancy-parallax\";a:6:{s:4:\"name\";s:21:\"Fancy Parallax Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:33:\"premium,fullwidth,parallax,slider\";s:3:\"url\";s:48:\"https://layerslider.com/sliders/parallax-slider/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/fancy-parallax.jpg\";}s:13:\"simple-slider\";a:6:{s:4:\"name\";s:13:\"Simple Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:11:\"free,slider\";s:3:\"url\";s:46:\"https://layerslider.com/sliders/simple-slider/\";s:7:\"preview\";s:74:\"https://repository.kreaturamedia.com/v4/sliders/packages/simple-slider.jpg\";}s:12:\"image-slider\";a:6:{s:4:\"name\";s:12:\"Image Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:11:\"free,slider\";s:3:\"url\";s:48:\"https://layerslider.com/sliders/image-slideshow/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/image-slider.jpg\";}s:19:\"client-testimonials\";a:6:{s:4:\"name\";s:19:\"Client Testimonials\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:24:\"premium,fullwidth,slider\";s:3:\"url\";s:52:\"https://layerslider.com/sliders/client-testimonials/\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/client-testimonials.jpg\";}s:8:\"fixed-bg\";a:6:{s:4:\"name\";s:16:\"Fixed Background\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:30:\"premium,fullwidth,media,slider\";s:3:\"url\";s:49:\"https://layerslider.com/sliders/fixed-background/\";s:7:\"preview\";s:69:\"https://repository.kreaturamedia.com/v4/sliders/packages/fixed-bg.jpg\";}s:22:\"dynamic-content-slider\";a:6:{s:4:\"name\";s:22:\"Dynamic Content Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:11:\"free,slider\";s:3:\"url\";s:55:\"https://layerslider.com/sliders/dynamic-content-slider/\";s:7:\"preview\";s:83:\"https://repository.kreaturamedia.com/v4/sliders/packages/dynamic-content-slider.jpg\";}s:6:\"old-3d\";a:6:{s:4:\"name\";s:14:\"LayerSlider v4\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:30:\"free,3dtransition,media,slider\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/3d-demo-slider/\";s:7:\"preview\";s:67:\"https://repository.kreaturamedia.com/v4/sliders/packages/old-3d.jpg\";}s:2:\"v5\";a:6:{s:4:\"name\";s:14:\"LayerSlider v5\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:26:\"free,parallax,media,slider\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/layerslider-v5/\";s:7:\"preview\";s:63:\"https://repository.kreaturamedia.com/v4/sliders/packages/v5.jpg\";}s:12:\"video-slider\";a:6:{s:4:\"name\";s:12:\"Video Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:17:\"free,media,slider\";s:3:\"url\";s:45:\"https://layerslider.com/sliders/video-slider/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/video-slider.jpg\";}s:6:\"resort\";a:6:{s:4:\"name\";s:6:\"Resort\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:14:\"premium,slider\";s:3:\"url\";s:40:\"https://layerslider.com/sliders/restort/\";s:7:\"preview\";s:67:\"https://repository.kreaturamedia.com/v4/sliders/packages/resort.jpg\";}}s:15:\"kreatura-popups\";a:17:{s:20:\"christmas-bottom-bar\";a:8:{s:8:\"released\";s:10:\"2021-12-20\";s:4:\"name\";s:20:\"Christmas Bottom Bar\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"7.0.0\";s:6:\"groups\";s:17:\"premium,new,popup\";s:3:\"url\";s:52:\"https://layerslider.com/popups/#christmas-bottom-bar\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/christmas-bottom-bar.jpg\";}s:17:\"black-friday-2020\";a:8:{s:8:\"released\";s:10:\"2020-11-18\";s:4:\"name\";s:17:\"Black Friday 2020\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:13:\"premium,popup\";s:3:\"url\";s:49:\"https://layerslider.com/popups/#black-friday-2020\";s:7:\"preview\";s:78:\"https://repository.kreaturamedia.com/v4/sliders/packages/black-friday-2020.jpg\";}s:21:\"covid-19-notification\";a:8:{s:8:\"released\";s:10:\"2020-04-01\";s:4:\"name\";s:21:\"COVID-19 Notification\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:13:\"premium,popup\";s:3:\"url\";s:53:\"https://layerslider.com/popups/#covid-19-notification\";s:7:\"preview\";s:82:\"https://repository.kreaturamedia.com/v4/sliders/packages/covid-19-notification.jpg\";}s:19:\"covid-19-bottom-bar\";a:8:{s:8:\"released\";s:10:\"2020-04-01\";s:4:\"name\";s:19:\"COVID-19 Bottom Bar\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:13:\"premium,popup\";s:3:\"url\";s:51:\"https://layerslider.com/popups/#covid-19-bottom-bar\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/covid-19-bottom-bar.jpg\";}s:14:\"top-bar-notice\";a:8:{s:8:\"released\";s:10:\"2020-04-01\";s:4:\"name\";s:14:\"Top Bar Notice\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:13:\"premium,popup\";s:3:\"url\";s:46:\"https://layerslider.com/popups/#top-bar-notice\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/top-bar-notice.jpg\";}s:20:\"christmas-snow-globe\";a:8:{s:8:\"released\";s:10:\"2019-12-19\";s:4:\"name\";s:20:\"Christmas Snow Globe\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:34:\"premium,parallax,popup,loop,filter\";s:3:\"url\";s:52:\"https://layerslider.com/popups/#christmas-snow-globe\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/christmas-snow-globe.jpg\";}s:14:\"discount-popup\";a:8:{s:8:\"released\";s:10:\"2017-12-10\";s:4:\"name\";s:14:\"Discount Popup\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:13:\"premium,popup\";s:3:\"url\";s:46:\"https://layerslider.com/popups/#discount-popup\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/discount-popup.jpg\";}s:18:\"social-share-popup\";a:8:{s:8:\"released\";s:10:\"2017-12-06\";s:4:\"name\";s:18:\"Social Share Popup\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:17:\"premium,popup,api\";s:3:\"url\";s:50:\"https://layerslider.com/popups/#social-share-popup\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/social-share-popup.jpg\";}s:16:\"popup-guide-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:16:\"Popup Guide Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:27:\"premium,popup,parallax,text\";s:3:\"url\";s:48:\"https://layerslider.com/popups/#popup-guide-demo\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-guide-demo.jpg\";}s:18:\"popup-welcome-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Welcome Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:27:\"premium,popup,parallax,text\";s:3:\"url\";s:50:\"https://layerslider.com/popups/#popup-welcome-demo\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-welcome-demo.jpg\";}s:22:\"popup-transparent-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:22:\"Popup Transparent Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:27:\"premium,popup,parallax,loop\";s:3:\"url\";s:54:\"https://layerslider.com/popups/#popup-transparent-demo\";s:7:\"preview\";s:83:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-transparent-demo.jpg\";}s:18:\"popup-sidebar-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Sidebar Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:40:\"premium,popup,experiments,blendmode,text\";s:3:\"url\";s:50:\"https://layerslider.com/popups/#popup-sidebar-demo\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-sidebar-demo.jpg\";}s:19:\"popup-photo-gallery\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:19:\"Popup Photo Gallery\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:22:\"premium,popup,kenburns\";s:3:\"url\";s:51:\"https://layerslider.com/popups/#popup-photo-gallery\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-photo-gallery.jpg\";}s:16:\"popup-modal-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:16:\"Popup Modal Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:20:\"premium,popup,static\";s:3:\"url\";s:48:\"https://layerslider.com/popups/#popup-modal-demo\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-modal-demo.jpg\";}s:18:\"popup-infobar-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Infobar Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:30:\"premium,popup,experiments,text\";s:3:\"url\";s:50:\"https://layerslider.com/popups/#popup-infobar-demo\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-infobar-demo.jpg\";}s:24:\"popup-fullsize-desk-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:24:\"Popup Fullsize Desk Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:43:\"premium,popup,experiments,fullsize,parallax\";s:3:\"url\";s:56:\"https://layerslider.com/popups/#popup-fullsize-desk-demo\";s:7:\"preview\";s:85:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-fullsize-desk-demo.jpg\";}s:18:\"conversation-popup\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Conversation Popup\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:25:\"premium,popup,experiments\";s:3:\"url\";s:50:\"https://layerslider.com/popups/#conversation-popup\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/conversation-popup.jpg\";}}s:19:\"webshopworks-popups\";a:67:{s:17:\"black-friday-sale\";a:8:{s:8:\"released\";s:10:\"2020-11-18\";s:4:\"name\";s:17:\"Black Friday Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:62:\"https://layerslider.com/popups/webshopworks/#black-friday-sale\";s:7:\"preview\";s:98:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-sale.jpg\";}s:16:\"black-friday-bar\";a:8:{s:8:\"released\";s:10:\"2020-11-18\";s:4:\"name\";s:16:\"Black Friday Bar\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:61:\"https://layerslider.com/popups/webshopworks/#black-friday-bar\";s:7:\"preview\";s:97:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-bar.jpg\";}s:16:\"reveal-your-deal\";a:7:{s:4:\"name\";s:16:\"Reveal Your Deal\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:31:\"sales,coupon,seasonal,promotion\";s:3:\"url\";s:61:\"https://layerslider.com/popups/webshopworks/#reveal-your-deal\";s:7:\"preview\";s:97:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/reveal-your-deal.jpg\";}s:27:\"christmas-sidebar-countdown\";a:7:{s:4:\"name\";s:27:\"Christmas Sidebar Countdown\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:72:\"https://layerslider.com/popups/webshopworks/#christmas-sidebar-countdown\";s:7:\"preview\";s:108:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/christmas-sidebar-countdown.jpg\";}s:20:\"christmas-sale-santa\";a:7:{s:4:\"name\";s:20:\"Christmas Sale Santa\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:65:\"https://layerslider.com/popups/webshopworks/#christmas-sale-santa\";s:7:\"preview\";s:101:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/christmas-sale-santa.jpg\";}s:11:\"santa-walks\";a:7:{s:4:\"name\";s:11:\"Santa Walks\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#santa-walks\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/santa-walks.jpg\";}s:14:\"christmas-sale\";a:7:{s:4:\"name\";s:14:\"Christmas Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:14:\"seasonal,sales\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#christmas-sale\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/christmas-sale.jpg\";}s:12:\"gift-voucher\";a:7:{s:4:\"name\";s:12:\"Gift Voucher\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:32:\"newsletter,coupon,sales,seasonal\";s:3:\"url\";s:57:\"https://layerslider.com/popups/webshopworks/#gift-voucher\";s:7:\"preview\";s:93:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/gift-voucher.jpg\";}s:16:\"christmas-topbar\";a:7:{s:4:\"name\";s:17:\"Christmas Top Bar\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:61:\"https://layerslider.com/popups/webshopworks/#christmas-topbar\";s:7:\"preview\";s:97:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/christmas-topbar.jpg\";}s:14:\"black-friday-9\";a:7:{s:4:\"name\";s:15:\"Black Friday #9\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:35:\"sales,seasonal,promotion,fullscreen\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#black-friday-9\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-9.jpg\";}s:14:\"black-friday-8\";a:7:{s:4:\"name\";s:15:\"Black Friday #8\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:35:\"sales,seasonal,promotion,fullscreen\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#black-friday-8\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-8.jpg\";}s:20:\"black-friday-premium\";a:7:{s:4:\"name\";s:20:\"Black Friday Premium\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:65:\"https://layerslider.com/popups/webshopworks/#black-friday-premium\";s:7:\"preview\";s:101:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-premium.jpg\";}s:14:\"black-friday-7\";a:7:{s:4:\"name\";s:15:\"Black Friday #7\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#black-friday-7\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-7.jpg\";}s:11:\"todays-sale\";a:7:{s:4:\"name\";s:14:\"Today’s Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:15:\"sales,promotion\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#todays-sale\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/todays-sale.jpg\";}s:9:\"sign-up-6\";a:7:{s:4:\"name\";s:10:\"Sign Up #6\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:54:\"https://layerslider.com/popups/webshopworks/#sign-up-6\";s:7:\"preview\";s:90:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/sign-up-6.jpg\";}s:9:\"sign-up-7\";a:7:{s:4:\"name\";s:10:\"Sign Up #7\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:54:\"https://layerslider.com/popups/webshopworks/#sign-up-7\";s:7:\"preview\";s:90:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/sign-up-7.jpg\";}s:9:\"sign-up-8\";a:7:{s:4:\"name\";s:10:\"Sign Up #8\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:54:\"https://layerslider.com/popups/webshopworks/#sign-up-8\";s:7:\"preview\";s:90:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/sign-up-8.jpg\";}s:20:\"get-in-touch-with-us\";a:7:{s:4:\"name\";s:20:\"Get in Touch with Us\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"contact-us\";s:3:\"url\";s:65:\"https://layerslider.com/popups/webshopworks/#get-in-touch-with-us\";s:7:\"preview\";s:101:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/get-in-touch-with-us.jpg\";}s:17:\"top-bar-subscribe\";a:7:{s:4:\"name\";s:17:\"Top Bar Subscribe\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:20:\"newsletter,promotion\";s:3:\"url\";s:62:\"https://layerslider.com/popups/webshopworks/#top-bar-subscribe\";s:7:\"preview\";s:98:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/top-bar-subscribe.jpg\";}s:7:\"sign-up\";a:7:{s:4:\"name\";s:7:\"Sign Up\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:23:\"newsletter,sales,coupon\";s:3:\"url\";s:52:\"https://layerslider.com/popups/webshopworks/#sign-up\";s:7:\"preview\";s:88:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/sign-up.jpg\";}s:14:\"black-friday-6\";a:7:{s:4:\"name\";s:15:\"Black Friday #6\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#black-friday-6\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-6.jpg\";}s:14:\"black-friday-5\";a:7:{s:4:\"name\";s:15:\"Black Friday #5\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:35:\"sales,seasonal,promotion,fullscreen\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#black-friday-5\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-5.jpg\";}s:14:\"black-friday-4\";a:7:{s:4:\"name\";s:15:\"Black Friday #4\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#black-friday-4\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-4.jpg\";}s:14:\"black-friday-1\";a:7:{s:4:\"name\";s:15:\"Black Friday #1\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#black-friday-1\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-1.jpg\";}s:17:\"spring-super-sale\";a:7:{s:4:\"name\";s:17:\"Spring Super Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:62:\"https://layerslider.com/popups/webshopworks/#spring-super-sale\";s:7:\"preview\";s:98:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/spring-super-sale.jpg\";}s:8:\"discount\";a:7:{s:4:\"name\";s:8:\"Discount\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:5:\"sales\";s:3:\"url\";s:53:\"https://layerslider.com/popups/webshopworks/#discount\";s:7:\"preview\";s:89:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/discount.jpg\";}s:9:\"sign-up-3\";a:7:{s:4:\"name\";s:10:\"Sign Up #3\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:54:\"https://layerslider.com/popups/webshopworks/#sign-up-3\";s:7:\"preview\";s:90:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/sign-up-3.jpg\";}s:22:\"sidebar-countdown-sale\";a:7:{s:4:\"name\";s:22:\"Sidebar Countdown Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:22:\"sales,promotion,coupon\";s:3:\"url\";s:67:\"https://layerslider.com/popups/webshopworks/#sidebar-countdown-sale\";s:7:\"preview\";s:103:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/sidebar-countdown-sale.jpg\";}s:15:\"countdown-timer\";a:7:{s:4:\"name\";s:15:\"Countdown Timer\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:14:\"sales,seasonal\";s:3:\"url\";s:60:\"https://layerslider.com/popups/webshopworks/#countdown-timer\";s:7:\"preview\";s:96:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/countdown-timer.jpg\";}s:10:\"discount-5\";a:7:{s:4:\"name\";s:11:\"Discount #5\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:5:\"sales\";s:3:\"url\";s:55:\"https://layerslider.com/popups/webshopworks/#discount-5\";s:7:\"preview\";s:91:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/discount-5.jpg\";}s:10:\"discount-2\";a:7:{s:4:\"name\";s:10:\"Discount 2\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:12:\"sales,coupon\";s:3:\"url\";s:55:\"https://layerslider.com/popups/webshopworks/#discount-2\";s:7:\"preview\";s:91:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/discount-2.jpg\";}s:11:\"subscribe-5\";a:7:{s:4:\"name\";s:12:\"Subscribe #5\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:23:\"newsletter,sales,coupon\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#subscribe-5\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/subscribe-5.jpg\";}s:9:\"mega-sale\";a:7:{s:4:\"name\";s:9:\"Mega Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:35:\"sales,seasonal,promotion,fullscreen\";s:3:\"url\";s:54:\"https://layerslider.com/popups/webshopworks/#mega-sale\";s:7:\"preview\";s:90:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/mega-sale.jpg\";}s:10:\"discount-4\";a:7:{s:4:\"name\";s:10:\"Discount 4\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:15:\"sales,promotion\";s:3:\"url\";s:55:\"https://layerslider.com/popups/webshopworks/#discount-4\";s:7:\"preview\";s:91:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/discount-4.jpg\";}s:8:\"info-bar\";a:7:{s:4:\"name\";s:8:\"Info Bar\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:9:\"promotion\";s:3:\"url\";s:53:\"https://layerslider.com/popups/webshopworks/#info-bar\";s:7:\"preview\";s:89:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/info-bar.jpg\";}s:11:\"subscribe-4\";a:7:{s:4:\"name\";s:12:\"Subscribe #4\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:20:\"newsletter,promotion\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#subscribe-4\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/subscribe-4.jpg\";}s:10:\"contact-us\";a:7:{s:4:\"name\";s:10:\"Contact Us\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"contact-us\";s:3:\"url\";s:55:\"https://layerslider.com/popups/webshopworks/#contact-us\";s:7:\"preview\";s:91:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/contact-us.jpg\";}s:10:\"discount-3\";a:7:{s:4:\"name\";s:10:\"Discount 3\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:5:\"sales\";s:3:\"url\";s:55:\"https://layerslider.com/popups/webshopworks/#discount-3\";s:7:\"preview\";s:91:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/discount-3.jpg\";}s:9:\"sign-up-4\";a:7:{s:4:\"name\";s:10:\"Sign Up #4\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:54:\"https://layerslider.com/popups/webshopworks/#sign-up-4\";s:7:\"preview\";s:90:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/sign-up-4.jpg\";}s:4:\"mail\";a:7:{s:4:\"name\";s:4:\"Mail\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:49:\"https://layerslider.com/popups/webshopworks/#mail\";s:7:\"preview\";s:85:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/mail.jpg\";}s:18:\"kitchen-appliances\";a:7:{s:4:\"name\";s:18:\"Kitchen Appliances\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:9:\"promotion\";s:3:\"url\";s:63:\"https://layerslider.com/popups/webshopworks/#kitchen-appliances\";s:7:\"preview\";s:99:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/kitchen-appliances.jpg\";}s:11:\"subscribe-3\";a:7:{s:4:\"name\";s:12:\"Subscribe #3\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#subscribe-3\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/subscribe-3.jpg\";}s:6:\"ticket\";a:7:{s:4:\"name\";s:6:\"Ticket\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:12:\"sales,coupon\";s:3:\"url\";s:51:\"https://layerslider.com/popups/webshopworks/#ticket\";s:7:\"preview\";s:87:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/ticket.jpg\";}s:8:\"hey-wait\";a:7:{s:4:\"name\";s:10:\"Hey, wait!\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:35:\"exit-intent,newsletter,sales,coupon\";s:3:\"url\";s:53:\"https://layerslider.com/popups/webshopworks/#hey-wait\";s:7:\"preview\";s:89:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/hey-wait.jpg\";}s:9:\"subscribe\";a:7:{s:4:\"name\";s:12:\"Subscribe #1\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:54:\"https://layerslider.com/popups/webshopworks/#subscribe\";s:7:\"preview\";s:90:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/subscribe.jpg\";}s:11:\"subscribe-2\";a:7:{s:4:\"name\";s:12:\"Subscribe #2\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:21:\"newsletter,fullscreen\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#subscribe-2\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/subscribe-2.jpg\";}s:16:\"age-verification\";a:7:{s:4:\"name\";s:16:\"Age Verification\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:27:\"age-verification,fullscreen\";s:3:\"url\";s:61:\"https://layerslider.com/popups/webshopworks/#age-verification\";s:7:\"preview\";s:97:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/age-verification.jpg\";}s:12:\"get-in-touch\";a:7:{s:4:\"name\";s:12:\"Get in Touch\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"contact-us\";s:3:\"url\";s:57:\"https://layerslider.com/popups/webshopworks/#get-in-touch\";s:7:\"preview\";s:93:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/get-in-touch.jpg\";}s:14:\"social-share-2\";a:7:{s:4:\"name\";s:15:\"Social Share #2\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:6:\"social\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#social-share-2\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/social-share-2.jpg\";}s:9:\"sign-up-2\";a:7:{s:4:\"name\";s:10:\"Sign Up #2\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:54:\"https://layerslider.com/popups/webshopworks/#sign-up-2\";s:7:\"preview\";s:90:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/sign-up-2.jpg\";}s:11:\"watch-promo\";a:7:{s:4:\"name\";s:11:\"Watch Promo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:21:\"promotion,exit-intent\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#watch-promo\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/watch-promo.jpg\";}s:19:\"product-accessories\";a:7:{s:4:\"name\";s:19:\"Product Accessories\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:9:\"promotion\";s:3:\"url\";s:64:\"https://layerslider.com/popups/webshopworks/#product-accessories\";s:7:\"preview\";s:100:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/product-accessories.jpg\";}s:9:\"sign-up-5\";a:7:{s:4:\"name\";s:10:\"Sign Up #5\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:54:\"https://layerslider.com/popups/webshopworks/#sign-up-5\";s:7:\"preview\";s:90:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/sign-up-5.jpg\";}s:14:\"black-friday-2\";a:7:{s:4:\"name\";s:15:\"Black Friday #2\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#black-friday-2\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-2.jpg\";}s:14:\"black-friday-3\";a:7:{s:4:\"name\";s:15:\"Black Friday #3\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#black-friday-3\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-3.jpg\";}s:16:\"halloween-sale-2\";a:7:{s:4:\"name\";s:17:\"Halloween Sale #2\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:61:\"https://layerslider.com/popups/webshopworks/#halloween-sale-2\";s:7:\"preview\";s:97:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/halloween-sale-2.jpg\";}s:16:\"halloween-sale-1\";a:7:{s:4:\"name\";s:17:\"Halloween Sale #1\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:61:\"https://layerslider.com/popups/webshopworks/#halloween-sale-1\";s:7:\"preview\";s:97:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/halloween-sale-1.jpg\";}s:12:\"pumpkin-sale\";a:7:{s:4:\"name\";s:12:\"Pumpkin Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:57:\"https://layerslider.com/popups/webshopworks/#pumpkin-sale\";s:7:\"preview\";s:93:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/pumpkin-sale.jpg\";}s:11:\"spring-sale\";a:7:{s:4:\"name\";s:11:\"Spring Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#spring-sale\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/spring-sale.jpg\";}s:11:\"mothers-day\";a:7:{s:4:\"name\";s:14:\"Mother’s Day\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:35:\"sales,seasonal,promotion,fullscreen\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#mothers-day\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/mothers-day.jpg\";}s:20:\"easter-subscribe-bar\";a:7:{s:4:\"name\";s:20:\"Easter Subscribe Bar\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:25:\"sales,seasonal,newsletter\";s:3:\"url\";s:65:\"https://layerslider.com/popups/webshopworks/#easter-subscribe-bar\";s:7:\"preview\";s:101:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/easter-subscribe-bar.jpg\";}s:14:\"easter-welcome\";a:7:{s:4:\"name\";s:14:\"Easter Welcome\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:8:\"seasonal\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#easter-welcome\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/easter-welcome.jpg\";}s:17:\"easter-newsletter\";a:7:{s:4:\"name\";s:17:\"Easter Newsletter\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:32:\"sales,seasonal,newsletter,coupon\";s:3:\"url\";s:62:\"https://layerslider.com/popups/webshopworks/#easter-newsletter\";s:7:\"preview\";s:98:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/easter-newsletter.jpg\";}s:11:\"season-sale\";a:7:{s:4:\"name\";s:11:\"Season Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#season-sale\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/season-sale.jpg\";}s:11:\"easter-sale\";a:7:{s:4:\"name\";s:11:\"Easter Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#easter-sale\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/easter-sale.jpg\";}s:20:\"easter-sale-surprise\";a:7:{s:4:\"name\";s:20:\"Easter Sale Surprise\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:65:\"https://layerslider.com/popups/webshopworks/#easter-sale-surprise\";s:7:\"preview\";s:101:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/easter-sale-surprise.jpg\";}s:18:\"join-the-community\";a:7:{s:4:\"name\";s:18:\"Join the Community\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:6:\"social\";s:3:\"url\";s:63:\"https://layerslider.com/popups/webshopworks/#join-the-community\";s:7:\"preview\";s:99:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/join-the-community.jpg\";}}s:16:\"important_notice\";a:9:{s:4:\"date\";s:10:\"2022-05-05\";s:5:\"title\";s:39:\"LayerSlider Security Update Recommended\";s:7:\"message\";s:227:\"Several security issues were fixed in the latest versions of LayerSlider. If you haven’t done it already, please update to LayerSlider 7.2.1. <a href=\"https://layerslider.com/how-to-update/\" target=\"_blank\">HOW TO UPDATE?</a>\";s:5:\"image\";s:0:\"\";s:6:\"banner\";a:5:{s:5:\"class\";s:21:\"ls-v7-security-banner\";s:5:\"style\";s:132:\"height: auto; margin: 39px auto 0 auto !important; min-width: 700px; max-width: 1700px; padding-right: 20px; box-sizing: border-box;\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:6:\"_blank\";s:7:\"content\";s:2674:\"\n\n		<style>\n		@import url(\"https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;800&display=swap\");\n		</style>\n		<style>\n\n			.ls-v7-security-banner {\n				max-width: 1200px !important;\n			}\n\n			.ls-v7-security-banner > a.dashicons-dismiss {\n				top: 0.2rem;\n				right: calc( 20px + 0.2rem ) !important;\n			}\n\n			#lspr-inner {\n				position: relative;\n				height: auto;\n				display: flex;\n				margin: 0 auto !important;\n				justify-content: space-between;\n			}\n\n			#lspr-right {\n				margin: 0 auto;\n				border-radius: 0.5rem;\n				background-color: #ee0070;\n				width: 100%;\n			}\n\n			.lspr-over {\n				position: relative;\n				z-index: 2;\n			}\n\n			#lspr-heading {\n				padding: 0.5rem 3rem 0 3rem;\n				color: white;\n				font-size: 1.2rem;\n				font-weight: 600;\n				font-family: Nunito, sans-serif;\n				text-align: center;\n			}\n\n			.lspr-nowrap {\n				white-space: nowrap;\n			}\n\n			.lspr-text {\n				position: relative;\n				z-index: 200;\n				margin: 0.3rem auto;\n				padding: 0 3rem;\n				color: white;\n				font-family: Nunito, sans-serif;\n				font-size: 1rem;\n				line-height: normal;\n				text-align: center;\n			}\n\n			.lspr-text a {\n				color: white;\n				font-weight: bold;\n			}\n\n			#lspr-buttons {\n				text-align: center;\n				padding-top: 0.1rem;\n				padding-bottom: 0.65rem;\n			}\n\n			#lspr-buttons a {\n				text-decoration: none;\n				color: #ee0070;\n				text-transform: uppercase;\n				font-family: Nunito, sans-serif;\n				font-weight: 800;\n				display: inline-block;\n				border-radius: 0.5rem;\n				background-color: white;\n				padding: 0 1rem;\n				line-height: 1.5rem;\n				font-size: 0.9rem;\n				transform: rotate(0.001deg);\n				transition: all 0.2s;\n				box-shadow: none;\n				cursor: pointer;\n			}\n\n			#lspr-buttons a:hover {\n				transform: rotate(0.001deg) scale(1.05);\n				box-shadow: 0 0.25vw 0.5vw rgba(0,0,0,0.15);\n			}\n\n			.layerslider_notice_img  .dashicons-dismiss {\n				right: 30px;\n			}\n\n			.lspr-bold {\n				font-weight: 800 !important;\n			}\n\n		</style>\n		<div id=\"lspr-inner\">\n			<div id=\"lspr-right\">\n				<div id=\"lspr-heading-small\" class=\"lspr-over\"></div>\n				<div id=\"lspr-heading\" class=\"lspr-over\">\n					<span class=\"lspr-nowrap\">LayerSlider Security Update Recommended<span>\n				</div>\n\n				<div class=\"lspr-text\" class=\"lspr-over\">\n					<span class=\"lspr-nowrap\">\n						Several security issues were fixed in the latest versions of LayerSlider.\n					</span>\n					<span class=\"lspr-nowrap\">\n						If you haven’t done it already, please update to LayerSlider 7.2.1.\n					</span>\n				</div>\n\n				<div id=\"lspr-buttons\" class=\"lspr-over\">\n					<a href=\"https://layerslider.com/how-to-update/\" target=\"_blank\">HOW TO UPDATE?</a>\n				</div>\n			</div>\n		</div>\";}s:11:\"min_version\";s:0:\"\";s:11:\"max_version\";s:5:\"7.1.1\";s:11:\"unactivated\";b:0;s:10:\"url_filter\";s:33:\"layerslider index.php plugins.php\";}}","no"),
("1445","nf_active_promotions","{\"dashboard\":[{\"id\":\"sendwp-banner\",\"location\":\"dashboard\",\"content\":\"<span aria-label=\\\"SendWP. Getting WordPress email into an inbox shouldn\'t be that hard! Never miss another receipt, form submission, or any WordPress email ever again.\\\" style=\\\"cursor:pointer;width:800px;height:83px;border-radius:4px;-moz-border-radius:4px;-webkit-border-radius:4px;background-image:url(\'http:\\/\\/www.mercifulwaygroup.com\\/cms\\/wp-content\\/plugins\\/ninja-forms\\/assets\\/img\\/promotions\\/dashboard-banner-sendwp.png\');display:block;\\\"><\\/span>\",\"type\":\"sendwp\",\"script\":\"\\n\\t\\t\\t\\tsetTimeout(function(){ \\/* Wait for services to init. *\\/\\n\\t\\t\\t\\t\\tvar data = {\\n\\t\\t\\t\\t\\t\\twidth: 450,\\n\\t\\t\\t\\t\\t\\tcloseOnClick: \'body\',\\n\\t\\t\\t\\t\\t\\tcloseOnEsc: true,\\n\\t\\t\\t\\t\\t\\tcontent: \'<p><h2>Frustrated that WordPress email isn\\u2019t being received?<\\/h2><p>Form submission notifications not hitting your inbox? Some of your visitors getting form feedback via email, others not? By default, your WordPress site sends emails through your web host, which can be unreliable. Your host has spent lots of time and money optimizing to serve your pages, not send your emails.<\\/p><h3>Sign up for SendWP today, and never deal with WordPress email issues again!<\\/h3><p>SendWP is an email service that removes your web host from the email equation.<\\/p><ul style=&quot;list-style-type:initial;margin-left: 20px;&quot;><li>Sends email through dedicated email service, increasing email deliverability.<\\/li><li>Keeps form submission emails out of spam by using a trusted email provider.<\\/li><li>On a shared web host? Don\\u2019t worry about emails being rejected because of blocked IP addresses.<\\/li><li><strong>$1 for the first month. $9\\/month after. Cancel anytime!<\\/strong><\\/li><\\/ul><\\/p><br \\/>\',\\n\\t\\t\\t\\t\\t\\tbtnPrimary: {\\n\\t\\t\\t\\t\\t\\t\\ttext: \'Sign me up!\',\\n\\t\\t\\t\\t\\t\\t\\tcallback: function() {\\n\\t\\t\\t\\t\\t\\t\\t\\tvar spinner = document.createElement(\'span\');\\n\\t\\t\\t\\t\\t\\t\\t\\tspinner.classList.add(\'dashicons\', \'dashicons-update\', \'dashicons-update-spin\');\\n\\t\\t\\t\\t\\t\\t\\t\\tvar w = this.offsetWidth;\\n\\t\\t\\t\\t\\t\\t\\t\\tthis.innerHTML = spinner.outerHTML;\\n\\t\\t\\t\\t\\t\\t\\t\\tthis.style.width = w+\'px\';\\n\\t\\t\\t\\t\\t\\t\\t\\tninja_forms_sendwp_remote_install();\\n\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t},\\n\\t\\t\\t\\t\\t\\tbtnSecondary: {\\n\\t\\t\\t\\t\\t\\t\\ttext: \'Cancel\',\\n\\t\\t\\t\\t\\t\\t\\tcallback: function() {\\n\\t\\t\\t\\t\\t\\t\\t\\tsendwpModal.toggleModal(false);\\n\\t\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\t}\\n\\t\\t\\t\\t\\tvar sendwpModal = new NinjaModal(data);\\n\\t\\t\\t\\t}, 500);\\n\\t\\t\\t\"}]}","no"),
("1446","ninja_forms_addons_feed","[{\"title\":\"Multi Step Forms\",\"image\":\"assets\\/img\\/add-ons\\/multi-step-forms.png\",\"content\":\"Give submissions a boost on any longer form by making it a multi-page form. Drag and drop fields between pages, add breadcrumb navigation, a progress bar, and loads more!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/multi-step-forms\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Multi+Step+Forms\",\"plugin\":\"ninja-forms-multi-part\\/multi-part.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/multi-step-forms\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Multi+Step+Forms+Docs\",\"version\":\"3.0.26\",\"categories\":[{\"name\":\"Look &amp; Feel\",\"slug\":\"look-feel\"},{\"name\":\"Developer\",\"slug\":\"developer\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"User\",\"slug\":\"user\"},{\"name\":\"Business\",\"slug\":\"business\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Form Function and Design\",\"slug\":\"form-function-design\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Basic 2022\",\"slug\":\"basic-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Most Popular\",\"slug\":\"most-popular\"}]},{\"title\":\"Front-End Posting\",\"image\":\"assets\\/img\\/add-ons\\/front-end-posting.png\",\"content\":\"Let users publish content just by submitting a form! Completely configurable including post type, title, even categories and tags. Set post status, author, and much more!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/post-creation\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Front-End+Posting\",\"plugin\":\"ninja-forms-post-creation\\/ninja-forms-post-creation.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/post-creation\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Front-End+Posting+Docs\",\"version\":\"3.0.10\",\"categories\":[{\"name\":\"Content Management\",\"slug\":\"content-management\"},{\"name\":\"Developer\",\"slug\":\"developer\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"User\",\"slug\":\"user\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Manage Users\",\"slug\":\"user-management\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"Mailchimp\",\"image\":\"assets\\/img\\/add-ons\\/mailchimp.png\",\"content\":\"Bring new life to your lists with upgraded Mailchimp signup forms for WordPress! Easy to build and customize with no code required. Link to lists and interest groups!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/mailchimp\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Mailchimp\",\"plugin\":\"ninja-forms-mail-chimp\\/ninja-forms-mail-chimp.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/mailchimp\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Mailchimp+Docs\",\"version\":\"3.3.2\",\"categories\":[{\"name\":\"Email Marketing\",\"slug\":\"email-marketing\"},{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Business\",\"slug\":\"business\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"Campaign Monitor\",\"image\":\"assets\\/img\\/add-ons\\/campaign-monitor.png\",\"content\":\"Make any form a custom crafted WordPress signup form for Campaign Monitor. Connect to any list, link form fields to list fields, and watch your lists grow!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/campaign-monitor\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Campaign+Monitor\",\"plugin\":\"ninja-forms-campaign-monitor\\/ninja-forms-campaign-monitor.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/campaign-monitor\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Campaign+Monitor+Docs\",\"version\":\"3.0.6\",\"categories\":[{\"name\":\"Email Marketing\",\"slug\":\"email-marketing\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"User Analytics\",\"image\":\"assets\\/img\\/add-ons\\/user-analytics.png\",\"content\":\"Get better data on where your form traffic is coming from with every submission. Add 12+ analytics fields including UTM values,  URL referrer, geo data, and more!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/user-analytics\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=User+Analytics\",\"plugin\":\"ninja-forms-user-analytics\\/ninja-forms-user-analytics.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/user-analytics\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=User+Analytics+Docs\",\"version\":\"3.0.1\",\"categories\":[{\"name\":\"Content Management\",\"slug\":\"content-management\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Manage Users\",\"slug\":\"user-management\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"Constant Contact\",\"image\":\"assets\\/img\\/add-ons\\/constant-contact.png\",\"content\":\"Connect WordPress to Constant Contact with forms that you can build and design just the way you want, no tech skills required! Subscribe users to any list or interest group.\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/constant-contact\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Constant+Contact\",\"plugin\":\"ninja-forms-constant-contact\\/ninja-forms-constant-contact.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/constant-contact\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Constant+Contact+Docs\",\"version\":\"3.1.0\",\"categories\":[{\"name\":\"Email Marketing\",\"slug\":\"email-marketing\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"AWeber\",\"image\":\"assets\\/img\\/add-ons\\/aweber.png\",\"content\":\"Build your lists faster with easy to design, professional quality WordPress signup forms. No technical skills required. Connect WordPress to AWeber with style!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/aweber\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=AWeber\",\"plugin\":\"ninja-forms-aweber\\/ninja-forms-aweber.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/aweber\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=AWeber+Docs\",\"version\":\"3.2.0\",\"categories\":[{\"name\":\"Email Marketing\",\"slug\":\"email-marketing\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"PayPal Express\",\"image\":\"assets\\/img\\/add-ons\\/paypal-express.png\",\"content\":\"Set up any form to accept PayPal payments with PayPal Express for WordPress! Base totals on a fixed amount, user entered amount, or a calculated total.\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/paypal-express\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=PayPal+Express\",\"plugin\":\"ninja-forms-paypal-express\\/ninja-forms-paypal-express.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/paypal-express\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=PayPal+Express+Docs\",\"version\":\"3.1.2\",\"categories\":[{\"name\":\"Payment Gateways\",\"slug\":\"payment-gateways\"},{\"name\":\"Developer\",\"slug\":\"developer\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"User\",\"slug\":\"user\"},{\"name\":\"Business\",\"slug\":\"business\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"MailPoet\",\"image\":\"assets\\/img\\/add-ons\\/mailpoet.png\",\"content\":\"Say hello better! Customize your MailPoet signup forms to draw more subscribers than ever before. Connect WordPress to any MailPoet list in minutes!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/mailpoet\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=MailPoet\",\"plugin\":\"ninja-forms-mailpoet\\/nf-mailpoet.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/mailpoet\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=MailPoet+Docs\",\"version\":\"3.0.1\",\"categories\":[{\"name\":\"Email Marketing\",\"slug\":\"email-marketing\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"Zoho CRM\",\"image\":\"assets\\/img\\/add-ons\\/zoho-crm.png\",\"content\":\"Customize your forms to get the most out of your connection between WordPress and Zoho. Link form fields directly to Zoho fields, custom fields included, from almost any module.\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/zoho-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Zoho+CRM\",\"plugin\":\"ninja-forms-zoho-crm\\/ninja-forms-zoho-crm.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/zoho-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Zoho+CRM+Docs\",\"version\":\"3.5.0\",\"categories\":[{\"name\":\"CRM Integrations\",\"slug\":\"crm-integrations\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"Capsule CRM\",\"image\":\"assets\\/img\\/add-ons\\/capsule-crm.png\",\"content\":\"Boost conversions from WordPress to Capsule with forms tailor made to your audience. Link form fields to Capsule fields from a wide range of modules. Custom fields too!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/capsule-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Capsule+CRM\",\"plugin\":\"ninja-forms-capsule-crm\\/ninja-forms-capsule-crm.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/capsule-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Capsule+CRM+Docs\",\"version\":\"3.4.2\",\"categories\":[{\"name\":\"CRM Integrations\",\"slug\":\"crm-integrations\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"Insightly CRM\",\"image\":\"assets\\/img\\/add-ons\\/insightly-crm.png\",\"content\":\"Your customer\'s journey begins with your WordPress forms. Send Contacts, Leads, Opportunities, Custom fields and more seamlessly from WordPress to Insightly!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/insightly-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Insightly+CRM\",\"plugin\":\"ninja-forms-insightly-crm\\/ninja-forms-insightly-crm.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/insightly-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Insightly+CRM+Docs\",\"version\":\"3.2.1\",\"categories\":[{\"name\":\"CRM Integrations\",\"slug\":\"crm-integrations\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"Trello\",\"image\":\"assets\\/img\\/add-ons\\/trello.png\",\"content\":\"Create a new Trello card with data from any WordPress form submission. Map fields to card details, assign members and labels, upload images, embed links.\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/trello\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Trello\",\"plugin\":\"ninja-forms-trello\\/ninja-forms-trello.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/trello\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Trello+Docs\",\"version\":\"3.0.4\",\"categories\":[{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Notification and Workflow\",\"slug\":\"notification-workflow\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Manage Submissions\",\"slug\":\"manage-submissions\"}]},{\"title\":\"Elavon\",\"image\":\"assets\\/img\\/add-ons\\/elavon.png\",\"content\":\"Accept credit card payments from any of your WordPress forms. Pass customer and invoice info from any field securely into Elavon with each payment.\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/elavon\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Elavon\",\"plugin\":\"ninja-forms-elavon-payment-gateway\\/ninja-forms-elavon-payment-gateway.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/elavon\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Elavon+Docs\",\"version\":\"3.1.1\",\"categories\":[{\"name\":\"Payment Gateways\",\"slug\":\"payment-gateways\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"Zapier\",\"image\":\"assets\\/img\\/add-ons\\/zapier.png\",\"content\":\"Don\'t see an add-on integration for a service you love? Don\'t worry! Connect WordPress to more than 4,000 different services through Zapier, no code required!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/zapier\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Zapier\",\"plugin\":\"ninja-forms-zapier\\/ninja-forms-zapier.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/zapier\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Zapier+Docs\",\"version\":\"3.0.8\",\"categories\":[{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"File Management\",\"slug\":\"file-management\"},{\"name\":\"Notification and Workflow\",\"slug\":\"notification-workflow\"},{\"name\":\"Custom Integrations\",\"slug\":\"custom-integrations\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Manage Submissions\",\"slug\":\"manage-submissions\"}]},{\"title\":\"Salesforce CRM\",\"image\":\"assets\\/img\\/add-ons\\/salesforce-crm.png\",\"content\":\"Easily map any form field to any Salesforce Object or Field. A better connection to your customers begins with a better WordPress form builder!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/salesforce-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Salesforce+CRM\",\"plugin\":\"ninja-forms-salesforce-crm\\/ninja-forms-salesforce-crm.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/salesforce-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Salesforce+CRM+Docs\",\"version\":\"3.3.2\",\"categories\":[{\"name\":\"CRM Integrations\",\"slug\":\"crm-integrations\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"Slack\",\"image\":\"assets\\/img\\/add-ons\\/slack.png\",\"content\":\"Get realtime Slack notifications in the workspace and channel of your choice with any new WordPress form submission. @Mention any team member!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/slack\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Slack\",\"plugin\":\"ninja-forms-slack\\/ninja-forms-slack.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/slack\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Slack+Docs\",\"version\":\"3.0.3\",\"categories\":[{\"name\":\"Notifications\",\"slug\":\"notifications\"},{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Notification and Workflow\",\"slug\":\"notification-workflow\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Manage Submissions\",\"slug\":\"manage-submissions\"}]},{\"title\":\"CleverReach\",\"image\":\"assets\\/img\\/add-ons\\/cleverreach.png\",\"content\":\"Grow the reach of your email marketing with better CleverReach signup forms. Tailor your forms to your audience with this easy to set up integration!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/cleverreach\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=CleverReach\",\"plugin\":\"ninja-forms-cleverreach\\/ninja-forms-cleverreach.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/cleverreach\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=CleverReach+Docs\",\"version\":\"3.1.5\",\"categories\":[{\"name\":\"Email Marketing\",\"slug\":\"email-marketing\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"Webhooks\",\"image\":\"assets\\/img\\/add-ons\\/webhooks.png\",\"content\":\"Can\'t find a WordPress integration for the service you love? Send WordPress forms data to any external URL using a simple GET or POST request!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/webhooks\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Webhooks\",\"plugin\":\"ninja-forms-webhooks\\/ninja-forms-webhooks.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/webhooks\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Webhooks+Docs\",\"version\":\"3.0.5\",\"categories\":[{\"name\":\"Notifications\",\"slug\":\"notifications\"},{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Developer\",\"slug\":\"developer\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"User\",\"slug\":\"user\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Custom Integrations\",\"slug\":\"custom-integrations\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"Excel Export\",\"image\":\"assets\\/img\\/add-ons\\/excel-export.png\",\"content\":\"Export any form\'s submissions as a Microsoft Excel spreadsheet. Choose a date range, the fields you want to include, and export to Excel! \",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/excel-export\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Excel+Export\",\"plugin\":\"ninja-forms-excel-export\\/ninja-forms-excel-export.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/excel-export\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Excel+Export+Docs\",\"version\":\"3.3.4\",\"categories\":[{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"File Management\",\"slug\":\"file-management\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Manage Submissions\",\"slug\":\"manage-submissions\"}]},{\"title\":\"Formstack Documents\",\"image\":\"assets\\/img\\/add-ons\\/webmerge.png\",\"content\":\"Create specifically formatted templates from an uploaded PDF or Word document, then auto-fill them from any WordPress form submission!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/webmerge\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Formstack+Documents\",\"plugin\":\"ninja-forms-webmerge\\/ninja-forms-webmerge.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/webmerge\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Formstack+Documents+Docs\",\"version\":\"3.0.3\",\"categories\":[{\"name\":\"Content Management\",\"slug\":\"content-management\"},{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Developer\",\"slug\":\"developer\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"User\",\"slug\":\"user\"},{\"name\":\"Agency\",\"slug\":\"agency\"}]},{\"title\":\"Help Scout\",\"image\":\"assets\\/img\\/add-ons\\/help-scout.png\",\"content\":\"Offering great support is hard. Tailor your WordPress forms to match your customers\' needs with this Help Scout integration for WordPress.\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/help-scout\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Help+Scout\",\"plugin\":null,\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/help-scout\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Help+Scout+Docs\",\"version\":\"3.1.3\",\"categories\":[{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Manage Users\",\"slug\":\"user-management\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"Emma\",\"image\":\"assets\\/img\\/add-ons\\/emma.png\",\"content\":\"Take your email marketing further with handcrafted, easy to build signup forms that connect directly into your Emma account! \",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/emma\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Emma\",\"plugin\":\"ninja-forms-emma\\/ninja-forms-emma.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/emma\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Emma+Docs\",\"version\":\"3.0.4\",\"categories\":[{\"name\":\"Email Marketing\",\"slug\":\"email-marketing\"},{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Developer\",\"slug\":\"developer\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"User\",\"slug\":\"user\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"ClickSend SMS\",\"image\":\"assets\\/img\\/add-ons\\/clicksend-sms.png\",\"content\":\"Get instant SMS notifications with every new WordPress form submission. Respond to leads faster and make more personal connections!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/clicksend-sms\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=ClickSend+SMS\",\"plugin\":\"ninja-forms-clicksend\\/ninja-forms-clicksend.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/clicksend-sms\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=ClickSend+SMS+Docs\",\"version\":\"3.0.1\",\"categories\":[{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Notification and Workflow\",\"slug\":\"notification-workflow\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"SMS Notifications\",\"slug\":\"sms-notifications\"}]},{\"title\":\"Twilio SMS\",\"image\":\"assets\\/img\\/add-ons\\/twilio-sms.png\",\"content\":\"Get instant SMS notifications with every new WordPress form submission. Respond to leads faster and make more personal connections!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/twilio\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Twilio+SMS\",\"plugin\":\"ninja-forms-twilio\\/ninja-forms-twilio.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/twilio\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Twilio+SMS+Docs\",\"version\":\"3.0.1\",\"categories\":[{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Notification and Workflow\",\"slug\":\"notification-workflow\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"SMS Notifications\",\"slug\":\"sms-notifications\"}]},{\"title\":\"Recurly\",\"image\":\"assets\\/img\\/add-ons\\/recurly.png\",\"content\":\"Subscription plans a part of your business model? Let your users subscribe from any WordPress form & make management easier with Recurly!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/recurly\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Recurly\",\"plugin\":\"ninja-forms-recurly\\/ninja-forms-recurly.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/recurly\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Recurly+Docs\",\"version\":\"3.0.4\",\"categories\":[{\"name\":\"Payment Gateways\",\"slug\":\"payment-gateways\"},{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"Save Progress\",\"image\":\"assets\\/img\\/add-ons\\/save-progress.png\",\"content\":\"Let your users save their work and reload it all when they have time to return. Don\'t lose out on valuable submissions for longer forms!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/save-progress\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Save+Progress\",\"plugin\":\"ninja-forms-save-progress\\/ninja-forms-save-progress.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/save-progress\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Save+Progress+Docs\",\"version\":\"3.0.25\",\"categories\":[{\"name\":\"Content Management\",\"slug\":\"content-management\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Form Function and Design\",\"slug\":\"form-function-design\"},{\"name\":\"Manage Users\",\"slug\":\"user-management\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"EmailOctopus\",\"image\":\"assets\\/img\\/add-ons\\/emailoctopus.png\",\"content\":\"Pair WordPress\' best drag and drop form builder with your EmailOctopus account for incredibly effective signup forms. Easy, complete integration.\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/emailoctopus\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=EmailOctopus\",\"plugin\":\"ninja-forms-emailoctopus\\/ninja-forms-emailoctopus.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/emailoctopus\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=EmailOctopus+Docs\",\"version\":\"3.0.0\",\"categories\":[{\"name\":\"Email Marketing\",\"slug\":\"email-marketing\"},{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Business\",\"slug\":\"business\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"Pipeline CRM\",\"image\":\"assets\\/img\\/add-ons\\/pipelinedeals-crm.png\",\"content\":\"Complete, effortless integration with Pipeline CRM. Increase the flow of leads into your sales pipeline with upgraded lead generation forms!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/pipelinedeals-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Pipeline+CRM\",\"plugin\":\"ninja-forms-zoho-crm\\/zoho-integration.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/pipelinedeals-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Pipeline+CRM+Docs\",\"version\":\"3.0.1\",\"categories\":[{\"name\":\"CRM Integrations\",\"slug\":\"crm-integrations\"},{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"ConvertKit\",\"image\":\"assets\\/img\\/add-ons\\/convertkit.png\",\"content\":\"Connect WordPress to your ConvertKit account with completely customizable opt-in forms. Watch your audience & sales grow like never before!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/convertkit\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=ConvertKit\",\"plugin\":\"ninja-forms-convertkit\\/ninja-forms-convertkit.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/convertkit\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=ConvertKit+Docs\",\"version\":\"3.1.1\",\"categories\":[{\"name\":\"Email Marketing\",\"slug\":\"email-marketing\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"OnePageCRM\",\"image\":\"assets\\/img\\/add-ons\\/onepage-crm.png\",\"content\":\"Integrate WordPress with OnePage CRM seamlessly through highly customizable WordPress forms. Make better conversions <em>your<\\/em> Next Action!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/onepage-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=OnePageCRM\",\"plugin\":\"ninja-forms-onepage-crm\\/ninja-forms-onepage-crm.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/onepage-crm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=OnePageCRM+Docs\",\"version\":\"3.0.2\",\"categories\":[{\"name\":\"CRM Integrations\",\"slug\":\"crm-integrations\"},{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"ActiveCampaign\",\"image\":\"assets\\/img\\/add-ons\\/active-campaign.png\",\"content\":\"Design custom forms that link perfectly to your ActiveCampaign account for the ultimate in marketing automation. Better leads begin here!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/activecampaign\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=ActiveCampaign\",\"plugin\":\"ninja-forms-active-campaign\\/ninja-forms-active-campaign.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/activecampaign\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=ActiveCampaign+Docs\",\"version\":\"3.1.2\",\"categories\":[{\"name\":\"Email Marketing\",\"slug\":\"email-marketing\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"Agency Membership\",\"image\":\"assets\\/img\\/add-ons\\/ninja-forms-membership-bundle-2.png\",\"content\":\"Get every single Ninja Forms add-ons, at an amazingly discounted price.\",\"link\":\"https:\\/\\/ninjaforms.com\\/documentation\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Agency+Membership\",\"plugin\":null,\"docs\":\"https:\\/\\/ninjaforms.com\\/documentation\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Agency+Membership+Docs\",\"version\":null,\"categories\":[{\"name\":\"Deprecated\",\"slug\":\"deprecated\"}]},{\"title\":\"Personal Membership\",\"image\":\"assets\\/img\\/add-ons\\/individual-membership-2.png\",\"content\":\"Get our most popular add-ons at an amazingly discounted price. Perfect for the single site owner.\",\"link\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Personal+Membership\",\"plugin\":null,\"docs\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Personal+Membership+Docs\",\"version\":null,\"categories\":[{\"name\":\"Deprecated\",\"slug\":\"deprecated\"}]},{\"title\":\"Professional Membership\",\"image\":\"assets\\/img\\/add-ons\\/professional-membership-2.png\",\"content\":\"Get our 4 most popular add-ons at an amazingly discounted price. Perfect for your Do It Yourself business owner.\",\"link\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Professional+Membership\",\"plugin\":null,\"docs\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Professional+Membership+Docs\",\"version\":null,\"categories\":[{\"name\":\"Deprecated\",\"slug\":\"deprecated\"}]},{\"title\":\"Basic Membership\",\"image\":\"assets\\/img\\/add-ons\\/basic-membership.png\",\"content\":\"\",\"link\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Basic+Membership\",\"plugin\":null,\"docs\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Basic+Membership+Docs\",\"version\":null,\"categories\":[{\"name\":null,\"slug\":null}]},{\"title\":\"Plus Membership\",\"image\":\"assets\\/img\\/add-ons\\/plus-membership.png\",\"content\":\"\",\"link\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Plus+Membership\",\"plugin\":null,\"docs\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Plus+Membership+Docs\",\"version\":null,\"categories\":[{\"name\":null,\"slug\":null}]},{\"title\":\"Pro Membership\",\"image\":\"assets\\/img\\/add-ons\\/pro-membership.png\",\"content\":\"\",\"link\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Pro+Membership\",\"plugin\":null,\"docs\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Pro+Membership+Docs\",\"version\":null,\"categories\":[{\"name\":null,\"slug\":null}]},{\"title\":\"Elite Membership\",\"image\":\"assets\\/img\\/add-ons\\/elite-membership.png\",\"content\":\"\",\"link\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Elite+Membership\",\"plugin\":null,\"docs\":\"\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Elite+Membership+Docs\",\"version\":null,\"categories\":[{\"name\":null,\"slug\":null}]},{\"title\":\"Scheduled Submissions Export\",\"image\":\"assets\\/img\\/add-ons\\/scheduled-submissions-export.png\",\"content\":\"Use Scheduled Submissions Export to set hourly, daily, or weekly exports of any WordPress form submissions to any email address(es)!\",\"link\":\" https:\\/\\/ninjaforms.com\\/extensions\\/scheduled-submissions-export\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Scheduled+Submissions+Export\",\"plugin\":\"ninja-forms-scheduled-exports\\/ninja-forms-scheduled-exports.php\",\"docs\":\" https:\\/\\/ninjaforms.com\\/docs\\/scheduled-submissions-export\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Scheduled+Submissions+Export+Docs\",\"version\":\"3.0.2\",\"categories\":[{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"File Management\",\"slug\":\"file-management\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Manage Submissions\",\"slug\":\"manage-submissions\"}]},{\"title\":\"CiviCRM\",\"image\":\"assets\\/img\\/add-ons\\/civicrm.png\",\"content\":\"Connect & update your CiviCRM account from any WordPress form with the Ninja Forms CiviCRM add-on. Easily add or update Contacts & Activities!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/civicrm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=CiviCRM\",\"plugin\":\"ninja-forms-civicrm\\/ninja-forms-civicrm.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/civicrm\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=CiviCRM+Docs\",\"version\":\"3.0.0\",\"categories\":[{\"name\":\"CRM Integrations\",\"slug\":\"crm-integrations\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"File Uploads\",\"image\":\"assets\\/img\\/add-ons\\/file-uploads.png\",\"content\":\"Add file upload fields to any WordPress form. Set allowed file types, sizes, upload directories and save to WordPress, Google Drive and more.\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/file-uploads\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=File+Uploads\",\"plugin\":\"ninja-forms-uploads\\/file-uploads.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/file-uploads\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=File+Uploads+Docs\",\"version\":\"3.3.14\",\"categories\":[{\"name\":\"Content Management\",\"slug\":\"content-management\"},{\"name\":\"Developer\",\"slug\":\"developer\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"User\",\"slug\":\"user\"},{\"name\":\"Business\",\"slug\":\"business\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"File Management\",\"slug\":\"file-management\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Basic 2022\",\"slug\":\"basic-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Most Popular\",\"slug\":\"most-popular\"}]},{\"title\":\"User Management\",\"image\":\"assets\\/img\\/add-ons\\/user-management.png\",\"content\":\"Let users register, login, & manage profiles with customizable form templates. Allow user roles to view or edit form submissions. \",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/user-management\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=User+Management\",\"plugin\":\"ninja-forms-user-management\\/ninja-forms-user-management.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/user-management\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=User+Management+Docs\",\"version\":\"3.2.0\",\"categories\":[{\"name\":\"Content Management\",\"slug\":\"content-management\"},{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Manage Users\",\"slug\":\"user-management\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"Layout and Styles\",\"image\":\"assets\\/img\\/add-ons\\/layout-styles.png\",\"content\":\"Edit form styles. Create two column forms. Multi column forms. Easily adjust form layout. You don\'t need a designer, just Layout and Styles!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/layouts-and-styles\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Layout+and+Styles\",\"plugin\":\"ninja-forms-style\\/ninja-forms-style.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/layouts-and-styles\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Layout+and+Styles+Docs\",\"version\":\"3.0.29\",\"categories\":[{\"name\":\"Look &amp; Feel\",\"slug\":\"look-feel\"},{\"name\":\"Developer\",\"slug\":\"developer\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"User\",\"slug\":\"user\"},{\"name\":\"Business\",\"slug\":\"business\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Form Function and Design\",\"slug\":\"form-function-design\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Basic 2022\",\"slug\":\"basic-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Most Popular\",\"slug\":\"most-popular\"}]},{\"title\":\"Stripe\",\"image\":\"assets\\/img\\/add-ons\\/stripe.png\",\"content\":\"Use Stripe Checkout forms to sell products or subscriptions. Accept credit cards, Google Pay, Apple Pay, & much more!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/stripe\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Stripe\",\"plugin\":\"ninja-forms-stripe\\/ninja-forms-stripe.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/stripe\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Stripe+Docs\",\"version\":\"3.2.2\",\"categories\":[{\"name\":\"Payment Gateways\",\"slug\":\"payment-gateways\"},{\"name\":\"Developer\",\"slug\":\"developer\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"User\",\"slug\":\"user\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"}]},{\"title\":\"Conditional Logic\",\"image\":\"assets\\/img\\/add-ons\\/conditional-logic.png\",\"content\":\"Create forms that change as they\'re filled out. Show and hide fields, modify lists, send email to different recipients conditionally and much more.\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/conditional-logic\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Conditional+Logic\",\"plugin\":\"ninja-forms-conditionals\\/conditionals.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/conditional-logic\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Conditional+Logic+Docs\",\"version\":\"3.1\",\"categories\":[{\"name\":\"Look &amp; Feel\",\"slug\":\"look-feel\"},{\"name\":\"Actions\",\"slug\":\"actions\"},{\"name\":\"Developer\",\"slug\":\"developer\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"User\",\"slug\":\"user\"},{\"name\":\"Business\",\"slug\":\"business\"},{\"name\":\"Personal\",\"slug\":\"personal\"},{\"name\":\"Professional\",\"slug\":\"professional\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"Form Function and Design\",\"slug\":\"form-function-design\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Basic 2022\",\"slug\":\"basic-2022\"},{\"name\":\"Plus 2022\",\"slug\":\"plus-2022\"},{\"name\":\"Pro 2022\",\"slug\":\"pro-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Most Popular\",\"slug\":\"most-popular\"}]},{\"title\":\"PDF Form Submission\",\"image\":\"assets\\/img\\/add-ons\\/pdf-form-submission.png\",\"content\":\"Use PDF Form Submission to generate a PDF from any WordPress form submission. Create a fully customizable, fillable PDF from top to bottom!\",\"link\":\"https:\\/\\/ninjaforms.com\\/extensions\\/pdf\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=PDF+Form+Submission\",\"plugin\":\"ninja-forms-pdf-submissions\\/nf-pdf-submissions.php\",\"docs\":\"https:\\/\\/ninjaforms.com\\/docs\\/pdf\\/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=PDF+Form+Submission+Docs\",\"version\":\"3.2.0\",\"categories\":[{\"name\":\"Content Management\",\"slug\":\"content-management\"},{\"name\":\"Membership\",\"slug\":\"membership\"},{\"name\":\"Business\",\"slug\":\"business\"},{\"name\":\"Agency\",\"slug\":\"agency\"},{\"name\":\"File Management\",\"slug\":\"file-management\"},{\"name\":\"Memberships 2022\",\"slug\":\"memberships-2022\"},{\"name\":\"Elite 2022\",\"slug\":\"elite-2022\"},{\"name\":\"Manage Submissions\",\"slug\":\"manage-submissions\"}]}]","no");

INSERT IGNORE INTO `wpxd_options` VALUES 
("1769","category_children","a:0:{}","yes"),
("1969","nf_form_tel_sent","true","no"),
("1974","fbwidget_no_bug","1","no"),
("1975","ls-last-important-notice","2020-08-17","yes"),
("3131","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:17:\"info@deoworkz.net\";s:7:\"version\";s:5:\"5.7.8\";s:9:\"timestamp\";i:1666336384;}","no"),
("3701","auto_update_core_dev","enabled","yes"),
("3702","auto_update_core_minor","enabled","yes"),
("3703","auto_update_core_major","unset","yes"),
("3704","db_upgraded","","yes"),
("3744","avada_permalinks","a:3:{s:23:\"portfolio_category_base\";s:0:\"\";s:21:\"portfolio_skills_base\";s:0:\"\";s:19:\"portfolio_tags_base\";s:0:\"\";}","yes"),
("3757","avada_previous_version","a:4:{i:0;s:5:\"7.0.2\";i:1;s:5:\"7.2.0\";i:2;s:5:\"7.3.1\";i:3;s:6:\"7.10.0\";}","yes"),
("3774","widget_form-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("3779","fusion_form_cleanup_datetime","1686222282","yes"),
("29880","wfls_last_role_change","1686141454","no"),
("35027","https_detection_errors","a:0:{}","yes"),
("111112","ls-important-notice","a:9:{s:4:\"date\";s:10:\"2022-06-26\";s:5:\"title\";s:39:\"LayerSlider Security Update Recommended\";s:7:\"message\";s:227:\"Several security issues were fixed in the latest versions of LayerSlider. If you haven’t done it already, please update to LayerSlider 7.2.1. <a href=\"https://layerslider.com/how-to-update/\" target=\"_blank\">HOW TO UPDATE?</a>\";s:5:\"image\";s:0:\"\";s:6:\"banner\";a:5:{s:5:\"class\";s:21:\"ls-v7-security-banner\";s:5:\"style\";s:132:\"height: auto; margin: 39px auto 0 auto !important; min-width: 700px; max-width: 1700px; padding-right: 20px; box-sizing: border-box;\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:6:\"_blank\";s:7:\"content\";s:2674:\"\n\n		<style>\n		@import url(\"https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;800&display=swap\");\n		</style>\n		<style>\n\n			.ls-v7-security-banner {\n				max-width: 1200px !important;\n			}\n\n			.ls-v7-security-banner > a.dashicons-dismiss {\n				top: 0.2rem;\n				right: calc( 20px + 0.2rem ) !important;\n			}\n\n			#lspr-inner {\n				position: relative;\n				height: auto;\n				display: flex;\n				margin: 0 auto !important;\n				justify-content: space-between;\n			}\n\n			#lspr-right {\n				margin: 0 auto;\n				border-radius: 0.5rem;\n				background-color: #ee0070;\n				width: 100%;\n			}\n\n			.lspr-over {\n				position: relative;\n				z-index: 2;\n			}\n\n			#lspr-heading {\n				padding: 0.5rem 3rem 0 3rem;\n				color: white;\n				font-size: 1.2rem;\n				font-weight: 600;\n				font-family: Nunito, sans-serif;\n				text-align: center;\n			}\n\n			.lspr-nowrap {\n				white-space: nowrap;\n			}\n\n			.lspr-text {\n				position: relative;\n				z-index: 200;\n				margin: 0.3rem auto;\n				padding: 0 3rem;\n				color: white;\n				font-family: Nunito, sans-serif;\n				font-size: 1rem;\n				line-height: normal;\n				text-align: center;\n			}\n\n			.lspr-text a {\n				color: white;\n				font-weight: bold;\n			}\n\n			#lspr-buttons {\n				text-align: center;\n				padding-top: 0.1rem;\n				padding-bottom: 0.65rem;\n			}\n\n			#lspr-buttons a {\n				text-decoration: none;\n				color: #ee0070;\n				text-transform: uppercase;\n				font-family: Nunito, sans-serif;\n				font-weight: 800;\n				display: inline-block;\n				border-radius: 0.5rem;\n				background-color: white;\n				padding: 0 1rem;\n				line-height: 1.5rem;\n				font-size: 0.9rem;\n				transform: rotate(0.001deg);\n				transition: all 0.2s;\n				box-shadow: none;\n				cursor: pointer;\n			}\n\n			#lspr-buttons a:hover {\n				transform: rotate(0.001deg) scale(1.05);\n				box-shadow: 0 0.25vw 0.5vw rgba(0,0,0,0.15);\n			}\n\n			.layerslider_notice_img  .dashicons-dismiss {\n				right: 30px;\n			}\n\n			.lspr-bold {\n				font-weight: 800 !important;\n			}\n\n		</style>\n		<div id=\"lspr-inner\">\n			<div id=\"lspr-right\">\n				<div id=\"lspr-heading-small\" class=\"lspr-over\"></div>\n				<div id=\"lspr-heading\" class=\"lspr-over\">\n					<span class=\"lspr-nowrap\">LayerSlider Security Update Recommended<span>\n				</div>\n\n				<div class=\"lspr-text\" class=\"lspr-over\">\n					<span class=\"lspr-nowrap\">\n						Several security issues were fixed in the latest versions of LayerSlider.\n					</span>\n					<span class=\"lspr-nowrap\">\n						If you haven’t done it already, please update to LayerSlider 7.2.1.\n					</span>\n				</div>\n\n				<div id=\"lspr-buttons\" class=\"lspr-over\">\n					<a href=\"https://layerslider.com/how-to-update/\" target=\"_blank\">HOW TO UPDATE?</a>\n				</div>\n			</div>\n		</div>\";}s:11:\"min_version\";s:0:\"\";s:11:\"max_version\";s:5:\"7.1.1\";s:11:\"unactivated\";b:0;s:10:\"url_filter\";s:33:\"layerslider index.php plugins.php\";}","yes"),
("114417","ls-last-update-notification","7.2.2","yes"),
("114453","_transient_health-check-site-status-result","{\"good\":15,\"recommended\":4,\"critical\":2}","yes"),
("114455","widget_block","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("114456","wp_force_deactivated_plugins","a:0:{}","yes"),
("114457","user_count","1","no"),
("114469","can_compress_scripts","0","no"),
("114480","ihaf_activated","a:2:{s:6:\"wpcode\";i:1666336518;s:7:\"version\";s:6:\"2.0.12\";}","yes"),
("114481","wpcode_snippets","a:1:{s:15:\"after_paragraph\";a:0:{}}","yes"),
("114516","ls-remote-data","a:7:{s:9:\"templates\";a:4:{s:12:\"last_updated\";s:10:\"2023-05-23\";s:7:\"sliders\";a:117:{s:18:\"nature-photography\";a:7:{s:8:\"released\";s:10:\"2023-05-23\";s:4:\"name\";s:18:\"Nature Photography\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.7.6\";s:6:\"groups\";s:66:\"new,premium,slider,fullsize,landing,text,static,blendmode,parallax\";s:3:\"url\";s:51:\"https://layerslider.com/sliders/nature-photography/\";s:7:\"preview\";s:62:\"https://layerslider.com/media/templates/nature-photography.jpg\";}s:8:\"flowerin\";a:8:{s:8:\"released\";s:10:\"2023-05-03\";s:4:\"name\";s:8:\"FLOWERIN\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.7.0\";s:6:\"groups\";s:86:\"new,premium,fullsize,landing,pack,website,specialeffects,text,addons,popup,loop,static\";s:11:\"collections\";s:11:\"mothers-day\";s:3:\"url\";s:41:\"https://layerslider.com/sliders/flowerin/\";s:7:\"preview\";s:52:\"https://layerslider.com/media/templates/flowerin.jpg\";}s:15:\"the-web-company\";a:7:{s:8:\"released\";s:10:\"2023-04-17\";s:4:\"name\";s:15:\"The Web Company\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.7.0\";s:6:\"groups\";s:68:\"new,premium,fullsize,landing,pack,website,specialeffects,text,addons\";s:3:\"url\";s:48:\"https://layerslider.com/sliders/the-web-company/\";s:7:\"preview\";s:59:\"https://layerslider.com/media/templates/the-web-company.jpg\";}s:17:\"style-and-fashion\";a:7:{s:8:\"released\";s:10:\"2023-03-29\";s:4:\"name\";s:15:\"Style & Fashion\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.6.9\";s:6:\"groups\";s:60:\"new,premium,slider,fullsize,landing,blendmode,specialeffects\";s:3:\"url\";s:50:\"https://layerslider.com/sliders/style-and-fashion/\";s:7:\"preview\";s:61:\"https://layerslider.com/media/templates/style-and-fashion.jpg\";}s:24:\"scrolling-christmas-2022\";a:8:{s:8:\"released\";s:10:\"2022-12-18\";s:4:\"name\";s:19:\"Scrolling Christmas\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.6.0\";s:6:\"groups\";s:35:\"new,premium,slider,fullsize,landing\";s:11:\"collections\";s:9:\"christmas\";s:3:\"url\";s:57:\"https://layerslider.com/sliders/scrolling-christmas-2022/\";s:7:\"preview\";s:68:\"https://layerslider.com/media/templates/scrolling-christmas-2022.jpg\";}s:22:\"christmas-baubles-2022\";a:8:{s:8:\"released\";s:10:\"2022-12-15\";s:4:\"name\";s:17:\"Christmas Baubles\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.6.0\";s:6:\"groups\";s:40:\"new,premium,slider,fullsize,landing,text\";s:11:\"collections\";s:9:\"christmas\";s:3:\"url\";s:55:\"https://layerslider.com/sliders/christmas-baubles-2022/\";s:7:\"preview\";s:66:\"https://layerslider.com/media/templates/christmas-baubles-2022.jpg\";}s:20:\"sweet-christmas-2022\";a:8:{s:8:\"released\";s:10:\"2022-12-15\";s:4:\"name\";s:15:\"Sweet Christmas\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.6.0\";s:6:\"groups\";s:40:\"new,premium,slider,fullsize,landing,text\";s:11:\"collections\";s:9:\"christmas\";s:3:\"url\";s:53:\"https://layerslider.com/sliders/sweet-christmas-2022/\";s:7:\"preview\";s:64:\"https://layerslider.com/media/templates/sweet-christmas-2022.jpg\";}s:19:\"happy-holidays-2022\";a:8:{s:8:\"released\";s:10:\"2022-12-12\";s:4:\"name\";s:14:\"Happy Holidays\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.6.0\";s:6:\"groups\";s:35:\"new,premium,slider,fullsize,landing\";s:11:\"collections\";s:9:\"christmas\";s:3:\"url\";s:52:\"https://layerslider.com/sliders/happy-holidays-2022/\";s:7:\"preview\";s:63:\"https://layerslider.com/media/templates/happy-holidays-2022.jpg\";}s:25:\"christmas-decoration-2022\";a:8:{s:8:\"released\";s:10:\"2022-12-12\";s:4:\"name\";s:20:\"Christmas Decoration\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.6.0\";s:6:\"groups\";s:35:\"new,premium,slider,fullsize,landing\";s:11:\"collections\";s:9:\"christmas\";s:3:\"url\";s:58:\"https://layerslider.com/sliders/christmas-decoration-2022/\";s:7:\"preview\";s:69:\"https://layerslider.com/media/templates/christmas-decoration-2022.jpg\";}s:12:\"four-seasons\";a:7:{s:8:\"released\";s:10:\"2022-12-02\";s:4:\"name\";s:12:\"Four Seasons\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.6.0\";s:6:\"groups\";s:48:\"new,premium,fullsize,landing,text,specialeffects\";s:3:\"url\";s:45:\"https://layerslider.com/sliders/four-seasons/\";s:7:\"preview\";s:56:\"https://layerslider.com/media/templates/four-seasons.jpg\";}s:5:\"fairy\";a:7:{s:8:\"released\";s:10:\"2022-11-30\";s:4:\"name\";s:25:\"FAIRY - a magical company\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.6.0\";s:6:\"groups\";s:50:\"new,premium,landing,parallax,specialeffects,addons\";s:3:\"url\";s:38:\"https://layerslider.com/sliders/fairy/\";s:7:\"preview\";s:49:\"https://layerslider.com/media/templates/fairy.jpg\";}s:13:\"sweet-candies\";a:7:{s:8:\"released\";s:10:\"2022-11-23\";s:4:\"name\";s:13:\"Sweet Candies\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.6.0\";s:6:\"groups\";s:39:\"new,premium,landing,pack,website,addons\";s:3:\"url\";s:46:\"https://layerslider.com/sliders/sweet-candies/\";s:7:\"preview\";s:57:\"https://layerslider.com/media/templates/sweet-candies.jpg\";}s:22:\"scroll-transition-demo\";a:7:{s:8:\"released\";s:10:\"2022-08-03\";s:4:\"name\";s:22:\"Scroll Transition Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:7:\"7.3.0b1\";s:6:\"groups\";s:61:\"new,premium,slider,fullsize,specialeffects,experiments,addons\";s:3:\"url\";s:55:\"https://layerslider.com/sliders/scroll-transition-demo/\";s:7:\"preview\";s:66:\"https://layerslider.com/media/templates/scroll-transition-demo.jpg\";}s:17:\"modern-furnitures\";a:7:{s:8:\"released\";s:10:\"2022-07-19\";s:4:\"name\";s:17:\"Modern Furnitures\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.2.5\";s:6:\"groups\";s:54:\"new,premium,parallax,specialeffects,loop,static,slider\";s:3:\"url\";s:50:\"https://layerslider.com/sliders/modern-furnitures/\";s:7:\"preview\";s:61:\"https://layerslider.com/media/templates/modern-furnitures.jpg\";}s:14:\"f-and-p-juices\";a:7:{s:8:\"released\";s:10:\"2022-06-27\";s:4:\"name\";s:10:\"F&P Juices\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.2.1\";s:6:\"groups\";s:56:\"new,premium,specialeffects,landing,pack,website,parallax\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/f-and-p-juices/\";s:7:\"preview\";s:58:\"https://layerslider.com/media/templates/f-and-p-juices.jpg\";}s:14:\"save-the-world\";a:7:{s:8:\"released\";s:10:\"2022-05-02\";s:4:\"name\";s:14:\"Save the World\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.2.1\";s:6:\"groups\";s:49:\"new,premium,sliders,specialeffects,static,landing\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/save-the-world/\";s:7:\"preview\";s:58:\"https://layerslider.com/media/templates/save-the-world.jpg\";}s:7:\"new-era\";a:7:{s:8:\"released\";s:10:\"2022-04-21\";s:4:\"name\";s:7:\"New Era\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.2.0\";s:6:\"groups\";s:64:\"new,premium,sliders,specialeffects,parallax,loop,fullwidth,blend\";s:3:\"url\";s:40:\"https://layerslider.com/sliders/new-era/\";s:7:\"preview\";s:51:\"https://layerslider.com/media/templates/new-era.jpg\";}s:15:\"virtual-reality\";a:7:{s:8:\"released\";s:10:\"2022-03-21\";s:4:\"name\";s:15:\"Virtual Reality\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.0.8\";s:6:\"groups\";s:49:\"premium,sliders,specialeffects,parallax,loop,text\";s:3:\"url\";s:48:\"https://layerslider.com/sliders/virtual-reality/\";s:7:\"preview\";s:59:\"https://layerslider.com/media/templates/virtual-reality.jpg\";}s:12:\"fruit-juices\";a:7:{s:8:\"released\";s:10:\"2022-02-21\";s:4:\"name\";s:12:\"Fruit Juices\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.0.8\";s:6:\"groups\";s:39:\"premium,sliders,specialeffects,parallax\";s:3:\"url\";s:45:\"https://layerslider.com/sliders/fruit-juices/\";s:7:\"preview\";s:56:\"https://layerslider.com/media/templates/fruit-juices.jpg\";}s:12:\"before-after\";a:7:{s:8:\"released\";s:10:\"2022-02-14\";s:4:\"name\";s:14:\"Before | After\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.0.8\";s:6:\"groups\";s:32:\"premium,sliders,experiments,text\";s:3:\"url\";s:45:\"https://layerslider.com/sliders/before-after/\";s:7:\"preview\";s:56:\"https://layerslider.com/media/templates/before-after.jpg\";}s:16:\"panoramic-slider\";a:7:{s:8:\"released\";s:10:\"2022-02-08\";s:4:\"name\";s:16:\"Panoramic Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.0.7\";s:6:\"groups\";s:19:\"new,premium,sliders\";s:3:\"url\";s:49:\"https://layerslider.com/sliders/panoramic-slider/\";s:7:\"preview\";s:60:\"https://layerslider.com/media/templates/panoramic-slider.jpg\";}s:20:\"modern-home-for-sale\";a:7:{s:8:\"released\";s:10:\"2022-01-25\";s:4:\"name\";s:20:\"Modern Home for Sale\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.0.7\";s:6:\"groups\";s:41:\"new,premium,sliders,text,landing,parallax\";s:3:\"url\";s:53:\"https://layerslider.com/sliders/modern-home-for-sale/\";s:7:\"preview\";s:64:\"https://layerslider.com/media/templates/modern-home-for-sale.jpg\";}s:22:\"day-and-night-on-earth\";a:7:{s:8:\"released\";s:10:\"2022-01-17\";s:4:\"name\";s:22:\"Day and Night on Earth\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.0.7\";s:6:\"groups\";s:34:\"new,premium,sliders,specialeffects\";s:3:\"url\";s:55:\"https://layerslider.com/sliders/day-and-night-on-earth/\";s:7:\"preview\";s:66:\"https://layerslider.com/media/templates/day-and-night-on-earth.jpg\";}s:16:\"cosmetics-slider\";a:7:{s:8:\"released\";s:10:\"2022-01-11\";s:4:\"name\";s:16:\"Cosmetics Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"7.0.7\";s:6:\"groups\";s:19:\"new,premium,sliders\";s:3:\"url\";s:49:\"https://layerslider.com/sliders/cosmetics-slider/\";s:7:\"preview\";s:60:\"https://layerslider.com/media/templates/cosmetics-slider.jpg\";}s:15:\"back-to-the-80s\";a:7:{s:8:\"released\";s:10:\"2020-09-29\";s:4:\"name\";s:15:\"Back To The 80s\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:50:\"premium,sliders,parallax,loop,blend,specialeffects\";s:3:\"url\";s:48:\"https://layerslider.com/sliders/back-to-the-80s/\";s:7:\"preview\";s:59:\"https://layerslider.com/media/templates/back-to-the-80s.jpg\";}s:17:\"love-with-flowers\";a:8:{s:8:\"released\";s:10:\"2020-07-28\";s:4:\"name\";s:17:\"LOVE with Flowers\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:34:\"free,landing,sliders,parallax,loop\";s:11:\"collections\";s:11:\"mothers-day\";s:3:\"url\";s:50:\"https://layerslider.com/sliders/love-with-flowers/\";s:7:\"preview\";s:61:\"https://layerslider.com/media/templates/love-with-flowers.jpg\";}s:6:\"people\";a:7:{s:8:\"released\";s:10:\"2020-07-13\";s:4:\"name\";s:6:\"People\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:43:\"premium,landing,blend,static,specialeffects\";s:3:\"url\";s:39:\"https://layerslider.com/sliders/people/\";s:7:\"preview\";s:50:\"https://layerslider.com/media/templates/people.jpg\";}s:16:\"music-is-my-life\";a:7:{s:8:\"released\";s:10:\"2020-07-06\";s:4:\"name\";s:16:\"Music Is My Life\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:20:\"premium,slider,blend\";s:3:\"url\";s:49:\"https://layerslider.com/sliders/music-is-my-life/\";s:7:\"preview\";s:60:\"https://layerslider.com/media/templates/music-is-my-life.jpg\";}s:21:\"product-showcase-dark\";a:7:{s:8:\"released\";s:10:\"2020-07-01\";s:4:\"name\";s:25:\"Product Showcase – Dark\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:14:\"premium,slider\";s:3:\"url\";s:54:\"https://layerslider.com/sliders/product-showcase-dark/\";s:7:\"preview\";s:65:\"https://layerslider.com/media/templates/product-showcase-dark.jpg\";}s:13:\"team-showcase\";a:7:{s:8:\"released\";s:10:\"2020-06-24\";s:4:\"name\";s:13:\"Team Showcase\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:21:\"premium,slider,static\";s:3:\"url\";s:46:\"https://layerslider.com/sliders/team-showcase/\";s:7:\"preview\";s:57:\"https://layerslider.com/media/templates/team-showcase.jpg\";}s:14:\"furniture-shop\";a:7:{s:8:\"released\";s:10:\"2020-06-09\";s:4:\"name\";s:14:\"Furniture Shop\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:23:\"premium,landing,website\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/furniture-shop/\";s:7:\"preview\";s:58:\"https://layerslider.com/media/templates/furniture-shop.jpg\";}s:14:\"product-banner\";a:7:{s:8:\"released\";s:10:\"2020-06-02\";s:4:\"name\";s:14:\"Product Banner\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:18:\"free,slider,static\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/product-banner/\";s:7:\"preview\";s:58:\"https://layerslider.com/media/templates/product-banner.jpg\";}s:19:\"architecture-slider\";a:7:{s:8:\"released\";s:10:\"2020-05-26\";s:4:\"name\";s:19:\"Architecture Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:18:\"free,slider,static\";s:3:\"url\";s:52:\"https://layerslider.com/sliders/architecture-slider/\";s:7:\"preview\";s:63:\"https://layerslider.com/media/templates/architecture-slider.jpg\";}s:22:\"product-showcase-light\";a:7:{s:8:\"released\";s:10:\"2020-05-18\";s:4:\"name\";s:26:\"Product Showcase – Light\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:21:\"premium,slider,static\";s:3:\"url\";s:55:\"https://layerslider.com/sliders/product-showcase-light/\";s:7:\"preview\";s:66:\"https://layerslider.com/media/templates/product-showcase-light.jpg\";}s:12:\"fashion-shop\";a:7:{s:8:\"released\";s:10:\"2020-05-12\";s:4:\"name\";s:12:\"Fashion Shop\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:18:\"free,slider,static\";s:3:\"url\";s:45:\"https://layerslider.com/sliders/fashion-shop/\";s:7:\"preview\";s:56:\"https://layerslider.com/media/templates/fashion-shop.jpg\";}s:12:\"pixel-agency\";a:7:{s:8:\"released\";s:10:\"2020-05-05\";s:4:\"name\";s:12:\"PIXEL Agency\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:51:\"premium,fullwidth,landing,website,text,popup,static\";s:3:\"url\";s:45:\"https://layerslider.com/sliders/pixel-agency/\";s:7:\"preview\";s:56:\"https://layerslider.com/media/templates/pixel-agency.jpg\";}s:11:\"mode-slider\";a:7:{s:8:\"released\";s:10:\"2020-04-28\";s:4:\"name\";s:11:\"Mode Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:26:\"free,fullwidth,slider,text\";s:3:\"url\";s:44:\"https://layerslider.com/sliders/mode-slider/\";s:7:\"preview\";s:55:\"https://layerslider.com/media/templates/mode-slider.jpg\";}s:13:\"mountain-bike\";a:7:{s:8:\"released\";s:10:\"2020-04-22\";s:4:\"name\";s:13:\"Mountain Bike\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:41:\"premium,fullsize,landing,pack,static,text\";s:3:\"url\";s:46:\"https://layerslider.com/sliders/mountain-bike/\";s:7:\"preview\";s:57:\"https://layerslider.com/media/templates/mountain-bike.jpg\";}s:18:\"aerial-photography\";a:7:{s:8:\"released\";s:10:\"2020-04-14\";s:4:\"name\";s:18:\"Aerial Photography\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:35:\"premium,slider,static,text,kenburns\";s:3:\"url\";s:51:\"https://layerslider.com/sliders/aerial-photography/\";s:7:\"preview\";s:62:\"https://layerslider.com/media/templates/aerial-photography.jpg\";}s:24:\"simple-fullscreen-slider\";a:7:{s:8:\"released\";s:10:\"2020-04-07\";s:4:\"name\";s:24:\"Simple Fullscreen Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:42:\"free,fullsize,landing,static,text,kenburns\";s:3:\"url\";s:57:\"https://layerslider.com/sliders/simple-fullscreen-slider/\";s:7:\"preview\";s:68:\"https://layerslider.com/media/templates/simple-fullscreen-slider.jpg\";}s:21:\"covid-19-notification\";a:8:{s:8:\"released\";s:10:\"2020-04-01\";s:4:\"name\";s:21:\"COVID-19 Notification\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:13:\"premium,popup\";s:3:\"url\";s:53:\"https://layerslider.com/popups/#covid-19-notification\";s:7:\"preview\";s:65:\"https://layerslider.com/media/templates/covid-19-notification.jpg\";}s:19:\"covid-19-bottom-bar\";a:8:{s:8:\"released\";s:10:\"2020-04-01\";s:4:\"name\";s:19:\"COVID-19 Bottom Bar\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:13:\"premium,popup\";s:3:\"url\";s:51:\"https://layerslider.com/popups/#covid-19-bottom-bar\";s:7:\"preview\";s:63:\"https://layerslider.com/media/templates/covid-19-bottom-bar.jpg\";}s:14:\"top-bar-notice\";a:8:{s:8:\"released\";s:10:\"2020-04-01\";s:4:\"name\";s:14:\"Top Bar Notice\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:13:\"premium,popup\";s:3:\"url\";s:46:\"https://layerslider.com/popups/#top-bar-notice\";s:7:\"preview\";s:58:\"https://layerslider.com/media/templates/top-bar-notice.jpg\";}s:20:\"christmas-snow-globe\";a:9:{s:8:\"released\";s:10:\"2019-12-19\";s:4:\"name\";s:20:\"Christmas Snow Globe\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:34:\"premium,parallax,popup,loop,filter\";s:11:\"collections\";s:9:\"christmas\";s:3:\"url\";s:52:\"https://layerslider.com/popups/#christmas-snow-globe\";s:7:\"preview\";s:64:\"https://layerslider.com/media/templates/christmas-snow-globe.jpg\";}s:9:\"xmas-2019\";a:8:{s:8:\"released\";s:10:\"2019-12-19\";s:4:\"name\";s:9:\"Xmas 2019\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:32:\"free,parallax,slider,loop,filter\";s:11:\"collections\";s:9:\"christmas\";s:3:\"url\";s:42:\"https://layerslider.com/sliders/xmas-2019/\";s:7:\"preview\";s:53:\"https://layerslider.com/media/templates/xmas-2019.jpg\";}s:18:\"creative-portraits\";a:7:{s:8:\"released\";s:10:\"2019-12-09\";s:4:\"name\";s:18:\"Creative Portraits\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:32:\"premium,fullwidth,landing,static\";s:3:\"url\";s:51:\"https://layerslider.com/sliders/creative-portraits/\";s:7:\"preview\";s:62:\"https://layerslider.com/media/templates/creative-portraits.jpg\";}s:13:\"parallax-city\";a:7:{s:8:\"released\";s:10:\"2019-12-02\";s:4:\"name\";s:13:\"Parallax City\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:58:\"premium,landing,pack,parallax,text,blend,fullwidth,website\";s:3:\"url\";s:46:\"https://layerslider.com/sliders/parallax-city/\";s:7:\"preview\";s:57:\"https://layerslider.com/media/templates/parallax-city.jpg\";}s:10:\"cybertruck\";a:7:{s:8:\"released\";s:10:\"2019-11-28\";s:4:\"name\";s:10:\"Cybertruck\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:39:\"premium,fullsize,landing,specialeffects\";s:3:\"url\";s:43:\"https://layerslider.com/sliders/cybertruck/\";s:7:\"preview\";s:54:\"https://layerslider.com/media/templates/cybertruck.jpg\";}s:17:\"summer-collection\";a:7:{s:8:\"released\";s:10:\"2019-11-21\";s:4:\"name\";s:17:\"Summer Collection\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:21:\"free,fullwidth,slider\";s:3:\"url\";s:50:\"https://layerslider.com/sliders/summer-collection/\";s:7:\"preview\";s:61:\"https://layerslider.com/media/templates/summer-collection.jpg\";}s:18:\"nature-slider-pack\";a:7:{s:8:\"released\";s:10:\"2019-11-14\";s:4:\"name\";s:18:\"Nature Slider PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.9.0\";s:6:\"groups\";s:62:\"premium,text,blend,fullwidth,media,landing,packs,popup,website\";s:3:\"url\";s:51:\"https://layerslider.com/sliders/nature-slider-pack/\";s:7:\"preview\";s:62:\"https://layerslider.com/media/templates/nature-slider-pack.jpg\";}s:20:\"catering-xmas-slider\";a:8:{s:8:\"released\";s:10:\"2017-12-22\";s:4:\"name\";s:25:\"Catering Christmas Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:32:\"premium,static,text,blend,slider\";s:11:\"collections\";s:9:\"christmas\";s:3:\"url\";s:58:\"https://layerslider.com/sliders/catering-christmas-slider/\";s:7:\"preview\";s:64:\"https://layerslider.com/media/templates/catering-xmas-slider.jpg\";}s:20:\"discover-the-details\";a:7:{s:8:\"released\";s:10:\"2017-12-19\";s:4:\"name\";s:20:\"Discover the Details\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:50:\"free,loop,parallax,blendmode,specialeffects,slider\";s:3:\"url\";s:53:\"https://layerslider.com/sliders/discover-the-details/\";s:7:\"preview\";s:64:\"https://layerslider.com/media/templates/discover-the-details.jpg\";}s:10:\"rainforest\";a:7:{s:8:\"released\";s:10:\"2017-12-17\";s:4:\"name\";s:10:\"Rainforest\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:57:\"free,loop,filter,blendmode,fullsize,specialeffects,slider\";s:3:\"url\";s:43:\"https://layerslider.com/sliders/rainforest/\";s:7:\"preview\";s:54:\"https://layerslider.com/media/templates/rainforest.jpg\";}s:30:\"ecommerce-global-hover-example\";a:7:{s:8:\"released\";s:10:\"2017-12-15\";s:4:\"name\";s:30:\"eCommerce Global Hover Example\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:26:\"premium,experiments,slider\";s:3:\"url\";s:63:\"https://layerslider.com/sliders/ecommerce-global-hover-example/\";s:7:\"preview\";s:74:\"https://layerslider.com/media/templates/ecommerce-global-hover-example.jpg\";}s:20:\"3d-canyon-experience\";a:7:{s:8:\"released\";s:10:\"2017-12-13\";s:4:\"name\";s:20:\"3D Canyon Experience\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:40:\"premium,parallax,experiments,text,slider\";s:3:\"url\";s:53:\"https://layerslider.com/sliders/3d-canyon-experience/\";s:7:\"preview\";s:64:\"https://layerslider.com/media/templates/3d-canyon-experience.jpg\";}s:14:\"vintage-photos\";a:7:{s:8:\"released\";s:10:\"2017-12-08\";s:4:\"name\";s:14:\"Vintage Photos\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:50:\"premium,fullsize,loop,filter,specialeffects,slider\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/vintage-photos/\";s:7:\"preview\";s:58:\"https://layerslider.com/media/templates/vintage-photos.jpg\";}s:8:\"aquarium\";a:7:{s:8:\"released\";s:10:\"2017-12-04\";s:4:\"name\";s:8:\"Aquarium\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:71:\"premium,parallax,fullsize,loop,filter,experiments,specialeffects,slider\";s:3:\"url\";s:41:\"https://layerslider.com/sliders/aquarium/\";s:7:\"preview\";s:52:\"https://layerslider.com/media/templates/aquarium.jpg\";}s:16:\"what-is-the-time\";a:7:{s:8:\"released\";s:10:\"2017-08-25\";s:4:\"name\";s:17:\"What is the time?\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:54:\"premium,parallax,text,blendmode,experiments,api,slider\";s:3:\"url\";s:49:\"https://layerslider.com/sliders/what-is-the-time/\";s:7:\"preview\";s:60:\"https://layerslider.com/media/templates/what-is-the-time.jpg\";}s:18:\"personal-page-pack\";a:7:{s:8:\"released\";s:10:\"2017-08-23\";s:4:\"name\";s:18:\"Personal Page PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:62:\"premium,fullsize,fullwidth,landing,text,parallax,packs,website\";s:3:\"url\";s:51:\"https://layerslider.com/sliders/personal-page-pack/\";s:7:\"preview\";s:62:\"https://layerslider.com/media/templates/personal-page-pack.jpg\";}s:19:\"marketing-page-pack\";a:7:{s:8:\"released\";s:10:\"2017-08-21\";s:4:\"name\";s:19:\"Marketing Page PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:69:\"premium,fullsize,fullwidth,landing,parallax,static,loop,packs,website\";s:3:\"url\";s:52:\"https://layerslider.com/sliders/marketing-page-pack/\";s:7:\"preview\";s:63:\"https://layerslider.com/media/templates/marketing-page-pack.jpg\";}s:14:\"dynamic-slider\";a:7:{s:8:\"released\";s:10:\"2017-08-18\";s:4:\"name\";s:14:\"Dynamic Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:32:\"premium,fullwidth,landing,static\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/dynamic-slider/\";s:7:\"preview\";s:58:\"https://layerslider.com/media/templates/dynamic-slider.jpg\";}s:14:\"colorful-cases\";a:7:{s:8:\"released\";s:10:\"2017-08-16\";s:4:\"name\";s:14:\"Colorful Cases\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:50:\"premium,text,loop,parallax,static,blendmode,slider\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/colorful-cases/\";s:7:\"preview\";s:58:\"https://layerslider.com/media/templates/colorful-cases.jpg\";}s:16:\"beauty-shop-pack\";a:8:{s:8:\"released\";s:10:\"2017-08-14\";s:4:\"name\";s:16:\"Beauty Shop PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:44:\"premium,fullwidth,text,landing,packs,website\";s:11:\"collections\";s:11:\"mothers-day\";s:3:\"url\";s:49:\"https://layerslider.com/sliders/beauty-shop-pack/\";s:7:\"preview\";s:60:\"https://layerslider.com/media/templates/beauty-shop-pack.jpg\";}s:14:\"discount-popup\";a:8:{s:8:\"released\";s:10:\"2017-12-10\";s:4:\"name\";s:14:\"Discount Popup\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:13:\"premium,popup\";s:3:\"url\";s:46:\"https://layerslider.com/popups/#discount-popup\";s:7:\"preview\";s:58:\"https://layerslider.com/media/templates/discount-popup.jpg\";}s:18:\"social-share-popup\";a:8:{s:8:\"released\";s:10:\"2017-12-06\";s:4:\"name\";s:18:\"Social Share Popup\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:17:\"premium,popup,api\";s:3:\"url\";s:50:\"https://layerslider.com/popups/#social-share-popup\";s:7:\"preview\";s:62:\"https://layerslider.com/media/templates/social-share-popup.jpg\";}s:16:\"popup-guide-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:16:\"Popup Guide Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:27:\"premium,popup,parallax,text\";s:3:\"url\";s:48:\"https://layerslider.com/popups/#popup-guide-demo\";s:7:\"preview\";s:60:\"https://layerslider.com/media/templates/popup-guide-demo.jpg\";}s:18:\"popup-welcome-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Welcome Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:27:\"premium,popup,parallax,text\";s:3:\"url\";s:50:\"https://layerslider.com/popups/#popup-welcome-demo\";s:7:\"preview\";s:62:\"https://layerslider.com/media/templates/popup-welcome-demo.jpg\";}s:22:\"popup-transparent-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:22:\"Popup Transparent Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:27:\"premium,popup,parallax,loop\";s:3:\"url\";s:54:\"https://layerslider.com/popups/#popup-transparent-demo\";s:7:\"preview\";s:66:\"https://layerslider.com/media/templates/popup-transparent-demo.jpg\";}s:18:\"popup-sidebar-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Sidebar Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:40:\"premium,popup,experiments,blendmode,text\";s:3:\"url\";s:50:\"https://layerslider.com/popups/#popup-sidebar-demo\";s:7:\"preview\";s:62:\"https://layerslider.com/media/templates/popup-sidebar-demo.jpg\";}s:19:\"popup-photo-gallery\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:19:\"Popup Photo Gallery\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:22:\"premium,popup,kenburns\";s:3:\"url\";s:51:\"https://layerslider.com/popups/#popup-photo-gallery\";s:7:\"preview\";s:63:\"https://layerslider.com/media/templates/popup-photo-gallery.jpg\";}s:16:\"popup-modal-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:16:\"Popup Modal Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:20:\"premium,popup,static\";s:3:\"url\";s:48:\"https://layerslider.com/popups/#popup-modal-demo\";s:7:\"preview\";s:60:\"https://layerslider.com/media/templates/popup-modal-demo.jpg\";}s:18:\"popup-infobar-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Infobar Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:30:\"premium,popup,experiments,text\";s:3:\"url\";s:50:\"https://layerslider.com/popups/#popup-infobar-demo\";s:7:\"preview\";s:62:\"https://layerslider.com/media/templates/popup-infobar-demo.jpg\";}s:24:\"popup-fullsize-desk-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:24:\"Popup Fullsize Desk Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:43:\"premium,popup,experiments,fullsize,parallax\";s:3:\"url\";s:56:\"https://layerslider.com/popups/#popup-fullsize-desk-demo\";s:7:\"preview\";s:68:\"https://layerslider.com/media/templates/popup-fullsize-desk-demo.jpg\";}s:18:\"conversation-popup\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Conversation Popup\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:25:\"premium,popup,experiments\";s:3:\"url\";s:50:\"https://layerslider.com/popups/#conversation-popup\";s:7:\"preview\";s:62:\"https://layerslider.com/media/templates/conversation-popup.jpg\";}s:20:\"global-hover-example\";a:7:{s:8:\"released\";s:10:\"2017-05-02\";s:4:\"name\";s:20:\"Global Hover Example\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.4.0\";s:6:\"groups\";s:55:\"premium,experiments,specialeffects,parallax,text,slider\";s:3:\"url\";s:53:\"https://layerslider.com/sliders/global-hover-example/\";s:7:\"preview\";s:64:\"https://layerslider.com/media/templates/global-hover-example.jpg\";}s:10:\"gastronomy\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:10:\"Gastronomy\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.2.2\";s:6:\"groups\";s:35:\"premium,kenburns,filter,text,slider\";s:3:\"url\";s:43:\"https://layerslider.com/sliders/gastronomy/\";s:7:\"preview\";s:54:\"https://layerslider.com/media/templates/gastronomy.jpg\";}s:13:\"police-lights\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:13:\"Police Lights\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:50:\"free,specialeffects,loop,blendmode,parallax,slider\";s:3:\"url\";s:46:\"https://layerslider.com/sliders/police-lights/\";s:7:\"preview\";s:57:\"https://layerslider.com/media/templates/police-lights.jpg\";}s:16:\"beautiful-sunset\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:16:\"Beautiful Sunset\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:41:\"free,specialeffects,loop,blendmode,slider\";s:3:\"url\";s:49:\"https://layerslider.com/sliders/beautiful-sunset/\";s:7:\"preview\";s:60:\"https://layerslider.com/media/templates/beautiful-sunset.jpg\";}s:23:\"blend-mode-experiment-1\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:23:\"Blend Mode Experiment 1\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:67:\"free,specialeffects,text,blendmode,experiments,loop,parallax,slider\";s:3:\"url\";s:56:\"https://layerslider.com/sliders/blend-mode-experiment-1/\";s:7:\"preview\";s:67:\"https://layerslider.com/media/templates/blend-mode-experiment-1.jpg\";}s:16:\"flying-banners-2\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:16:\"Flying Banners 2\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:47:\"premium,parallax,specialeffects,fullsize,slider\";s:3:\"url\";s:49:\"https://layerslider.com/sliders/flying-banners-2/\";s:7:\"preview\";s:60:\"https://layerslider.com/media/templates/flying-banners-2.jpg\";}s:14:\"layerslider-v6\";a:7:{s:8:\"released\";s:10:\"2017-03-08\";s:4:\"name\";s:14:\"LayerSlider v6\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.6\";s:6:\"groups\";s:75:\"premium,specialeffects,parallax,fullsize,landing,loop,text,media,api,slider\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/layerslider-v6/\";s:7:\"preview\";s:58:\"https://layerslider.com/media/templates/layerslider-v6.jpg\";}s:16:\"flying-banners-1\";a:7:{s:8:\"released\";s:10:\"2017-03-08\";s:4:\"name\";s:16:\"Flying Banners 1\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:45:\"free,parallax,loop,text,specialeffects,slider\";s:3:\"url\";s:49:\"https://layerslider.com/sliders/flying-banners-1/\";s:7:\"preview\";s:60:\"https://layerslider.com/media/templates/flying-banners-1.jpg\";}s:18:\"anniversary-slider\";a:7:{s:8:\"released\";s:10:\"2017-03-08\";s:4:\"name\";s:18:\"Anniversary Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:47:\"free,parallax,experiments,specialeffects,slider\";s:3:\"url\";s:51:\"https://layerslider.com/sliders/anniversary-slider/\";s:7:\"preview\";s:62:\"https://layerslider.com/media/templates/anniversary-slider.jpg\";}s:7:\"origami\";a:7:{s:8:\"released\";s:10:\"2016-12-07\";s:4:\"name\";s:7:\"Origami\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:61:\"premium,experiments,specialeffects,3dtransition,slider,addons\";s:3:\"url\";s:40:\"https://layerslider.com/sliders/origami/\";s:7:\"preview\";s:51:\"https://layerslider.com/media/templates/origami.jpg\";}s:17:\"origami-buildings\";a:7:{s:8:\"released\";s:10:\"2016-12-07\";s:4:\"name\";s:17:\"Origami Buildings\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:70:\"premium,experiments,specialeffects,kenburns,3dtransition,slider,addons\";s:3:\"url\";s:50:\"https://layerslider.com/sliders/origami-buildings/\";s:7:\"preview\";s:61:\"https://layerslider.com/media/templates/origami-buildings.jpg\";}s:17:\"autumn-experiment\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:17:\"Autumn Experiment\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:52:\"experiments,free,loop,parallax,specialeffects,slider\";s:3:\"url\";s:50:\"https://layerslider.com/sliders/autumn-experiment/\";s:7:\"preview\";s:61:\"https://layerslider.com/media/templates/autumn-experiment.jpg\";}s:28:\"features-parallax-experiment\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:32:\"Features | A Parallax Experiment\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:47:\"experiments,free,parallax,specialeffects,slider\";s:3:\"url\";s:61:\"https://layerslider.com/sliders/features-parallax-experiment/\";s:7:\"preview\";s:72:\"https://layerslider.com/media/templates/features-parallax-experiment.jpg\";}s:16:\"furniture-slider\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:16:\"Furniture Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:40:\"fullwidth,parallax,premium,static,slider\";s:3:\"url\";s:49:\"https://layerslider.com/sliders/furniture-slider/\";s:7:\"preview\";s:60:\"https://layerslider.com/media/templates/furniture-slider.jpg\";}s:15:\"room-experiment\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:15:\"Room Experiment\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.6\";s:6:\"groups\";s:72:\"api,experiments,media,parallax,premium,specialeffects,static,text,slider\";s:3:\"url\";s:48:\"https://layerslider.com/sliders/room-experiment/\";s:7:\"preview\";s:59:\"https://layerslider.com/media/templates/room-experiment.jpg\";}s:11:\"drag-n-drop\";a:6:{s:4:\"name\";s:11:\"Drag & Drop\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:44:\"premium,fullwidth,specialeffects,text,slider\";s:3:\"url\";s:44:\"https://layerslider.com/sliders/drag-n-drop/\";s:7:\"preview\";s:55:\"https://layerslider.com/media/templates/drag-n-drop.jpg\";}s:10:\"headphones\";a:6:{s:4:\"name\";s:10:\"Headphones\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:21:\"premium,static,slider\";s:3:\"url\";s:43:\"https://layerslider.com/sliders/headphones/\";s:7:\"preview\";s:54:\"https://layerslider.com/media/templates/headphones.jpg\";}s:14:\"play-by-scroll\";a:6:{s:4:\"name\";s:19:\"Play By Scroll demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:80:\"premium,fullsize,text,experiments,specialeffects,playbyscroll,loop,slider,addons\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/play-by-scroll/\";s:7:\"preview\";s:58:\"https://layerslider.com/media/templates/play-by-scroll.jpg\";}s:3:\"sky\";a:6:{s:4:\"name\";s:14:\"Sky Experience\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:70:\"premium,fullwidth,text,experiments,parallax,specialeffects,loop,slider\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/sky-experience/\";s:7:\"preview\";s:47:\"https://layerslider.com/media/templates/sky.jpg\";}s:9:\"halloween\";a:7:{s:4:\"name\";s:16:\"Happy Halloween!\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:42:\"free,fullsize,text,experiments,loop,slider\";s:11:\"collections\";s:9:\"halloween\";s:3:\"url\";s:48:\"https://layerslider.com/sliders/happy-halloween/\";s:7:\"preview\";s:53:\"https://layerslider.com/media/templates/halloween.jpg\";}s:15:\"creative-agency\";a:6:{s:4:\"name\";s:6:\"Agency\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:49:\"premium,fullsize,kenburns,parallax,landing,filter\";s:3:\"url\";s:48:\"https://layerslider.com/sliders/creative-agency/\";s:7:\"preview\";s:59:\"https://layerslider.com/media/templates/creative-agency.jpg\";}s:18:\"interactive-slider\";a:6:{s:4:\"name\";s:18:\"Interactive Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:47:\"premium,fullsize,parallax,kenburns,text,landing\";s:3:\"url\";s:51:\"https://layerslider.com/sliders/interactive-slider/\";s:7:\"preview\";s:62:\"https://layerslider.com/media/templates/interactive-slider.jpg\";}s:9:\"ecommerce\";a:6:{s:4:\"name\";s:9:\"eCommerce\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:24:\"premium,fullwidth,slider\";s:3:\"url\";s:42:\"https://layerslider.com/sliders/ecommerce/\";s:7:\"preview\";s:53:\"https://layerslider.com/media/templates/ecommerce.jpg\";}s:17:\"landing-page-pack\";a:6:{s:4:\"name\";s:17:\"Landing Page PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:62:\"premium,fullsize,fullwidth,landing,parallax,text,packs,website\";s:3:\"url\";s:45:\"https://layerslider.com/sliders/landing-page/\";s:7:\"preview\";s:61:\"https://layerslider.com/media/templates/landing-page-pack.jpg\";}s:6:\"hiking\";a:6:{s:4:\"name\";s:6:\"Hiking\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:24:\"premium,fullwidth,slider\";s:3:\"url\";s:39:\"https://layerslider.com/sliders/hiking/\";s:7:\"preview\";s:50:\"https://layerslider.com/media/templates/hiking.jpg\";}s:12:\"movie-slider\";a:6:{s:4:\"name\";s:12:\"Movie Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:24:\"premium,fullwidth,slider\";s:3:\"url\";s:45:\"https://layerslider.com/sliders/movie-slider/\";s:7:\"preview\";s:56:\"https://layerslider.com/media/templates/movie-slider.jpg\";}s:12:\"photo-studio\";a:6:{s:4:\"name\";s:12:\"Photo Studio\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:70:\"premium,fullsize,filter,text,parallax,specialeffects,blendmode,landing\";s:3:\"url\";s:45:\"https://layerslider.com/sliders/photo-studio/\";s:7:\"preview\";s:56:\"https://layerslider.com/media/templates/photo-studio.jpg\";}s:5:\"shoes\";a:6:{s:4:\"name\";s:5:\"Shoes\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:42:\"premium,fullwidth,parallax,carousel,slider\";s:3:\"url\";s:38:\"https://layerslider.com/sliders/shoes/\";s:7:\"preview\";s:49:\"https://layerslider.com/media/templates/shoes.jpg\";}s:11:\"mini-cooper\";a:6:{s:4:\"name\";s:18:\"Mini Cooper Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:47:\"premium,fullsize,parallax,specialeffects,slider\";s:3:\"url\";s:51:\"https://layerslider.com/sliders/mini-cooper-slider/\";s:7:\"preview\";s:55:\"https://layerslider.com/media/templates/mini-cooper.jpg\";}s:4:\"xmas\";a:7:{s:4:\"name\";s:16:\"Merry Christmas!\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:64:\"free,parallax,filter,experiments,specialeffects,text,loop,slider\";s:11:\"collections\";s:9:\"christmas\";s:3:\"url\";s:48:\"https://layerslider.com/sliders/merry-christmas/\";s:7:\"preview\";s:48:\"https://layerslider.com/media/templates/xmas.jpg\";}s:5:\"clock\";a:6:{s:4:\"name\";s:32:\"Vintage Clock | shows valid time\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:44:\"premium,fullsize,api,experiments,loop,slider\";s:3:\"url\";s:46:\"https://layerslider.com/sliders/vintage-clock/\";s:7:\"preview\";s:49:\"https://layerslider.com/media/templates/clock.jpg\";}s:8:\"car-show\";a:6:{s:4:\"name\";s:8:\"Car Show\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:45:\"premium,fullwidth,experiments,api,loop,slider\";s:3:\"url\";s:41:\"https://layerslider.com/sliders/car-show/\";s:7:\"preview\";s:52:\"https://layerslider.com/media/templates/car-show.jpg\";}s:8:\"carousel\";a:6:{s:4:\"name\";s:8:\"Carousel\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:20:\"free,carousel,slider\";s:3:\"url\";s:41:\"https://layerslider.com/sliders/carousel/\";s:7:\"preview\";s:52:\"https://layerslider.com/media/templates/carousel.jpg\";}s:14:\"fancy-parallax\";a:6:{s:4:\"name\";s:21:\"Fancy Parallax Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:33:\"premium,fullwidth,parallax,slider\";s:3:\"url\";s:48:\"https://layerslider.com/sliders/parallax-slider/\";s:7:\"preview\";s:58:\"https://layerslider.com/media/templates/fancy-parallax.jpg\";}s:13:\"simple-slider\";a:6:{s:4:\"name\";s:13:\"Simple Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:11:\"free,slider\";s:3:\"url\";s:46:\"https://layerslider.com/sliders/simple-slider/\";s:7:\"preview\";s:57:\"https://layerslider.com/media/templates/simple-slider.jpg\";}s:12:\"image-slider\";a:6:{s:4:\"name\";s:12:\"Image Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:11:\"free,slider\";s:3:\"url\";s:48:\"https://layerslider.com/sliders/image-slideshow/\";s:7:\"preview\";s:56:\"https://layerslider.com/media/templates/image-slider.jpg\";}s:19:\"client-testimonials\";a:6:{s:4:\"name\";s:19:\"Client Testimonials\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:24:\"premium,fullwidth,slider\";s:3:\"url\";s:52:\"https://layerslider.com/sliders/client-testimonials/\";s:7:\"preview\";s:63:\"https://layerslider.com/media/templates/client-testimonials.jpg\";}s:8:\"fixed-bg\";a:6:{s:4:\"name\";s:16:\"Fixed Background\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:30:\"premium,fullwidth,media,slider\";s:3:\"url\";s:49:\"https://layerslider.com/sliders/fixed-background/\";s:7:\"preview\";s:52:\"https://layerslider.com/media/templates/fixed-bg.jpg\";}s:22:\"dynamic-content-slider\";a:6:{s:4:\"name\";s:22:\"Dynamic Content Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:11:\"free,slider\";s:3:\"url\";s:55:\"https://layerslider.com/sliders/dynamic-content-slider/\";s:7:\"preview\";s:66:\"https://layerslider.com/media/templates/dynamic-content-slider.jpg\";}s:6:\"old-3d\";a:6:{s:4:\"name\";s:14:\"LayerSlider v4\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:30:\"free,3dtransition,media,slider\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/3d-demo-slider/\";s:7:\"preview\";s:50:\"https://layerslider.com/media/templates/old-3d.jpg\";}s:2:\"v5\";a:6:{s:4:\"name\";s:14:\"LayerSlider v5\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:26:\"free,parallax,media,slider\";s:3:\"url\";s:47:\"https://layerslider.com/sliders/layerslider-v5/\";s:7:\"preview\";s:46:\"https://layerslider.com/media/templates/v5.jpg\";}s:12:\"video-slider\";a:6:{s:4:\"name\";s:12:\"Video Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:17:\"free,media,slider\";s:3:\"url\";s:45:\"https://layerslider.com/sliders/video-slider/\";s:7:\"preview\";s:56:\"https://layerslider.com/media/templates/video-slider.jpg\";}s:6:\"resort\";a:6:{s:4:\"name\";s:6:\"Resort\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:14:\"premium,slider\";s:3:\"url\";s:40:\"https://layerslider.com/sliders/restort/\";s:7:\"preview\";s:50:\"https://layerslider.com/media/templates/resort.jpg\";}}s:15:\"kreatura-popups\";a:20:{s:22:\"mothers-day-2023-popup\";a:9:{s:8:\"released\";s:10:\"2023-05-03\";s:4:\"name\";s:19:\"Mother’s Day 2023\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"7.7.0\";s:6:\"groups\";s:36:\"premium,new,popup,seasonal,promotion\";s:11:\"collections\";s:11:\"mothers-day\";s:3:\"url\";s:54:\"https://layerslider.com/popups/#mothers-day-2023-popup\";s:7:\"preview\";s:66:\"https://layerslider.com/media/templates/mothers-day-2023-popup.jpg\";}s:26:\"happy-fluffy-holidays-2022\";a:9:{s:8:\"released\";s:10:\"2022-12-18\";s:4:\"name\";s:22:\"Happy Fluffy Holidays!\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"7.6.0\";s:6:\"groups\";s:26:\"premium,new,popup,seasonal\";s:11:\"collections\";s:9:\"christmas\";s:3:\"url\";s:58:\"https://layerslider.com/popups/#happy-fluffy-holidays-2022\";s:7:\"preview\";s:70:\"https://layerslider.com/media/templates/happy-fluffy-holidays-2022.jpg\";}s:31:\"christmas-decoration-popup-2022\";a:9:{s:8:\"released\";s:10:\"2022-12-12\";s:4:\"name\";s:26:\"Christmas Decoration Popup\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"7.6.0\";s:6:\"groups\";s:26:\"premium,new,popup,seasonal\";s:11:\"collections\";s:9:\"christmas\";s:3:\"url\";s:63:\"https://layerslider.com/popups/#christmas-decoration-popup-2022\";s:7:\"preview\";s:75:\"https://layerslider.com/media/templates/christmas-decoration-popup-2022.jpg\";}s:20:\"christmas-bottom-bar\";a:9:{s:8:\"released\";s:10:\"2021-12-20\";s:4:\"name\";s:20:\"Christmas Bottom Bar\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"7.0.0\";s:6:\"groups\";s:32:\"premium,popup,seasonal,promotion\";s:11:\"collections\";s:9:\"christmas\";s:3:\"url\";s:52:\"https://layerslider.com/popups/#christmas-bottom-bar\";s:7:\"preview\";s:64:\"https://layerslider.com/media/templates/christmas-bottom-bar.jpg\";}s:17:\"black-friday-2020\";a:9:{s:8:\"released\";s:10:\"2020-11-18\";s:4:\"name\";s:17:\"Black Friday 2020\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:32:\"premium,popup,promotion,seasonal\";s:11:\"collections\";s:12:\"black-friday\";s:3:\"url\";s:49:\"https://layerslider.com/popups/#black-friday-2020\";s:7:\"preview\";s:61:\"https://layerslider.com/media/templates/black-friday-2020.jpg\";}s:21:\"covid-19-notification\";a:8:{s:8:\"released\";s:10:\"2020-04-01\";s:4:\"name\";s:21:\"COVID-19 Notification\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:26:\"premium,popup,notification\";s:3:\"url\";s:53:\"https://layerslider.com/popups/#covid-19-notification\";s:7:\"preview\";s:65:\"https://layerslider.com/media/templates/covid-19-notification.jpg\";}s:19:\"covid-19-bottom-bar\";a:8:{s:8:\"released\";s:10:\"2020-04-01\";s:4:\"name\";s:19:\"COVID-19 Bottom Bar\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:26:\"premium,popup,notification\";s:3:\"url\";s:51:\"https://layerslider.com/popups/#covid-19-bottom-bar\";s:7:\"preview\";s:63:\"https://layerslider.com/media/templates/covid-19-bottom-bar.jpg\";}s:14:\"top-bar-notice\";a:8:{s:8:\"released\";s:10:\"2020-04-01\";s:4:\"name\";s:14:\"Top Bar Notice\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:26:\"premium,popup,notification\";s:3:\"url\";s:46:\"https://layerslider.com/popups/#top-bar-notice\";s:7:\"preview\";s:58:\"https://layerslider.com/media/templates/top-bar-notice.jpg\";}s:20:\"christmas-snow-globe\";a:9:{s:8:\"released\";s:10:\"2019-12-19\";s:4:\"name\";s:20:\"Christmas Snow Globe\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:43:\"premium,parallax,popup,loop,filter,seasonal\";s:11:\"collections\";s:9:\"christmas\";s:3:\"url\";s:52:\"https://layerslider.com/popups/#christmas-snow-globe\";s:7:\"preview\";s:64:\"https://layerslider.com/media/templates/christmas-snow-globe.jpg\";}s:14:\"discount-popup\";a:8:{s:8:\"released\";s:10:\"2017-12-10\";s:4:\"name\";s:14:\"Discount Popup\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:23:\"premium,popup,promotion\";s:3:\"url\";s:46:\"https://layerslider.com/popups/#discount-popup\";s:7:\"preview\";s:58:\"https://layerslider.com/media/templates/discount-popup.jpg\";}s:18:\"social-share-popup\";a:8:{s:8:\"released\";s:10:\"2017-12-06\";s:4:\"name\";s:18:\"Social Share Popup\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:24:\"premium,popup,api,social\";s:3:\"url\";s:50:\"https://layerslider.com/popups/#social-share-popup\";s:7:\"preview\";s:62:\"https://layerslider.com/media/templates/social-share-popup.jpg\";}s:16:\"popup-guide-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:16:\"Popup Guide Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:33:\"premium,popup,parallax,text,other\";s:3:\"url\";s:48:\"https://layerslider.com/popups/#popup-guide-demo\";s:7:\"preview\";s:60:\"https://layerslider.com/media/templates/popup-guide-demo.jpg\";}s:18:\"popup-welcome-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Welcome Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:33:\"premium,popup,parallax,text,other\";s:3:\"url\";s:50:\"https://layerslider.com/popups/#popup-welcome-demo\";s:7:\"preview\";s:62:\"https://layerslider.com/media/templates/popup-welcome-demo.jpg\";}s:22:\"popup-transparent-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:22:\"Popup Transparent Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:37:\"premium,popup,parallax,loop,promotion\";s:3:\"url\";s:54:\"https://layerslider.com/popups/#popup-transparent-demo\";s:7:\"preview\";s:66:\"https://layerslider.com/media/templates/popup-transparent-demo.jpg\";}s:18:\"popup-sidebar-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Sidebar Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:56:\"premium,popup,experiments,blendmode,text,promotion,other\";s:3:\"url\";s:50:\"https://layerslider.com/popups/#popup-sidebar-demo\";s:7:\"preview\";s:62:\"https://layerslider.com/media/templates/popup-sidebar-demo.jpg\";}s:19:\"popup-photo-gallery\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:19:\"Popup Photo Gallery\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:28:\"premium,popup,kenburns,other\";s:3:\"url\";s:51:\"https://layerslider.com/popups/#popup-photo-gallery\";s:7:\"preview\";s:63:\"https://layerslider.com/media/templates/popup-photo-gallery.jpg\";}s:16:\"popup-modal-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:16:\"Popup Modal Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:30:\"premium,popup,static,promotion\";s:3:\"url\";s:48:\"https://layerslider.com/popups/#popup-modal-demo\";s:7:\"preview\";s:60:\"https://layerslider.com/media/templates/popup-modal-demo.jpg\";}s:18:\"popup-infobar-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Infobar Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:59:\"premium,popup,experiments,text,promotion,notification,other\";s:3:\"url\";s:50:\"https://layerslider.com/popups/#popup-infobar-demo\";s:7:\"preview\";s:62:\"https://layerslider.com/media/templates/popup-infobar-demo.jpg\";}s:24:\"popup-fullsize-desk-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:24:\"Popup Fullsize Desk Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:60:\"premium,popup,experiments,fullsize,parallax,fullscreen,other\";s:3:\"url\";s:56:\"https://layerslider.com/popups/#popup-fullsize-desk-demo\";s:7:\"preview\";s:68:\"https://layerslider.com/media/templates/popup-fullsize-desk-demo.jpg\";}s:18:\"conversation-popup\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Conversation Popup\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:44:\"premium,popup,experiments,notification,other\";s:3:\"url\";s:50:\"https://layerslider.com/popups/#conversation-popup\";s:7:\"preview\";s:62:\"https://layerslider.com/media/templates/conversation-popup.jpg\";}}s:19:\"webshopworks-popups\";a:69:{s:29:\"wonderful-holidays-popup-2022\";a:9:{s:8:\"released\";s:10:\"2022-12-18\";s:4:\"name\";s:18:\"Wonderful Holidays\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"7.6.0\";s:6:\"groups\";s:26:\"premium,new,popup,seasonal\";s:11:\"collections\";s:9:\"christmas\";s:3:\"url\";s:74:\"https://layerslider.com/popups/webshopworks/#wonderful-holidays-popup-2022\";s:7:\"preview\";s:93:\"https://layerslider.com/media/templates/webshopworks-popups/wonderful-holidays-popup-2022.jpg\";}s:26:\"christmas-gifts-popup-2022\";a:9:{s:8:\"released\";s:10:\"2022-12-15\";s:4:\"name\";s:21:\"Christmas Gifts Popup\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"7.6.0\";s:6:\"groups\";s:8:\"seasonal\";s:11:\"collections\";s:9:\"christmas\";s:3:\"url\";s:71:\"https://layerslider.com/popups/webshopworks/#christmas-gifts-popup-2022\";s:7:\"preview\";s:90:\"https://layerslider.com/media/templates/webshopworks-popups/christmas-gifts-popup-2022.jpg\";}s:17:\"black-friday-sale\";a:9:{s:8:\"released\";s:10:\"2020-11-18\";s:4:\"name\";s:17:\"Black Friday Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:11:\"collections\";s:12:\"black-friday\";s:3:\"url\";s:62:\"https://layerslider.com/popups/webshopworks/#black-friday-sale\";s:7:\"preview\";s:81:\"https://layerslider.com/media/templates/webshopworks-popups/black-friday-sale.jpg\";}s:16:\"black-friday-bar\";a:9:{s:8:\"released\";s:10:\"2020-11-18\";s:4:\"name\";s:16:\"Black Friday Bar\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:11:\"collections\";s:12:\"black-friday\";s:3:\"url\";s:61:\"https://layerslider.com/popups/webshopworks/#black-friday-bar\";s:7:\"preview\";s:80:\"https://layerslider.com/media/templates/webshopworks-popups/black-friday-bar.jpg\";}s:16:\"reveal-your-deal\";a:7:{s:4:\"name\";s:16:\"Reveal Your Deal\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:31:\"sales,coupon,seasonal,promotion\";s:3:\"url\";s:61:\"https://layerslider.com/popups/webshopworks/#reveal-your-deal\";s:7:\"preview\";s:80:\"https://layerslider.com/media/templates/webshopworks-popups/reveal-your-deal.jpg\";}s:27:\"christmas-sidebar-countdown\";a:8:{s:4:\"name\";s:27:\"Christmas Sidebar Countdown\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:11:\"collections\";s:9:\"christmas\";s:3:\"url\";s:72:\"https://layerslider.com/popups/webshopworks/#christmas-sidebar-countdown\";s:7:\"preview\";s:91:\"https://layerslider.com/media/templates/webshopworks-popups/christmas-sidebar-countdown.jpg\";}s:20:\"christmas-sale-santa\";a:8:{s:4:\"name\";s:20:\"Christmas Sale Santa\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:11:\"collections\";s:9:\"christmas\";s:3:\"url\";s:65:\"https://layerslider.com/popups/webshopworks/#christmas-sale-santa\";s:7:\"preview\";s:84:\"https://layerslider.com/media/templates/webshopworks-popups/christmas-sale-santa.jpg\";}s:11:\"santa-walks\";a:8:{s:4:\"name\";s:11:\"Santa Walks\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:11:\"collections\";s:9:\"christmas\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#santa-walks\";s:7:\"preview\";s:75:\"https://layerslider.com/media/templates/webshopworks-popups/santa-walks.jpg\";}s:14:\"christmas-sale\";a:8:{s:4:\"name\";s:14:\"Christmas Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:14:\"seasonal,sales\";s:11:\"collections\";s:9:\"christmas\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#christmas-sale\";s:7:\"preview\";s:78:\"https://layerslider.com/media/templates/webshopworks-popups/christmas-sale.jpg\";}s:12:\"gift-voucher\";a:7:{s:4:\"name\";s:12:\"Gift Voucher\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:32:\"newsletter,coupon,sales,seasonal\";s:3:\"url\";s:57:\"https://layerslider.com/popups/webshopworks/#gift-voucher\";s:7:\"preview\";s:76:\"https://layerslider.com/media/templates/webshopworks-popups/gift-voucher.jpg\";}s:16:\"christmas-topbar\";a:8:{s:4:\"name\";s:17:\"Christmas Top Bar\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:11:\"collections\";s:9:\"christmas\";s:3:\"url\";s:61:\"https://layerslider.com/popups/webshopworks/#christmas-topbar\";s:7:\"preview\";s:80:\"https://layerslider.com/media/templates/webshopworks-popups/christmas-topbar.jpg\";}s:14:\"black-friday-9\";a:8:{s:4:\"name\";s:15:\"Black Friday #9\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:35:\"sales,seasonal,promotion,fullscreen\";s:11:\"collections\";s:12:\"black-friday\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#black-friday-9\";s:7:\"preview\";s:78:\"https://layerslider.com/media/templates/webshopworks-popups/black-friday-9.jpg\";}s:14:\"black-friday-8\";a:8:{s:4:\"name\";s:15:\"Black Friday #8\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:35:\"sales,seasonal,promotion,fullscreen\";s:11:\"collections\";s:12:\"black-friday\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#black-friday-8\";s:7:\"preview\";s:78:\"https://layerslider.com/media/templates/webshopworks-popups/black-friday-8.jpg\";}s:20:\"black-friday-premium\";a:8:{s:4:\"name\";s:20:\"Black Friday Premium\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:11:\"collections\";s:12:\"black-friday\";s:3:\"url\";s:65:\"https://layerslider.com/popups/webshopworks/#black-friday-premium\";s:7:\"preview\";s:84:\"https://layerslider.com/media/templates/webshopworks-popups/black-friday-premium.jpg\";}s:14:\"black-friday-7\";a:8:{s:4:\"name\";s:15:\"Black Friday #7\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:11:\"collections\";s:12:\"black-friday\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#black-friday-7\";s:7:\"preview\";s:78:\"https://layerslider.com/media/templates/webshopworks-popups/black-friday-7.jpg\";}s:11:\"todays-sale\";a:7:{s:4:\"name\";s:14:\"Today’s Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:15:\"sales,promotion\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#todays-sale\";s:7:\"preview\";s:75:\"https://layerslider.com/media/templates/webshopworks-popups/todays-sale.jpg\";}s:9:\"sign-up-6\";a:7:{s:4:\"name\";s:10:\"Sign Up #6\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:54:\"https://layerslider.com/popups/webshopworks/#sign-up-6\";s:7:\"preview\";s:73:\"https://layerslider.com/media/templates/webshopworks-popups/sign-up-6.jpg\";}s:9:\"sign-up-7\";a:7:{s:4:\"name\";s:10:\"Sign Up #7\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:54:\"https://layerslider.com/popups/webshopworks/#sign-up-7\";s:7:\"preview\";s:73:\"https://layerslider.com/media/templates/webshopworks-popups/sign-up-7.jpg\";}s:9:\"sign-up-8\";a:7:{s:4:\"name\";s:10:\"Sign Up #8\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:54:\"https://layerslider.com/popups/webshopworks/#sign-up-8\";s:7:\"preview\";s:73:\"https://layerslider.com/media/templates/webshopworks-popups/sign-up-8.jpg\";}s:20:\"get-in-touch-with-us\";a:7:{s:4:\"name\";s:20:\"Get in Touch with Us\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"contact-us\";s:3:\"url\";s:65:\"https://layerslider.com/popups/webshopworks/#get-in-touch-with-us\";s:7:\"preview\";s:84:\"https://layerslider.com/media/templates/webshopworks-popups/get-in-touch-with-us.jpg\";}s:17:\"top-bar-subscribe\";a:7:{s:4:\"name\";s:17:\"Top Bar Subscribe\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:20:\"newsletter,promotion\";s:3:\"url\";s:62:\"https://layerslider.com/popups/webshopworks/#top-bar-subscribe\";s:7:\"preview\";s:81:\"https://layerslider.com/media/templates/webshopworks-popups/top-bar-subscribe.jpg\";}s:7:\"sign-up\";a:7:{s:4:\"name\";s:7:\"Sign Up\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:23:\"newsletter,sales,coupon\";s:3:\"url\";s:52:\"https://layerslider.com/popups/webshopworks/#sign-up\";s:7:\"preview\";s:71:\"https://layerslider.com/media/templates/webshopworks-popups/sign-up.jpg\";}s:14:\"black-friday-6\";a:8:{s:4:\"name\";s:15:\"Black Friday #6\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:11:\"collections\";s:12:\"black-friday\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#black-friday-6\";s:7:\"preview\";s:78:\"https://layerslider.com/media/templates/webshopworks-popups/black-friday-6.jpg\";}s:14:\"black-friday-5\";a:8:{s:4:\"name\";s:15:\"Black Friday #5\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:35:\"sales,seasonal,promotion,fullscreen\";s:11:\"collections\";s:12:\"black-friday\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#black-friday-5\";s:7:\"preview\";s:78:\"https://layerslider.com/media/templates/webshopworks-popups/black-friday-5.jpg\";}s:14:\"black-friday-4\";a:8:{s:4:\"name\";s:15:\"Black Friday #4\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:11:\"collections\";s:12:\"black-friday\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#black-friday-4\";s:7:\"preview\";s:78:\"https://layerslider.com/media/templates/webshopworks-popups/black-friday-4.jpg\";}s:14:\"black-friday-1\";a:8:{s:4:\"name\";s:15:\"Black Friday #1\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:11:\"collections\";s:12:\"black-friday\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#black-friday-1\";s:7:\"preview\";s:78:\"https://layerslider.com/media/templates/webshopworks-popups/black-friday-1.jpg\";}s:17:\"spring-super-sale\";a:7:{s:4:\"name\";s:17:\"Spring Super Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:62:\"https://layerslider.com/popups/webshopworks/#spring-super-sale\";s:7:\"preview\";s:81:\"https://layerslider.com/media/templates/webshopworks-popups/spring-super-sale.jpg\";}s:8:\"discount\";a:7:{s:4:\"name\";s:8:\"Discount\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:5:\"sales\";s:3:\"url\";s:53:\"https://layerslider.com/popups/webshopworks/#discount\";s:7:\"preview\";s:72:\"https://layerslider.com/media/templates/webshopworks-popups/discount.jpg\";}s:9:\"sign-up-3\";a:7:{s:4:\"name\";s:10:\"Sign Up #3\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:54:\"https://layerslider.com/popups/webshopworks/#sign-up-3\";s:7:\"preview\";s:73:\"https://layerslider.com/media/templates/webshopworks-popups/sign-up-3.jpg\";}s:22:\"sidebar-countdown-sale\";a:7:{s:4:\"name\";s:22:\"Sidebar Countdown Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:22:\"sales,promotion,coupon\";s:3:\"url\";s:67:\"https://layerslider.com/popups/webshopworks/#sidebar-countdown-sale\";s:7:\"preview\";s:86:\"https://layerslider.com/media/templates/webshopworks-popups/sidebar-countdown-sale.jpg\";}s:15:\"countdown-timer\";a:7:{s:4:\"name\";s:15:\"Countdown Timer\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:14:\"sales,seasonal\";s:3:\"url\";s:60:\"https://layerslider.com/popups/webshopworks/#countdown-timer\";s:7:\"preview\";s:79:\"https://layerslider.com/media/templates/webshopworks-popups/countdown-timer.jpg\";}s:10:\"discount-5\";a:7:{s:4:\"name\";s:11:\"Discount #5\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:5:\"sales\";s:3:\"url\";s:55:\"https://layerslider.com/popups/webshopworks/#discount-5\";s:7:\"preview\";s:74:\"https://layerslider.com/media/templates/webshopworks-popups/discount-5.jpg\";}s:10:\"discount-2\";a:7:{s:4:\"name\";s:10:\"Discount 2\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:12:\"sales,coupon\";s:3:\"url\";s:55:\"https://layerslider.com/popups/webshopworks/#discount-2\";s:7:\"preview\";s:74:\"https://layerslider.com/media/templates/webshopworks-popups/discount-2.jpg\";}s:11:\"subscribe-5\";a:7:{s:4:\"name\";s:12:\"Subscribe #5\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:23:\"newsletter,sales,coupon\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#subscribe-5\";s:7:\"preview\";s:75:\"https://layerslider.com/media/templates/webshopworks-popups/subscribe-5.jpg\";}s:9:\"mega-sale\";a:7:{s:4:\"name\";s:9:\"Mega Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:35:\"sales,seasonal,promotion,fullscreen\";s:3:\"url\";s:54:\"https://layerslider.com/popups/webshopworks/#mega-sale\";s:7:\"preview\";s:73:\"https://layerslider.com/media/templates/webshopworks-popups/mega-sale.jpg\";}s:10:\"discount-4\";a:7:{s:4:\"name\";s:10:\"Discount 4\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:15:\"sales,promotion\";s:3:\"url\";s:55:\"https://layerslider.com/popups/webshopworks/#discount-4\";s:7:\"preview\";s:74:\"https://layerslider.com/media/templates/webshopworks-popups/discount-4.jpg\";}s:8:\"info-bar\";a:7:{s:4:\"name\";s:8:\"Info Bar\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:9:\"promotion\";s:3:\"url\";s:53:\"https://layerslider.com/popups/webshopworks/#info-bar\";s:7:\"preview\";s:72:\"https://layerslider.com/media/templates/webshopworks-popups/info-bar.jpg\";}s:11:\"subscribe-4\";a:7:{s:4:\"name\";s:12:\"Subscribe #4\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:20:\"newsletter,promotion\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#subscribe-4\";s:7:\"preview\";s:75:\"https://layerslider.com/media/templates/webshopworks-popups/subscribe-4.jpg\";}s:10:\"contact-us\";a:7:{s:4:\"name\";s:10:\"Contact Us\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"contact-us\";s:3:\"url\";s:55:\"https://layerslider.com/popups/webshopworks/#contact-us\";s:7:\"preview\";s:74:\"https://layerslider.com/media/templates/webshopworks-popups/contact-us.jpg\";}s:10:\"discount-3\";a:7:{s:4:\"name\";s:10:\"Discount 3\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:5:\"sales\";s:3:\"url\";s:55:\"https://layerslider.com/popups/webshopworks/#discount-3\";s:7:\"preview\";s:74:\"https://layerslider.com/media/templates/webshopworks-popups/discount-3.jpg\";}s:9:\"sign-up-4\";a:7:{s:4:\"name\";s:10:\"Sign Up #4\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:54:\"https://layerslider.com/popups/webshopworks/#sign-up-4\";s:7:\"preview\";s:73:\"https://layerslider.com/media/templates/webshopworks-popups/sign-up-4.jpg\";}s:4:\"mail\";a:7:{s:4:\"name\";s:4:\"Mail\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:49:\"https://layerslider.com/popups/webshopworks/#mail\";s:7:\"preview\";s:68:\"https://layerslider.com/media/templates/webshopworks-popups/mail.jpg\";}s:18:\"kitchen-appliances\";a:7:{s:4:\"name\";s:18:\"Kitchen Appliances\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:9:\"promotion\";s:3:\"url\";s:63:\"https://layerslider.com/popups/webshopworks/#kitchen-appliances\";s:7:\"preview\";s:82:\"https://layerslider.com/media/templates/webshopworks-popups/kitchen-appliances.jpg\";}s:11:\"subscribe-3\";a:7:{s:4:\"name\";s:12:\"Subscribe #3\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#subscribe-3\";s:7:\"preview\";s:75:\"https://layerslider.com/media/templates/webshopworks-popups/subscribe-3.jpg\";}s:6:\"ticket\";a:7:{s:4:\"name\";s:6:\"Ticket\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:12:\"sales,coupon\";s:3:\"url\";s:51:\"https://layerslider.com/popups/webshopworks/#ticket\";s:7:\"preview\";s:70:\"https://layerslider.com/media/templates/webshopworks-popups/ticket.jpg\";}s:8:\"hey-wait\";a:7:{s:4:\"name\";s:10:\"Hey, wait!\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:35:\"exit-intent,newsletter,sales,coupon\";s:3:\"url\";s:53:\"https://layerslider.com/popups/webshopworks/#hey-wait\";s:7:\"preview\";s:72:\"https://layerslider.com/media/templates/webshopworks-popups/hey-wait.jpg\";}s:9:\"subscribe\";a:7:{s:4:\"name\";s:12:\"Subscribe #1\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:54:\"https://layerslider.com/popups/webshopworks/#subscribe\";s:7:\"preview\";s:73:\"https://layerslider.com/media/templates/webshopworks-popups/subscribe.jpg\";}s:11:\"subscribe-2\";a:7:{s:4:\"name\";s:12:\"Subscribe #2\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:21:\"newsletter,fullscreen\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#subscribe-2\";s:7:\"preview\";s:75:\"https://layerslider.com/media/templates/webshopworks-popups/subscribe-2.jpg\";}s:16:\"age-verification\";a:7:{s:4:\"name\";s:16:\"Age Verification\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:27:\"age-verification,fullscreen\";s:3:\"url\";s:61:\"https://layerslider.com/popups/webshopworks/#age-verification\";s:7:\"preview\";s:80:\"https://layerslider.com/media/templates/webshopworks-popups/age-verification.jpg\";}s:12:\"get-in-touch\";a:7:{s:4:\"name\";s:12:\"Get in Touch\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"contact-us\";s:3:\"url\";s:57:\"https://layerslider.com/popups/webshopworks/#get-in-touch\";s:7:\"preview\";s:76:\"https://layerslider.com/media/templates/webshopworks-popups/get-in-touch.jpg\";}s:14:\"social-share-2\";a:7:{s:4:\"name\";s:15:\"Social Share #2\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:6:\"social\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#social-share-2\";s:7:\"preview\";s:78:\"https://layerslider.com/media/templates/webshopworks-popups/social-share-2.jpg\";}s:9:\"sign-up-2\";a:7:{s:4:\"name\";s:10:\"Sign Up #2\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:54:\"https://layerslider.com/popups/webshopworks/#sign-up-2\";s:7:\"preview\";s:73:\"https://layerslider.com/media/templates/webshopworks-popups/sign-up-2.jpg\";}s:11:\"watch-promo\";a:7:{s:4:\"name\";s:11:\"Watch Promo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:21:\"promotion,exit-intent\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#watch-promo\";s:7:\"preview\";s:75:\"https://layerslider.com/media/templates/webshopworks-popups/watch-promo.jpg\";}s:19:\"product-accessories\";a:7:{s:4:\"name\";s:19:\"Product Accessories\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:9:\"promotion\";s:3:\"url\";s:64:\"https://layerslider.com/popups/webshopworks/#product-accessories\";s:7:\"preview\";s:83:\"https://layerslider.com/media/templates/webshopworks-popups/product-accessories.jpg\";}s:9:\"sign-up-5\";a:7:{s:4:\"name\";s:10:\"Sign Up #5\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:54:\"https://layerslider.com/popups/webshopworks/#sign-up-5\";s:7:\"preview\";s:73:\"https://layerslider.com/media/templates/webshopworks-popups/sign-up-5.jpg\";}s:14:\"black-friday-2\";a:8:{s:4:\"name\";s:15:\"Black Friday #2\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:11:\"collections\";s:12:\"black-friday\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#black-friday-2\";s:7:\"preview\";s:78:\"https://layerslider.com/media/templates/webshopworks-popups/black-friday-2.jpg\";}s:14:\"black-friday-3\";a:8:{s:4:\"name\";s:15:\"Black Friday #3\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:11:\"collections\";s:12:\"black-friday\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#black-friday-3\";s:7:\"preview\";s:78:\"https://layerslider.com/media/templates/webshopworks-popups/black-friday-3.jpg\";}s:16:\"halloween-sale-2\";a:8:{s:4:\"name\";s:17:\"Halloween Sale #2\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:11:\"collections\";s:9:\"halloween\";s:3:\"url\";s:61:\"https://layerslider.com/popups/webshopworks/#halloween-sale-2\";s:7:\"preview\";s:80:\"https://layerslider.com/media/templates/webshopworks-popups/halloween-sale-2.jpg\";}s:16:\"halloween-sale-1\";a:8:{s:4:\"name\";s:17:\"Halloween Sale #1\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:11:\"collections\";s:9:\"halloween\";s:3:\"url\";s:61:\"https://layerslider.com/popups/webshopworks/#halloween-sale-1\";s:7:\"preview\";s:80:\"https://layerslider.com/media/templates/webshopworks-popups/halloween-sale-1.jpg\";}s:12:\"pumpkin-sale\";a:8:{s:4:\"name\";s:12:\"Pumpkin Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:11:\"collections\";s:9:\"halloween\";s:3:\"url\";s:57:\"https://layerslider.com/popups/webshopworks/#pumpkin-sale\";s:7:\"preview\";s:76:\"https://layerslider.com/media/templates/webshopworks-popups/pumpkin-sale.jpg\";}s:11:\"spring-sale\";a:8:{s:4:\"name\";s:11:\"Spring Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:11:\"collections\";s:11:\"mothers-day\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#spring-sale\";s:7:\"preview\";s:75:\"https://layerslider.com/media/templates/webshopworks-popups/spring-sale.jpg\";}s:11:\"mothers-day\";a:8:{s:4:\"name\";s:14:\"Mother’s Day\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:35:\"sales,seasonal,promotion,fullscreen\";s:11:\"collections\";s:11:\"mothers-day\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#mothers-day\";s:7:\"preview\";s:75:\"https://layerslider.com/media/templates/webshopworks-popups/mothers-day.jpg\";}s:20:\"easter-subscribe-bar\";a:8:{s:4:\"name\";s:20:\"Easter Subscribe Bar\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:25:\"sales,seasonal,newsletter\";s:11:\"collections\";s:6:\"easter\";s:3:\"url\";s:65:\"https://layerslider.com/popups/webshopworks/#easter-subscribe-bar\";s:7:\"preview\";s:84:\"https://layerslider.com/media/templates/webshopworks-popups/easter-subscribe-bar.jpg\";}s:14:\"easter-welcome\";a:8:{s:4:\"name\";s:14:\"Easter Welcome\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:8:\"seasonal\";s:11:\"collections\";s:6:\"easter\";s:3:\"url\";s:59:\"https://layerslider.com/popups/webshopworks/#easter-welcome\";s:7:\"preview\";s:78:\"https://layerslider.com/media/templates/webshopworks-popups/easter-welcome.jpg\";}s:17:\"easter-newsletter\";a:8:{s:4:\"name\";s:17:\"Easter Newsletter\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:32:\"sales,seasonal,newsletter,coupon\";s:11:\"collections\";s:6:\"easter\";s:3:\"url\";s:62:\"https://layerslider.com/popups/webshopworks/#easter-newsletter\";s:7:\"preview\";s:81:\"https://layerslider.com/media/templates/webshopworks-popups/easter-newsletter.jpg\";}s:11:\"season-sale\";a:8:{s:4:\"name\";s:11:\"Season Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:11:\"collections\";s:6:\"easter\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#season-sale\";s:7:\"preview\";s:75:\"https://layerslider.com/media/templates/webshopworks-popups/season-sale.jpg\";}s:11:\"easter-sale\";a:8:{s:4:\"name\";s:11:\"Easter Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:11:\"collections\";s:6:\"easter\";s:3:\"url\";s:56:\"https://layerslider.com/popups/webshopworks/#easter-sale\";s:7:\"preview\";s:75:\"https://layerslider.com/media/templates/webshopworks-popups/easter-sale.jpg\";}s:20:\"easter-sale-surprise\";a:8:{s:4:\"name\";s:20:\"Easter Sale Surprise\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:11:\"collections\";s:6:\"easter\";s:3:\"url\";s:65:\"https://layerslider.com/popups/webshopworks/#easter-sale-surprise\";s:7:\"preview\";s:84:\"https://layerslider.com/media/templates/webshopworks-popups/easter-sale-surprise.jpg\";}s:18:\"join-the-community\";a:7:{s:4:\"name\";s:18:\"Join the Community\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:6:\"social\";s:3:\"url\";s:63:\"https://layerslider.com/popups/webshopworks/#join-the-community\";s:7:\"preview\";s:82:\"https://layerslider.com/media/templates/webshopworks-popups/join-the-community.jpg\";}}}s:13:\"notifications\";a:0:{}s:7:\"modules\";a:11:{s:6:\"assets\";a:3:{s:4:\"name\";s:6:\"Assets\";s:6:\"handle\";s:12:\"assets-1.0.6\";s:5:\"files\";a:1:{s:2:\"js\";s:13:\"assets.min.js\";}}s:5:\"pixie\";a:3:{s:4:\"name\";s:12:\"Image Editor\";s:6:\"handle\";s:11:\"pixie-2.0.8\";s:5:\"files\";a:2:{s:3:\"css\";s:14:\"styles.min.css\";s:2:\"js\";s:14:\"scripts.min.js\";}}s:14:\"font-awesome-5\";a:4:{s:4:\"name\";s:14:\"Font Awesome 5\";s:4:\"icon\";s:12:\"font-awesome\";s:6:\"handle\";s:19:\"font-awesome-5.15.3\";s:4:\"file\";s:8:\"icons.js\";}s:14:\"font-awesome-6\";a:4:{s:4:\"name\";s:14:\"Font Awesome 6\";s:4:\"icon\";s:14:\"font-awesome-6\";s:6:\"handle\";s:18:\"font-awesome-6.0.0\";s:4:\"file\";s:8:\"icons.js\";}s:8:\"ionicons\";a:4:{s:4:\"name\";s:8:\"Ionicons\";s:4:\"icon\";s:8:\"ionicons\";s:6:\"handle\";s:14:\"ionicons-5.5.1\";s:4:\"file\";s:8:\"icons.js\";}s:12:\"line-awesome\";a:4:{s:4:\"name\";s:12:\"Line Awesome\";s:4:\"icon\";s:6:\"icons8\";s:6:\"handle\";s:17:\"lineawesome-1.3.0\";s:4:\"file\";s:8:\"icons.js\";}s:15:\"material-filled\";a:4:{s:4:\"name\";s:15:\"Material Filled\";s:4:\"icon\";s:14:\"material-icons\";s:6:\"handle\";s:21:\"material-filled-4.0.0\";s:4:\"file\";s:8:\"icons.js\";}s:17:\"material-outlined\";a:4:{s:4:\"name\";s:17:\"Material Outlined\";s:4:\"icon\";s:14:\"material-icons\";s:6:\"handle\";s:23:\"material-outlined-4.0.0\";s:4:\"file\";s:8:\"icons.js\";}s:16:\"material-rounded\";a:4:{s:4:\"name\";s:16:\"Material Rounded\";s:4:\"icon\";s:14:\"material-icons\";s:6:\"handle\";s:22:\"material-rounded-4.0.0\";s:4:\"file\";s:8:\"icons.js\";}s:14:\"material-sharp\";a:4:{s:4:\"name\";s:14:\"Material Sharp\";s:4:\"icon\";s:14:\"material-icons\";s:6:\"handle\";s:20:\"material-sharp-4.0.0\";s:4:\"file\";s:8:\"icons.js\";}s:16:\"material-twotone\";a:4:{s:4:\"name\";s:17:\"Material Two Tone\";s:4:\"icon\";s:14:\"material-icons\";s:6:\"handle\";s:22:\"material-twotone-4.0.0\";s:4:\"file\";s:8:\"icons.js\";}}s:11:\"release-log\";s:24354:\"<!-- FEED-ENTRY -->\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.7.6\n			<ls-small>May 23, 2023</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>Introducing: Position Adjustments. Fine-tune layer positions in a more refined way, especially if you want to align layers relative to the bottom and right edges.</ls-li><ls-li>Significant improvements and fixes for keyboard shortcuts.</ls-li><ls-li>Fixed an issue that resulted in media playback in the background while quickly changing slides.</ls-li><ls-li>Fixed a Chrome rendering issue where videos appeared blank in rare cases.</ls-li><ls-li>Fixed some layer style properties when using a min/max responsive ratio.</ls-li><ls-li>Fixed the \"Missing Ending Transitions\" warning that sometimes appeared incorrectly.</ls-li><ls-li>Other under-the-hood changes.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n<!-- FEED-ENTRY -->\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.7.5\n			<ls-small>May 8, 2023</ls-small>\n		</ls-h5>\n		<ls-p><strong>Ready to make your designs stand out?</strong> LayerSlider’s Assets Library just got a major upgrade and now offers millions of new royalty-free stock photos to choose from. Save time and impress your audience with stunning graphics in just a few clicks.</ls-p><ls-p>Other changes:</ls-p><ls-ul><ls-li>Added Project Settings → Miscellaneous → \"Fix resizing issues in special cases\" option.</ls-li><ls-li>Updated French localization. [Thanks to <a href=\"https://instinct-photo.fr/contact/\" target=\"_blank\">Patrick Perrono</a>]</ls-li><ls-li>Fixed certain exporting issues, especially affecting the \"Export as HTML\" option.</ls-li><ls-li>Fixed a resizing issue with static layers.</ls-li><ls-li>Fixed detecting available external fonts in the editor in Safari.</ls-li><ls-li>Fixed Text Transition rendering issues in Safari.</ls-li><ls-li>Layers with text transitions now properly inherit text decoration settings.</ls-li><ls-li>Various UI and under-the-hood enhancements and bug fixes.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n<!-- FEED-ENTRY -->\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.7.1\n			<ls-small>Apr 19, 2023</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>LayerSlider now fully supports WPML\'s Media Translation.&nbsp;</ls-li><ls-li>Translation features can now be adjusted under Plugin Settings → Integrations.</ls-li><ls-li>Updated French localization. [Thanks to <a href=\"https://instinct-photo.fr/contact/\" target=\"_blank\">Patrick Perrono</a>]</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n<!-- FEED-ENTRY -->\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.7.0\n			<ls-small>Apr 5, 2023</ls-small>\n		</ls-h5>\n		<ls-p><strong>Introducing: Assets Library.</strong> Say goodbye to design roadblocks. Elevate your creative vision and easily bring your dream projects to life using our vast collection of professional assets. These pre-made graphics are designed for immediate use and can be quickly integrated into your projects with just a few clicks.</ls-p><ls-p>Other changes:</ls-p>\n		<ls-ul>\n			<ls-li>Icon, Shape, and SVG layers have new stroke color and width options.</ls-li>\n			<ls-li>Blob and Wave shapes now also support stroke.</ls-li>\n			<ls-li>Updated French localization [Thanks to <a href=\"https://instinct-photo.fr/contact/\" target=\"_blank\">Patrick Perrono</a>]</ls-li>\n			<ls-li>The editor now automatically detects certain transition issues and offers to fix them.</ls-li>\n			<ls-li>Significant rendering performance optimizations.</ls-li>\n			<ls-li>Improved automatic layer naming.</ls-li>\n			<ls-li>Improved layer preview in the layers list.</ls-li>\n			<ls-li>Improved SVG source normalization for better layer scaling.</ls-li>\n			<ls-li>SVG files dropped onto the editor now preserve their original sizes.</ls-li>\n			<ls-li>Fixed linked Video / Audio layers’ transition issues.</ls-li>\n			<ls-li>Fixed many undo/redo issues.</ls-li>\n			<ls-li>Fixed many multiple-selection mode issues.</ls-li>\n			<ls-li>Fixed a very rare import issue due to file name normalization.</ls-li>\n			<ls-li>Fixed Safari rendering issues with pinned layers.</ls-li>\n			<ls-li>Fixed an issue when opening Popups with specific slides.</ls-li>\n			<ls-li>Eliminated countless under-the-hood bugs.</ls-li>\n			<ls-li>Lots of small UI and other improvements.</ls-li>\n		</ls-ul>\n	</ls-box>\n</ls-li>\n<!-- FEED-ENTRY -->\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.6.9\n			<ls-small>Feb 15, 2023</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>Added Smooth Scroll Duration option to adjust the reaction time of Scroll Scenes.</ls-li><ls-li>Added new layer action: Scroll to Scene Position</ls-li><ls-li>Improved other scroll-related layer actions to better work with scenes.</ls-li><ls-li>Fixed Collections in the Templates section.</ls-li><ls-li>Fixed Google Fonts in merged projects.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.6.8\n			<ls-small>Jan 24, 2023</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>Interface and usability improvements in the new Templates section.</ls-li><ls-li>Fixed the Hide on Mobile option on desktop machines with touchscreens.</ls-li><ls-li>Fixed an issue in IE11 that caused a \"Multiple jQuery issue\" notification.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.6.7\n			<ls-small>Dec 12, 2022</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>Fixed an issue with importing in the new Templates section.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.6.5\n			<ls-small>Dec 12, 2022</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>Brand new Templates section with a Discover page, Collections, and more.</ls-li><ls-li>Fixed the Hide and Delete project context menu options on the dashboard.</ls-li><ls-li>Fixed popup parallax behavior issues in some cases.</ls-li><ls-li>Fixed some pinned layer issues in Safari.</ls-li><ls-li>Fixed an issue with static layers if the Allow Restarting Slides On Resize option was active.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.6.1\n			<ls-small>Nov 28, 2022</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>We\'ve changed the way we compress our plugin files to avoid potential false-positive security detections. Read our <a target=\"_blank\" href=\"https://layerslider.com/blog/incident-report-false-malware-detection/\">recent blog post</a> on the matter to learn more.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.6.0\n			<ls-small>Nov 23, 2022</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>NEW: Scroll Scene, a successor to \"Play By Scroll\", is here. Play your slider animations by scrolling the page.</ls-li><ls-li>NEW: Sticky Scene is also here, so you can pin and keep sliders in place while scrolling the page.</ls-li><ls-li>NEW: You can pin layers as well in the same manner.</ls-li><ls-li>NEW: Introducing Performance Mode, a new option that ensures your sliders aren\'t consuming resources in the background. It can dramatically increase performance when there are many sliders on the same page.</ls-li><ls-li>NEW: Hero sliders can now track and adapt to specified elements to perfectly align with your header area in all cases.</ls-li><ls-li>NEW: The editor now automatically detects and offers custom fonts loaded by 3rd parties.</ls-li><ls-li>NEW: Added custom prompt windows that are much nicer and won\'t interfere in fullscreen editing mode.</ls-li><ls-li>NEW: Added \"Get Scroll Position Of\" option to Scroll Transition.</ls-li><ls-li>NEW: \"tabindex\" now has a dedicated option field in common attributes.</ls-li><ls-li>Updated Gutenberg block to ensure compatibility with future WordPress releases.</ls-li><ls-li>Updated and improved Elementor widget, which now requires Elementor 3.5.0 or newer.</ls-li><ls-li>General user interface improvements throughout the plugin.</ls-li><ls-li>Improved compatibility with certain WordPress themes.</ls-li><ls-li>Enhanced Lazy Load to maximize compatibility with 3rd parties.</ls-li><ls-li>Lots of improvements for all preview modes.</ls-li><ls-li>Further performance optimizations under the hood.</ls-li><ls-li>Fixed Popup display issues in some instances.</ls-li><ls-li>Fixed muting Vimeo videos that interfered with autoplay.</ls-li><ls-li>Fixed modifying SVGs that inserted a duplicate before.</ls-li><ls-li>Fixed some dropzone issues when dragging and dropping files into the editor.</ls-li><ls-li>Fixed horizontal scrollbar appearing in rare cases.</ls-li><ls-li>Fixed pinch &amp; zoom resizing issues on mobile devices in rare cases.</ls-li><ls-li>Fixed stacking order issue in Layer Preview with multiple selection.</ls-li><ls-li>Fixed removing layer background image in multiple selection mode.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.5.3\n			<ls-small>Oct 17, 2022</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>Improved System Status with an added option to clear LocalStorage.</ls-li><ls-li>Fixed an issue that caused blank slides with sliders outside the viewport in some cases.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.5.2\n			<ls-small>Oct 14, 2022</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>Fixed popup parallax and timing issues in rare cases.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.5.1\n			<ls-small>Oct 14, 2022</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>The Origami special effect can now work with solid background colors.</ls-li><ls-li>Improvements for online services and connectivity.</ls-li><ls-li>Changed the default \"Initial Fade Duration\" from 350 to 0.</ls-li><ls-li>Increased compatibility with image lazy-loaders.</ls-li><ls-li>Improved \"restart slide on resize\" behavior on mobile devices.</ls-li><ls-li>Fixed the Allow Fullscreen Mode option in Project Settings.</ls-li><ls-li>Fixed miscalculated transform origin in rare cases.</ls-li><ls-li>Fixed text selection when text transition and background clip are used together.</ls-li><ls-li>Fixed background image position issues on text layers with text transition and background clip enabled.</ls-li><ls-li>Fixed text transition of parallax-enabled layers when navigating backwards.</ls-li><ls-li>Fixed transform origin and transform perspective of layers where the opening transition duration is set to 0.</ls-li><ls-li>Fixed font size issues on some mobile devices.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.5.0\n			<ls-small>Sep 20, 2022</ls-small>\n		</ls-h5>\n		<ls-ul>\n			<ls-li>NEW: Say hello to Transition Presets! Choose from 68 beautiful and unique pre-designed effects for various use cases, or save your own frequently used layer transitions.</ls-li>\n			<ls-li>NEW: Text mask effects. Apply gradients or texture on your fonts with the new Background Clip option.</ls-li>\n			<ls-li>NEW: Added 28 new slide transitions.</ls-li>\n			<ls-li>NEW: Added \"Mirror Transition\" options to support carousel-like effects that animate layers back and forth depending on the navigation direction.</ls-li>\n			<ls-li>NEW: Opening and Ending Transitions can now inherit transformations set under the STYLE menu as well as perform automatic operations on those values.</ls-li>\n			<ls-li>NEW: Added text color option to Text Transitions.</ls-li>\n			<ls-li>NEW: Added \"Overflow\" option to layer styles, Opening Text Transition, and Ending Text Transition.</ls-li>\n			<ls-li>NEW: You can now specify a minimum and maximum responsive ratio, making it possible to control how layers are resized.</ls-li>\n			<ls-li>NEW: Added \"Responsive\" options to Scroll Transition\'s Offset settings to control layer movement on different devices.</ls-li>\n			<ls-li>Updated French localization [Thanks to <a href=\"https://instinct-photo.fr/contact/\" target=\"_blank\">Patrick Perrono</a>]</ls-li>\n			<ls-li>Layer Preview now supports multiple selection mode.</ls-li>\n			<ls-li>Slide Preview now supports live edits just like Layer Preview, and changes are reflected in real-time without leaving preview mode.</ls-li>\n			<ls-li>You can now undo/redo changes in live preview mode, and changes are reflected in real-time.</ls-li>\n			<ls-li>Various other improvements in all preview modes.</ls-li>\n			<ls-li>Various improvements for multiple selection mode.</ls-li>\n			<ls-li>Various improvements and bug fixes for undoing/redoing changes.</ls-li>\n			<ls-li>Various color picker improvements.</ls-li>\n			<ls-li>Ending Text Transition no longer requires an Ending Transition and can be played at the end of the slide.</ls-li>\n			<ls-li>Fixed \"Prevent Mouse Events\" option.</ls-li>\n			<ls-li>Fixed fast slide jumps. Rapidly changing slides can no longer cause any issues.</ls-li>\n			<ls-li>Fixed layer timings when the \"Start At\" field is empty.</ls-li>\n			<ls-li>Fixed returning values from certain API callbacks like slideChangeWillStart.</ls-li>\n			<ls-li>Fixed animation behavior when the Ending Transition is disabled.</ls-li>\n			<ls-li>Fixed the Transform Origin setting of Text Transition nodes.</ls-li>\n			<ls-li>Fixed disabling keyboard navigation when visitors are typing into a text field.</ls-li>\n			<ls-li>Many animation and timing behavior improvements.</ls-li>\n			<ls-li>Many UI improvements throughout the editor.</ls-li>\n			<ls-li>Many under-the-hood improvements and bug fixes.</ls-li>\n		</ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.3.0\n			<ls-small>Aug 23, 2022</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>NEW: Scroll Transition. Animate layers by scrolling the page.</ls-li><ls-li>DEPRECATED: Play By Scroll.</ls-li><ls-li>Added \"Enable Play By Scroll\" option to Plugin Settings → Miscellaneous.</ls-li><ls-li>Added \"Vertical Spacing\" options to Project Settings → Layout.</ls-li><ls-li>Added \"Related Settings\" shortcuts to relevant places of the Project Editor.</ls-li><ls-li>Improved Search experience in the Project Editor.</ls-li><ls-li>Fixed setting layer background image in multiple selection mode.</ls-li><ls-li>Fixed slide background position issues in Ken Burns effect.</ls-li><ls-li>Fixed searching for projects that are in groups.</ls-li><ls-li>Fixed color stop dragging issues in the color picker.</ls-li><ls-li>Fixed Post Taxonomy support for dynamic content sources.</ls-li><ls-li>Fixed the \"Open Popup\" layer action on front-end pages with logged out users.</ls-li><ls-li>Many under-the-hood improvements and bug fixes.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.2.5\n			<ls-small>Jul 18, 2022</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>Added backdrop filter support that allows blurring, color shifting, etc., the area behind layers.</ls-li><ls-li>Added a dedicated System Status menu item to LayerSlider\'s dashboard.</ls-li><ls-li>Added \"Recommended Settings\" section to System Status.</ls-li><ls-li>Improvements in text rendering and resizing sliders and popups.</ls-li><ls-li>Increased PHP compatibility with some non-GNU systems, like Solaris or Alpine Linux.</ls-li><ls-li>Fixed a rare issue that caused severe interface display issues.</ls-li><ls-li>Fixed video poster images not properly displaying in some cases.</ls-li><ls-li>Fixed Parallax Transition\'s Transform Origin setting.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.2.4\n			<ls-small>Jun 27, 2022</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>Fixed an issue that caused incorrectly renaming projects in rare cases.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.2.3\n			<ls-small>Jun 13, 2022</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>Added <strong>Skip \"Start in Viewport\"</strong> option, which makes it possible for layers to appear before your sliders start.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.2.2\n			<ls-small>Jun 1, 2022</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>Added a Quick Tip panel for embedding projects when you publish your work.</ls-li><ls-li>Introducing a new \"Open Popup\" layer action. Easily open any Popup anywhere, even if they aren\'t embedded on the page. No configuration needed.</ls-li><ls-li>Added a \"Launch Popups\" layer action, which triggers Popups waiting in the background to be opened.</ls-li><ls-li>Fixed switches and other layer action features.</ls-li><ls-li>Several UI fixes and improvements.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.2.1\n			<ls-small>May 2, 2022</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>This update contains security fixes.</ls-li><ls-li>New positioning options for layers (Align Positions From).</ls-li><ls-li>Updated LayerSlider module for the Classic Editor.</ls-li><ls-li>Improvements for the Hero layout mode.</ls-li><ls-li>Improved Project Preview now tracks much more options.&nbsp;</ls-li><ls-li>Fixed ampersand character in project names.</ls-li><ls-li>Fixed \"Scroll to Element\" layer action.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.2.0\n			<ls-small>Apr 20, 2022</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>Added Blob and Wave Shape generators.</ls-li><ls-li>Improved interface for Shape layers.</ls-li><ls-li>Revised Help and Smart Operation popups.</ls-li><ls-li>Improved Project Preview that tracks much more options.</ls-li><ls-li>Lots of important fixes and improvements throughout the plugin.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.1.4\n			<ls-small>Mar 31, 2022</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>Used Google Fonts are now automatically added to your project when importing or pasting layers and slides.</ls-li><ls-li>More efficient and better handling of loading Google Fonts.</ls-li><ls-li>Fixed the Timeline\'s layers list with hidden layers.</ls-li><ls-li>Fixed PHP debug messages.</ls-li><ls-li>Fixed minor UI issues.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.1.3\n			<ls-small>Mar 17, 2022</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>Fixed image layers loaded from custom URLs.</ls-li><ls-li>Fixed the [image] post placeholder for Dynamic Layers.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.1.2\n			<ls-small>Mar 10, 2022</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>This update contains security fixes.</ls-li><ls-li>You can now set the default slide duration and timings in Project Settings.</ls-li><ls-li>Slide duration and timing settings can now easily be applied to other slides.</ls-li><ls-li>Eliminated some rare issues with importing templates.</ls-li><ls-li>Fixed rare layer animation issues when changing slides.</ls-li><ls-li>Fixed Hover Transition\'s \"Always on Top\" option.</ls-li><ls-li>UI fixes and improvements.</ls-li><ls-li>Other bug fixes and improvements under the hood.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.1.1\n			<ls-small>Feb 21, 2022</ls-small>\n		</ls-h5>\n		<ls-p>Added complete French localization. [Thanks to <a href=\"https://instinct-photo.fr/contact/\" target=\"_blank\">Patrick Perrono</a>]</ls-p>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.1.0\n			<ls-small>Feb 14, 2022</ls-small>\n		</ls-h5>\n		<ls-p>Added Font Awesome 6 icon family.</ls-p>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.0.8\n			<ls-small>Feb 8, 2022</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>You can now quickly rename any project from the dashboard</ls-li><ls-li>Added slidebar timer support for Slide and Project Preview</ls-li><ls-li>Multiple fixes and enhancements in Project Preview</ls-li><ls-li>UI and usability fixes</ls-li><ls-li>Countless improvements under the hood</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.0.7\n			<ls-small>Dec 20, 2021</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>Fixed manually updating the list of LayerSlider Templates.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.0.6\n			<ls-small>Dec 20, 2021</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>Added shortcuts to quickly remove text and box shadows.</ls-li><ls-li>Added layer action: Close All Popups.</ls-li><ls-li>Fixed project search on dashboard.</ls-li><ls-li>Fixed layers list visibility and lock buttons.</ls-li><ls-li>Fixed project editor with \"Defer Javascript loading\" option enabled.</ls-li><ls-li>Fixed custom slide transition in Project Preview.</ls-li><ls-li>Numerous fixes and improvements throughout the plugin.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.0.5\n			<ls-small>Dec 3, 2021</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>Important fixes for UI and performance issues in the Project Editor.</ls-li><ls-li>Project IDs are now visible and searchable on LayerSlider’s dashboard.</ls-li><ls-li>Various minor fixes and improvements.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.0.4\n			<ls-small>Nov 29, 2021</ls-small>\n		</ls-h5>\n		<ls-ul><ls-li>Added layer alignment shortcuts to the STYLE menu of layers.</ls-li><ls-li>Fixed Media Library modal window in Safari.</ls-li><ls-li>Fixed scrolling issues in Project Preview.</ls-li><ls-li>Various fixes under the hood.</ls-li></ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.0.1 – 7.0.3\n			<ls-small>Nov 26, 2021</ls-small>\n		</ls-h5>\n		<ls-ul>\n			<ls-li>Fixed modal windows in Safari.</ls-li>\n			<ls-li>Various fixes throughout the plugin.</ls-li>\n		</ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 7.0.0\n			<ls-small>Nov 25, 2021</ls-small>\n		</ls-h5>\n		<ls-p>The day has finally come to share LayerSlider 7 with you. &nbsp;We’re super excited about this release. It’s a massive milestone in the development of LayerSlider, which gives us a solid and modern foundation we can easily and quickly build upon. We’ve concluded that making a complete changelog is impossible due to the amount of changes both visible and under the hood. We keep updating and refining the documentation, and LayerSlider 7 will be welcoming you with a guided product tour explaining the interface changes. We hope you’ll enjoy using LayerSlider 7 as much as we do.</ls-p>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 6.11.9\n			<ls-small>Sep 28, 2021</ls-small>\n		</ls-h5>\n		<ls-p>We know it may seem otherwise, but we\'re still alive! ;) In fact, we are extremely busy getting ready LayerSlider 7. It will be our biggest update since LayerSlider came into existence. LS7 will be a free update, and we\'ll announce more details soon. Until then, here\'s a maintenance release to address the issues that can\'t wait.</ls-p>\n		<ls-ul>\n			<ls-li>Fixed LayerSlider\'s Gutenberg block.</ls-li>\n			<ls-li>Various compatibility fixes.</ls-li>\n		</ls-ul>\n	</ls-box>\n</ls-li>\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 6.11.8\n			<ls-small>Apr 19, 2021</ls-small>\n		</ls-h5>\n		<ls-ul>\n			<ls-li>\n				Improved compatibility with older versions of LayerSlider.\n			</ls-li>\n			<ls-li>\n				Other improvements and bug fixes under the hood.\n			</ls-li>\n		</ls-ul>\n	</ls-box>\n</ls-li>\n\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 6.11.7\n			<ls-small>Apr 7, 2021</ls-small>\n		</ls-h5>\n		<ls-ul>\n			<ls-li>\n				Fixed minor user interface issues.\n			</ls-li>\n			<ls-li>\n				Fixed layer order when using <picture> element.\n			</ls-li>\n			<ls-li>\n				Fixed linked &lt;picture&gt; elements.\n			</ls-li>\n		</ls-ul>\n	</ls-box>\n</ls-li>\n\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 6.11.6\n			<ls-small>Mar 3, 2021</ls-small>\n		</ls-h5>\n		<ls-ul>\n			<ls-li>\n				Fixed image sizes & positions with certain image optimization plugins\n			</ls-li>\n			<ls-li>\n				Added WayPoint support to update scroll triggers after slider initialization\n			</ls-li>\n		</ls-ul>\n	</ls-box>\n</ls-li>\n\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 6.11.5\n			<ls-small>Feb 1, 2021</ls-small>\n		</ls-h5>\n		<ls-ul>\n			<ls-li>\n				Prevent WordPress applying HTML-native lazy loading on slider images. LayerSlider has its own lazy loading mechanism that’s more suitable for sliders and popups.\n			</ls-li>\n			<ls-li>\n				Added \"Use loading attribute\" option to LayerSlider → Options → Advanced to restore HTML-native lazy loading.\n			</ls-li>\n			<ls-li>\n				Increased compatibility for 3rd party themes and plugins.\n			</ls-li>\n		</ls-ul>\n	</ls-box>\n</ls-li>\n\n\n<ls-li>\n	<ls-box>\n		<ls-h5>\n			LayerSlider 6.11.4\n			<ls-small>Jan 25, 2021</ls-small>\n		</ls-h5>\n		<ls-p>\n			This release fixes an issue introduced in the last update when there are multiple sliders on page.\n		</ls-p>\n	</ls-box>\n</ls-li>\n\";s:16:\"important-notice\";a:9:{s:4:\"date\";s:10:\"2023-05-22\";s:5:\"title\";s:58:\"Celebrating LayerSlider’s New Home with a Special Offer!\";s:7:\"message\";s:748:\"We’re saying goodbye to Envato Market: LayerSlider is now fully independent and available exclusively on <a href=\"https://layerslider.com/\" target=\"_blank\">layerslider.com</a>. Don’t worry! LayerSlider is thriving and evolving faster than ever, and Envato customers continue to receive the same benefits. To celebrate this occasion, you can <span style=\"font-weight: 500\">purchase LayerSlider 15% OFF for a limited time with coupon code <span style=\"font-weight: 800; color: #007cba;\">INDIE15</span></span>.<br><br><a class=\"button button-primary\" href=\"https://layerslider.com/leaving-envato/\" target=\"_blank\">full announcement</a> <a class=\"button button-primary\" href=\"https://layerslider.com/pricing/\" target=\"_blank\">Grab your discount</a>\";s:5:\"image\";s:0:\"\";s:6:\"banner\";a:5:{s:5:\"class\";s:0:\"\";s:5:\"style\";s:132:\"height: auto; margin: 39px auto 0 auto !important; min-width: 700px; max-width: 1700px; padding-right: 20px; box-sizing: border-box;\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:6:\"_blank\";s:7:\"content\";s:3901:\"\n\n		<style>\n		@import url(\"https://fonts.googleapis.com/css2?family=Montserrat:wght@200;300;400;500&display=swap\");\n		</style>\n		<style>\n\n			.layerslider_notice_img {\n				padding-right: 30px !important;\n				max-width: none !important;\n				min-width: 0 !important;\n			}\n\n\n			#lspr-inner {\n				position: relative;\n				height: auto;\n				background-image: 	linear-gradient(150deg, rgb(56, 103, 189) 0%, rgba(76, 119, 199, 0.5) 28%, rgba(69, 110, 186, 0) 68%),\n									linear-gradient(45deg, rgb(41, 10, 102) 50%, rgb(111, 32, 214) 100%);\n				border-radius: 6px;\n			}\n\n			#lspr-grid {\n				position: relative;\n				height: auto;\n				display: flex;\n				margin: 0 auto !important;\n				justify-content: space-between;\n				align-items: stretch;\n				flex-flow: row wrap;\n				max-width: 1500px;\n				padding: 20px;\n			}\n\n			#lspr-left,\n			#lspr-right {\n				position: relative;\n				box-sizing: border-box;\n			}\n\n			#lspr-left {\n				flex: 70% 1 0;\n			}\n\n			#lspr-right {\n				flex: 30% 1 0;\n				min-width: 270px;\n				display: flex;\n				align-items: center;\n				justify-content: center;\n			}\n\n			#lspr-scroll {\n				position: absolute;\n				left: 0;\n				top: 0;\n				right: 0;\n				bottom: 0;\n				z-index: 1;\n				overflow: hidden;\n				border-radius: 1rem;\n			}\n\n			.lspr-over {\n				position: relative;\n				z-index: 2;\n			}\n\n			#lspr-heading {\n				text-align: center;\n				color: white;\n				font-size: 18px;\n				font-weight: 500;\n				line-height: 20px;\n				font-family: Montserrat, sans-serif;\n			}\n\n			.lspr-nowrap {\n				white-space: nowrap;\n			}\n\n			.lspr-text {\n				position: relative;\n				padding-top: 15px;\n				z-index: 200;\n				color: white;\n				font-family: Montserrat, sans-serif;\n				font-size: 15px;\n				font-weight: 300;\n				line-height: 22px;\n				text-align: justify;\n			}\n\n			.lspr-text a {\n				font-weight: 500;\n				text-decoration: none;\n				padding: 0 3px;\n				margin-right: 2px;\n				background-color: white;\n				color: #363088;\n				border-radius: 3px;\n			}\n\n			.lspr-text a:hover {\n				background-color: #e3177d;\n				color: white;\n			}\n\n			#lspr-buttons {\n				text-align: center;\n			}\n\n			#lspr-buttons a {\n				margin: 0 1rem;\n				text-decoration: none;\n				color: white;\n				text-transform: uppercase;\n				font-family: Montserrat, sans-serif;\n				font-weight: 500;\n				display: inline-block;\n				border-radius: 100px;\n				background-color: #e3177d;\n				line-height: 32px;\n				font-size: 14px;\n				transition: all 0.2s;\n				box-shadow: none;\n				cursor: pointer;\n				width: 240px;\n				box-sizing: border-box;\n			}\n\n			#lspr-buttons a:last-child {\n				margin-top: 15px;\n			}\n\n			#lspr-buttons a:hover {\n				filter: contrast(170%);\n			}\n\n			.layerslider_notice_img  .dashicons-dismiss {\n				right: 30px;\n			}\n\n		</style>\n		<div id=\"lspr-inner\">\n			<div id=\"lspr-grid\">\n				<div id=\"lspr-left\">\n					<div id=\"lspr-heading\" class=\"lspr-over\">\n						<span class=\"lspr-nowrap\">Celebrating LayerSlider’s New Home<span> <span class=\"lspr-nowrap\">with a Special Offer!<span>\n					</div>\n\n					<div class=\"lspr-text\" class=\"lspr-over\">\n						<span>\n							We’re saying goodbye to Envato Market: LayerSlider is now fully independent and available exclusively on <a href=\"https://layerslider.com/\" target=\"_blank\">layerslider.com</a>. Don’t worry! LayerSlider is thriving and evolving faster than ever, and Envato customers continue to receive the same benefits. To celebrate this occasion, you can <span style=\"font-weight: 500\">purchase LayerSlider 15% OFF for a limited time with coupon code <span style=\"color: #ff55af\">INDIE15</span></span>.\n						</span>\n					</div>\n				</div>\n				<div id=\"lspr-right\">\n					<div id=\"lspr-buttons\" class=\"lspr-over\">\n						<a href=\"https://layerslider.com/leaving-envato/\" target=\"_blank\">full announcement</a>\n                    	<a href=\"https://layerslider.com/pricing/\" target=\"_blank\">Grab your discount</a>\n                    </div>\n				</div>\n			</div>\n		</div>\n		\";}s:11:\"min_version\";s:0:\"\";s:11:\"max_version\";s:0:\"\";s:11:\"unactivated\";b:0;s:10:\"url_filter\";s:11:\"layerslider\";}s:14:\"latest-version\";s:5:\"7.7.6\";s:19:\"latest-version-date\";s:10:\"2023-05-23\";}","no"),
("114517","ls-remote-data-updated","1685855704","no"),
("114518","ls-google-fonts-data","a:2:{s:9:\"languages\";a:28:{i:0;a:2:{s:4:\"lang\";s:5:\"latin\";s:8:\"sentence\";s:27:\"It\'s just a matter of time.\";}i:1;a:2:{s:4:\"lang\";s:9:\"latin-ext\";s:8:\"sentence\";s:54:\"Qui trop légèrement se fie, mal à propos se défie.\";}i:2;a:2:{s:4:\"lang\";s:6:\"arabic\";s:8:\"sentence\";s:54:\"الحب سماء لا تمطر غير الأحلام.\";}i:3;a:2:{s:4:\"lang\";s:7:\"bengali\";s:8:\"sentence\";s:182:\"আগুনের শিখা নিভে গিয়েছিল, আর তিনি জানলা দিয়ে তারাদের দিকে তাকালেন৷\";}i:4;a:2:{s:4:\"lang\";s:16:\"chinese-hongkong\";s:8:\"sentence\";s:57:\"他們所有的設備和儀器彷彿都是有生命的。\";}i:5;a:2:{s:4:\"lang\";s:19:\"chinese-traditional\";s:8:\"sentence\";s:57:\"他们所有的设备和仪器彷佛都是有生命的。\";}i:6;a:2:{s:4:\"lang\";s:18:\"chinese-simplified\";s:8:\"sentence\";s:57:\"他們所有的設備和儀器彷彿都是有生命的。\";}i:7;a:2:{s:4:\"lang\";s:8:\"cyrillic\";s:8:\"sentence\";s:90:\"Алая вспышка осветила силуэт зазубренного крыла.\";}i:8;a:2:{s:4:\"lang\";s:12:\"cyrillic-ext\";s:8:\"sentence\";s:90:\"Алая вспышка осветила силуэт зазубренного крыла.\";}i:9;a:2:{s:4:\"lang\";s:10:\"devanagari\";s:8:\"sentence\";s:156:\"अंतरिक्ष यान से दूर नीचे पृथ्वी शानदार ढंग से जगमगा रही थी ।\";}i:10;a:2:{s:4:\"lang\";s:5:\"greek\";s:8:\"sentence\";s:42:\"Ήταν απλώς θέμα χρόνου.\";}i:11;a:2:{s:4:\"lang\";s:9:\"greek-ext\";s:8:\"sentence\";s:42:\"Ήταν απλώς θέμα χρόνου.\";}i:12;a:2:{s:4:\"lang\";s:8:\"gujarati\";s:8:\"sentence\";s:136:\"અમને તેની જાણ થાય તે પહેલાં જ, અમે જમીન છોડી દીધી હતી.\";}i:13;a:2:{s:4:\"lang\";s:8:\"gurmukhi\";s:8:\"sentence\";s:58:\"ਸਵਾਲ ਸਿਰਫ਼ ਸਮੇਂ ਦਾ ਸੀ।\";}i:14;a:2:{s:4:\"lang\";s:6:\"hebrew\";s:8:\"sentence\";s:63:\"אז הגיע הלילה של כוכב השביט הראשון.\";}i:15;a:2:{s:4:\"lang\";s:8:\"japanese\";s:8:\"sentence\";s:51:\"彼らの機器や装置はすべて生命体だ。\";}i:16;a:2:{s:4:\"lang\";s:7:\"kannada\";s:8:\"sentence\";s:76:\"ಇದು ಕೇವಲ ಸಮಯದ ಪ್ರಶ್ನೆಯಾಗಿದೆ.\";}i:17;a:2:{s:4:\"lang\";s:5:\"khmer\";s:8:\"sentence\";s:173:\"ខ្ញុំបានមើលព្យុះ ដែលមានភាពស្រស់ស្អាតណាស់ ប៉ុន្តែគួរឱ្យខ្លាច\";}i:18;a:2:{s:4:\"lang\";s:6:\"korean\";s:8:\"sentence\";s:51:\"그들의 장비와 기구는 모두 살아 있다.\";}i:19;a:2:{s:4:\"lang\";s:9:\"malayalam\";s:8:\"sentence\";s:187:\"അവരുടെ എല്ലാ ഉപകരണങ്ങളും യന്ത്രങ്ങളും ഏതെങ്കിലും രൂപത്തിൽ സജീവമാണ്.\";}i:20;a:2:{s:4:\"lang\";s:7:\"myanmar\";s:8:\"sentence\";s:163:\"သူတို့ရဲ့ စက်ပစ္စည်းတွေ၊ ကိရိယာတွေ အားလုံး အသက်ရှင်ကြတယ်။\";}i:21;a:2:{s:4:\"lang\";s:5:\"oriya\";s:8:\"sentence\";s:73:\"ଏହା କେବଳ ଏକ ସମୟ କଥା ହିଁ ଥିଲା.\";}i:22;a:2:{s:4:\"lang\";s:7:\"sinhala\";s:8:\"sentence\";s:96:\"එය කාලය පිළිබඳ ප්‍රශ්නයක් පමණක් විය.\";}i:23;a:2:{s:4:\"lang\";s:5:\"tamil\";s:8:\"sentence\";s:120:\"அந்திமாலையில், அலைகள் வேகமாக வீசத் தொடங்கின.\";}i:24;a:2:{s:4:\"lang\";s:6:\"telugu\";s:8:\"sentence\";s:120:\"ఆ రాత్రి మొదటిసారిగా ఒక నక్షత్రం నేలరాలింది.\";}i:25;a:2:{s:4:\"lang\";s:4:\"thai\";s:8:\"sentence\";s:72:\"การเดินทางขากลับคงจะเหงา\";}i:26;a:2:{s:4:\"lang\";s:7:\"tibetan\";s:8:\"sentence\";s:132:\"ཁོ་ཚོའི་སྒྲིག་ཆས་དང་ལག་ཆ་ཡོད་ཚད་གསོན་པོ་རེད།\";}i:27;a:2:{s:4:\"lang\";s:10:\"vietnamese\";s:8:\"sentence\";s:62:\"Bầu trời trong xanh thăm thẳm, không một gợn mây.\";}}s:5:\"fonts\";a:1521:{i:0;a:7:{s:6:\"family\";s:6:\"Roboto\";s:8:\"variants\";a:12:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";}s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v30\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:746;}i:1;a:7:{s:6:\"family\";s:9:\"Open Sans\";s:8:\"variants\";a:12:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:9:\"300italic\";i:7;s:6:\"italic\";i:8;s:9:\"500italic\";i:9;s:9:\"600italic\";i:10;s:9:\"700italic\";i:11;s:9:\"800italic\";}s:7:\"subsets\";a:8:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:6:\"hebrew\";i:5;s:5:\"latin\";i:6;s:9:\"latin-ext\";i:7;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v35\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:825;}i:2;a:7:{s:6:\"family\";s:12:\"Noto Sans JP\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:8:\"japanese\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v52\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:298;}i:3;a:7:{s:6:\"family\";s:10:\"Montserrat\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v25\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:755;}i:4;a:7:{s:6:\"family\";s:4:\"Lato\";s:8:\"variants\";a:10:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v24\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:908;}i:5;a:7:{s:6:\"family\";s:7:\"Poppins\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:726;}i:6;a:7:{s:6:\"family\";s:16:\"Roboto Condensed\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";}s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v25\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:886;}i:7;a:7:{s:6:\"family\";s:15:\"Source Sans Pro\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";}s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:641;}i:8;a:7:{s:6:\"family\";s:14:\"Material Icons\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:4:\"v140\";s:12:\"lastModified\";s:10:\"2023-03-08\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:692;}i:9;a:7:{s:6:\"family\";s:5:\"Inter\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:80;}i:10;a:7:{s:6:\"family\";s:11:\"Roboto Mono\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:9:\"100italic\";i:8;s:9:\"200italic\";i:9;s:9:\"300italic\";i:10;s:6:\"italic\";i:11;s:9:\"500italic\";i:12;s:9:\"600italic\";i:13;s:9:\"700italic\";}s:7:\"subsets\";a:6:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v22\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:1035;}i:11;a:7:{s:6:\"family\";s:6:\"Oswald\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v49\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:947;}i:12;a:7:{s:6:\"family\";s:7:\"Raleway\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v28\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:837;}i:13;a:7:{s:6:\"family\";s:9:\"Noto Sans\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:8:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:10:\"devanagari\";i:3;s:5:\"greek\";i:4;s:9:\"greek-ext\";i:5;s:5:\"latin\";i:6;s:9:\"latin-ext\";i:7;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v28\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:678;}i:14;a:7:{s:6:\"family\";s:6:\"Ubuntu\";s:8:\"variants\";a:8:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";}s:7:\"subsets\";a:6:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:463;}i:15;a:7:{s:6:\"family\";s:11:\"Nunito Sans\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:9:\"200italic\";i:9;s:9:\"300italic\";i:10;s:6:\"italic\";i:11;s:9:\"500italic\";i:12;s:9:\"600italic\";i:13;s:9:\"700italic\";i:14;s:9:\"800italic\";i:15;s:9:\"900italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:928;}i:16;a:7:{s:6:\"family\";s:11:\"Roboto Slab\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v25\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:856;}i:17;a:7:{s:6:\"family\";s:6:\"Nunito\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:9:\"200italic\";i:9;s:9:\"300italic\";i:10;s:6:\"italic\";i:11;s:9:\"500italic\";i:12;s:9:\"600italic\";i:13;s:9:\"700italic\";i:14;s:9:\"800italic\";i:15;s:9:\"900italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v25\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:558;}i:18;a:7:{s:6:\"family\";s:5:\"Rubik\";s:8:\"variants\";a:14:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:9:\"300italic\";i:8;s:6:\"italic\";i:9;s:9:\"500italic\";i:10;s:9:\"600italic\";i:11;s:9:\"700italic\";i:12;s:9:\"800italic\";i:13;s:9:\"900italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:6:\"hebrew\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v26\";s:12:\"lastModified\";s:10:\"2023-03-09\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:745;}i:19;a:7:{s:6:\"family\";s:16:\"Playfair Display\";s:8:\"variants\";a:12:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:6:\"italic\";i:7;s:9:\"500italic\";i:8;s:9:\"600italic\";i:9;s:9:\"700italic\";i:10;s:9:\"800italic\";i:11;s:9:\"900italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v30\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:875;}i:20;a:7:{s:6:\"family\";s:12:\"Merriweather\";s:8:\"variants\";a:8:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"900\";i:7;s:9:\"900italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v30\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1149;}i:21;a:7:{s:6:\"family\";s:7:\"PT Sans\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1068;}i:22;a:7:{s:6:\"family\";s:12:\"Noto Sans KR\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"700\";i:5;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:6:\"korean\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v27\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1172;}i:23;a:7:{s:6:\"family\";s:5:\"Kanit\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:518;}i:24;a:7:{s:6:\"family\";s:9:\"Work Sans\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1051;}i:25;a:7:{s:6:\"family\";s:4:\"Lora\";s:8:\"variants\";a:8:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:6:\"italic\";i:5;s:9:\"500italic\";i:6;s:9:\"600italic\";i:7;s:9:\"700italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v32\";s:12:\"lastModified\";s:10:\"2023-02-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:687;}i:26;a:7:{s:6:\"family\";s:12:\"Noto Sans TC\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"700\";i:5;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:19:\"chinese-traditional\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v26\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:851;}i:27;a:7:{s:6:\"family\";s:9:\"Fira Sans\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:507;}i:28;a:7:{s:6:\"family\";s:9:\"Quicksand\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v30\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:844;}i:29;a:7:{s:6:\"family\";s:6:\"Barlow\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1003;}i:30;a:7:{s:6:\"family\";s:11:\"Inconsolata\";s:8:\"variants\";a:8:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v31\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:545;}i:31;a:7:{s:6:\"family\";s:5:\"Mukta\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1486;}i:32;a:7:{s:6:\"family\";s:6:\"Mulish\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:9:\"200italic\";i:9;s:9:\"300italic\";i:10;s:6:\"italic\";i:11;s:9:\"500italic\";i:12;s:9:\"600italic\";i:13;s:9:\"700italic\";i:14;s:9:\"800italic\";i:15;s:9:\"900italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1153;}i:33;a:7:{s:6:\"family\";s:5:\"Heebo\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:6:\"hebrew\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:379;}i:34;a:7:{s:6:\"family\";s:8:\"PT Serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:916;}i:35;a:7:{s:6:\"family\";s:13:\"IBM Plex Sans\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";}s:7:\"subsets\";a:6:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:496;}i:36;a:7:{s:6:\"family\";s:13:\"Titillium Web\";s:8:\"variants\";a:11:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:597;}i:37;a:7:{s:6:\"family\";s:7:\"DM Sans\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:366;}i:38;a:7:{s:6:\"family\";s:10:\"Noto Serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:753;}i:39;a:7:{s:6:\"family\";s:14:\"Libre Franklin\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:347;}i:40;a:7:{s:6:\"family\";s:7:\"Manrope\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";}s:7:\"subsets\";a:6:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:586;}i:41;a:7:{s:6:\"family\";s:12:\"Nanum Gothic\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"700\";i:2;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:6:\"korean\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1211;}i:42;a:7:{s:6:\"family\";s:5:\"Karla\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:9:\"200italic\";i:8;s:9:\"300italic\";i:9;s:6:\"italic\";i:10;s:9:\"500italic\";i:11;s:9:\"600italic\";i:12;s:9:\"700italic\";i:13;s:9:\"800italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v30\";s:12:\"lastModified\";s:10:\"2023-05-09\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:809;}i:43;a:7:{s:6:\"family\";s:12:\"Josefin Sans\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:9:\"100italic\";i:8;s:9:\"200italic\";i:9;s:9:\"300italic\";i:10;s:6:\"italic\";i:11;s:9:\"500italic\";i:12;s:9:\"600italic\";i:13;s:9:\"700italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v26\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:741;}i:44;a:7:{s:6:\"family\";s:13:\"Hind Siliguri\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:7:\"bengali\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1414;}i:45;a:7:{s:6:\"family\";s:23:\"Material Icons Outlined\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:4:\"v109\";s:12:\"lastModified\";s:10:\"2023-03-08\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:551;}i:46;a:7:{s:6:\"family\";s:5:\"Arimo\";s:8:\"variants\";a:8:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:6:\"italic\";i:5;s:9:\"500italic\";i:6;s:9:\"600italic\";i:7;s:9:\"700italic\";}s:7:\"subsets\";a:8:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:6:\"hebrew\";i:5;s:5:\"latin\";i:6;s:9:\"latin-ext\";i:7;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v28\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1109;}i:47;a:7:{s:6:\"family\";s:16:\"Noto Color Emoji\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"emoji\";}s:7:\"version\";s:3:\"v24\";s:12:\"lastModified\";s:10:\"2022-09-26\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:6;}i:48;a:7:{s:6:\"family\";s:17:\"Libre Baskerville\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:748;}i:49;a:7:{s:6:\"family\";s:5:\"Dosis\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v27\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:661;}i:50;a:7:{s:6:\"family\";s:16:\"Source Serif Pro\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";}s:7:\"subsets\";a:6:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:596;}i:51;a:7:{s:6:\"family\";s:6:\"Bitter\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v32\";s:12:\"lastModified\";s:10:\"2022-12-08\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:459;}i:52;a:7:{s:6:\"family\";s:14:\"PT Sans Narrow\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:773;}i:53;a:7:{s:6:\"family\";s:10:\"Bebas Neue\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2023-05-09\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1092;}i:54;a:7:{s:6:\"family\";s:15:\"Source Code Pro\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:9:\"200italic\";i:9;s:9:\"300italic\";i:10;s:6:\"italic\";i:11;s:9:\"500italic\";i:12;s:9:\"600italic\";i:13;s:9:\"700italic\";i:14;s:9:\"800italic\";i:15;s:9:\"900italic\";}s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v22\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:375;}i:55;a:7:{s:6:\"family\";s:6:\"Oxygen\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:574;}i:56;a:7:{s:6:\"family\";s:5:\"Cairo\";s:8:\"variants\";a:8:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:6:\"arabic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v28\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:615;}i:57;a:7:{s:6:\"family\";s:5:\"Cabin\";s:8:\"variants\";a:8:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:6:\"italic\";i:5;s:9:\"500italic\";i:6;s:9:\"600italic\";i:7;s:9:\"700italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v26\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:714;}i:58;a:7:{s:6:\"family\";s:11:\"EB Garamond\";s:8:\"variants\";a:10:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:6:\"italic\";i:6;s:9:\"500italic\";i:7;s:9:\"600italic\";i:8;s:9:\"700italic\";i:9;s:9:\"800italic\";}s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v26\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:236;}i:59;a:7:{s:6:\"family\";s:5:\"Anton\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v23\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1145;}i:60;a:7:{s:6:\"family\";s:4:\"Abel\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:368;}i:61;a:7:{s:6:\"family\";s:7:\"Lobster\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v28\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:940;}i:62;a:7:{s:6:\"family\";s:14:\"Dancing Script\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v24\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:758;}i:63;a:7:{s:6:\"family\";s:6:\"Prompt\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:771;}i:64;a:7:{s:6:\"family\";s:8:\"Pacifico\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v22\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:991;}i:65;a:7:{s:6:\"family\";s:9:\"Comfortaa\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:6:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v40\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1225;}i:66;a:7:{s:6:\"family\";s:5:\"Exo 2\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:731;}i:67;a:7:{s:6:\"family\";s:12:\"Crimson Text\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:427;}i:68;a:7:{s:6:\"family\";s:16:\"Barlow Condensed\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:474;}i:69;a:7:{s:6:\"family\";s:9:\"Maven Pro\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v32\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:628;}i:70;a:7:{s:6:\"family\";s:4:\"Hind\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:697;}i:71;a:7:{s:6:\"family\";s:8:\"Rajdhani\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:275;}i:72;a:7:{s:6:\"family\";s:13:\"Noto Serif JP\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:8:\"japanese\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:750;}i:73;a:7:{s:6:\"family\";s:4:\"Jost\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:408;}i:74;a:7:{s:6:\"family\";s:12:\"Noto Sans SC\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"700\";i:5;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:18:\"chinese-simplified\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v26\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1393;}i:75;a:7:{s:6:\"family\";s:12:\"Varela Round\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:6:\"hebrew\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2023-02-16\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1015;}i:76;a:7:{s:6:\"family\";s:10:\"Fjalla One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:12:\"cyrillic-ext\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2023-04-04\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:841;}i:77;a:7:{s:6:\"family\";s:16:\"Signika Negative\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1130;}i:78;a:7:{s:6:\"family\";s:25:\"Material Symbols Outlined\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:4:\"v110\";s:12:\"lastModified\";s:10:\"2023-05-08\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:500;}i:79;a:7:{s:6:\"family\";s:20:\"Material Icons Round\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:4:\"v108\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:671;}i:80;a:7:{s:6:\"family\";s:4:\"Teko\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:961;}i:81;a:7:{s:6:\"family\";s:4:\"Arvo\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1086;}i:82;a:7:{s:6:\"family\";s:9:\"Assistant\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";}s:7:\"subsets\";a:3:{i:0;s:6:\"hebrew\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:449;}i:83;a:7:{s:6:\"family\";s:13:\"Space Grotesk\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2023-01-06\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1070;}i:84;a:7:{s:6:\"family\";s:4:\"Asap\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v26\";s:12:\"lastModified\";s:10:\"2022-11-18\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:302;}i:85;a:7:{s:6:\"family\";s:7:\"Archivo\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1100;}i:86;a:7:{s:6:\"family\";s:13:\"Abril Fatface\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1233;}i:87;a:7:{s:6:\"family\";s:9:\"Righteous\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:873;}i:88;a:7:{s:6:\"family\";s:6:\"Caveat\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:993;}i:89;a:7:{s:6:\"family\";s:11:\"Public Sans\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:594;}i:90;a:7:{s:6:\"family\";s:17:\"Merriweather Sans\";s:8:\"variants\";a:12:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:9:\"300italic\";i:7;s:6:\"italic\";i:8;s:9:\"500italic\";i:9;s:9:\"600italic\";i:10;s:9:\"700italic\";i:11;s:9:\"800italic\";}s:7:\"subsets\";a:4:{i:0;s:12:\"cyrillic-ext\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v26\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1218;}i:91;a:7:{s:6:\"family\";s:13:\"IBM Plex Mono\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:208;}i:92;a:7:{s:6:\"family\";s:18:\"Shadows Into Light\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:909;}i:93;a:7:{s:6:\"family\";s:18:\"Cormorant Garamond\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1118;}i:94;a:7:{s:6:\"family\";s:19:\"Fira Sans Condensed\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1290;}i:95;a:7:{s:6:\"family\";s:8:\"Overpass\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:634;}i:96;a:7:{s:6:\"family\";s:10:\"Slabo 27px\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:914;}i:97;a:7:{s:6:\"family\";s:7:\"Tajawal\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:6:\"arabic\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:223;}i:98;a:7:{s:6:\"family\";s:7:\"Satisfy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:563;}i:99;a:7:{s:6:\"family\";s:17:\"Yanone Kaffeesatz\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v24\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:604;}i:100;a:7:{s:6:\"family\";s:20:\"Material Icons Sharp\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:4:\"v109\";s:12:\"lastModified\";s:10:\"2023-03-08\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:570;}i:101;a:7:{s:6:\"family\";s:17:\"M PLUS Rounded 1c\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";}s:7:\"subsets\";a:9:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:6:\"hebrew\";i:5;s:8:\"japanese\";i:6;s:5:\"latin\";i:7;s:9:\"latin-ext\";i:8;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:418;}i:102;a:7:{s:6:\"family\";s:14:\"Nanum Myeongjo\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"700\";i:2;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:6:\"korean\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1026;}i:103;a:7:{s:6:\"family\";s:15:\"Red Hat Display\";s:8:\"variants\";a:14:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:9:\"300italic\";i:8;s:6:\"italic\";i:9;s:9:\"500italic\";i:10;s:9:\"600italic\";i:11;s:9:\"700italic\";i:12;s:9:\"800italic\";i:13;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:373;}i:104;a:7:{s:6:\"family\";s:10:\"Zilla Slab\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1140;}i:105;a:7:{s:6:\"family\";s:9:\"Catamaran\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:5:\"tamil\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:211;}i:106;a:7:{s:6:\"family\";s:12:\"Indie Flower\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:581;}i:107;a:7:{s:6:\"family\";s:23:\"Material Icons Two Tone\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:4:\"v112\";s:12:\"lastModified\";s:10:\"2023-03-08\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:480;}i:108;a:7:{s:6:\"family\";s:14:\"Asap Condensed\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:839;}i:109;a:7:{s:6:\"family\";s:21:\"Barlow Semi Condensed\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:835;}i:110;a:7:{s:6:\"family\";s:7:\"Sarabun\";s:8:\"variants\";a:16:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:255;}i:111;a:7:{s:6:\"family\";s:4:\"Play\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:6:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1283;}i:112;a:7:{s:6:\"family\";s:12:\"Chakra Petch\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:920;}i:113;a:7:{s:6:\"family\";s:11:\"Secular One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:6:\"hebrew\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1207;}i:114;a:7:{s:6:\"family\";s:3:\"Exo\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1279;}i:115;a:7:{s:6:\"family\";s:12:\"Hind Madurai\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:5:\"tamil\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1421;}i:116;a:7:{s:6:\"family\";s:16:\"Noto Sans Arabic\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:1:{i:0;s:6:\"arabic\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-06-01\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1253;}i:117;a:7:{s:6:\"family\";s:6:\"Domine\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1074;}i:118;a:7:{s:6:\"family\";s:10:\"Lilita One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:925;}i:119;a:7:{s:6:\"family\";s:6:\"Outfit\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:179;}i:120;a:7:{s:6:\"family\";s:9:\"Questrial\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2023-01-06\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:904;}i:121;a:7:{s:6:\"family\";s:7:\"Signika\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1058;}i:122;a:7:{s:6:\"family\";s:16:\"Permanent Marker\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:602;}i:123;a:7:{s:6:\"family\";s:10:\"Bree Serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:411;}i:124;a:7:{s:6:\"family\";s:9:\"Russo One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:887;}i:125;a:7:{s:6:\"family\";s:14:\"IBM Plex Serif\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:789;}i:126;a:7:{s:6:\"family\";s:9:\"M PLUS 1p\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";}s:7:\"subsets\";a:9:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:6:\"hebrew\";i:5;s:8:\"japanese\";i:6;s:5:\"latin\";i:7;s:9:\"latin-ext\";i:8;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v28\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:213;}i:127;a:7:{s:6:\"family\";s:13:\"Didact Gothic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:6:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1193;}i:128;a:7:{s:6:\"family\";s:24:\"Material Symbols Rounded\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:4:\"v109\";s:12:\"lastModified\";s:10:\"2023-05-08\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:265;}i:129;a:7:{s:6:\"family\";s:4:\"Acme\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2022-12-08\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:817;}i:130;a:7:{s:6:\"family\";s:13:\"Alegreya Sans\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";}s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v24\";s:12:\"lastModified\";s:10:\"2022-12-08\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:404;}i:131;a:7:{s:6:\"family\";s:9:\"Amatic SC\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:6:\"hebrew\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v24\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:804;}i:132;a:7:{s:6:\"family\";s:13:\"Alfa Slab One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:770;}i:133;a:7:{s:6:\"family\";s:8:\"Vollkorn\";s:8:\"variants\";a:12:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:6:\"italic\";i:7;s:9:\"500italic\";i:8;s:9:\"600italic\";i:9;s:9:\"700italic\";i:10;s:9:\"800italic\";i:11;s:9:\"900italic\";}s:7:\"subsets\";a:6:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v22\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1095;}i:134;a:7:{s:6:\"family\";s:16:\"DM Serif Display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1301;}i:135;a:7:{s:6:\"family\";s:7:\"Almarai\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"700\";i:3;s:3:\"800\";}s:7:\"subsets\";a:1:{i:0;s:6:\"arabic\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:396;}i:136;a:7:{s:6:\"family\";s:14:\"Archivo Narrow\";s:8:\"variants\";a:8:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:6:\"italic\";i:5;s:9:\"500italic\";i:6;s:9:\"600italic\";i:7;s:9:\"700italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v29\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1080;}i:137;a:7:{s:6:\"family\";s:7:\"Rowdies\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:977;}i:138;a:7:{s:6:\"family\";s:5:\"Kalam\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:493;}i:139;a:7:{s:6:\"family\";s:5:\"Tinos\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:8:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:6:\"hebrew\";i:5;s:5:\"latin\";i:6;s:9:\"latin-ext\";i:7;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v24\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:911;}i:140;a:7:{s:6:\"family\";s:7:\"ABeeZee\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v22\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:666;}i:141;a:7:{s:6:\"family\";s:7:\"Figtree\";s:8:\"variants\";a:14:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:9:\"300italic\";i:8;s:6:\"italic\";i:9;s:9:\"500italic\";i:10;s:9:\"600italic\";i:11;s:9:\"700italic\";i:12;s:9:\"800italic\";i:13;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:57;}i:142;a:7:{s:6:\"family\";s:20:\"IBM Plex Sans Arabic\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:6:\"arabic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:983;}i:143;a:7:{s:6:\"family\";s:12:\"Noto Sans HK\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"700\";i:5;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:16:\"chinese-hongkong\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1441;}i:144;a:7:{s:6:\"family\";s:16:\"Noto Kufi Arabic\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:1:{i:0;s:6:\"arabic\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:103;}i:145;a:7:{s:6:\"family\";s:8:\"Orbitron\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v29\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1356;}i:146;a:7:{s:6:\"family\";s:6:\"Cinzel\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v23\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1315;}i:147;a:7:{s:6:\"family\";s:8:\"Urbanist\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2023-01-06\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1111;}i:148;a:7:{s:6:\"family\";s:9:\"Patua One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1038;}i:149;a:7:{s:6:\"family\";s:5:\"Cardo\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:5:\"greek\";i:1;s:9:\"greek-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:434;}i:150;a:7:{s:6:\"family\";s:4:\"Sora\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:572;}i:151;a:7:{s:6:\"family\";s:6:\"Zeyada\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:556;}i:152;a:7:{s:6:\"family\";s:5:\"Amiri\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:3:{i:0;s:6:\"arabic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v27\";s:12:\"lastModified\";s:10:\"2023-01-10\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:913;}i:153;a:7:{s:6:\"family\";s:10:\"Space Mono\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2023-01-06\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:528;}i:154;a:7:{s:6:\"family\";s:8:\"Alegreya\";s:8:\"variants\";a:12:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:6:\"italic\";i:7;s:9:\"500italic\";i:8;s:9:\"600italic\";i:9;s:9:\"700italic\";i:10;s:9:\"800italic\";i:11;s:9:\"900italic\";}s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v35\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:514;}i:155;a:7:{s:6:\"family\";s:13:\"Archivo Black\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:761;}i:156;a:7:{s:6:\"family\";s:16:\"Frank Ruhl Libre\";s:8:\"variants\";a:7:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:6:\"hebrew\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:566;}i:157;a:7:{s:6:\"family\";s:11:\"Yantramanav\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"700\";i:5;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:486;}i:158;a:7:{s:6:\"family\";s:12:\"Noticia Text\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1473;}i:159;a:7:{s:6:\"family\";s:21:\"Montserrat Alternates\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:862;}i:160;a:7:{s:6:\"family\";s:6:\"Martel\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:794;}i:161;a:7:{s:6:\"family\";s:17:\"Plus Jakarta Sans\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:9:\"200italic\";i:8;s:9:\"300italic\";i:9;s:6:\"italic\";i:10;s:9:\"500italic\";i:11;s:9:\"600italic\";i:12;s:9:\"700italic\";i:13;s:9:\"800italic\";}s:7:\"subsets\";a:4:{i:0;s:12:\"cyrillic-ext\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:117;}i:162;a:7:{s:6:\"family\";s:15:\"Saira Condensed\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1350;}i:163;a:7:{s:6:\"family\";s:15:\"PT Sans Caption\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:987;}i:164;a:7:{s:6:\"family\";s:9:\"Courgette\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1066;}i:165;a:7:{s:6:\"family\";s:6:\"Lexend\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:903;}i:166;a:7:{s:6:\"family\";s:8:\"Spectral\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2023-01-06\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:976;}i:167;a:7:{s:6:\"family\";s:9:\"Cormorant\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:9:\"300italic\";i:6;s:6:\"italic\";i:7;s:9:\"500italic\";i:8;s:9:\"600italic\";i:9;s:9:\"700italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:590;}i:168;a:7:{s:6:\"family\";s:16:\"Ubuntu Condensed\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:6:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:884;}i:169;a:7:{s:6:\"family\";s:11:\"Great Vibes\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:827;}i:170;a:7:{s:6:\"family\";s:7:\"Baloo 2\";s:8:\"variants\";a:5:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";}s:7:\"subsets\";a:4:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-11-09\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:768;}i:171;a:7:{s:6:\"family\";s:11:\"Lexend Deca\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:242;}i:172;a:7:{s:6:\"family\";s:6:\"Changa\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";}s:7:\"subsets\";a:3:{i:0;s:6:\"arabic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v22\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:757;}i:173;a:7:{s:6:\"family\";s:11:\"Lobster Two\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:559;}i:174;a:7:{s:6:\"family\";s:12:\"Francois One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:189;}i:175;a:7:{s:6:\"family\";s:11:\"Philosopher\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:300;}i:176;a:7:{s:6:\"family\";s:5:\"Alata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:431;}i:177;a:7:{s:6:\"family\";s:5:\"Prata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1245;}i:178;a:7:{s:6:\"family\";s:14:\"Be Vietnam Pro\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1088;}i:179;a:7:{s:6:\"family\";s:9:\"Titan One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:269;}i:180;a:7:{s:6:\"family\";s:11:\"Crete Round\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1011;}i:181;a:7:{s:6:\"family\";s:11:\"Passion One\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"700\";i:2;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:936;}i:182;a:7:{s:6:\"family\";s:3:\"Sen\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"700\";i:2;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1227;}i:183;a:7:{s:6:\"family\";s:13:\"Noto Serif TC\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:19:\"chinese-traditional\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v23\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1023;}i:184;a:7:{s:6:\"family\";s:9:\"Marcellus\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:766;}i:185;a:7:{s:6:\"family\";s:13:\"Noto Serif KR\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:6:\"korean\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1365;}i:186;a:7:{s:6:\"family\";s:6:\"Gruppo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1402;}i:187;a:7:{s:6:\"family\";s:11:\"Paytone One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:340;}i:188;a:7:{s:6:\"family\";s:7:\"Rokkitt\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v34\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1381;}i:189;a:7:{s:6:\"family\";s:18:\"Pathway Gothic One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:599;}i:190;a:7:{s:6:\"family\";s:11:\"Encode Sans\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1262;}i:191;a:7:{s:6:\"family\";s:5:\"Eczar\";s:8:\"variants\";a:5:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";}s:7:\"subsets\";a:5:{i:0;s:10:\"devanagari\";i:1;s:5:\"greek\";i:2;s:9:\"greek-ext\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v22\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:303;}i:192;a:7:{s:6:\"family\";s:11:\"Bodoni Moda\";s:8:\"variants\";a:12:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:6:\"italic\";i:7;s:9:\"500italic\";i:8;s:9:\"600italic\";i:9;s:9:\"700italic\";i:10;s:9:\"800italic\";i:11;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v23\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:650;}i:193;a:7:{s:6:\"family\";s:19:\"Architects Daughter\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:76;}i:194;a:7:{s:6:\"family\";s:14:\"Kaushan Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:717;}i:195;a:7:{s:6:\"family\";s:15:\"Old Standard TT\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1191;}i:196;a:7:{s:6:\"family\";s:7:\"PT Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:723;}i:197;a:7:{s:6:\"family\";s:7:\"Macondo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:181;}i:198;a:7:{s:6:\"family\";s:5:\"Alice\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:335;}i:199;a:7:{s:6:\"family\";s:10:\"Sacramento\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:476;}i:200;a:7:{s:6:\"family\";s:17:\"Quattrocento Sans\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:981;}i:201;a:7:{s:6:\"family\";s:6:\"Cookie\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:974;}i:202;a:7:{s:6:\"family\";s:15:\"Sawarabi Mincho\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"japanese\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:829;}i:203;a:7:{s:6:\"family\";s:11:\"Staatliches\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:235;}i:204;a:7:{s:6:\"family\";s:10:\"El Messiri\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:6:\"arabic\";i:1;s:8:\"cyrillic\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v22\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:119;}i:205;a:7:{s:6:\"family\";s:17:\"Gloria Hallelujah\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:872;}i:206;a:7:{s:6:\"family\";s:12:\"Luckiest Guy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:494;}i:207;a:7:{s:6:\"family\";s:4:\"Unna\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:969;}i:208;a:7:{s:6:\"family\";s:9:\"Creepster\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:166;}i:209;a:7:{s:6:\"family\";s:5:\"Khand\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-12-08\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:695;}i:210;a:7:{s:6:\"family\";s:8:\"Faustina\";s:8:\"variants\";a:12:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:9:\"300italic\";i:7;s:6:\"italic\";i:8;s:9:\"500italic\";i:9;s:9:\"600italic\";i:10;s:9:\"700italic\";i:11;s:9:\"800italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:893;}i:211;a:7:{s:6:\"family\";s:7:\"Arsenal\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:342;}i:212;a:7:{s:6:\"family\";s:10:\"Carter One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:387;}i:213;a:7:{s:6:\"family\";s:9:\"Gothic A1\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:6:\"korean\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1188;}i:214;a:7:{s:6:\"family\";s:17:\"Noto Sans Display\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:999;}i:215;a:7:{s:6:\"family\";s:14:\"League Spartan\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:75;}i:216;a:7:{s:6:\"family\";s:10:\"Yellowtail\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:743;}i:217;a:7:{s:6:\"family\";s:12:\"Patrick Hand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:877;}i:218;a:7:{s:6:\"family\";s:5:\"Chivo\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-11-18\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1073;}i:219;a:7:{s:6:\"family\";s:5:\"Saira\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1237;}i:220;a:7:{s:6:\"family\";s:11:\"Concert One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:858;}i:221;a:7:{s:6:\"family\";s:12:\"Commissioner\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:6:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:885;}i:222;a:7:{s:6:\"family\";s:14:\"Press Start 2P\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1052;}i:223;a:7:{s:6:\"family\";s:10:\"News Cycle\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v23\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1266;}i:224;a:7:{s:6:\"family\";s:9:\"Cantarell\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-11-09\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:834;}i:225;a:7:{s:6:\"family\";s:10:\"Antic Slab\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:785;}i:226;a:7:{s:6:\"family\";s:12:\"Josefin Slab\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:9:\"100italic\";i:8;s:9:\"200italic\";i:9;s:9:\"300italic\";i:10;s:6:\"italic\";i:11;s:9:\"500italic\";i:12;s:9:\"600italic\";i:13;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v24\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1005;}i:227;a:7:{s:6:\"family\";s:6:\"Cuprum\";s:8:\"variants\";a:8:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:6:\"italic\";i:5;s:9:\"500italic\";i:6;s:9:\"600italic\";i:7;s:9:\"700italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v25\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:796;}i:228;a:7:{s:6:\"family\";s:7:\"Handlee\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:367;}i:229;a:7:{s:6:\"family\";s:15:\"Sawarabi Gothic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:8:\"japanese\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:498;}i:230;a:7:{s:6:\"family\";s:11:\"Crimson Pro\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:9:\"200italic\";i:9;s:9:\"300italic\";i:10;s:6:\"italic\";i:11;s:9:\"500italic\";i:12;s:9:\"600italic\";i:13;s:9:\"700italic\";i:14;s:9:\"800italic\";i:15;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v23\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:674;}i:231;a:7:{s:6:\"family\";s:11:\"Roboto Flex\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:6:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2023-01-06\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:137;}i:232;a:7:{s:6:\"family\";s:7:\"Gelasio\";s:8:\"variants\";a:8:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1012;}i:233;a:7:{s:6:\"family\";s:16:\"Alegreya Sans SC\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";}s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v23\";s:12:\"lastModified\";s:10:\"2022-12-08\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:822;}i:234;a:7:{s:6:\"family\";s:7:\"Bangers\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:93;}i:235;a:7:{s:6:\"family\";s:25:\"Fira Sans Extra Condensed\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1331;}i:236;a:7:{s:6:\"family\";s:10:\"Advent Pro\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:965;}i:237;a:7:{s:6:\"family\";s:12:\"Quattrocento\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:684;}i:238;a:7:{s:6:\"family\";s:12:\"Marck Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:333;}i:239;a:7:{s:6:\"family\";s:11:\"Ubuntu Mono\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:6:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:1122;}i:240;a:7:{s:6:\"family\";s:9:\"Unbounded\";s:8:\"variants\";a:8:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:215;}i:241;a:7:{s:6:\"family\";s:8:\"Mr Dafoe\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:277;}i:242;a:7:{s:6:\"family\";s:10:\"Poiret One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1215;}i:243;a:7:{s:6:\"family\";s:14:\"Noto Sans Thai\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:183;}i:244;a:7:{s:6:\"family\";s:10:\"Tenor Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1248;}i:245;a:7:{s:6:\"family\";s:8:\"Vidaloka\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:855;}i:246;a:7:{s:6:\"family\";s:7:\"Antonio\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:164;}i:247;a:7:{s:6:\"family\";s:10:\"Yeseva One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1438;}i:248;a:7:{s:6:\"family\";s:12:\"Bai Jamjuree\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:225;}i:249;a:7:{s:6:\"family\";s:9:\"Fugaz One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:917;}i:250;a:7:{s:6:\"family\";s:11:\"Mukta Malar\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:5:\"tamil\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1251;}i:251;a:7:{s:6:\"family\";s:23:\"IBM Plex Sans Condensed\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:12:\"cyrillic-ext\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1480;}i:252;a:7:{s:6:\"family\";s:7:\"Sanchez\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:619;}i:253;a:7:{s:6:\"family\";s:4:\"Aleo\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:948;}i:254;a:7:{s:6:\"family\";s:21:\"Stint Ultra Condensed\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:106;}i:255;a:7:{s:6:\"family\";s:6:\"Neuton\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:950;}i:256;a:7:{s:6:\"family\";s:4:\"Mitr\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:312;}i:257;a:7:{s:6:\"family\";s:13:\"Special Elite\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1213;}i:258;a:7:{s:6:\"family\";s:8:\"Merienda\";s:8:\"variants\";a:7:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1374;}i:259;a:7:{s:6:\"family\";s:6:\"Neucha\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1247;}i:260;a:7:{s:6:\"family\";s:13:\"DM Serif Text\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:454;}i:261;a:7:{s:6:\"family\";s:5:\"Ultra\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:853;}i:262;a:7:{s:6:\"family\";s:6:\"Allura\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2023-01-18\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1417;}i:263;a:7:{s:6:\"family\";s:7:\"Mandali\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:6:\"telugu\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-04-26\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:676;}i:264;a:7:{s:6:\"family\";s:9:\"Tangerine\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:659;}i:265;a:7:{s:6:\"family\";s:19:\"Playfair Display SC\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1239;}i:266;a:7:{s:6:\"family\";s:9:\"Shrikhand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"gujarati\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1385;}i:267;a:7:{s:6:\"family\";s:14:\"Rubik Mono One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1455;}i:268;a:7:{s:6:\"family\";s:7:\"Taviraj\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1194;}i:269;a:7:{s:6:\"family\";s:13:\"Hind Vadodara\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:8:\"gujarati\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1105;}i:270;a:7:{s:6:\"family\";s:6:\"Padauk\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:7:\"myanmar\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-11-09\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:130;}i:271;a:7:{s:6:\"family\";s:4:\"Ruda\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v23\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:174;}i:272;a:7:{s:6:\"family\";s:17:\"Libre Caslon Text\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:612;}i:273;a:7:{s:6:\"family\";s:9:\"Yatra One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:316;}i:274;a:7:{s:6:\"family\";s:12:\"Roboto Serif\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2023-04-04\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:374;}i:275;a:7:{s:6:\"family\";s:19:\"Nanum Gothic Coding\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:6:\"korean\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:992;}i:276;a:7:{s:6:\"family\";s:5:\"Gudea\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:588;}i:277;a:7:{s:6:\"family\";s:11:\"Kosugi Maru\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:8:\"japanese\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:949;}i:278;a:7:{s:6:\"family\";s:9:\"Ropa Sans\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1075;}i:279;a:7:{s:6:\"family\";s:10:\"Parisienne\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1008;}i:280;a:7:{s:6:\"family\";s:11:\"Oleo Script\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-05-10\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:326;}i:281;a:7:{s:6:\"family\";s:10:\"Readex Pro\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:6:\"arabic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:811;}i:282;a:7:{s:6:\"family\";s:8:\"Amaranth\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:867;}i:283;a:7:{s:6:\"family\";s:4:\"Mada\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:6:\"arabic\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-12-08\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:314;}i:284;a:7:{s:6:\"family\";s:4:\"Viga\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1342;}i:285;a:7:{s:6:\"family\";s:8:\"Literata\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:9:\"200italic\";i:9;s:9:\"300italic\";i:10;s:6:\"italic\";i:11;s:9:\"500italic\";i:12;s:9:\"600italic\";i:13;s:9:\"700italic\";i:14;s:9:\"800italic\";i:15;s:9:\"900italic\";}s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v34\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:527;}i:286;a:7:{s:6:\"family\";s:6:\"Bungee\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:311;}i:287;a:7:{s:6:\"family\";s:7:\"Volkhov\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-04-27\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1144;}i:288;a:7:{s:6:\"family\";s:12:\"Abhaya Libre\";s:8:\"variants\";a:5:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:7:\"sinhala\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1397;}i:289;a:7:{s:6:\"family\";s:12:\"Red Hat Text\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:9:\"300italic\";i:6;s:6:\"italic\";i:7;s:9:\"500italic\";i:8;s:9:\"600italic\";i:9;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:613;}i:290;a:7:{s:6:\"family\";s:4:\"Itim\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:978;}i:291;a:7:{s:6:\"family\";s:13:\"Noto Serif SC\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:18:\"chinese-simplified\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v22\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1320;}i:292;a:7:{s:6:\"family\";s:13:\"Source Sans 3\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:9:\"200italic\";i:9;s:9:\"300italic\";i:10;s:6:\"italic\";i:11;s:9:\"500italic\";i:12;s:9:\"600italic\";i:13;s:9:\"700italic\";i:14;s:9:\"800italic\";i:15;s:9:\"900italic\";}s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1493;}i:293;a:7:{s:6:\"family\";s:8:\"Playball\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:203;}i:294;a:7:{s:6:\"family\";s:20:\"Saira Semi Condensed\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1127;}i:295;a:7:{s:6:\"family\";s:5:\"Forum\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:207;}i:296;a:7:{s:6:\"family\";s:21:\"Encode Sans Condensed\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1160;}i:297;a:7:{s:6:\"family\";s:14:\"Homemade Apple\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:364;}i:298;a:7:{s:6:\"family\";s:15:\"Hammersmith One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1288;}i:299;a:7:{s:6:\"family\";s:8:\"Sriracha\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:892;}i:300;a:7:{s:6:\"family\";s:5:\"Laila\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:321;}i:301;a:7:{s:6:\"family\";s:10:\"Ramabhadra\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:6:\"telugu\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-04-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1250;}i:302;a:7:{s:6:\"family\";s:7:\"Blinker\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:664;}i:303;a:7:{s:6:\"family\";s:10:\"Alex Brush\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v22\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:682;}i:304;a:7:{s:6:\"family\";s:7:\"Castoro\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1258;}i:305;a:7:{s:6:\"family\";s:9:\"Istok Web\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:957;}i:306;a:7:{s:6:\"family\";s:7:\"Niramit\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1327;}i:307;a:7:{s:6:\"family\";s:16:\"Nanum Pen Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:6:\"korean\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:988;}i:308;a:7:{s:6:\"family\";s:10:\"Bad Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-04-20\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:797;}i:309;a:7:{s:6:\"family\";s:14:\"Pragati Narrow\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:377;}i:310;a:7:{s:6:\"family\";s:9:\"Rock Salt\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1002;}i:311;a:7:{s:6:\"family\";s:12:\"Baskervville\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2023-01-18\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1046;}i:312;a:7:{s:6:\"family\";s:12:\"Average Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:372;}i:313;a:7:{s:6:\"family\";s:15:\"Cabin Condensed\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1367;}i:314;a:7:{s:6:\"family\";s:18:\"Noto Serif Bengali\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:7:\"bengali\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1259;}i:315;a:7:{s:6:\"family\";s:4:\"Jura\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:8:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:8:\"kayah-li\";i:5;s:5:\"latin\";i:6;s:9:\"latin-ext\";i:7;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v29\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:439;}i:316;a:7:{s:6:\"family\";s:5:\"Monda\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:890;}i:317;a:7:{s:6:\"family\";s:4:\"Alef\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:6:\"hebrew\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:617;}i:318;a:7:{s:6:\"family\";s:7:\"Lalezar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:6:\"arabic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1164;}i:319;a:7:{s:6:\"family\";s:7:\"Monoton\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:998;}i:320;a:7:{s:6:\"family\";s:9:\"Unica One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1022;}i:321;a:7:{s:6:\"family\";s:9:\"Audiowide\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1163;}i:322;a:7:{s:6:\"family\";s:7:\"Cousine\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:8:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:6:\"hebrew\";i:5;s:5:\"latin\";i:6;s:9:\"latin-ext\";i:7;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v25\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:1208;}i:323;a:7:{s:6:\"family\";s:9:\"Fira Mono\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"700\";}s:7:\"subsets\";a:6:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:1299;}i:324;a:7:{s:6:\"family\";s:8:\"Voltaire\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:846;}i:325;a:7:{s:6:\"family\";s:17:\"Noto Naskh Arabic\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:6:\"arabic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v33\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:245;}i:326;a:7:{s:6:\"family\";s:11:\"Inter Tight\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:250;}i:327;a:7:{s:6:\"family\";s:5:\"Khula\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1202;}i:328;a:7:{s:6:\"family\";s:8:\"Lusitana\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:585;}i:329;a:7:{s:6:\"family\";s:7:\"Adamina\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2022-04-20\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1428;}i:330;a:7:{s:6:\"family\";s:5:\"Jaldi\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:63;}i:331;a:7:{s:6:\"family\";s:6:\"Damion\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:802;}i:332;a:7:{s:6:\"family\";s:13:\"Courier Prime\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:553;}i:333;a:7:{s:6:\"family\";s:9:\"BenchNine\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1270;}i:334;a:7:{s:6:\"family\";s:8:\"Epilogue\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1203;}i:335;a:7:{s:6:\"family\";s:21:\"Big Shoulders Display\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:823;}i:336;a:7:{s:6:\"family\";s:9:\"Economica\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:838;}i:337;a:7:{s:6:\"family\";s:15:\"Allerta Stencil\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:477;}i:338;a:7:{s:6:\"family\";s:6:\"Athiti\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:204;}i:339;a:7:{s:6:\"family\";s:6:\"Rufina\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:306;}i:340;a:7:{s:6:\"family\";s:11:\"Albert Sans\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1021;}i:341;a:7:{s:6:\"family\";s:15:\"Julius Sans One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1043;}i:342;a:7:{s:6:\"family\";s:5:\"Actor\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1159;}i:343;a:7:{s:6:\"family\";s:10:\"Kumbh Sans\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"math\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:295;}i:344;a:7:{s:6:\"family\";s:6:\"Sarala\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:744;}i:345;a:7:{s:6:\"family\";s:7:\"Sintony\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1357;}i:346;a:7:{s:6:\"family\";s:9:\"Calistoga\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-12-08\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:831;}i:347;a:7:{s:6:\"family\";s:4:\"Mate\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2023-04-04\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:40;}i:348;a:7:{s:6:\"family\";s:16:\"Sorts Mill Goudy\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1036;}i:349;a:7:{s:6:\"family\";s:6:\"Varela\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1291;}i:350;a:7:{s:6:\"family\";s:13:\"Black Ops One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:12:\"cyrillic-ext\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:308;}i:351;a:7:{s:6:\"family\";s:4:\"Krub\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1053;}i:352;a:7:{s:6:\"family\";s:10:\"Comic Neue\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:532;}i:353;a:7:{s:6:\"family\";s:9:\"Palanquin\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:739;}i:354;a:7:{s:6:\"family\";s:20:\"Nothing You Could Do\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:815;}i:355;a:7:{s:6:\"family\";s:11:\"Electrolize\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-04-21\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1325;}i:356;a:7:{s:6:\"family\";s:11:\"Martel Sans\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1141;}i:357;a:7:{s:6:\"family\";s:9:\"Italianno\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:550;}i:358;a:7:{s:6:\"family\";s:19:\"Noto Sans Malayalam\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:9:\"malayalam\";}s:7:\"version\";s:3:\"v26\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:447;}i:359;a:7:{s:6:\"family\";s:5:\"Karma\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1303;}i:360;a:7:{s:6:\"family\";s:12:\"Pontano Sans\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2023-04-04\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:592;}i:361;a:7:{s:6:\"family\";s:10:\"Squada One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:716;}i:362;a:7:{s:6:\"family\";s:14:\"Londrina Solid\";s:8:\"variants\";a:4:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"900\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:677;}i:363;a:7:{s:6:\"family\";s:13:\"Anonymous Pro\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"greek\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:1042;}i:364;a:7:{s:6:\"family\";s:14:\"Black Han Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:6:\"korean\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:954;}i:365;a:7:{s:6:\"family\";s:19:\"Zen Kaku Gothic New\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"900\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:8:\"japanese\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2023-01-06\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:833;}i:366;a:7:{s:6:\"family\";s:15:\"Share Tech Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:1298;}i:367;a:7:{s:6:\"family\";s:15:\"Holtwood One SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:294;}i:368;a:7:{s:6:\"family\";s:10:\"Gochi Hand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-12-08\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1419;}i:369;a:7:{s:6:\"family\";s:7:\"Sansita\";s:8:\"variants\";a:8:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"800\";i:5;s:9:\"800italic\";i:6;s:3:\"900\";i:7;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:779;}i:370;a:7:{s:6:\"family\";s:10:\"Sigmar One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1430;}i:371;a:7:{s:6:\"family\";s:7:\"Mate SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v22\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:25;}i:372;a:7:{s:6:\"family\";s:8:\"Pangolin\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:86;}i:373;a:7:{s:6:\"family\";s:13:\"Pinyon Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1047;}i:374;a:7:{s:6:\"family\";s:10:\"Changa One\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1508;}i:375;a:7:{s:6:\"family\";s:8:\"Quantico\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1399;}i:376;a:7:{s:6:\"family\";s:12:\"Cabin Sketch\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1376;}i:377;a:7:{s:6:\"family\";s:5:\"Pridi\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1219;}i:378;a:7:{s:6:\"family\";s:15:\"Racing Sans One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1228;}i:379;a:7:{s:6:\"family\";s:6:\"Glegoo\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:432;}i:380;a:7:{s:6:\"family\";s:4:\"Syne\";s:8:\"variants\";a:5:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";}s:7:\"subsets\";a:3:{i:0;s:5:\"greek\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:700;}i:381;a:7:{s:6:\"family\";s:11:\"Cutive Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:121;}i:382;a:7:{s:6:\"family\";s:14:\"JetBrains Mono\";s:8:\"variants\";a:16:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:9:\"100italic\";i:9;s:9:\"200italic\";i:10;s:9:\"300italic\";i:11;s:6:\"italic\";i:12;s:9:\"500italic\";i:13;s:9:\"600italic\";i:14;s:9:\"700italic\";i:15;s:9:\"800italic\";}s:7:\"subsets\";a:6:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:720;}i:383;a:7:{s:6:\"family\";s:5:\"VT323\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:754;}i:384;a:7:{s:6:\"family\";s:8:\"Six Caps\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1439;}i:385;a:7:{s:6:\"family\";s:11:\"Hind Guntur\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:6:\"telugu\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:690;}i:386;a:7:{s:6:\"family\";s:12:\"Leckerli One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:924;}i:387;a:7:{s:6:\"family\";s:13:\"Gilda Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2023-02-16\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:445;}i:388;a:7:{s:6:\"family\";s:15:\"Noto Sans Tamil\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:5:\"tamil\";}s:7:\"version\";s:3:\"v27\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:385;}i:389;a:7:{s:6:\"family\";s:14:\"Noto Sans Mono\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v26\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:630;}i:390;a:7:{s:6:\"family\";s:12:\"Markazi Text\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:6:\"arabic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v22\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1379;}i:391;a:7:{s:6:\"family\";s:8:\"Michroma\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:567;}i:392;a:7:{s:6:\"family\";s:15:\"Zen Maru Gothic\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"900\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:5:\"greek\";i:2;s:8:\"japanese\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1128;}i:393;a:7:{s:6:\"family\";s:8:\"Days One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:425;}i:394;a:7:{s:6:\"family\";s:8:\"Boogaloo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:330;}i:395;a:7:{s:6:\"family\";s:13:\"Reenie Beanie\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1115;}i:396;a:7:{s:6:\"family\";s:6:\"Arapey\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:793;}i:397;a:7:{s:6:\"family\";s:5:\"Chewy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:162;}i:398;a:7:{s:6:\"family\";s:5:\"Kreon\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v37\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1117;}i:399;a:7:{s:6:\"family\";s:21:\"Covered By Your Grace\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:647;}i:400;a:7:{s:6:\"family\";s:8:\"Aclonica\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:918;}i:401;a:7:{s:6:\"family\";s:15:\"Shippori Mincho\";s:8:\"variants\";a:5:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";}s:7:\"subsets\";a:3:{i:0;s:8:\"japanese\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:623;}i:402;a:7:{s:6:\"family\";s:21:\"Atkinson Hyperlegible\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:97;}i:403;a:7:{s:6:\"family\";s:6:\"Koulen\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"khmer\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v25\";s:12:\"lastModified\";s:10:\"2022-04-26\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:579;}i:404;a:7:{s:6:\"family\";s:8:\"BioRhyme\";s:8:\"variants\";a:5:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"700\";i:4;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1273;}i:405;a:7:{s:6:\"family\";s:8:\"Lemonada\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:6:\"arabic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v26\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1083;}i:406;a:7:{s:6:\"family\";s:5:\"Basic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:292;}i:407;a:7:{s:6:\"family\";s:15:\"Berkshire Swash\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1487;}i:408;a:7:{s:6:\"family\";s:19:\"Mrs Saint Delafield\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:361;}i:409;a:7:{s:6:\"family\";s:12:\"Caveat Brush\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1177;}i:410;a:7:{s:6:\"family\";s:8:\"Fraunces\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v31\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:209;}i:411;a:7:{s:6:\"family\";s:13:\"Bowlby One SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1081;}i:412;a:7:{s:6:\"family\";s:21:\"Saira Extra Condensed\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1072;}i:413;a:7:{s:6:\"family\";s:18:\"Nanum Brush Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:6:\"korean\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v22\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1173;}i:414;a:7:{s:6:\"family\";s:7:\"DM Mono\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:740;}i:415;a:7:{s:6:\"family\";s:22:\"Shadows Into Light Two\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:611;}i:416;a:7:{s:6:\"family\";s:10:\"Newsreader\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:9:\"200italic\";i:8;s:9:\"300italic\";i:9;s:6:\"italic\";i:10;s:9:\"500italic\";i:11;s:9:\"600italic\";i:12;s:9:\"700italic\";i:13;s:9:\"800italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:971;}i:417;a:7:{s:6:\"family\";s:6:\"Rancho\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:481;}i:418;a:7:{s:6:\"family\";s:11:\"Short Stack\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:104;}i:419;a:7:{s:6:\"family\";s:5:\"Amita\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:669;}i:420;a:7:{s:6:\"family\";s:5:\"Antic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:880;}i:421;a:7:{s:6:\"family\";s:16:\"Libre Barcode 39\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-04-26\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:356;}i:422;a:7:{s:6:\"family\";s:11:\"Oranienbaum\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1199;}i:423;a:7:{s:6:\"family\";s:9:\"Syncopate\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:417;}i:424;a:7:{s:6:\"family\";s:11:\"Cantata One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:383;}i:425;a:7:{s:6:\"family\";s:16:\"PT Serif Caption\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1094;}i:426;a:7:{s:6:\"family\";s:5:\"Charm\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:446;}i:427;a:7:{s:6:\"family\";s:6:\"Armata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1000;}i:428;a:7:{s:6:\"family\";s:6:\"Candal\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:419;}i:429;a:7:{s:6:\"family\";s:17:\"Just Another Hand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1445;}i:430;a:7:{s:6:\"family\";s:7:\"Aldrich\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1107;}i:431;a:7:{s:6:\"family\";s:4:\"Mali\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:633;}i:432;a:7:{s:6:\"family\";s:9:\"Fira Code\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:6:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:450;}i:433;a:7:{s:6:\"family\";s:12:\"Arbutus Slab\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:200;}i:434;a:7:{s:6:\"family\";s:8:\"Wallpoet\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1007;}i:435;a:7:{s:6:\"family\";s:20:\"Herr Von Muellerhoff\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:390;}i:436;a:7:{s:6:\"family\";s:6:\"Alatsi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:12:\"cyrillic-ext\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1363;}i:437;a:7:{s:6:\"family\";s:8:\"Suez One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:6:\"hebrew\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1171;}i:438;a:7:{s:6:\"family\";s:6:\"Livvic\";s:8:\"variants\";a:16:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:156;}i:439;a:7:{s:6:\"family\";s:4:\"Coda\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:608;}i:440;a:7:{s:6:\"family\";s:4:\"Yrsa\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:9:\"300italic\";i:6;s:6:\"italic\";i:7;s:9:\"500italic\";i:8;s:9:\"600italic\";i:9;s:9:\"700italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1014;}i:441;a:7:{s:6:\"family\";s:20:\"Fredericka the Great\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:607;}i:442;a:7:{s:6:\"family\";s:6:\"Corben\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1264;}i:443;a:7:{s:6:\"family\";s:12:\"Miriam Libre\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:6:\"hebrew\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1078;}i:444;a:7:{s:6:\"family\";s:17:\"Cinzel Decorative\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"700\";i:2;s:3:\"900\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1501;}i:445;a:7:{s:6:\"family\";s:3:\"Jua\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:6:\"korean\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1256;}i:446;a:7:{s:6:\"family\";s:7:\"Lustria\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:850;}i:447;a:7:{s:6:\"family\";s:15:\"La Belle Aurore\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:656;}i:448;a:7:{s:6:\"family\";s:5:\"Bevan\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1039;}i:449;a:7:{s:6:\"family\";s:8:\"Capriola\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:718;}i:450;a:7:{s:6:\"family\";s:8:\"Do Hyeon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:6:\"korean\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1496;}i:451;a:7:{s:6:\"family\";s:14:\"Palanquin Dark\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:713;}i:452;a:7:{s:6:\"family\";s:13:\"Overpass Mono\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:198;}i:453;a:7:{s:6:\"family\";s:12:\"Rammetto One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:502;}i:454;a:7:{s:6:\"family\";s:5:\"Telex\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-12-08\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:282;}i:455;a:7:{s:6:\"family\";s:5:\"Julee\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v25\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1170;}i:456;a:7:{s:6:\"family\";s:14:\"Source Serif 4\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:9:\"200italic\";i:9;s:9:\"300italic\";i:10;s:6:\"italic\";i:11;s:9:\"500italic\";i:12;s:9:\"600italic\";i:13;s:9:\"700italic\";i:14;s:9:\"800italic\";i:15;s:9:\"900italic\";}s:7:\"subsets\";a:6:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:172;}i:457;a:7:{s:6:\"family\";s:14:\"Carrois Gothic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:72;}i:458;a:7:{s:6:\"family\";s:9:\"Reem Kufi\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:6:\"arabic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2022-12-08\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:952;}i:459;a:7:{s:6:\"family\";s:9:\"GFS Didot\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"greek\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:810;}i:460;a:7:{s:6:\"family\";s:16:\"Darker Grotesque\";s:8:\"variants\";a:7:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:216;}i:461;a:7:{s:6:\"family\";s:7:\"Petrona\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v32\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1446;}i:462;a:7:{s:6:\"family\";s:3:\"K2D\";s:8:\"variants\";a:16:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:111;}i:463;a:7:{s:6:\"family\";s:8:\"Chonburi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:254;}i:464;a:7:{s:6:\"family\";s:13:\"STIX Two Text\";s:8:\"variants\";a:8:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:6:\"italic\";i:5;s:9:\"500italic\";i:6;s:9:\"600italic\";i:7;s:9:\"700italic\";}s:7:\"subsets\";a:6:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1161;}i:465;a:7:{s:6:\"family\";s:7:\"Allerta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1071;}i:466;a:7:{s:6:\"family\";s:6:\"Smokum\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v24\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1483;}i:467;a:7:{s:6:\"family\";s:13:\"Balsamiq Sans\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1332;}i:468;a:7:{s:6:\"family\";s:12:\"Marcellus SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:663;}i:469;a:7:{s:6:\"family\";s:24:\"Annie Use Your Telescope\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:600;}i:470;a:7:{s:6:\"family\";s:6:\"Lateef\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";}s:7:\"subsets\";a:3:{i:0;s:6:\"arabic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v27\";s:12:\"lastModified\";s:10:\"2022-11-09\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:689;}i:471;a:7:{s:6:\"family\";s:13:\"Bungee Inline\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:315;}i:472;a:7:{s:6:\"family\";s:8:\"Arizonia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1006;}i:473;a:7:{s:6:\"family\";s:7:\"Knewave\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1306;}i:474;a:7:{s:6:\"family\";s:14:\"Quintessential\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:83;}i:475;a:7:{s:6:\"family\";s:7:\"Oxanium\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1106;}i:476;a:7:{s:6:\"family\";s:9:\"Krona One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:259;}i:477;a:7:{s:6:\"family\";s:12:\"Sedgwick Ave\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1280;}i:478;a:7:{s:6:\"family\";s:20:\"Noto Sans Devanagari\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v25\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:942;}i:479;a:7:{s:6:\"family\";s:16:\"Noto Sans Hebrew\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:6:\"hebrew\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v43\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:310;}i:480;a:7:{s:6:\"family\";s:8:\"Graduate\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1113;}i:481;a:7:{s:6:\"family\";s:11:\"Alumni Sans\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:73;}i:482;a:7:{s:6:\"family\";s:18:\"Averia Serif Libre\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1300;}i:483;a:7:{s:6:\"family\";s:16:\"Cormorant Infant\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1101;}i:484;a:7:{s:6:\"family\";s:3:\"Rye\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1370;}i:485;a:7:{s:6:\"family\";s:18:\"Noto Serif Display\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:148;}i:486;a:7:{s:6:\"family\";s:8:\"Overlock\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:270;}i:487;a:7:{s:6:\"family\";s:8:\"Coustard\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"900\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1317;}i:488;a:7:{s:6:\"family\";s:7:\"Belleza\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1018;}i:489;a:7:{s:6:\"family\";s:9:\"Rozha One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1296;}i:490;a:7:{s:6:\"family\";s:9:\"Enriqueta\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:926;}i:491;a:7:{s:6:\"family\";s:10:\"Bowlby One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1351;}i:492;a:7:{s:6:\"family\";s:5:\"Scada\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:544;}i:493;a:7:{s:6:\"family\";s:18:\"IBM Plex Sans Thai\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:12:\"cyrillic-ext\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:4:\"thai\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:898;}i:494;a:7:{s:6:\"family\";s:7:\"Niconne\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1243;}i:495;a:7:{s:6:\"family\";s:7:\"Pattaya\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:4:\"thai\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:145;}i:496;a:7:{s:6:\"family\";s:9:\"Bellefair\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:6:\"hebrew\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:175;}i:497;a:7:{s:6:\"family\";s:18:\"Cedarville Cursive\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1246;}i:498;a:7:{s:6:\"family\";s:11:\"Coming Soon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:595;}i:499;a:7:{s:6:\"family\";s:7:\"Biryani\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:956;}i:500;a:7:{s:6:\"family\";s:7:\"Norican\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:309;}i:501;a:7:{s:6:\"family\";s:6:\"Kristi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-04-26\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1044;}i:502;a:7:{s:6:\"family\";s:7:\"Trirong\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:702;}i:503;a:7:{s:6:\"family\";s:8:\"Mallanna\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:6:\"telugu\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-04-26\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:109;}i:504;a:7:{s:6:\"family\";s:6:\"Rambla\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:816;}i:505;a:7:{s:6:\"family\";s:7:\"Kameron\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:627;}i:506;a:7:{s:6:\"family\";s:7:\"Qwigley\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:635;}i:507;a:7:{s:6:\"family\";s:14:\"Seaweed Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:524;}i:508;a:7:{s:6:\"family\";s:12:\"Averia Libre\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:505;}i:509;a:7:{s:6:\"family\";s:4:\"B612\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:820;}i:510;a:7:{s:6:\"family\";s:15:\"Rubik Moonrocks\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:6:\"hebrew\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:842;}i:511;a:7:{s:6:\"family\";s:12:\"Contrail One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1069;}i:512;a:7:{s:6:\"family\";s:9:\"Kiwi Maru\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:8:\"japanese\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:939;}i:513;a:7:{s:6:\"family\";s:6:\"Judson\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:131;}i:514;a:7:{s:6:\"family\";s:14:\"Bubblegum Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:622;}i:515;a:7:{s:6:\"family\";s:19:\"Petit Formal Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1156;}i:516;a:7:{s:6:\"family\";s:10:\"Lexend Exa\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v30\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:36;}i:517;a:7:{s:6:\"family\";s:7:\"Podkova\";s:8:\"variants\";a:5:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v26\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1162;}i:518;a:7:{s:6:\"family\";s:9:\"Thasadith\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:87;}i:519;a:7:{s:6:\"family\";s:5:\"Sofia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:468;}i:520;a:7:{s:6:\"family\";s:8:\"M PLUS 1\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:4:{i:0;s:8:\"japanese\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1135;}i:521;a:7:{s:6:\"family\";s:7:\"Maitree\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:107;}i:522;a:7:{s:6:\"family\";s:9:\"Amethysta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-04-20\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:458;}i:523;a:7:{s:6:\"family\";s:7:\"Goldman\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:68;}i:524;a:7:{s:6:\"family\";s:12:\"Grandstander\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:637;}i:525;a:7:{s:6:\"family\";s:6:\"Caudex\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:5:\"greek\";i:1;s:9:\"greek-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1143;}i:526;a:7:{s:6:\"family\";s:9:\"Nixie One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:441;}i:527;a:7:{s:6:\"family\";s:6:\"Cambay\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1349;}i:528;a:7:{s:6:\"family\";s:10:\"Yesteryear\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:725;}i:529;a:7:{s:6:\"family\";s:11:\"Henny Penny\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-04-26\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:982;}i:530;a:7:{s:6:\"family\";s:5:\"Magra\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:711;}i:531;a:7:{s:6:\"family\";s:11:\"Alegreya SC\";s:8:\"variants\";a:10:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";}s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:9:\"greek-ext\";i:4;s:5:\"latin\";i:5;s:9:\"latin-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v25\";s:12:\"lastModified\";s:10:\"2022-12-08\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1098;}i:532;a:7:{s:6:\"family\";s:9:\"Rochester\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:706;}i:533;a:7:{s:6:\"family\";s:5:\"Alike\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2022-04-20\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1097;}i:534;a:7:{s:6:\"family\";s:10:\"Schoolbell\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1155;}i:535;a:7:{s:6:\"family\";s:11:\"Grand Hotel\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:703;}i:536;a:7:{s:6:\"family\";s:20:\"Dawning of a New Day\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:537;}i:537;a:7:{s:6:\"family\";s:6:\"Halant\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1146;}i:538;a:7:{s:6:\"family\";s:6:\"Kosugi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:8:\"japanese\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:483;}i:539;a:7:{s:6:\"family\";s:6:\"Delius\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:629;}i:540;a:7:{s:6:\"family\";s:6:\"Nobile\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:721;}i:541;a:7:{s:6:\"family\";s:9:\"Spinnaker\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-04-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:410;}i:542;a:7:{s:6:\"family\";s:7:\"Average\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-11-09\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:729;}i:543;a:7:{s:6:\"family\";s:7:\"Hanuman\";s:8:\"variants\";a:5:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"700\";i:4;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:5:\"khmer\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v22\";s:12:\"lastModified\";s:10:\"2022-04-21\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:134;}i:544;a:7:{s:6:\"family\";s:8:\"Marmelad\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1125;}i:545;a:7:{s:6:\"family\";s:7:\"Tillana\";s:8:\"variants\";a:5:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1466;}i:546;a:7:{s:6:\"family\";s:3:\"NTR\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:6:\"telugu\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1157;}i:547;a:7:{s:6:\"family\";s:15:\"Lily Script One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1184;}i:548;a:7:{s:6:\"family\";s:7:\"Manjari\";s:8:\"variants\";a:3:{i:0;s:3:\"100\";i:1;s:7:\"regular\";i:2;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:9:\"malayalam\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2022-04-26\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:423;}i:549;a:7:{s:6:\"family\";s:10:\"Alexandria\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:4:{i:0;s:6:\"arabic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1354;}i:550;a:7:{s:6:\"family\";s:7:\"Trocchi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:357;}i:551;a:7:{s:6:\"family\";s:5:\"Amiko\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"600\";i:2;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:638;}i:552;a:7:{s:6:\"family\";s:7:\"Rosario\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:9:\"300italic\";i:6;s:6:\"italic\";i:7;s:9:\"500italic\";i:8;s:9:\"600italic\";i:9;s:9:\"700italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v31\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:115;}i:553;a:7:{s:6:\"family\";s:3:\"Ovo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1063;}i:554;a:7:{s:6:\"family\";s:6:\"Aladin\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1099;}i:555;a:7:{s:6:\"family\";s:13:\"ZCOOL XiaoWei\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:18:\"chinese-simplified\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-11-09\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:129;}i:556;a:7:{s:6:\"family\";s:6:\"Kurale\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:10:\"devanagari\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:495;}i:557;a:7:{s:6:\"family\";s:10:\"Poller One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1418;}i:558;a:7:{s:6:\"family\";s:22:\"Material Symbols Sharp\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:4:\"v106\";s:12:\"lastModified\";s:10:\"2023-05-08\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:291;}i:559;a:7:{s:6:\"family\";s:12:\"Irish Grover\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v23\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:456;}i:560;a:7:{s:6:\"family\";s:13:\"BIZ UDPGothic\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:9:\"greek-ext\";i:2;s:8:\"japanese\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1485;}i:561;a:7:{s:6:\"family\";s:20:\"Monsieur La Doulaise\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1048;}i:562;a:7:{s:6:\"family\";s:21:\"Love Ya Like A Sister\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:206;}i:563;a:7:{s:6:\"family\";s:11:\"Oxygen Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:9:\"monospace\";s:13:\"trendingIndex\";i:539;}i:564;a:7:{s:6:\"family\";s:12:\"Raleway Dots\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:70;}i:565;a:7:{s:6:\"family\";s:7:\"Sniglet\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1470;}i:566;a:7:{s:6:\"family\";s:11:\"Vollkorn SC\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"900\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:329;}i:567;a:7:{s:6:\"family\";s:12:\"Libre Bodoni\";s:8:\"variants\";a:8:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:6:\"italic\";i:5;s:9:\"500italic\";i:6;s:9:\"600italic\";i:7;s:9:\"700italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1448;}i:568;a:7:{s:6:\"family\";s:9:\"Fauna One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:848;}i:569;a:7:{s:6:\"family\";s:9:\"Fjord One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:391;}i:570;a:7:{s:6:\"family\";s:12:\"Brygada 1918\";s:8:\"variants\";a:8:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:6:\"italic\";i:5;s:9:\"500italic\";i:6;s:9:\"600italic\";i:7;s:9:\"700italic\";}s:7:\"subsets\";a:6:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"greek\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2023-01-06\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1254;}i:571;a:7:{s:6:\"family\";s:10:\"Hepta Slab\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1123;}i:572;a:7:{s:6:\"family\";s:9:\"Kodchasan\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:45;}i:573;a:7:{s:6:\"family\";s:11:\"Proza Libre\";s:8:\"variants\";a:10:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:540;}i:574;a:7:{s:6:\"family\";s:18:\"IM Fell English SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1049;}i:575;a:7:{s:6:\"family\";s:12:\"Headland One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1186;}i:576;a:7:{s:6:\"family\";s:23:\"Waiting for the Sunrise\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:359;}i:577;a:7:{s:6:\"family\";s:14:\"Grenze Gotisch\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:523;}i:578;a:7:{s:6:\"family\";s:10:\"Slabo 13px\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1079;}i:579;a:7:{s:6:\"family\";s:12:\"Vesper Libre\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"700\";i:3;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1029;}i:580;a:7:{s:6:\"family\";s:8:\"Klee One\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"600\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:9:\"greek-ext\";i:2;s:8:\"japanese\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:409;}i:581;a:7:{s:6:\"family\";s:7:\"Molengo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:369;}i:582;a:7:{s:6:\"family\";s:5:\"Share\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:683;}i:583;a:7:{s:6:\"family\";s:13:\"Baloo Tamma 2\";s:8:\"variants\";a:5:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";}s:7:\"subsets\";a:4:{i:0;s:7:\"kannada\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-11-09\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1383;}i:584;a:7:{s:6:\"family\";s:14:\"Calligraffitti\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1108;}i:585;a:7:{s:6:\"family\";s:6:\"Marvel\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1134;}i:586;a:7:{s:6:\"family\";s:7:\"Fredoka\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:6:\"hebrew\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2023-04-04\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:157;}i:587;a:7:{s:6:\"family\";s:26:\"Encode Sans Semi Condensed\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1302;}i:588;a:7:{s:6:\"family\";s:7:\"Suranna\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:6:\"telugu\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-04-27\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:349;}i:589;a:7:{s:6:\"family\";s:4:\"Rasa\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:9:\"300italic\";i:6;s:6:\"italic\";i:7;s:9:\"500italic\";i:8;s:9:\"600italic\";i:9;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"gujarati\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:701;}i:590;a:7:{s:6:\"family\";s:15:\"Stardos Stencil\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1377;}i:591;a:7:{s:6:\"family\";s:5:\"Allan\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:195;}i:592;a:7:{s:6:\"family\";s:11:\"Turret Road\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"700\";i:5;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:515;}i:593;a:7:{s:6:\"family\";s:8:\"Gabriela\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:847;}i:594;a:7:{s:6:\"family\";s:10:\"Kelly Slab\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1261;}i:595;a:7:{s:6:\"family\";s:9:\"Limelight\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:863;}i:596;a:7:{s:6:\"family\";s:12:\"Meera Inimai\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:5:\"tamil\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-04-26\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:48;}i:597;a:7:{s:6:\"family\";s:21:\"Goudy Bookletter 1911\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:696;}i:598;a:7:{s:6:\"family\";s:10:\"Pirata One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v22\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:668;}i:599;a:7:{s:6:\"family\";s:11:\"Rampart One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:8:\"japanese\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1361;}i:600;a:7:{s:6:\"family\";s:6:\"Rakkas\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:6:\"arabic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:535;}i:601;a:7:{s:6:\"family\";s:11:\"David Libre\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:6:\"hebrew\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1287;}i:602;a:7:{s:6:\"family\";s:15:\"Patrick Hand SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1396;}i:603;a:7:{s:6:\"family\";s:8:\"Fahkwang\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:799;}i:604;a:7:{s:6:\"family\";s:15:\"IM Fell English\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1139;}i:605;a:7:{s:6:\"family\";s:17:\"Cormorant Upright\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:655;}i:606;a:7:{s:6:\"family\";s:5:\"Copse\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-04-21\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:751;}i:607;a:7:{s:6:\"family\";s:13:\"Baloo Paaji 2\";s:8:\"variants\";a:5:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";}s:7:\"subsets\";a:4:{i:0;s:8:\"gurmukhi\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v22\";s:12:\"lastModified\";s:10:\"2022-11-09\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1016;}i:608;a:7:{s:6:\"family\";s:10:\"Baloo Da 2\";s:8:\"variants\";a:5:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";}s:7:\"subsets\";a:4:{i:0;s:7:\"bengali\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1495;}i:609;a:7:{s:6:\"family\";s:16:\"IBM Plex Sans KR\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:6:\"korean\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1197;}i:610;a:7:{s:6:\"family\";s:12:\"Bungee Shade\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1432;}i:611;a:7:{s:6:\"family\";s:20:\"Montserrat Subrayada\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:632;}i:612;a:7:{s:6:\"family\";s:7:\"Caladea\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:90;}i:613;a:7:{s:6:\"family\";s:8:\"Mansalva\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:5:\"greek\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2022-11-09\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:504;}i:614;a:7:{s:6:\"family\";s:10:\"Jockey One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1386;}i:615;a:7:{s:6:\"family\";s:9:\"Sunflower\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:6:\"korean\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1255;}i:616;a:7:{s:6:\"family\";s:13:\"Ma Shan Zheng\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:18:\"chinese-simplified\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2022-09-27\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:489;}i:617;a:7:{s:6:\"family\";s:11:\"Spectral SC\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:944;}i:618;a:7:{s:6:\"family\";s:11:\"Metrophobic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v23\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1050;}i:619;a:7:{s:6:\"family\";s:7:\"Allison\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:845;}i:620;a:7:{s:6:\"family\";s:7:\"Brawler\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:116;}i:621;a:7:{s:6:\"family\";s:10:\"Aref Ruqaa\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:6:\"arabic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v25\";s:12:\"lastModified\";s:10:\"2022-12-08\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:287;}i:622;a:7:{s:6:\"family\";s:5:\"Mirza\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:6:\"arabic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:513;}i:623;a:7:{s:6:\"family\";s:7:\"Bentham\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1114;}i:624;a:7:{s:6:\"family\";s:6:\"Fresca\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1435;}i:625;a:7:{s:6:\"family\";s:14:\"Zen Old Mincho\";s:8:\"variants\";a:5:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"900\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:5:\"greek\";i:2;s:8:\"japanese\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2023-01-06\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1221;}i:626;a:7:{s:6:\"family\";s:15:\"IM Fell DW Pica\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:881;}i:627;a:7:{s:6:\"family\";s:20:\"Sedgwick Ave Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v19\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1503;}i:628;a:7:{s:6:\"family\";s:12:\"Rouge Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:769;}i:629;a:7:{s:6:\"family\";s:15:\"Sansita Swashed\";s:8:\"variants\";a:7:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:323;}i:630;a:7:{s:6:\"family\";s:6:\"Cutive\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1210;}i:631;a:7:{s:6:\"family\";s:12:\"Style Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:284;}i:632;a:7:{s:6:\"family\";s:8:\"Italiana\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:868;}i:633;a:7:{s:6:\"family\";s:12:\"Gemunu Libre\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:7:\"sinhala\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:626;}i:634;a:7:{s:6:\"family\";s:7:\"Skranji\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:81;}i:635;a:7:{s:6:\"family\";s:22:\"Oleo Script Swash Caps\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2022-05-10\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1295;}i:636;a:7:{s:6:\"family\";s:12:\"Cormorant SC\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:469;}i:637;a:7:{s:6:\"family\";s:8:\"Pompiere\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1276;}i:638;a:7:{s:6:\"family\";s:21:\"Noto Serif Devanagari\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v28\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:154;}i:639;a:7:{s:6:\"family\";s:13:\"League Gothic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1201;}i:640;a:7:{s:6:\"family\";s:11:\"Zen Antique\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:5:\"greek\";i:2;s:8:\"japanese\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2023-01-06\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1338;}i:641;a:7:{s:6:\"family\";s:9:\"Vazirmatn\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:6:\"arabic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1413;}i:642;a:7:{s:6:\"family\";s:12:\"Bellota Text\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:392;}i:643;a:7:{s:6:\"family\";s:7:\"Trykker\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v21\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:247;}i:644;a:7:{s:6:\"family\";s:18:\"UnifrakturMaguntia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:849;}i:645;a:7:{s:6:\"family\";s:8:\"Almendra\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v23\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:84;}i:646;a:7:{s:6:\"family\";s:6:\"Quando\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:543;}i:647;a:7:{s:6:\"family\";s:11:\"Odibee Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:370;}i:648;a:7:{s:6:\"family\";s:18:\"Big Shoulders Text\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v22\";s:12:\"lastModified\";s:10:\"2023-03-21\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:733;}i:649;a:7:{s:6:\"family\";s:9:\"Harmattan\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:6:\"arabic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2022-11-09\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1240;}i:650;a:7:{s:6:\"family\";s:12:\"Fanwood Text\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:575;}i:651;a:7:{s:6:\"family\";s:5:\"Inder\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:861;}i:652;a:7:{s:6:\"family\";s:5:\"Lemon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2023-04-04\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:388;}i:653;a:7:{s:6:\"family\";s:14:\"Baloo Thambi 2\";s:8:\"variants\";a:5:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:5:\"tamil\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v16\";s:12:\"lastModified\";s:10:\"2022-11-09\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:1358;}i:654;a:7:{s:6:\"family\";s:6:\"Andika\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:12:\"cyrillic-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v24\";s:12:\"lastModified\";s:10:\"2023-04-27\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:963;}i:655;a:7:{s:6:\"family\";s:7:\"Georama\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";i:9;s:9:\"100italic\";i:10;s:9:\"200italic\";i:11;s:9:\"300italic\";i:12;s:6:\"italic\";i:13;s:9:\"500italic\";i:14;s:9:\"600italic\";i:15;s:9:\"700italic\";i:16;s:9:\"800italic\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:1482;}i:656;a:7:{s:6:\"family\";s:10:\"Fondamento\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v17\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:962;}i:657;a:7:{s:6:\"family\";s:6:\"Meddon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:11:\"handwriting\";s:13:\"trendingIndex\";i:1269;}i:658;a:7:{s:6:\"family\";s:5:\"Kadwa\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:10:\"devanagari\";i:1;s:5:\"latin\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:5:\"serif\";s:13:\"trendingIndex\";i:1308;}i:659;a:7:{s:6:\"family\";s:7:\"McLaren\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2023-05-02\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:951;}i:660;a:7:{s:6:\"family\";s:5:\"Farro\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v14\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:10:\"sans-serif\";s:13:\"trendingIndex\";i:972;}i:661;a:7:{s:6:\"family\";s:12:\"Gravitas One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2022-09-22\";s:8:\"category\";s:7:\"display\";s:13:\"trendingIndex\";i:455;}i:662;a:7:{s:6:\"family\";s:6:\"Radley\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v20\";s:12:\"lastModified\";s:10:\"2022-